/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.networkmanager.impl.RateHandler;
import java.io.IOException;
import org.gudy.azureus2.core3.util.Debug;

public class SinglePeerUploader
implements RateControlledEntity {
    private final NetworkConnectionBase connection;
    private final RateHandler rate_handler;

    public SinglePeerUploader(NetworkConnectionBase networkConnectionBase, RateHandler rateHandler) {
        this.connection = networkConnectionBase;
        this.rate_handler = rateHandler;
    }

    public boolean canProcess(EventWaiter eventWaiter) {
        if (!this.connection.getTransportBase().isReadyForWrite(eventWaiter)) {
            return false;
        }
        if (this.connection.getOutgoingMessageQueue().getTotalSize() < 1) {
            return false;
        }
        return this.rate_handler.getCurrentNumBytesAllowed() >= 1;
    }

    public boolean doProcessing(EventWaiter eventWaiter) {
        if (!this.connection.getTransportBase().isReadyForWrite(eventWaiter)) {
            return false;
        }
        int n = this.rate_handler.getCurrentNumBytesAllowed();
        if (n < 1) {
            return false;
        }
        int n2 = this.connection.getOutgoingMessageQueue().getTotalSize();
        if (n2 < 1) {
            if (!this.connection.getOutgoingMessageQueue().isDestroyed()) {
                // empty if block
            }
            return false;
        }
        int n3 = n > n2 ? n2 : n;
        int n4 = 0;
        try {
            n4 = this.connection.getOutgoingMessageQueue().deliverToTransport(n3, false);
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof IOException)) {
                Debug.printStackTrace(throwable);
            }
            this.connection.notifyOfException(throwable);
            return false;
        }
        if (n4 < 1) {
            return false;
        }
        this.rate_handler.bytesProcessed(n4);
        return true;
    }

    public int getPriority() {
        return 0;
    }

    public long getBytesReadyToWrite() {
        return this.connection.getOutgoingMessageQueue().getTotalSize();
    }

    public int getConnectionCount() {
        return 1;
    }

    public int getReadyConnectionCount(EventWaiter eventWaiter) {
        if (this.connection.getTransportBase().isReadyForWrite(eventWaiter)) {
            return 1;
        }
        return 0;
    }

    public String getString() {
        return "SPU: bytes_allowed=" + this.rate_handler.getCurrentNumBytesAllowed() + " " + this.connection.getString();
    }
}

