/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.ByteBucket;
import com.aelitis.azureus.core.networkmanager.impl.ByteBucketMT;
import com.aelitis.azureus.core.networkmanager.impl.ByteBucketST;
import com.aelitis.azureus.core.networkmanager.impl.EntityHandler;
import com.aelitis.azureus.core.networkmanager.impl.NetworkManagerUtilities;
import com.aelitis.azureus.core.networkmanager.impl.RateHandler;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class TransferProcessor {
    private static final boolean RATE_LIMIT_LAN_TOO = false;
    public static final int TYPE_UPLOAD = 0;
    public static final int TYPE_DOWNLOAD = 1;
    private final LimitedRateGroup max_rate;
    private final ByteBucket main_bucket;
    private final EntityHandler main_controller;
    private final HashMap group_buckets = new HashMap();
    private final HashMap connections = new HashMap();
    private final AEMonitor connections_mon;
    private final boolean multi_threaded;

    public TransferProcessor(int n, LimitedRateGroup limitedRateGroup, boolean bl) {
        this.max_rate = limitedRateGroup;
        this.multi_threaded = bl;
        this.connections_mon = new AEMonitor("TransferProcessor:" + n);
        this.main_bucket = this.createBucket(this.max_rate.getRateLimitBytesPerSecond());
        this.main_controller = new EntityHandler(n, new RateHandler(){

            public int getCurrentNumBytesAllowed() {
                if (TransferProcessor.this.main_bucket.getRate() != TransferProcessor.this.max_rate.getRateLimitBytesPerSecond()) {
                    TransferProcessor.this.main_bucket.setRate(TransferProcessor.this.max_rate.getRateLimitBytesPerSecond());
                }
                return TransferProcessor.this.main_bucket.getAvailableByteCount();
            }

            public void bytesProcessed(int n) {
                TransferProcessor.this.main_bucket.setBytesUsed(n);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPeerConnection(NetworkConnectionBase networkConnectionBase, boolean bl) {
        ConnectionData connectionData2 = new ConnectionData();
        try {
            this.connections_mon.enter();
            LimitedRateGroup[] limitedRateGroupArray = networkConnectionBase.getRateLimiters(bl);
            GroupData[] groupDataArray = new GroupData[limitedRateGroupArray.length];
            for (int i = 0; i < limitedRateGroupArray.length; ++i) {
                LimitedRateGroup limitedRateGroup = limitedRateGroupArray[i];
                GroupData groupData = (GroupData)this.group_buckets.get(limitedRateGroup);
                if (groupData == null) {
                    int n = NetworkManagerUtilities.getGroupRateLimit(limitedRateGroup);
                    groupData = new GroupData(this.createBucket(n));
                    this.group_buckets.put(limitedRateGroup, groupData);
                }
                groupData.group_size++;
                groupDataArray[i] = groupData;
            }
            ConnectionData.access$502(connectionData2, limitedRateGroupArray);
            ConnectionData.access$602(connectionData2, groupDataArray);
            connectionData2.state = 0;
            this.connections.put(networkConnectionBase, connectionData2);
            Object var11_10 = null;
            this.connections_mon.exit();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.connections_mon.exit();
            throw throwable;
        }
        this.main_controller.registerPeerConnection(networkConnectionBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(NetworkConnectionBase networkConnectionBase) {
        try {
            this.connections_mon.enter();
            boolean bl = this.connections.containsKey(networkConnectionBase);
            Object var4_3 = null;
            this.connections_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.connections_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterPeerConnection(NetworkConnectionBase networkConnectionBase) {
        try {
            this.connections_mon.enter();
            ConnectionData connectionData2 = (ConnectionData)this.connections.remove(networkConnectionBase);
            if (connectionData2 != null) {
                GroupData[] groupDataArray = connectionData2.group_datas;
                for (int i = 0; i < groupDataArray.length; ++i) {
                    GroupData groupData = groupDataArray[i];
                    if (groupData.group_size == 1) {
                        this.group_buckets.remove(connectionData2.groups[i]);
                        continue;
                    }
                    groupData.group_size--;
                }
            }
            Object var7_6 = null;
            this.connections_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.connections_mon.exit();
            throw throwable;
        }
        this.main_controller.cancelPeerConnection(networkConnectionBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRateLimiter(NetworkConnectionBase networkConnectionBase, LimitedRateGroup limitedRateGroup) {
        try {
            this.connections_mon.enter();
            ConnectionData connectionData2 = (ConnectionData)this.connections.get(networkConnectionBase);
            if (connectionData2 != null) {
                LimitedRateGroup[] limitedRateGroupArray = connectionData2.groups;
                for (int i = 0; i < limitedRateGroupArray.length; ++i) {
                    if (limitedRateGroupArray[i] != limitedRateGroup) continue;
                    Object var11_7 = null;
                    this.connections_mon.exit();
                    return;
                }
                GroupData groupData = (GroupData)this.group_buckets.get(limitedRateGroup);
                if (groupData == null) {
                    int n = NetworkManagerUtilities.getGroupRateLimit(limitedRateGroup);
                    groupData = new GroupData(this.createBucket(n));
                    this.group_buckets.put(limitedRateGroup, groupData);
                }
                groupData.group_size++;
                GroupData[] groupDataArray = connectionData2.group_datas;
                int n = limitedRateGroupArray.length;
                LimitedRateGroup[] limitedRateGroupArray2 = new LimitedRateGroup[n + 1];
                System.arraycopy(limitedRateGroupArray, 0, limitedRateGroupArray2, 0, n);
                limitedRateGroupArray2[n] = limitedRateGroup;
                ConnectionData.access$502(connectionData2, limitedRateGroupArray2);
                GroupData[] groupDataArray2 = new GroupData[n + 1];
                System.arraycopy(groupDataArray, 0, groupDataArray2, 0, n);
                groupDataArray2[n] = groupData;
                ConnectionData.access$602(connectionData2, groupDataArray2);
            }
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.connections_mon.exit();
            throw throwable;
        }
        Object var11_8 = null;
        this.connections_mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeRateLimiter(NetworkConnectionBase networkConnectionBase, LimitedRateGroup limitedRateGroup) {
        block7: {
            block8: {
                try {
                    this.connections_mon.enter();
                    ConnectionData connectionData2 = (ConnectionData)this.connections.get(networkConnectionBase);
                    if (connectionData2 == null) break block7;
                    LimitedRateGroup[] limitedRateGroupArray = connectionData2.groups;
                    GroupData[] groupDataArray = connectionData2.group_datas;
                    int n = limitedRateGroupArray.length;
                    if (n == 0) {
                        Object var13_7 = null;
                        this.connections_mon.exit();
                        return;
                    }
                    LimitedRateGroup[] limitedRateGroupArray2 = new LimitedRateGroup[n - 1];
                    GroupData[] groupDataArray2 = new GroupData[n - 1];
                    int n2 = 0;
                    for (int i = 0; i < limitedRateGroupArray.length; ++i) {
                        if (limitedRateGroupArray[i] == limitedRateGroup) {
                            GroupData groupData = connectionData2.group_datas[i];
                            if (groupData.group_size == 1) {
                                this.group_buckets.remove(connectionData2.groups[i]);
                                continue;
                            }
                            groupData.group_size--;
                            continue;
                        }
                        if (n2 == limitedRateGroupArray2.length) {
                            break block8;
                        }
                        limitedRateGroupArray2[n2] = limitedRateGroupArray[i];
                        groupDataArray2[n2] = groupDataArray[i];
                        ++n2;
                    }
                    ConnectionData.access$502(connectionData2, limitedRateGroupArray2);
                    ConnectionData.access$602(connectionData2, groupDataArray2);
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var13_10 = null;
                    this.connections_mon.exit();
                    throw throwable;
                }
            }
            Object var13_8 = null;
            this.connections_mon.exit();
            return;
        }
        Object var13_9 = null;
        this.connections_mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradePeerConnection(final NetworkConnectionBase networkConnectionBase, int n) {
        ConnectionData connectionData2 = null;
        try {
            this.connections_mon.enter();
            connectionData2 = (ConnectionData)this.connections.get(networkConnectionBase);
            Object var5_4 = null;
            this.connections_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.connections_mon.exit();
            throw throwable;
        }
        if (connectionData2 != null && connectionData2.state == 0) {
            final ConnectionData connectionData3 = connectionData2;
            this.main_controller.upgradePeerConnection(networkConnectionBase, new RateHandler(){

                public int getCurrentNumBytesAllowed() {
                    int n;
                    block7: {
                        if (TransferProcessor.this.main_bucket.getRate() != TransferProcessor.this.max_rate.getRateLimitBytesPerSecond()) {
                            TransferProcessor.this.main_bucket.setRate(TransferProcessor.this.max_rate.getRateLimitBytesPerSecond());
                        }
                        n = TransferProcessor.this.main_bucket.getAvailableByteCount();
                        if ((n -= networkConnectionBase.getMssSize()) < 0) {
                            n = 0;
                        }
                        if (!networkConnectionBase.isLANLocal() || !NetworkManager.isLANRateEnabled()) {
                            try {
                                for (int i = 0; i < connectionData3.group_datas.length; ++i) {
                                    int n2;
                                    LimitedRateGroup limitedRateGroup = connectionData3.groups[i];
                                    int n3 = NetworkManagerUtilities.getGroupRateLimit(connectionData3.groups[i]);
                                    ByteBucket byteBucket = connectionData3.group_datas[i].bucket;
                                    if (byteBucket.getRate() != n3) {
                                        byteBucket.setRate(n3);
                                    }
                                    if ((n2 = byteBucket.getAvailableByteCount()) >= n) continue;
                                    n = n2;
                                }
                            }
                            catch (Throwable throwable) {
                                if (throwable instanceof IndexOutOfBoundsException) break block7;
                                Debug.printStackTrace(throwable);
                            }
                        }
                    }
                    return n;
                }

                public void bytesProcessed(int n) {
                    if (!networkConnectionBase.isLANLocal() || !NetworkManager.isLANRateEnabled()) {
                        for (int i = 0; i < connectionData3.group_datas.length; ++i) {
                            connectionData3.group_datas[i].bucket.setBytesUsed(n);
                        }
                    }
                    TransferProcessor.this.main_bucket.setBytesUsed(n);
                }
            }, n);
            connectionData3.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downgradePeerConnection(NetworkConnectionBase networkConnectionBase) {
        ConnectionData connectionData2 = null;
        try {
            this.connections_mon.enter();
            connectionData2 = (ConnectionData)this.connections.get(networkConnectionBase);
            Object var4_3 = null;
            this.connections_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.connections_mon.exit();
            throw throwable;
        }
        if (connectionData2 != null && connectionData2.state == 1) {
            this.main_controller.downgradePeerConnection(networkConnectionBase);
            connectionData2.state = 0;
        }
    }

    private ByteBucket createBucket(int n) {
        if (this.multi_threaded) {
            return new ByteBucketMT(n);
        }
        return new ByteBucketST(n);
    }

    private static class GroupData {
        private final ByteBucket bucket;
        private int group_size = 0;

        private GroupData(ByteBucket byteBucket) {
            this.bucket = byteBucket;
        }
    }

    private static class ConnectionData {
        private static final int STATE_NORMAL = 0;
        private static final int STATE_UPGRADED = 1;
        private int state;
        private LimitedRateGroup[] groups;
        private GroupData[] group_datas;

        private ConnectionData() {
        }

        static /* synthetic */ LimitedRateGroup[] access$502(ConnectionData connectionData2, LimitedRateGroup[] limitedRateGroupArray) {
            connectionData2.groups = limitedRateGroupArray;
            return limitedRateGroupArray;
        }

        static /* synthetic */ GroupData[] access$602(ConnectionData connectionData2, GroupData[] groupDataArray) {
            connectionData2.group_datas = groupDataArray;
            return groupDataArray;
        }
    }
}

