/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.gudy.azureus2.core3.util.Debug;

public class TransportCipher {
    private static boolean internal_rc4 = true;
    private Cipher cipher;
    private RC4Engine rc4_engine;

    public TransportCipher(String string, int n, SecretKeySpec secretKeySpec, AlgorithmParameterSpec algorithmParameterSpec) throws Exception {
        this.cipher = Cipher.getInstance(string);
        this.cipher.init(n, (Key)secretKeySpec, algorithmParameterSpec);
    }

    TransportCipher(String string, int n, SecretKeySpec secretKeySpec) throws Exception {
        if (string.equals("RC4")) {
            Object object;
            if (!internal_rc4) {
                try {
                    this.cipher = Cipher.getInstance(string);
                    this.cipher.init(n, secretKeySpec);
                }
                catch (Throwable throwable) {
                    internal_rc4 = true;
                }
            }
            if (internal_rc4) {
                this.rc4_engine = new RC4Engine();
                object = new KeyParameter(secretKeySpec.getEncoded());
                this.rc4_engine.init(n == 1, (CipherParameters)object);
            }
            object = new byte[1024];
            object = this.update((byte[])object);
        } else {
            this.cipher = Cipher.getInstance(string);
            this.cipher.init(n, secretKeySpec);
        }
    }

    protected byte[] update(byte[] byArray) {
        return this.update(byArray, 0, byArray.length);
    }

    protected byte[] update(byte[] byArray, int n, int n2) {
        byte[] byArray2;
        if (n2 == 0) {
            byArray2 = new byte[]{};
        } else if (this.cipher != null) {
            byArray2 = this.cipher.update(byArray, n, n2);
        } else {
            byArray2 = new byte[n2];
            this.rc4_engine.processBytes(byArray, n, n2, byArray2, 0);
        }
        return byArray2;
    }

    protected void update(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        try {
            int n;
            byte[] byArray;
            int n2 = byteBuffer.remaining();
            if (byteBuffer.hasArray()) {
                byArray = byteBuffer.array();
                n = byteBuffer.arrayOffset() + byteBuffer.position();
            } else {
                byArray = new byte[n2];
                n = 0;
                byteBuffer.get(byArray);
            }
            byte[] byArray2 = this.update(byArray, n, n2);
            byteBuffer.position(byteBuffer.limit());
            byteBuffer2.put(byArray2);
        }
        catch (Throwable throwable) {
            throw new IOException(Debug.getNestedExceptionMessage(throwable));
        }
    }

    public String getName() {
        if (this.cipher != null) {
            String string = this.cipher.getAlgorithm();
            int n = string.indexOf("/");
            if (n != -1) {
                string = string.substring(0, n);
            }
            string = string.equals("RC4") ? "RC4-160" : string + "-" + this.cipher.getBlockSize() * 8;
            return string;
        }
        return "RC4-160";
    }
}

