/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;

public class WriteController
implements AzureusCoreStatsProvider {
    private static int IDLE_SLEEP_TIME = 50;
    private static boolean AGGRESIVE_WRITE = false;
    private volatile ArrayList normal_priority_entities = new ArrayList();
    private volatile ArrayList high_priority_entities = new ArrayList();
    private final AEMonitor entities_mon = new AEMonitor("WriteController:EM");
    private int next_normal_position = 0;
    private int next_high_position = 0;
    private int aggressive_np_normal_priority_count;
    private int aggressive_np_high_priority_count;
    private long wait_count;
    private long progress_count;
    private long non_progress_count;
    private EventWaiter write_waiter = new EventWaiter();
    private int entity_count = 0;

    public WriteController() {
        AEThread aEThread = new AEThread("WriteController:WriteProcessor"){

            public void runSupport() {
                WriteController.this.writeProcessorLoop();
            }
        };
        aEThread.setDaemon(true);
        aEThread.setPriority(9);
        aEThread.start();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("net.write.control.wait.count");
        hashSet.add("net.write.control.np.count");
        hashSet.add("net.write.control.p.count");
        hashSet.add("net.write.control.entity.count");
        hashSet.add("net.write.control.con.count");
        hashSet.add("net.write.control.ready.con.count");
        hashSet.add("net.write.control.ready.byte.count");
        AzureusCoreStats.registerProvider(hashSet, this);
        AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void generate(IndentWriter indentWriter) {
                indentWriter.println("Write Controller");
                try {
                    RateControlledEntity rateControlledEntity;
                    int n;
                    indentWriter.indent();
                    ArrayList arrayList = WriteController.this.normal_priority_entities;
                    indentWriter.println("normal - " + arrayList.size());
                    for (n = 0; n < arrayList.size(); ++n) {
                        rateControlledEntity = (RateControlledEntity)arrayList.get(n);
                        indentWriter.println(rateControlledEntity.getString());
                    }
                    arrayList = WriteController.this.high_priority_entities;
                    indentWriter.println("priority - " + arrayList.size());
                    for (n = 0; n < arrayList.size(); ++n) {
                        rateControlledEntity = (RateControlledEntity)arrayList.get(n);
                        indentWriter.println(rateControlledEntity.getString());
                    }
                    Object var6_5 = null;
                    indentWriter.exdent();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    indentWriter.exdent();
                    throw throwable;
                }
            }
        });
    }

    public void updateStats(Set set, Map map) {
        if (set.contains("net.write.control.wait.count")) {
            map.put("net.write.control.wait.count", new Long(this.wait_count));
        }
        if (set.contains("net.write.control.np.count")) {
            map.put("net.write.control.np.count", new Long(this.non_progress_count));
        }
        if (set.contains("net.write.control.p.count")) {
            map.put("net.write.control.p.count", new Long(this.progress_count));
        }
        if (set.contains("net.write.control.entity.count")) {
            map.put("net.write.control.entity.count", new Long(this.high_priority_entities.size() + this.normal_priority_entities.size()));
        }
        if (set.contains("net.write.control.con.count") || set.contains("net.write.control.ready.con.count") || set.contains("net.write.control.ready.byte.count")) {
            long l = 0L;
            int n = 0;
            int n2 = 0;
            ArrayList[] arrayListArray = new ArrayList[]{this.normal_priority_entities, this.high_priority_entities};
            for (int i = 0; i < arrayListArray.length; ++i) {
                ArrayList arrayList = arrayListArray[i];
                for (int j = 0; j < arrayList.size(); ++j) {
                    RateControlledEntity rateControlledEntity = (RateControlledEntity)arrayList.get(j);
                    n2 += rateControlledEntity.getConnectionCount();
                    n += rateControlledEntity.getReadyConnectionCount(this.write_waiter);
                    l += rateControlledEntity.getBytesReadyToWrite();
                }
            }
            map.put("net.write.control.con.count", new Long(n2));
            map.put("net.write.control.ready.con.count", new Long(n));
            map.put("net.write.control.ready.byte.count", new Long(l));
        }
    }

    private void writeProcessorLoop() {
        boolean bl = true;
        while (true) {
            try {
                while (true) {
                    if (bl) {
                        bl = false;
                        if (this.doHighPriorityWrite() || this.doNormalPriorityWrite() || !this.write_waiter.waitForEvent(IDLE_SLEEP_TIME)) continue;
                        ++this.wait_count;
                        continue;
                    }
                    bl = true;
                    if (this.doNormalPriorityWrite() || this.doHighPriorityWrite() || !this.write_waiter.waitForEvent(IDLE_SLEEP_TIME)) continue;
                    ++this.wait_count;
                }
            }
            catch (Throwable throwable) {
                Debug.out("writeProcessorLoop() EXCEPTION: ", throwable);
                continue;
            }
            break;
        }
    }

    private boolean doNormalPriorityWrite() {
        RateControlledEntity rateControlledEntity = this.getNextReadyNormalPriorityEntity();
        if (rateControlledEntity != null) {
            if (rateControlledEntity.doProcessing(this.write_waiter)) {
                ++this.progress_count;
                return true;
            }
            ++this.non_progress_count;
            if (AGGRESIVE_WRITE) {
                ++this.aggressive_np_normal_priority_count;
                if (this.aggressive_np_normal_priority_count < this.normal_priority_entities.size()) {
                    return true;
                }
                this.aggressive_np_normal_priority_count = 0;
            }
        }
        return false;
    }

    private boolean doHighPriorityWrite() {
        RateControlledEntity rateControlledEntity = this.getNextReadyHighPriorityEntity();
        if (rateControlledEntity != null) {
            if (rateControlledEntity.doProcessing(this.write_waiter)) {
                ++this.progress_count;
                return true;
            }
            ++this.non_progress_count;
            if (AGGRESIVE_WRITE) {
                ++this.aggressive_np_high_priority_count;
                if (this.aggressive_np_high_priority_count < this.high_priority_entities.size()) {
                    return true;
                }
                this.aggressive_np_high_priority_count = 0;
            }
        }
        return false;
    }

    private RateControlledEntity getNextReadyNormalPriorityEntity() {
        ArrayList arrayList = this.normal_priority_entities;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            this.next_normal_position = this.next_normal_position >= n ? 0 : this.next_normal_position;
            RateControlledEntity rateControlledEntity = (RateControlledEntity)arrayList.get(this.next_normal_position);
            ++this.next_normal_position;
            if (!rateControlledEntity.canProcess(this.write_waiter)) continue;
            return rateControlledEntity;
        }
        return null;
    }

    private RateControlledEntity getNextReadyHighPriorityEntity() {
        ArrayList arrayList = this.high_priority_entities;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            this.next_high_position = this.next_high_position >= n ? 0 : this.next_high_position;
            RateControlledEntity rateControlledEntity = (RateControlledEntity)arrayList.get(this.next_high_position);
            ++this.next_high_position;
            if (!rateControlledEntity.canProcess(this.write_waiter)) continue;
            return rateControlledEntity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWriteEntity(RateControlledEntity rateControlledEntity) {
        try {
            this.entities_mon.enter();
            if (rateControlledEntity.getPriority() == 1) {
                ArrayList<RateControlledEntity> arrayList = new ArrayList<RateControlledEntity>(this.high_priority_entities.size() + 1);
                arrayList.addAll(this.high_priority_entities);
                arrayList.add(rateControlledEntity);
                this.high_priority_entities = arrayList;
            } else {
                ArrayList<RateControlledEntity> arrayList = new ArrayList<RateControlledEntity>(this.normal_priority_entities.size() + 1);
                arrayList.addAll(this.normal_priority_entities);
                arrayList.add(rateControlledEntity);
                this.normal_priority_entities = arrayList;
            }
            this.entity_count = this.normal_priority_entities.size() + this.high_priority_entities.size();
            Object var4_4 = null;
            this.entities_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.entities_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriteEntity(RateControlledEntity rateControlledEntity) {
        try {
            this.entities_mon.enter();
            if (rateControlledEntity.getPriority() == 1) {
                ArrayList arrayList = new ArrayList(this.high_priority_entities);
                arrayList.remove(rateControlledEntity);
                this.high_priority_entities = arrayList;
            } else {
                ArrayList arrayList = new ArrayList(this.normal_priority_entities);
                arrayList.remove(rateControlledEntity);
                this.normal_priority_entities = arrayList;
            }
            this.entity_count = this.normal_priority_entities.size() + this.high_priority_entities.size();
            Object var4_4 = null;
            this.entities_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.entities_mon.exit();
            throw throwable;
        }
    }

    public int getEntityCount() {
        return this.entity_count;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.control.write.idle.time", "network.control.write.aggressive"}, new ParameterListener(){

            public void parameterChanged(String string) {
                IDLE_SLEEP_TIME = COConfigurationManager.getIntParameter("network.control.write.idle.time");
                AGGRESIVE_WRITE = COConfigurationManager.getBooleanParameter("network.control.write.aggressive");
            }
        });
    }
}

