/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class TCPConnectionManager {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static int MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = 3;
    public static int MAX_SIMULTANIOUS_CONNECT_ATTEMPTS = 5;
    private static int max_outbound_connections;
    private static final int CONNECT_ATTEMPT_TIMEOUT = 30000;
    private static final int CONNECT_ATTEMPT_STALL_TIME = 3000;
    private static final boolean SHOW_CONNECT_STATS = false;
    private final VirtualChannelSelector connect_selector = new VirtualChannelSelector("Connect/Disconnect Manager", 8, true);
    private long connection_request_id_next;
    private final Set<ConnectionRequest> new_requests = new TreeSet<ConnectionRequest>(new Comparator<ConnectionRequest>(){

        @Override
        public int compare(ConnectionRequest connectionRequest, ConnectionRequest connectionRequest2) {
            int n = connectionRequest.getPriority() - connectionRequest2.getPriority();
            if (n == 0 && (n = connectionRequest.getRandom() - connectionRequest2.getRandom()) == 0) {
                long l = connectionRequest.getID() - connectionRequest2.getID();
                if (l < 0L) {
                    n = -1;
                } else if (l > 0L) {
                    n = 1;
                } else {
                    Debug.out("arghhh, borkage");
                }
            }
            return n;
        }
    });
    private final List<ConnectListener> canceled_requests = new ArrayList<ConnectListener>();
    private final AEMonitor new_canceled_mon = new AEMonitor("ConnectDisconnectManager:NCM");
    private final Map<ConnectionRequest, Object> pending_attempts = new HashMap<ConnectionRequest, Object>();
    private final LinkedList<SocketChannel> pending_closes = new LinkedList();
    private final Map<SocketChannel, Long> delayed_closes = new HashMap<SocketChannel, Long>();
    private final AEMonitor pending_closes_mon = new AEMonitor("ConnectDisconnectManager:PC");
    private boolean max_conn_exceeded_logged;

    public TCPConnectionManager() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("net.tcp.outbound.connect.queue.length");
        hashSet.add("net.tcp.outbound.cancel.queue.length");
        hashSet.add("net.tcp.outbound.close.queue.length");
        hashSet.add("net.tcp.outbound.pending.queue.length");
        AzureusCoreStats.registerProvider(hashSet, new AzureusCoreStatsProvider(){

            @Override
            public void updateStats(Set<String> set, Map<String, Object> map) {
                if (set.contains("net.tcp.outbound.connect.queue.length")) {
                    map.put("net.tcp.outbound.connect.queue.length", new Long(TCPConnectionManager.this.new_requests.size()));
                }
                if (set.contains("net.tcp.outbound.cancel.queue.length")) {
                    map.put("net.tcp.outbound.cancel.queue.length", new Long(TCPConnectionManager.this.canceled_requests.size()));
                }
                if (set.contains("net.tcp.outbound.close.queue.length")) {
                    map.put("net.tcp.outbound.close.queue.length", new Long(TCPConnectionManager.this.pending_closes.size()));
                }
                if (set.contains("net.tcp.outbound.pending.queue.length")) {
                    map.put("net.tcp.outbound.pending.queue.length", new Long(TCPConnectionManager.this.pending_attempts.size()));
                }
            }
        });
        new AEThread2("ConnectDisconnectManager", true){

            public void run() {
                while (true) {
                    TCPConnectionManager.this.addNewOutboundRequests();
                    TCPConnectionManager.this.runSelect();
                    TCPConnectionManager.this.doClosings();
                }
            }
        }.start();
    }

    public int getMaxOutboundPermitted() {
        return Math.max(max_outbound_connections - this.new_requests.size(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewOutboundRequests() {
        while (this.pending_attempts.size() < MIN_SIMULTANIOUS_CONNECT_ATTEMPTS) {
            Object var4_3;
            ConnectionRequest connectionRequest = null;
            try {
                this.new_canceled_mon.enter();
                if (this.new_requests.isEmpty()) {
                    var4_3 = null;
                    this.new_canceled_mon.exit();
                    break;
                }
                Iterator<ConnectionRequest> iterator = this.new_requests.iterator();
                connectionRequest = iterator.next();
                iterator.remove();
            }
            catch (Throwable throwable) {
                var4_3 = null;
                this.new_canceled_mon.exit();
                throw throwable;
            }
            var4_3 = null;
            this.new_canceled_mon.exit();
            if (connectionRequest == null) continue;
            this.addNewRequest(connectionRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewRequest(final ConnectionRequest connectionRequest) {
        block29: {
            connectionRequest.listener.connectAttemptStarted();
            boolean bl = false;
            try {
                connectionRequest.channel = SocketChannel.open();
                try {
                    int n;
                    String string;
                    int n2;
                    int n3 = COConfigurationManager.getIntParameter("network.tcp.socket.SO_RCVBUF");
                    if (n3 > 0) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Setting socket receive buffer size for outgoing connection [" + connectionRequest.address + "] to: " + n3));
                        }
                        connectionRequest.channel.socket().setReceiveBufferSize(n3);
                    }
                    if ((n2 = COConfigurationManager.getIntParameter("network.tcp.socket.SO_SNDBUF")) > 0) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Setting socket send buffer size for outgoing connection [" + connectionRequest.address + "] to: " + n2));
                        }
                        connectionRequest.channel.socket().setSendBufferSize(n2);
                    }
                    if ((string = COConfigurationManager.getStringParameter("network.tcp.socket.IPDiffServ")).length() > 0) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Setting socket TOS field for outgoing connection [" + connectionRequest.address + "] to: " + string));
                        }
                        connectionRequest.channel.socket().setTrafficClass(Integer.decode(string));
                    }
                    if ((n = COConfigurationManager.getIntParameter("network.bind.local.port")) > 0) {
                        connectionRequest.channel.socket().setReuseAddress(true);
                    }
                    try {
                        InetAddress inetAddress = NetworkAdmin.getSingleton().getMultiHomedOutgoingRoundRobinBindAddress(connectionRequest.address.getAddress());
                        if (inetAddress != null) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "Binding outgoing connection [" + connectionRequest.address + "] to local IP address: " + inetAddress + ":" + n));
                            }
                            connectionRequest.channel.socket().bind(new InetSocketAddress(inetAddress, n));
                        } else if (n > 0) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "Binding outgoing connection [" + connectionRequest.address + "] to local port #: " + n));
                            }
                            connectionRequest.channel.socket().bind(new InetSocketAddress(n));
                        }
                    }
                    catch (SocketException socketException) {
                        if (!socketException.getMessage().equals("Address family not supported by protocol family: bind") || !NetworkAdmin.getSingleton().hasIPV6Potential(true)) {
                            // empty if block
                        }
                        bl = true;
                        throw socketException;
                    }
                }
                catch (Throwable throwable) {
                    if (!bl) {
                        String string = "Error while processing advanced socket options.";
                        Debug.out(string, throwable);
                        Logger.log(new LogAlert(false, string, throwable));
                    }
                    throw throwable;
                }
                connectionRequest.channel.configureBlocking(false);
                connectionRequest.connect_start_time = SystemTime.getCurrentTime();
                if (connectionRequest.channel.connect(connectionRequest.address)) {
                    this.finishConnect(connectionRequest);
                    break block29;
                }
                try {
                    this.new_canceled_mon.enter();
                    this.pending_attempts.put(connectionRequest, null);
                    Object var9_16 = null;
                    this.new_canceled_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var9_17 = null;
                    this.new_canceled_mon.exit();
                    throw throwable;
                }
                this.connect_selector.register(connectionRequest.channel, new VirtualChannelSelector.VirtualSelectorListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean selectSuccess(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object) {
                        try {
                            TCPConnectionManager.this.new_canceled_mon.enter();
                            TCPConnectionManager.this.pending_attempts.remove(connectionRequest);
                            Object var5_4 = null;
                            TCPConnectionManager.this.new_canceled_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            TCPConnectionManager.this.new_canceled_mon.exit();
                            throw throwable;
                        }
                        TCPConnectionManager.this.finishConnect(connectionRequest);
                        return true;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void selectFailure(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object, Throwable throwable) {
                        try {
                            TCPConnectionManager.this.new_canceled_mon.enter();
                            TCPConnectionManager.this.pending_attempts.remove(connectionRequest);
                            Object var6_5 = null;
                            TCPConnectionManager.this.new_canceled_mon.exit();
                        }
                        catch (Throwable throwable2) {
                            Object var6_6 = null;
                            TCPConnectionManager.this.new_canceled_mon.exit();
                            throw throwable2;
                        }
                        TCPConnectionManager.this.closeConnection(connectionRequest.channel);
                        connectionRequest.listener.connectFailure(throwable);
                    }
                }, null);
            }
            catch (Throwable throwable) {
                String string = connectionRequest.address.toString();
                String string2 = connectionRequest.address.getHostName();
                int n = connectionRequest.address.getPort();
                boolean bl2 = connectionRequest.address.isUnresolved();
                InetAddress inetAddress = connectionRequest.address.getAddress();
                String string3 = inetAddress == null ? connectionRequest.address.toString() : inetAddress.toString();
                String string4 = inetAddress == null ? connectionRequest.address.toString() : inetAddress.getHostAddress();
                String string5 = "ConnectDisconnectManager::address exception: full=" + string + ", hostname=" + string2 + ", port=" + n + ", unresolved=" + bl2 + ", full_sub=" + string3 + ", host_address=" + string4;
                if (connectionRequest.channel != null) {
                    String string6 = connectionRequest.channel.toString();
                    String string7 = connectionRequest.channel.socket().toString();
                    String string8 = connectionRequest.channel.socket().getLocalAddress().toString();
                    int n4 = connectionRequest.channel.socket().getLocalPort();
                    SocketAddress socketAddress = connectionRequest.channel.socket().getRemoteSocketAddress();
                    String string9 = socketAddress != null ? socketAddress.toString() : "<null>";
                    int n5 = connectionRequest.channel.socket().getPort();
                    string5 = string5 + "\n channel=" + string6 + ", socket=" + string7 + ", local_address=" + string8 + ", local_port=" + n4 + ", remote_address=" + string9 + ", remote_port=" + n5;
                } else {
                    string5 = string5 + "\n channel=<null>";
                }
                if (bl || throwable instanceof UnresolvedAddressException || throwable instanceof NoRouteToHostException) {
                    Logger.log(new LogEvent(LOGID, 1, string5));
                } else {
                    Logger.log(new LogEvent(LOGID, 3, string5, throwable));
                }
                if (connectionRequest.channel != null) {
                    this.closeConnection(connectionRequest.channel);
                }
                connectionRequest.listener.connectFailure(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishConnect(ConnectionRequest connectionRequest) {
        block7: {
            try {
                if (connectionRequest.channel.finishConnect()) {
                    boolean bl = false;
                    try {
                        this.new_canceled_mon.enter();
                        bl = this.canceled_requests.contains(connectionRequest.listener);
                        Object var4_4 = null;
                        this.new_canceled_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        this.new_canceled_mon.exit();
                        throw throwable;
                    }
                    if (bl) {
                        this.closeConnection(connectionRequest.channel);
                    } else {
                        this.connect_selector.cancel(connectionRequest.channel);
                        connectionRequest.listener.connectSuccess(connectionRequest.channel);
                    }
                    break block7;
                }
                Debug.out("finishConnect() failed");
                connectionRequest.listener.connectFailure(new Throwable("finishConnect() failed"));
                this.closeConnection(connectionRequest.channel);
            }
            catch (Throwable throwable) {
                connectionRequest.listener.connectFailure(throwable);
                this.closeConnection(connectionRequest.channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSelect() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        try {
            this.new_canceled_mon.enter();
            block8: for (ConnectListener connectListener : this.canceled_requests) {
                Iterator<ConnectionRequest> iterator = this.pending_attempts.keySet().iterator();
                while (iterator.hasNext()) {
                    object4 = iterator.next();
                    if (((ConnectionRequest)object4).listener != connectListener) continue;
                    this.connect_selector.cancel(((ConnectionRequest)object4).channel);
                    this.closeConnection(((ConnectionRequest)object4).channel);
                    iterator.remove();
                    continue block8;
                }
            }
            this.canceled_requests.clear();
            object3 = null;
            this.new_canceled_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.new_canceled_mon.exit();
            throw throwable;
        }
        try {
            this.connect_selector.select(100L);
        }
        catch (Throwable throwable) {
            Debug.out("connnectSelectLoop() EXCEPTION: ", throwable);
        }
        int n = 0;
        long l = SystemTime.getCurrentTime();
        object4 = null;
        try {
            this.new_canceled_mon.enter();
            object2 = this.pending_attempts.keySet().iterator();
            while (object2.hasNext()) {
                object3 = object2.next();
                long l2 = l - ((ConnectionRequest)object3).connect_start_time;
                if (l2 > ((ConnectionRequest)object3).connect_timeout) {
                    object2.remove();
                    object = ((ConnectionRequest)object3).channel;
                    this.connect_selector.cancel((AbstractSelectableChannel)object);
                    this.closeConnection((SocketChannel)object);
                    if (object4 == null) {
                        object4 = new ArrayList();
                    }
                    object4.add(object3);
                    continue;
                }
                if (l2 >= 3000L) {
                    ++n;
                    continue;
                }
                if (l2 >= 0L) continue;
                ((ConnectionRequest)object3).connect_start_time = l;
            }
            Object var11_15 = null;
            this.new_canceled_mon.exit();
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            this.new_canceled_mon.exit();
            throw throwable;
        }
        if (object4 != null) {
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object3 = object2.next();
                InetSocketAddress inetSocketAddress = ((ConnectionRequest)object3).address;
                InetAddress inetAddress = inetSocketAddress.getAddress();
                object = inetAddress != null ? inetAddress.getHostAddress() + ":" + inetSocketAddress.getPort() : inetSocketAddress.toString();
                ((ConnectionRequest)object3).listener.connectFailure(new SocketTimeoutException("Connection attempt to " + (String)object + " aborted: timed out after " + ((ConnectionRequest)object3).connect_timeout / 1000L + "sec"));
            }
        }
        if (n == this.pending_attempts.size() && this.pending_attempts.size() < MAX_SIMULTANIOUS_CONNECT_ATTEMPTS) {
            object2 = null;
            try {
                this.new_canceled_mon.enter();
                if (!this.new_requests.isEmpty()) {
                    object3 = this.new_requests.iterator();
                    object2 = (ConnectionRequest)object3.next();
                    object3.remove();
                }
                Object var13_19 = null;
                this.new_canceled_mon.exit();
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                this.new_canceled_mon.exit();
                throw throwable;
            }
            if (object2 != null) {
                this.addNewRequest((ConnectionRequest)object2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClosings() {
        try {
            Object object;
            this.pending_closes_mon.enter();
            long l = SystemTime.getCurrentTime();
            if (this.delayed_closes.size() > 0) {
                object = this.delayed_closes.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry<SocketChannel, Long> entry = object.next();
                    long l2 = entry.getValue() - l;
                    if (l2 >= 0L && l2 <= 60000L) continue;
                    this.pending_closes.addLast(entry.getKey());
                    object.remove();
                }
            }
            while (!this.pending_closes.isEmpty()) {
                object = this.pending_closes.removeFirst();
                if (object == null) continue;
                this.connect_selector.cancel((AbstractSelectableChannel)object);
                try {
                    ((AbstractInterruptibleChannel)object).close();
                }
                catch (Throwable throwable) {}
            }
            Object var8_6 = null;
            this.pending_closes_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.pending_closes_mon.exit();
            throw throwable;
        }
    }

    public void requestNewConnection(InetSocketAddress inetSocketAddress, ConnectListener connectListener, int n) {
        this.requestNewConnection(inetSocketAddress, connectListener, 30000L, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestNewConnection(InetSocketAddress inetSocketAddress, ConnectListener connectListener, long l, int n) {
        ArrayList<ConnectionRequest> arrayList = null;
        try {
            this.new_canceled_mon.enter();
            ConnectionRequest connectionRequest = new ConnectionRequest(this.connection_request_id_next++, inetSocketAddress, connectListener, l, n);
            this.new_requests.add(connectionRequest);
            if (this.new_requests.size() >= max_outbound_connections && !this.max_conn_exceeded_logged) {
                this.max_conn_exceeded_logged = true;
                Debug.out("TCPConnectionManager: max outbound connection limit reached (" + max_outbound_connections + ")");
            }
            if (n == 1) {
                for (ConnectionRequest connectionRequest2 : this.pending_attempts.keySet()) {
                    if (connectionRequest2.priority != 4 || this.canceled_requests.contains(connectionRequest2.listener)) continue;
                    this.canceled_requests.add(connectionRequest2.listener);
                    if (arrayList == null) {
                        arrayList = new ArrayList<ConnectionRequest>();
                    }
                    arrayList.add(connectionRequest2);
                }
            }
            Object var11_11 = null;
            this.new_canceled_mon.exit();
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.new_canceled_mon.exit();
            throw throwable;
        }
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    ((ConnectionRequest)arrayList.get(i)).listener.connectFailure(new Exception("Low priority connection request abandoned in favour of high priority"));
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public void closeConnection(SocketChannel socketChannel) {
        this.closeConnection(socketChannel, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(SocketChannel socketChannel, int n) {
        try {
            this.pending_closes_mon.enter();
            if (n == 0) {
                if (!this.delayed_closes.containsKey(socketChannel) && !this.pending_closes.contains(socketChannel)) {
                    this.pending_closes.addLast(socketChannel);
                }
            } else {
                this.delayed_closes.put(socketChannel, new Long(SystemTime.getCurrentTime() + (long)n));
            }
            Object var4_3 = null;
            this.pending_closes_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.pending_closes_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequest(ConnectListener connectListener) {
        try {
            this.new_canceled_mon.enter();
            Iterator<ConnectionRequest> iterator = this.new_requests.iterator();
            while (iterator.hasNext()) {
                ConnectionRequest connectionRequest = iterator.next();
                if (connectionRequest.listener != connectListener) continue;
                iterator.remove();
                Object var5_4 = null;
                this.new_canceled_mon.exit();
                return;
            }
            this.canceled_requests.add(connectListener);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.new_canceled_mon.exit();
            throw throwable;
        }
        Object var5_5 = null;
        this.new_canceled_mon.exit();
    }

    static {
        MAX_SIMULTANIOUS_CONNECT_ATTEMPTS = COConfigurationManager.getIntParameter("network.max.simultaneous.connect.attempts");
        if (MAX_SIMULTANIOUS_CONNECT_ATTEMPTS < 1) {
            MAX_SIMULTANIOUS_CONNECT_ATTEMPTS = 1;
            COConfigurationManager.setParameter("network.max.simultaneous.connect.attempts", 1);
        }
        if ((MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = MAX_SIMULTANIOUS_CONNECT_ATTEMPTS - 2) < 1) {
            MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = 1;
        }
        COConfigurationManager.addParameterListener("network.max.simultaneous.connect.attempts", new ParameterListener(){

            public void parameterChanged(String string) {
                MAX_SIMULTANIOUS_CONNECT_ATTEMPTS = COConfigurationManager.getIntParameter("network.max.simultaneous.connect.attempts");
                MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = MAX_SIMULTANIOUS_CONNECT_ATTEMPTS - 2;
                if (MIN_SIMULTANIOUS_CONNECT_ATTEMPTS < 1) {
                    MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = 1;
                }
            }
        });
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.tcp.max.connections.outstanding"}, new ParameterListener(){

            public void parameterChanged(String string) {
                max_outbound_connections = COConfigurationManager.getIntParameter("network.tcp.max.connections.outstanding");
            }
        });
    }

    public static interface ConnectListener {
        public void connectAttemptStarted();

        public void connectSuccess(SocketChannel var1);

        public void connectFailure(Throwable var1);
    }

    private static class ConnectionRequest {
        private final InetSocketAddress address;
        private final ConnectListener listener;
        private final long request_start_time;
        private long connect_start_time;
        private final long connect_timeout;
        private SocketChannel channel;
        private final short rand;
        private final int priority;
        private final long id;

        private ConnectionRequest(long l, InetSocketAddress inetSocketAddress, ConnectListener connectListener, long l2, int n) {
            this.id = l;
            this.address = inetSocketAddress;
            this.listener = connectListener;
            this.connect_timeout = l2;
            this.request_start_time = SystemTime.getCurrentTime();
            this.rand = (short)(32767.0 * Math.random());
            this.priority = n;
        }

        private long getID() {
            return this.id;
        }

        private int getPriority() {
            return this.priority;
        }

        private short getRandom() {
            return this.rand;
        }
    }
}

