/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportEndpoint;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TransportCryptoManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportImpl;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProxyLoginHandler;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelperFilterFactory;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TransportEndpointTCP;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;

public class TCPTransportImpl
extends TransportImpl
implements Transport {
    private static final LogIDs LOGID = LogIDs.NET;
    protected ProtocolEndpointTCP protocol_endpoint;
    private TCPConnectionManager.ConnectListener connect_request_key = null;
    private String description = "<disconnected>";
    private final boolean is_inbound_connection;
    private int transport_mode = 0;
    public volatile boolean has_been_closed = false;
    private boolean connect_with_crypto;
    private byte[][] shared_secrets;
    private int fallback_count;
    private final boolean fallback_allowed;

    public TCPTransportImpl(ProtocolEndpointTCP protocolEndpointTCP, boolean bl, boolean bl2, byte[][] byArray) {
        this.protocol_endpoint = protocolEndpointTCP;
        this.is_inbound_connection = false;
        this.connect_with_crypto = bl;
        this.shared_secrets = byArray;
        this.fallback_allowed = bl2;
    }

    public TCPTransportImpl(ProtocolEndpointTCP protocolEndpointTCP, TransportHelperFilter transportHelperFilter) {
        this.protocol_endpoint = protocolEndpointTCP;
        this.setFilter(transportHelperFilter);
        this.is_inbound_connection = true;
        this.connect_with_crypto = false;
        this.fallback_allowed = false;
        this.description = (this.is_inbound_connection ? "R" : "L") + ": " + this.getSocketChannel().socket().getInetAddress().getHostAddress() + ": " + this.getSocketChannel().socket().getPort();
    }

    public SocketChannel getSocketChannel() {
        TransportHelperFilter transportHelperFilter = this.getFilter();
        if (transportHelperFilter == null) {
            return null;
        }
        TCPTransportHelper tCPTransportHelper = (TCPTransportHelper)transportHelperFilter.getHelper();
        if (tCPTransportHelper == null) {
            return null;
        }
        return tCPTransportHelper.getSocketChannel();
    }

    public TransportEndpoint getTransportEndpoint() {
        return new TransportEndpointTCP(this.protocol_endpoint, this.getSocketChannel());
    }

    public int getMssSize() {
        return TCPNetworkManager.getTcpMssSize();
    }

    public boolean isTCP() {
        return true;
    }

    public String getDescription() {
        return this.description;
    }

    public void connectOutbound(final ByteBuffer byteBuffer, final Transport.ConnectListener connectListener, final int n) {
        TCPConnectionManager.ConnectListener connectListener2;
        if (!TCPNetworkManager.TCP_OUTGOING_ENABLED) {
            connectListener.connectFailure(new Throwable("Outbound TCP connections disabled"));
            return;
        }
        if (this.has_been_closed) {
            return;
        }
        if (this.getFilter() != null) {
            Debug.out("socket_channel != null");
            connectListener.connectSuccess(this, byteBuffer);
            return;
        }
        final boolean bl = COConfigurationManager.getBooleanParameter("Proxy.Data.Enable");
        final TCPTransportImpl tCPTransportImpl = this;
        final InetSocketAddress inetSocketAddress = this.protocol_endpoint.getAddress();
        this.connect_request_key = connectListener2 = new TCPConnectionManager.ConnectListener(){

            public void connectAttemptStarted() {
                connectListener.connectAttemptStarted();
            }

            public void connectSuccess(final SocketChannel socketChannel) {
                if (socketChannel == null) {
                    String string = "connectSuccess:: given channel == null";
                    Debug.out(string);
                    connectListener.connectFailure(new Exception(string));
                    return;
                }
                if (TCPTransportImpl.this.has_been_closed) {
                    TCPNetworkManager.getSingleton().getConnectDisconnectManager().closeConnection(socketChannel);
                    return;
                }
                TCPTransportImpl.this.connect_request_key = null;
                TCPTransportImpl.this.description = (TCPTransportImpl.this.is_inbound_connection ? "R" : "L") + ": " + socketChannel.socket().getInetAddress().getHostAddress() + ": " + socketChannel.socket().getPort();
                if (bl) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Socket connection established to proxy server [" + TCPTransportImpl.this.description + "], login initiated..."));
                    }
                    TCPTransportImpl.this.setFilter(TCPTransportHelperFilterFactory.createTransparentFilter(socketChannel));
                    new ProxyLoginHandler(tCPTransportImpl, inetSocketAddress, new ProxyLoginHandler.ProxyListener(){

                        public void connectSuccess() {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "Proxy [" + TCPTransportImpl.this.description + "] login successful."));
                            }
                            TCPTransportImpl.this.handleCrypto(inetSocketAddress, socketChannel, byteBuffer, n, connectListener);
                        }

                        public void connectFailure(Throwable throwable) {
                            TCPTransportImpl.this.close("Proxy login failed");
                            connectListener.connectFailure(throwable);
                        }
                    });
                } else {
                    TCPTransportImpl.this.handleCrypto(inetSocketAddress, socketChannel, byteBuffer, n, connectListener);
                }
            }

            public void connectFailure(Throwable throwable) {
                TCPTransportImpl.this.connect_request_key = null;
                connectListener.connectFailure(throwable);
            }
        };
        InetSocketAddress inetSocketAddress2 = bl ? ProxyLoginHandler.DEFAULT_SOCKS_SERVER_ADDRESS : inetSocketAddress;
        TCPNetworkManager.getSingleton().getConnectDisconnectManager().requestNewConnection(inetSocketAddress2, connectListener2, n);
    }

    protected void handleCrypto(InetSocketAddress inetSocketAddress, final SocketChannel socketChannel, final ByteBuffer byteBuffer, final int n, final Transport.ConnectListener connectListener) {
        if (this.connect_with_crypto) {
            final TCPTransportHelper tCPTransportHelper = new TCPTransportHelper(socketChannel);
            TransportCryptoManager.getSingleton().manageCrypto(tCPTransportHelper, this.shared_secrets, false, byteBuffer, new TransportCryptoManager.HandshakeListener(){

                public void handshakeSuccess(ProtocolDecoder protocolDecoder, ByteBuffer byteBuffer2) {
                    TransportHelperFilter transportHelperFilter = protocolDecoder.getFilter();
                    TCPTransportImpl.this.setFilter(transportHelperFilter);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Outgoing TCP stream to " + socketChannel.socket().getRemoteSocketAddress() + " established, type = " + transportHelperFilter.getName(false)));
                    }
                    TCPTransportImpl.this.connectedOutbound(byteBuffer2, connectListener);
                }

                public void handshakeFailure(Throwable throwable) {
                    if (TCPTransportImpl.this.fallback_allowed && NetworkManager.OUTGOING_HANDSHAKE_FALLBACK_ALLOWED && !TCPTransportImpl.this.has_been_closed) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, TCPTransportImpl.this.description + " | crypto handshake failure [" + throwable.getMessage() + "], attempting non-crypto fallback."));
                        }
                        TCPTransportImpl.this.connect_with_crypto = false;
                        TCPTransportImpl.this.fallback_count++;
                        TCPTransportImpl.this.close(tCPTransportHelper, "Handshake failure and retry");
                        TCPTransportImpl.this.has_been_closed = false;
                        if (byteBuffer != null) {
                            byteBuffer.position(0);
                        }
                        TCPTransportImpl.this.connectOutbound(byteBuffer, connectListener, n);
                    } else {
                        TCPTransportImpl.this.close(tCPTransportHelper, "Handshake failure");
                        connectListener.connectFailure(throwable);
                    }
                }

                public void gotSecret(byte[] byArray) {
                }

                public int getMaximumPlainHeaderLength() {
                    throw new RuntimeException();
                }

                public int matchPlainHeader(ByteBuffer byteBuffer2) {
                    throw new RuntimeException();
                }
            });
        } else {
            this.setFilter(TCPTransportHelperFilterFactory.createTransparentFilter(socketChannel));
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Outgoing TCP stream to " + socketChannel.socket().getRemoteSocketAddress() + " established, type = " + this.getFilter().getName(false) + ", fallback = " + (this.fallback_count == 0 ? "no" : "yes")));
            }
            this.connectedOutbound(byteBuffer, connectListener);
        }
    }

    private void setTransportBuffersSize(int n) {
        if (this.getFilter() == null) {
            Debug.out("socket_channel == null");
            return;
        }
        try {
            SocketChannel socketChannel = this.getSocketChannel();
            socketChannel.socket().setSendBufferSize(n);
            socketChannel.socket().setReceiveBufferSize(n);
            int n2 = socketChannel.socket().getSendBufferSize();
            int n3 = socketChannel.socket().getReceiveBufferSize();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Setting new transport [" + this.description + "] buffer sizes: SND=" + n + " [" + n2 + "] , RCV=" + n + " [" + n3 + "]"));
            }
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
    }

    public void setTransportMode(int n) {
        if (n == this.transport_mode) {
            return;
        }
        switch (n) {
            case 0: {
                this.setTransportBuffersSize(8192);
                break;
            }
            case 1: {
                this.setTransportBuffersSize(65536);
                break;
            }
            case 2: {
                this.setTransportBuffersSize(524288);
                break;
            }
            default: {
                Debug.out("invalid transport mode given: " + n);
            }
        }
        this.transport_mode = n;
    }

    protected void connectedOutbound(ByteBuffer byteBuffer, Transport.ConnectListener connectListener) {
        if (this.has_been_closed) {
            TransportHelperFilter transportHelperFilter = this.getFilter();
            if (transportHelperFilter != null) {
                transportHelperFilter.getHelper().close("Connection closed");
                this.setFilter(null);
            }
            connectListener.connectFailure(new Throwable("Connection closed"));
        } else {
            this.connectedOutbound();
            connectListener.connectSuccess(this, byteBuffer);
        }
    }

    public int getTransportMode() {
        return this.transport_mode;
    }

    protected void close(TransportHelper transportHelper, String string) {
        transportHelper.close(string);
        this.close(string);
    }

    public void close(String string) {
        this.has_been_closed = true;
        if (this.connect_request_key != null) {
            TCPNetworkManager.getSingleton().getConnectDisconnectManager().cancelRequest(this.connect_request_key);
        }
        this.readyForRead(false);
        this.readyForWrite(false);
        TransportHelperFilter transportHelperFilter = this.getFilter();
        if (transportHelperFilter != null) {
            transportHelperFilter.getHelper().close(string);
            this.setFilter(null);
        }
        this.setReadyForRead();
    }
}

