/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class VirtualAcceptSelector {
    private static final VirtualAcceptSelector singleton = new VirtualAcceptSelector();
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private final VirtualChannelSelector accept_selector = new VirtualChannelSelector("Accepter", 16, false);

    public static VirtualAcceptSelector getSingleton() {
        return singleton;
    }

    protected VirtualAcceptSelector() {
        AEThread aEThread = new AEThread("Accept Selector"){

            public void runSupport() {
                while (true) {
                    try {
                        while (true) {
                            VirtualAcceptSelector.this.accept_selector.select(50L);
                        }
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                        continue;
                    }
                    break;
                }
            }
        };
        aEThread.setDaemon(true);
        aEThread.start();
    }

    public void register(ServerSocketChannel serverSocketChannel, final AcceptListener acceptListener) {
        this.accept_selector.register(serverSocketChannel, new VirtualChannelSelector.VirtualAcceptSelectorListener(){

            public boolean selectSuccess(VirtualChannelSelector virtualChannelSelector, ServerSocketChannel serverSocketChannel, Object object) {
                try {
                    SocketChannel socketChannel = serverSocketChannel.accept();
                    if (socketChannel == null) {
                        return false;
                    }
                    socketChannel.configureBlocking(false);
                    acceptListener.newConnectionAccepted(socketChannel);
                    return true;
                }
                catch (IOException iOException) {
                    Debug.printStackTrace(iOException);
                    return true;
                }
            }

            public void selectFailure(VirtualChannelSelector virtualChannelSelector, ServerSocketChannel serverSocketChannel, Object object, Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }, null);
    }

    public void cancel(ServerSocketChannel serverSocketChannel) {
        this.accept_selector.cancel(serverSocketChannel);
    }

    public static interface AcceptListener {
        public void newConnectionAccepted(SocketChannel var1);
    }
}

