/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPTransport;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public class ProtocolEndpointUDP
implements ProtocolEndpoint {
    private ConnectionEndpoint ce;
    private InetSocketAddress address;

    public ProtocolEndpointUDP(ConnectionEndpoint connectionEndpoint, InetSocketAddress inetSocketAddress) {
        this.ce = connectionEndpoint;
        this.address = inetSocketAddress;
        this.ce.addProtocol(this);
    }

    public ProtocolEndpointUDP(InetSocketAddress inetSocketAddress) {
        this.ce = new ConnectionEndpoint(inetSocketAddress);
        this.address = inetSocketAddress;
        this.ce.addProtocol(this);
    }

    public void setConnectionEndpoint(ConnectionEndpoint connectionEndpoint) {
        this.ce = connectionEndpoint;
        this.ce.addProtocol(this);
    }

    public int getType() {
        return 2;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public ConnectionEndpoint getConnectionEndpoint() {
        return this.ce;
    }

    public Transport connectOutbound(boolean bl, boolean bl2, byte[][] byArray, ByteBuffer byteBuffer, int n, Transport.ConnectListener connectListener) {
        UDPTransport uDPTransport = new UDPTransport(this, byArray);
        uDPTransport.connectOutbound(byteBuffer, connectListener, n);
        return uDPTransport;
    }

    public String getDescription() {
        return this.address.toString();
    }
}

