/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.IncomingConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TransportCryptoManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.udp.NetworkGlue;
import com.aelitis.azureus.core.networkmanager.impl.udp.NetworkGlueListener;
import com.aelitis.azureus.core.networkmanager.impl.udp.NetworkGlueUDP;
import com.aelitis.azureus.core.networkmanager.impl.udp.ProtocolEndpointUDP;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnection;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnectionSet;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPSelector;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPTransport;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPTransportHelper;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class UDPConnectionManager
implements NetworkGlueListener {
    private static final LogIDs LOGID = LogIDs.NET;
    private static final boolean LOOPBACK = false;
    private static final boolean FORCE_LOG = false;
    private static boolean LOG = false;
    private static int max_outbound_connections;
    public static final int TIMER_TICK_MILLIS = 25;
    public static final int THREAD_LINGER_ON_IDLE_PERIOD = 30000;
    public static final int DEAD_KEY_RETENTION_PERIOD = 30000;
    public static final int STATS_TIME = 60000;
    public static final int STATS_TICKS = 2400;
    private final Map connection_sets = new HashMap();
    private final Map recently_dead_keys = new HashMap();
    private int next_connection_id;
    private IncomingConnectionManager incoming_manager = IncomingConnectionManager.getSingleton();
    private NetworkGlue network_glue;
    private UDPSelector selector;
    private ProtocolTimer protocol_timer;
    private long idle_start;
    private static final int BLOOM_RECREATE = 30000;
    private static final int BLOOM_INCREASE = 1000;
    private BloomFilter incoming_bloom = BloomFilterFactory.createAddRemove4Bit(1000);
    private long incoming_bloom_create_time = SystemTime.getCurrentTime();
    private long last_incoming;
    private int rate_limit_discard_packets;
    private int rate_limit_discard_bytes;
    private int setup_discard_packets;
    private int setup_discard_bytes;
    private int outbound_connection_count;
    private boolean max_conn_exceeded_logged;

    protected UDPConnectionManager() {
        this.network_glue = new NetworkGlueUDP(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectOutbound(final UDPTransport uDPTransport, final InetSocketAddress inetSocketAddress, byte[][] byArray, ByteBuffer byteBuffer, final Transport.ConnectListener connectListener) {
        UDPTransportHelper uDPTransportHelper = null;
        try {
            connectListener.connectAttemptStarted();
            final UDPTransportHelper uDPTransportHelper2 = uDPTransportHelper = new UDPTransportHelper(this, inetSocketAddress, uDPTransport);
            UDPConnectionManager uDPConnectionManager = this;
            synchronized (uDPConnectionManager) {
                ++this.outbound_connection_count;
                if (this.outbound_connection_count >= max_outbound_connections && !this.max_conn_exceeded_logged) {
                    this.max_conn_exceeded_logged = true;
                    Debug.out("UDPConnectionManager: max outbound connection limit reached (" + max_outbound_connections + ")");
                }
            }
            try {
                TransportCryptoManager.getSingleton().manageCrypto(uDPTransportHelper, byArray, false, byteBuffer, new TransportCryptoManager.HandshakeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handshakeSuccess(ProtocolDecoder protocolDecoder, ByteBuffer byteBuffer) {
                        Object object = UDPConnectionManager.this;
                        synchronized (object) {
                            if (UDPConnectionManager.this.outbound_connection_count > 0) {
                                UDPConnectionManager.this.outbound_connection_count--;
                            }
                        }
                        object = protocolDecoder.getFilter();
                        try {
                            uDPTransport.setFilter((TransportHelperFilter)object);
                            if (uDPTransport.isClosed()) {
                                uDPTransport.close("Already closed");
                                connectListener.connectFailure(new Exception("Connection already closed"));
                            } else {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(LOGID, "Outgoing UDP stream to " + inetSocketAddress + " established, type = " + object.getName(false)));
                                }
                                uDPTransport.connectedOutbound();
                                connectListener.connectSuccess(uDPTransport, byteBuffer);
                            }
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                            uDPTransport.close(Debug.getNestedExceptionMessageAndStack(throwable));
                            connectListener.connectFailure(throwable);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handshakeFailure(Throwable throwable) {
                        UDPConnectionManager uDPConnectionManager = UDPConnectionManager.this;
                        synchronized (uDPConnectionManager) {
                            if (UDPConnectionManager.this.outbound_connection_count > 0) {
                                UDPConnectionManager.this.outbound_connection_count--;
                            }
                        }
                        uDPTransportHelper2.close(Debug.getNestedExceptionMessageAndStack(throwable));
                        connectListener.connectFailure(throwable);
                    }

                    public void gotSecret(byte[] byArray) {
                        uDPTransportHelper2.getConnection().setSecret(byArray);
                    }

                    public int getMaximumPlainHeaderLength() {
                        throw new RuntimeException();
                    }

                    public int matchPlainHeader(ByteBuffer byteBuffer) {
                        throw new RuntimeException();
                    }
                });
            }
            catch (Throwable throwable) {
                UDPConnectionManager uDPConnectionManager2 = this;
                synchronized (uDPConnectionManager2) {
                    if (this.outbound_connection_count > 0) {
                        --this.outbound_connection_count;
                    }
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            if (uDPTransportHelper != null) {
                uDPTransportHelper.close(Debug.getNestedExceptionMessage(throwable));
            }
            connectListener.connectFailure(throwable);
        }
    }

    public int getMaxOutboundPermitted() {
        return Math.max(max_outbound_connections - this.outbound_connection_count, 0);
    }

    protected UDPSelector checkThreadCreation() {
        if (this.selector == null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "UDPConnectionManager: activating"));
            }
            this.selector = new UDPSelector(this);
            this.protocol_timer = new ProtocolTimer();
        }
        return this.selector;
    }

    protected void checkThreadDeath(boolean bl) {
        if (bl) {
            this.idle_start = 0L;
        } else {
            long l = SystemTime.getCurrentTime();
            if (this.idle_start == 0L) {
                this.idle_start = l;
            } else if (this.idle_start > l) {
                this.idle_start = l;
            } else if (l - this.idle_start > 30000L) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "UDPConnectionManager: deactivating"));
                }
                this.selector.destroy();
                this.selector = null;
                this.protocol_timer.destroy();
                this.protocol_timer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poll() {
        Map map = this.connection_sets;
        synchronized (map) {
            Iterator iterator = this.connection_sets.values().iterator();
            while (iterator.hasNext()) {
                ((UDPConnectionSet)iterator.next()).poll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(UDPConnectionSet uDPConnectionSet, UDPConnection uDPConnection) {
        Map map = this.connection_sets;
        synchronized (map) {
            if (uDPConnectionSet.remove(uDPConnection)) {
                String string = uDPConnectionSet.getKey();
                if (uDPConnectionSet.hasFailed() && this.connection_sets.remove(string) != null) {
                    uDPConnectionSet.removed();
                    this.recently_dead_keys.put(string, new Long(SystemTime.getCurrentTime()));
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Connection set " + string + " failed"));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(UDPConnectionSet uDPConnectionSet) {
        Map map = this.connection_sets;
        synchronized (map) {
            String string = uDPConnectionSet.getKey();
            if (this.connection_sets.remove(string) != null) {
                uDPConnectionSet.removed();
                this.recently_dead_keys.put(string, new Long(SystemTime.getCurrentTime()));
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Connection set " + string + " failed"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UDPConnection registerOutgoing(UDPTransportHelper uDPTransportHelper) throws IOException {
        int n = UDPNetworkManager.getSingleton().getUDPListeningPortNumber();
        InetSocketAddress inetSocketAddress = uDPTransportHelper.getAddress();
        String string = n + ":" + inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort();
        Map map = this.connection_sets;
        synchronized (map) {
            UDPSelector uDPSelector = this.checkThreadCreation();
            UDPConnectionSet uDPConnectionSet = (UDPConnectionSet)this.connection_sets.get(string);
            if (uDPConnectionSet == null) {
                this.timeoutDeadKeys();
                uDPConnectionSet = new UDPConnectionSet(this, string, uDPSelector, n, inetSocketAddress);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Created new set - " + uDPConnectionSet.getName() + ", outgoing"));
                }
                this.connection_sets.put(string, uDPConnectionSet);
            }
            UDPConnection uDPConnection = new UDPConnection(uDPConnectionSet, this.allocationConnectionID(), uDPTransportHelper);
            uDPConnectionSet.add(uDPConnection);
            return uDPConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(int n, InetSocketAddress inetSocketAddress, byte[] byArray, int n2) {
        UDPConnectionSet uDPConnectionSet;
        String string = n + ":" + inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort();
        Map map = this.connection_sets;
        synchronized (map) {
            UDPSelector uDPSelector = this.checkThreadCreation();
            uDPConnectionSet = (UDPConnectionSet)this.connection_sets.get(string);
            if (uDPConnectionSet == null) {
                this.timeoutDeadKeys();
                if (n2 >= UDPNetworkManager.MIN_INCOMING_INITIAL_PACKET_SIZE && n2 <= UDPNetworkManager.MAX_INCOMING_INITIAL_PACKET_SIZE) {
                    if (!this.rateLimitIncoming(inetSocketAddress)) {
                        ++this.rate_limit_discard_packets;
                        this.rate_limit_discard_bytes += n2;
                        return;
                    }
                    uDPConnectionSet = new UDPConnectionSet(this, string, uDPSelector, n, inetSocketAddress);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Created new set - " + uDPConnectionSet.getName() + ", incoming"));
                    }
                    this.connection_sets.put(string, uDPConnectionSet);
                } else {
                    if (this.recently_dead_keys.get(string) == null) {
                        // empty if block
                    }
                    ++this.setup_discard_packets;
                    this.setup_discard_bytes += n2;
                    return;
                }
            }
        }
        try {
            uDPConnectionSet.receive(byArray, n2);
        }
        catch (IOException iOException) {
            uDPConnectionSet.failed(iOException);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            uDPConnectionSet.failed(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean rateLimitIncoming(InetSocketAddress inetSocketAddress) {
        long l;
        long l2 = SystemTime.getCurrentTime();
        byte[] byArray = inetSocketAddress.getAddress().getAddress();
        UDPConnectionManager uDPConnectionManager = this;
        synchronized (uDPConnectionManager) {
            int n = this.incoming_bloom.add(byArray);
            if (this.incoming_bloom.getSize() / this.incoming_bloom.getEntryCount() < 10) {
                this.incoming_bloom = BloomFilterFactory.createAddRemove4Bit(this.incoming_bloom.getSize() + 1000);
                this.incoming_bloom_create_time = l2;
                Logger.log(new LogEvent(LOGID, "UDP connnection bloom: size increased to " + this.incoming_bloom.getSize()));
            } else if (l2 < this.incoming_bloom_create_time || l2 - this.incoming_bloom_create_time > 30000L) {
                this.incoming_bloom = BloomFilterFactory.createAddRemove4Bit(this.incoming_bloom.getSize());
                this.incoming_bloom_create_time = l2;
            }
            if (n >= 15) {
                Logger.log(new LogEvent(LOGID, "UDP incoming: too many recent connection attempts from " + inetSocketAddress));
                return false;
            }
            long l3 = l2 - this.last_incoming;
            l = 100L - l3;
            this.last_incoming = l2;
        }
        if (l > 0L && l < 100L) {
            try {
                Thread.sleep(l);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    public int send(int n, InetSocketAddress inetSocketAddress, byte[] byArray) throws IOException {
        return this.network_glue.send(n, inetSocketAddress, byArray);
    }

    protected void accept(final int n, final InetSocketAddress inetSocketAddress, final UDPConnection uDPConnection) {
        final UDPTransportHelper uDPTransportHelper = new UDPTransportHelper(this, inetSocketAddress, uDPConnection);
        try {
            uDPConnection.setTransport(uDPTransportHelper);
            TransportCryptoManager.getSingleton().manageCrypto(uDPTransportHelper, null, true, null, new TransportCryptoManager.HandshakeListener(){

                public void handshakeSuccess(ProtocolDecoder protocolDecoder, ByteBuffer byteBuffer) {
                    TransportHelperFilter transportHelperFilter = protocolDecoder.getFilter();
                    ConnectionEndpoint connectionEndpoint = new ConnectionEndpoint(inetSocketAddress);
                    ProtocolEndpointUDP protocolEndpointUDP = new ProtocolEndpointUDP(connectionEndpoint, inetSocketAddress);
                    UDPTransport uDPTransport = new UDPTransport(protocolEndpointUDP, transportHelperFilter);
                    uDPTransportHelper.setTransport(uDPTransport);
                    UDPConnectionManager.this.incoming_manager.addConnection(n, transportHelperFilter, uDPTransport);
                }

                public void handshakeFailure(Throwable throwable) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "incoming crypto handshake failure: " + Debug.getNestedExceptionMessage(throwable)));
                    }
                    uDPConnection.close("handshake failure: " + Debug.getNestedExceptionMessage(throwable));
                }

                public void gotSecret(byte[] byArray) {
                    uDPTransportHelper.getConnection().setSecret(byArray);
                }

                public int getMaximumPlainHeaderLength() {
                    return UDPConnectionManager.this.incoming_manager.getMaxMinMatchBufferSize();
                }

                public int matchPlainHeader(ByteBuffer byteBuffer) {
                    Object[] objectArray = UDPConnectionManager.this.incoming_manager.checkForMatch(uDPTransportHelper, n, byteBuffer, true);
                    if (objectArray == null) {
                        return 1;
                    }
                    return 2;
                }
            });
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            uDPTransportHelper.close(Debug.getNestedExceptionMessage(throwable));
        }
    }

    protected synchronized int allocationConnectionID() {
        int n;
        if ((n = this.next_connection_id++) < 0) {
            n = 0;
            this.next_connection_id = 1;
        }
        return n;
    }

    protected void timeoutDeadKeys() {
        Iterator iterator = this.recently_dead_keys.values().iterator();
        long l = SystemTime.getCurrentTime();
        while (iterator.hasNext()) {
            long l2 = (Long)iterator.next();
            if (l2 <= l && l - l2 <= 30000L) continue;
            iterator.remove();
        }
    }

    protected void logStats() {
        if (Logger.isEnabled()) {
            long[] lArray = this.network_glue.getStats();
            String string = "UDPConnection stats: sent=" + lArray[0] + "/" + lArray[1] + ",received=" + lArray[2] + "/" + lArray[3];
            string = string + ", setup discards=" + this.setup_discard_packets + "/" + this.setup_discard_bytes;
            string = string + ", rate discards=" + this.rate_limit_discard_packets + "/" + this.rate_limit_discard_bytes;
            Logger.log(new LogEvent(LOGID, string));
        }
    }

    protected boolean trace() {
        return LOG;
    }

    protected void trace(String string) {
        if (LOG && Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, string));
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Logging Enable UDP Transport", "network.udp.max.connections.outstanding"}, new ParameterListener(){

            public void parameterChanged(String string) {
                LOG = COConfigurationManager.getBooleanParameter("Logging Enable UDP Transport");
                max_outbound_connections = COConfigurationManager.getIntParameter("network.udp.max.connections.outstanding", 2048);
            }
        });
    }

    protected class ProtocolTimer {
        private volatile boolean destroyed;

        protected ProtocolTimer() {
            new AEThread2("UDPConnectionManager:timer", true){
                private int tick_count;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Thread.currentThread().setPriority(6);
                    while (!ProtocolTimer.this.destroyed) {
                        try {
                            Thread.sleep(25L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ++this.tick_count;
                        if (this.tick_count % 2400 == 0) {
                            UDPConnectionManager.this.logStats();
                        }
                        ArrayList<Object[]> arrayList = null;
                        Map map = UDPConnectionManager.this.connection_sets;
                        synchronized (map) {
                            int n = UDPConnectionManager.this.connection_sets.size();
                            UDPConnectionManager.this.checkThreadDeath(n > 0);
                            if (n > 0) {
                                Iterator iterator = UDPConnectionManager.this.connection_sets.values().iterator();
                                while (iterator.hasNext()) {
                                    UDPConnectionSet uDPConnectionSet = (UDPConnectionSet)iterator.next();
                                    try {
                                        uDPConnectionSet.timerTick();
                                        if (!uDPConnectionSet.idleLimitExceeded()) continue;
                                        if (Logger.isEnabled()) {
                                            Logger.log(new LogEvent(LOGID, "Idle limit exceeded for " + uDPConnectionSet.getName() + ", removing"));
                                        }
                                        UDPConnectionManager.this.recently_dead_keys.put(uDPConnectionSet.getKey(), new Long(SystemTime.getCurrentTime()));
                                        iterator.remove();
                                        uDPConnectionSet.removed();
                                    }
                                    catch (Throwable throwable) {
                                        if (arrayList == null) {
                                            arrayList = new ArrayList<Object[]>();
                                        }
                                        arrayList.add(new Object[]{uDPConnectionSet, throwable});
                                    }
                                }
                            }
                        }
                        if (arrayList == null) continue;
                        for (int i = 0; i < arrayList.size(); ++i) {
                            Object[] objectArray = (Object[])arrayList.get(i);
                            ((UDPConnectionSet)objectArray[0]).failed((Throwable)objectArray[1]);
                        }
                    }
                    UDPConnectionManager.this.logStats();
                }
            }.start();
        }

        protected void destroy() {
            this.destroyed = true;
        }
    }
}

