/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoderPHE;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnectionManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;

public class UDPNetworkManager {
    public static final int PROTOCOL_HEADER_SIZE = 30;
    public static final boolean MINIMISE_OVERHEADS = true;
    public static final int MIN_INCOMING_INITIAL_PACKET_SIZE = ProtocolDecoderPHE.MIN_INCOMING_INITIAL_PACKET_SIZE;
    public static final int MAX_INCOMING_INITIAL_PACKET_SIZE = ProtocolDecoderPHE.getMaxIncomingInitialPacketSize(true);
    private static final int MIN_MSS = 128;
    private static final int MAX_MSS = 8192;
    private static int udp_mss_size;
    public static boolean UDP_INCOMING_ENABLED;
    public static boolean UDP_OUTGOING_ENABLED;
    private static UDPNetworkManager singleton;
    private int udp_listen_port = -1;
    private int udp_non_data_listen_port = -1;
    private UDPConnectionManager _connection_manager;

    public static int getUdpMssSize() {
        return udp_mss_size;
    }

    public static void refreshRates(int n) {
        udp_mss_size = COConfigurationManager.getIntParameter("network.udp.mtu.size") - 30;
        if (udp_mss_size > n) {
            udp_mss_size = n - 1;
        }
        if (udp_mss_size < 128) {
            udp_mss_size = 128;
        }
        if (udp_mss_size > 8192) {
            udp_mss_size = 8192;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UDPNetworkManager getSingleton() {
        Class<UDPNetworkManager> clazz = UDPNetworkManager.class;
        synchronized (UDPNetworkManager.class) {
            if (singleton == null) {
                singleton = new UDPNetworkManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    protected UDPNetworkManager() {
        COConfigurationManager.addAndFireParameterListener("UDP.Listen.Port", new ParameterListener(){

            public void parameterChanged(String string) {
                int n = COConfigurationManager.getIntParameter(string);
                if (n == UDPNetworkManager.this.udp_listen_port) {
                    return;
                }
                if (n < 0 || n > 65535 || n == 6880) {
                    String string2 = "Invalid incoming UDP listen port configured, " + n + ". The port has been reset. Please check your config!";
                    Debug.out(string2);
                    Logger.log(new LogAlert(false, 3, string2));
                    UDPNetworkManager.this.udp_listen_port = RandomUtils.generateRandomNetworkListenPort();
                    COConfigurationManager.setParameter(string, UDPNetworkManager.this.udp_listen_port);
                } else {
                    UDPNetworkManager.this.udp_listen_port = n;
                }
            }
        });
        COConfigurationManager.addAndFireParameterListener("UDP.NonData.Listen.Port", new ParameterListener(){

            public void parameterChanged(String string) {
                int n = COConfigurationManager.getIntParameter(string);
                if (n == UDPNetworkManager.this.udp_non_data_listen_port) {
                    return;
                }
                if (n < 0 || n > 65535 || n == 6880) {
                    String string2 = "Invalid incoming UDP non-data listen port configured, " + n + ". The port has been reset. Please check your config!";
                    Debug.out(string2);
                    Logger.log(new LogAlert(false, 3, string2));
                    UDPNetworkManager.this.udp_non_data_listen_port = RandomUtils.generateRandomNetworkListenPort();
                    COConfigurationManager.setParameter(string, UDPNetworkManager.this.udp_non_data_listen_port);
                } else {
                    UDPNetworkManager.this.udp_non_data_listen_port = n;
                }
            }
        });
    }

    public boolean isUDPListenerEnabled() {
        return UDP_INCOMING_ENABLED;
    }

    public int getUDPListeningPortNumber() {
        return this.udp_listen_port;
    }

    public boolean isUDPNonDataListenerEnabled() {
        return UDP_INCOMING_ENABLED;
    }

    public int getUDPNonDataListeningPortNumber() {
        return this.udp_non_data_listen_port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UDPConnectionManager getConnectionManager() {
        UDPNetworkManager uDPNetworkManager = this;
        synchronized (uDPNetworkManager) {
            if (this._connection_manager == null) {
                this._connection_manager = new UDPConnectionManager();
            }
        }
        return this._connection_manager;
    }

    static {
        COConfigurationManager.addAndFireParameterListener("UDP.Listen.Port.Enable", new ParameterListener(){

            public void parameterChanged(String string) {
                UDP_INCOMING_ENABLED = UDP_OUTGOING_ENABLED = COConfigurationManager.getBooleanParameter(string);
            }
        });
    }
}

