/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportEndpoint;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportImpl;
import com.aelitis.azureus.core.networkmanager.impl.udp.ProtocolEndpointUDP;
import com.aelitis.azureus.core.networkmanager.impl.udp.TransportEndpointUDP;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.logging.LogIDs;

public class UDPTransport
extends TransportImpl {
    private static final LogIDs LOGID = LogIDs.NET;
    private ProtocolEndpointUDP endpoint;
    private byte[][] shared_secrets;
    private int transport_mode = 0;
    private volatile boolean closed;

    protected UDPTransport(ProtocolEndpointUDP protocolEndpointUDP, byte[][] byArray) {
        this.endpoint = protocolEndpointUDP;
        this.shared_secrets = byArray;
    }

    protected UDPTransport(ProtocolEndpointUDP protocolEndpointUDP, TransportHelperFilter transportHelperFilter) {
        this.endpoint = protocolEndpointUDP;
        this.setFilter(transportHelperFilter);
    }

    public boolean isTCP() {
        return false;
    }

    public TransportEndpoint getTransportEndpoint() {
        return new TransportEndpointUDP(this.endpoint);
    }

    public int getMssSize() {
        return UDPNetworkManager.getUdpMssSize();
    }

    public String getDescription() {
        return this.endpoint.getAddress().toString();
    }

    public void setTransportMode(int n) {
        this.transport_mode = n;
    }

    public int getTransportMode() {
        return this.transport_mode;
    }

    public void connectOutbound(ByteBuffer byteBuffer, Transport.ConnectListener connectListener, int n) {
        if (!UDPNetworkManager.UDP_OUTGOING_ENABLED) {
            connectListener.connectFailure(new Throwable("Outbound UDP connections disabled"));
            return;
        }
        if (this.closed) {
            connectListener.connectFailure(new Throwable("Connection already closed"));
            return;
        }
        if (this.getFilter() != null) {
            connectListener.connectFailure(new Throwable("Already connected"));
            return;
        }
        UDPConnectionManager uDPConnectionManager = UDPNetworkManager.getSingleton().getConnectionManager();
        uDPConnectionManager.connectOutbound(this, this.endpoint.getAddress(), this.shared_secrets, byteBuffer, connectListener);
    }

    public void close(String string) {
        this.closed = true;
        this.readyForRead(false);
        this.readyForWrite(false);
        TransportHelperFilter transportHelperFilter = this.getFilter();
        if (transportHelperFilter != null) {
            transportHelperFilter.getHelper().close(string);
            this.setFilter(null);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

