/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnection;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPSelector;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPTransport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;

public class UDPTransportHelper
implements TransportHelper {
    public static final int READ_TIMEOUT = 30000;
    public static final int CONNECT_TIMEOUT = 60000;
    private UDPConnectionManager manager;
    private UDPSelector selector;
    private InetSocketAddress address;
    private UDPTransport transport;
    private boolean incoming;
    private UDPConnection connection;
    private TransportHelper.selectListener read_listener;
    private Object read_attachment;
    private boolean read_selects_paused;
    private TransportHelper.selectListener write_listener;
    private Object write_attachment;
    private boolean write_selects_paused = true;
    private boolean closed;
    private IOException failed;
    private ByteBuffer pending_partial_write;
    private Map user_data;

    public UDPTransportHelper(UDPConnectionManager uDPConnectionManager, InetSocketAddress inetSocketAddress, UDPTransport uDPTransport) throws IOException {
        this.manager = uDPConnectionManager;
        this.address = inetSocketAddress;
        this.transport = uDPTransport;
        this.incoming = false;
        this.connection = this.manager.registerOutgoing(this);
        this.selector = this.connection.getSelector();
    }

    public UDPTransportHelper(UDPConnectionManager uDPConnectionManager, InetSocketAddress inetSocketAddress, UDPConnection uDPConnection) {
        this.manager = uDPConnectionManager;
        this.address = inetSocketAddress;
        this.connection = uDPConnection;
        this.incoming = true;
        this.selector = this.connection.getSelector();
    }

    protected void setTransport(UDPTransport uDPTransport) {
        this.transport = uDPTransport;
    }

    protected UDPTransport getTransport() {
        return this.transport;
    }

    protected int getMss() {
        if (this.transport == null) {
            return UDPNetworkManager.getUdpMssSize();
        }
        return this.transport.getMssSize();
    }

    public boolean minimiseOverheads() {
        return true;
    }

    public int getConnectTimeout() {
        return 60000;
    }

    public int getReadTimeout() {
        return 30000;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public String getName(boolean bl) {
        return "UDP";
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    protected UDPConnection getConnection() {
        return this.connection;
    }

    public boolean delayWrite(ByteBuffer byteBuffer) {
        return false;
    }

    public boolean hasDelayedWrite() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer byteBuffer, boolean bl) throws IOException {
        Object object = this;
        synchronized (object) {
            if (this.failed != null) {
                throw this.failed;
            }
            if (this.closed) {
                throw new IOException("Transport closed");
            }
        }
        if (bl && this.pending_partial_write == null && byteBuffer.remaining() < 128) {
            object = ByteBuffer.allocate(byteBuffer.remaining());
            ((ByteBuffer)object).put(byteBuffer);
            ((ByteBuffer)object).position(0);
            this.pending_partial_write = object;
            return ((Buffer)object).remaining();
        }
        if (this.pending_partial_write != null) {
            block13: {
                int n;
                try {
                    int n2 = this.pending_partial_write.remaining();
                    int n3 = this.connection.write(new ByteBuffer[]{this.pending_partial_write, byteBuffer}, 0, 2);
                    if (n3 < n2) break block13;
                    n = n3 - n2;
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    if (this.pending_partial_write.remaining() == 0) {
                        this.pending_partial_write = null;
                    }
                    throw throwable;
                }
                if (this.pending_partial_write.remaining() == 0) {
                    this.pending_partial_write = null;
                }
                return n;
            }
            int n = 0;
            Object var7_10 = null;
            if (this.pending_partial_write.remaining() == 0) {
                this.pending_partial_write = null;
            }
            return n;
        }
        return this.connection.write(new ByteBuffer[]{byteBuffer}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        ByteBuffer[] byteBufferArray2 = this;
        synchronized (this) {
            if (this.failed != null) {
                throw this.failed;
            }
            if (this.closed) {
                throw new IOException("Transport closed");
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (this.pending_partial_write != null) {
                block13: {
                    long l;
                    int n3;
                    byteBufferArray2 = new ByteBuffer[n2 + 1];
                    byteBufferArray2[0] = this.pending_partial_write;
                    int n4 = 1;
                    for (n3 = n; n3 < n + n2; ++n3) {
                        byteBufferArray2[n4++] = byteBufferArray[n3];
                    }
                    try {
                        n3 = this.pending_partial_write.remaining();
                        int n5 = this.connection.write(byteBufferArray2, 0, byteBufferArray2.length);
                        if (n5 < n3) break block13;
                        l = n5 - n3;
                        Object var11_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        if (this.pending_partial_write.remaining() == 0) {
                            this.pending_partial_write = null;
                        }
                        throw throwable;
                    }
                    if (this.pending_partial_write.remaining() == 0) {
                        this.pending_partial_write = null;
                    }
                    return l;
                }
                long l = 0L;
                Object var11_12 = null;
                if (this.pending_partial_write.remaining() == 0) {
                    this.pending_partial_write = null;
                }
                return l;
            }
            return this.connection.write(byteBufferArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            if (this.failed != null) {
                throw this.failed;
            }
            if (this.closed) {
                throw new IOException("Transport closed");
            }
        }
        return this.connection.read(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            if (this.failed != null) {
                throw this.failed;
            }
            if (this.closed) {
                throw new IOException("Transport closed");
            }
        }
        long l = 0L;
        for (int i = n; i < n + n2; ++i) {
            ByteBuffer byteBuffer = byteBufferArray[i];
            int n3 = byteBuffer.remaining();
            int n4 = this.connection.read(byteBuffer);
            l += (long)n4;
            if (n4 < n3) break;
        }
        return l;
    }

    protected void canRead() {
        this.fireReadSelect();
    }

    protected void canWrite() {
        this.fireWriteSelect();
    }

    public synchronized void pauseReadSelects() {
        if (this.read_listener != null) {
            this.selector.cancel(this, this.read_listener);
        }
        this.read_selects_paused = true;
    }

    public synchronized void pauseWriteSelects() {
        if (this.write_listener != null) {
            this.selector.cancel(this, this.write_listener);
        }
        this.write_selects_paused = true;
    }

    public synchronized void resumeReadSelects() {
        this.read_selects_paused = false;
        this.fireReadSelect();
    }

    public synchronized void resumeWriteSelects() {
        this.write_selects_paused = false;
        this.fireWriteSelect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForReadSelects(TransportHelper.selectListener selectListener2, Object object) {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            this.read_listener = selectListener2;
            this.read_attachment = object;
        }
        this.resumeReadSelects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForWriteSelects(TransportHelper.selectListener selectListener2, Object object) {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            this.write_listener = selectListener2;
            this.write_attachment = object;
        }
        this.resumeWriteSelects();
    }

    public synchronized void cancelReadSelects() {
        this.selector.cancel(this, this.read_listener);
        this.read_selects_paused = true;
        this.read_listener = null;
        this.read_attachment = null;
    }

    public synchronized void cancelWriteSelects() {
        this.selector.cancel(this, this.write_listener);
        this.write_selects_paused = true;
        this.write_listener = null;
        this.write_attachment = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireReadSelect() {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            if (this.read_listener != null && !this.read_selects_paused) {
                if (this.failed != null) {
                    this.selector.ready(this, this.read_listener, this.read_attachment, this.failed);
                } else if (this.closed) {
                    this.selector.ready(this, this.read_listener, this.read_attachment, new Throwable("Transport closed"));
                } else if (this.connection.canRead()) {
                    this.selector.ready(this, this.read_listener, this.read_attachment);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireWriteSelect() {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            if (this.write_listener != null && !this.write_selects_paused) {
                if (this.failed != null) {
                    this.write_selects_paused = true;
                    this.selector.ready(this, this.write_listener, this.write_attachment, this.failed);
                } else if (this.closed) {
                    this.write_selects_paused = true;
                    this.selector.ready(this, this.write_listener, this.write_attachment, new Throwable("Transport closed"));
                } else if (this.connection.canWrite()) {
                    this.write_selects_paused = true;
                    this.selector.ready(this, this.write_listener, this.write_attachment);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(Throwable throwable) {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            this.failed = throwable instanceof IOException ? (IOException)throwable : new IOException(Debug.getNestedExceptionMessageAndStack(throwable));
            this.fireReadSelect();
            this.fireWriteSelect();
        }
        this.connection.failedSupport(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String string) {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            this.closed = true;
            this.fireReadSelect();
            this.fireWriteSelect();
        }
        this.connection.closeSupport(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poll() {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            this.fireReadSelect();
            this.fireWriteSelect();
        }
    }

    public synchronized void setUserData(Object object, Object object2) {
        if (this.user_data == null) {
            this.user_data = new HashMap();
        }
        this.user_data.put(object, object2);
    }

    public synchronized Object getUserData(Object object) {
        if (this.user_data == null) {
            return null;
        }
        return this.user_data.get(object);
    }

    public void setTrace(boolean bl) {
    }

    public void setScatteringMode(long l) {
    }
}

