/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.pairing.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminHTTPProxy;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.aelitis.azureus.core.pairing.PairedService;
import com.aelitis.azureus.core.pairing.PairingConnectionData;
import com.aelitis.azureus.core.pairing.PairingException;
import com.aelitis.azureus.core.pairing.PairingManager;
import com.aelitis.azureus.core.pairing.PairingManagerListener;
import com.aelitis.azureus.core.security.CryptoManager;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import com.aelitis.net.upnp.UPnPRootDevice;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AEVerifier;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.HyperlinkParameter;
import org.gudy.azureus2.plugins.ui.config.InfoParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairingManagerImpl
implements PairingManager {
    private static final boolean DEBUG = false;
    private static final String SERVICE_URL;
    private static final PairingManagerImpl singleton;
    private static final int GLOBAL_UPDATE_PERIOD = 60000;
    private static final int CD_REFRESH_PERIOD = 82800000;
    private static final int CD_REFRESH_TICKS = 1380;
    private AzureusCore azureus_core;
    private BooleanParameter param_enable;
    private InfoParameter param_ac_info;
    private InfoParameter param_status_info;
    private HyperlinkParameter param_view;
    private BooleanParameter param_e_enable;
    private StringParameter param_ipv4;
    private StringParameter param_ipv6;
    private StringParameter param_host;
    private Map<String, PairedServiceImpl> services = new HashMap<String, PairedServiceImpl>();
    private AESemaphore init_sem = new AESemaphore("PM:init");
    private TimerEventPeriodic global_update_event;
    private InetAddress current_v4;
    private InetAddress current_v6;
    private boolean update_outstanding;
    private boolean updates_enabled;
    private static final int MIN_UPDATE_PERIOD_DEFAULT = 60000;
    private static final int MAX_UPDATE_PERIOD_DEFAULT = 3600000;
    private int min_update_period = 60000;
    private int max_update_period = 3600000;
    private AsyncDispatcher dispatcher = new AsyncDispatcher();
    private boolean must_update_once;
    private TimerEvent deferred_update_event;
    private long last_update_time = -1L;
    private int consec_update_fails;
    private String last_message;
    private CopyOnWriteList<PairingManagerListener> listeners = new CopyOnWriteList();

    public static PairingManager getSingleton() {
        return singleton;
    }

    protected PairingManagerImpl() {
        this.must_update_once = COConfigurationManager.getBooleanParameter("pairing.updateoutstanding");
        PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
        final UIManager uIManager = pluginInterface.getUIManager();
        BasicPluginConfigModel basicPluginConfigModel = uIManager.createBasicPluginConfigModel("server", "Pairing");
        this.param_enable = basicPluginConfigModel.addBooleanParameter2("pairing.enable", "pairing.enable", false);
        String string = this.readAccessCode();
        this.param_ac_info = basicPluginConfigModel.addInfoParameter2("pairing.accesscode", string);
        this.param_status_info = basicPluginConfigModel.addInfoParameter2("pairing.status.info", "");
        this.param_view = basicPluginConfigModel.addHyperlinkParameter2("pairing.view.registered", SERVICE_URL + "/web/view?ac=" + string);
        if (string.length() == 0) {
            this.param_view.setEnabled(false);
        }
        final ActionParameter actionParameter = basicPluginConfigModel.addActionParameter2("pairing.ac.getnew", "pairing.ac.getnew.create");
        actionParameter.addListener(new ParameterListener(){

            public void parameterChanged(Parameter parameter) {
                try {
                    actionParameter.setEnabled(false);
                    PairingManagerImpl.this.allocateAccessCode(false);
                    SimpleTimer.addEvent("PM:enabler", SystemTime.getOffsetTime(30000L), new TimerEventPerformer(){

                        public void perform(TimerEvent timerEvent2) {
                            actionParameter.setEnabled(true);
                        }
                    });
                }
                catch (Throwable throwable) {
                    actionParameter.setEnabled(true);
                    String string = MessageText.getString("pairing.alloc.fail", new String[]{Debug.getNestedExceptionMessage(throwable)});
                    uIManager.showMessageBox("pairing.op.fail", "!" + string + "!", 1L);
                }
            }
        });
        LabelParameter labelParameter = basicPluginConfigModel.addLabelParameter2("pairing.explicit.info");
        this.param_e_enable = basicPluginConfigModel.addBooleanParameter2("pairing.explicit.enable", "pairing.explicit.enable", false);
        this.param_ipv4 = basicPluginConfigModel.addStringParameter2("pairing.ipv4", "pairing.ipv4", "");
        this.param_ipv6 = basicPluginConfigModel.addStringParameter2("pairing.ipv6", "pairing.ipv6", "");
        this.param_host = basicPluginConfigModel.addStringParameter2("pairing.host", "pairing.host", "");
        this.param_ipv4.setGenerateIntermediateEvents(false);
        this.param_ipv6.setGenerateIntermediateEvents(false);
        this.param_host.setGenerateIntermediateEvents(false);
        ParameterListener parameterListener = new ParameterListener(){

            public void parameterChanged(Parameter parameter) {
                PairingManagerImpl.this.updateNeeded();
                if (parameter == PairingManagerImpl.this.param_enable) {
                    PairingManagerImpl.this.fireChanged();
                }
            }
        };
        this.param_enable.addListener(parameterListener);
        this.param_e_enable.addListener(parameterListener);
        this.param_ipv4.addListener(parameterListener);
        this.param_ipv6.addListener(parameterListener);
        this.param_host.addListener(parameterListener);
        this.param_e_enable.addEnabledOnSelection(this.param_ipv4);
        this.param_e_enable.addEnabledOnSelection(this.param_ipv6);
        this.param_e_enable.addEnabledOnSelection(this.param_host);
        basicPluginConfigModel.createGroup("pairing.group.explicit", new Parameter[]{labelParameter, this.param_e_enable, this.param_ipv4, this.param_ipv6, this.param_host});
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore azureusCore) {
                PairingManagerImpl.this.initialise(azureusCore);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialise(AzureusCore azureusCore) {
        Object object = this;
        synchronized (object) {
            this.azureus_core = azureusCore;
        }
        try {
            object = PluginInitializer.getDefaultInterface();
            DelayedTask delayedTask = object.getUtilities().createDelayedTask(new Runnable(){

                public void run() {
                    new DelayedEvent("PM:delayinit", 30000L, new AERunnable(){

                        public void runSupport() {
                            PairingManagerImpl.this.enableUpdates();
                        }
                    });
                }
            });
            delayedTask.queue();
            Object var5_5 = null;
            this.init_sem.releaseForever();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.init_sem.releaseForever();
            throw throwable;
        }
    }

    protected void waitForInitialisation() throws PairingException {
        if (!this.init_sem.reserve(30000L)) {
            throw new PairingException("Timeout waiting for initialisation");
        }
    }

    @Override
    public boolean isEnabled() {
        return this.param_enable.getValue();
    }

    protected void setStatus(String string) {
        this.param_status_info.setValue(string);
    }

    protected String readAccessCode() {
        return COConfigurationManager.getStringParameter("pairing.accesscode", "");
    }

    protected void writeAccessCode(String string) {
        COConfigurationManager.setParameter("pairing.accesscode", string);
        this.param_ac_info.setValue(string);
        this.param_view.setHyperlink(SERVICE_URL + "/web/view?ac=" + string);
        this.param_view.setEnabled(string.length() > 0);
    }

    protected String allocateAccessCode(boolean bl) throws PairingException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = this.readAccessCode();
        hashMap.put("ac", string);
        Map<String, Object> map = this.sendRequest("allocate", hashMap);
        try {
            String string2 = this.getString(map, "ac");
            this.writeAccessCode(string2);
            if (!bl) {
                this.updateNeeded();
            }
            return string2;
        }
        catch (Throwable throwable) {
            throw new PairingException("allocation failed", throwable);
        }
    }

    @Override
    public String getAccessCode() throws PairingException {
        this.waitForInitialisation();
        String string = this.readAccessCode();
        if (string == null || string.length() == 0) {
            string = this.allocateAccessCode(false);
        }
        return string;
    }

    @Override
    public String getReplacementAccessCode() throws PairingException {
        this.waitForInitialisation();
        String string = this.allocateAccessCode(false);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PairedService addService(String string) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            PairedServiceImpl pairedServiceImpl = this.services.get(string);
            if (pairedServiceImpl == null) {
                pairedServiceImpl = new PairedServiceImpl(string);
                this.services.put(string, pairedServiceImpl);
            }
            return pairedServiceImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PairedService getService(String string) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            PairedService pairedService = this.services.get(string);
            return pairedService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(PairedServiceImpl pairedServiceImpl) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            String string = pairedServiceImpl.getSID();
            if (this.services.remove(string) != null) {
                // empty if block
            }
        }
        this.updateNeeded();
    }

    protected void sync(PairedServiceImpl pairedServiceImpl) {
        this.updateNeeded();
    }

    protected InetAddress updateAddress(InetAddress inetAddress, InetAddress inetAddress2, boolean bl) {
        if (bl ? inetAddress2 instanceof Inet4Address : inetAddress2 instanceof Inet6Address) {
            return inetAddress;
        }
        if (inetAddress == inetAddress2) {
            return inetAddress;
        }
        if (inetAddress == null || inetAddress2 == null) {
            return inetAddress2;
        }
        if (!inetAddress.equals(inetAddress2)) {
            return inetAddress2;
        }
        return inetAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateGlobals(boolean bl) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            NetworkAdmin networkAdmin = NetworkAdmin.getSingleton();
            InetAddress inetAddress = this.azureus_core.getInstanceManager().getMyInstance().getExternalAddress();
            InetAddress inetAddress2 = this.updateAddress(this.current_v4, inetAddress, false);
            InetAddress inetAddress3 = networkAdmin.getDefaultPublicAddressV6();
            InetAddress inetAddress4 = this.updateAddress(this.current_v6, inetAddress3, true);
            if (inetAddress2 != this.current_v4 || inetAddress4 != this.current_v6) {
                this.current_v4 = inetAddress2;
                this.current_v6 = inetAddress4;
                if (!bl) {
                    this.updateNeeded();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableUpdates() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            this.updates_enabled = true;
            if (this.update_outstanding) {
                this.update_outstanding = false;
                this.updateNeeded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNeeded() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            if (this.updates_enabled) {
                this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        PairingManagerImpl.this.doUpdate();
                    }
                });
            } else {
                this.setStatus(MessageText.getString("pairing.status.initialising"));
                this.update_outstanding = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpdate() {
        long l = SystemTime.getMonotonousTime();
        Object object = this;
        synchronized (object) {
            if (this.deferred_update_event != null) {
                return;
            }
            long l2 = l - this.last_update_time;
            if (this.last_update_time > 0L && l2 < (long)this.min_update_period) {
                this.deferUpdate((long)this.min_update_period - l2);
                return;
            }
        }
        try {
            Object object2;
            object = new HashMap();
            boolean bl = this.param_enable.getValue();
            Object object3 = this;
            synchronized (object3) {
                object2 = new ArrayList<Map<String, String>>();
                object.put("s", object2);
                if (this.services.size() > 0 && bl) {
                    if (this.global_update_event == null) {
                        this.global_update_event = SimpleTimer.addPeriodicEvent("PM:updater", 60000L, new TimerEventPerformer(){
                            private int tick_count;

                            public void perform(TimerEvent timerEvent2) {
                                ++this.tick_count;
                                PairingManagerImpl.this.updateGlobals(false);
                                if (this.tick_count % 1380 == 0) {
                                    PairingManagerImpl.this.updateNeeded();
                                }
                            }
                        });
                        this.updateGlobals(true);
                    }
                    for (PairedServiceImpl object4 : this.services.values()) {
                        object2.add(object4.toMap());
                    }
                } else if (this.global_update_event == null) {
                    if (this.consec_update_fails == 0 && !this.must_update_once) {
                        this.setStatus(MessageText.getString("pairing.status.disabled"));
                        return;
                    }
                } else {
                    this.global_update_event.cancel();
                    this.global_update_event = null;
                }
                this.last_update_time = l;
            }
            object3 = this.readAccessCode();
            if (((String)object3).length() == 0) {
                object3 = this.allocateAccessCode(true);
            }
            object.put("ac", object3);
            object2 = this;
            synchronized (object2) {
                Object object4;
                Object object6;
                if (this.current_v4 != null) {
                    object.put("c_v4", this.current_v4.getHostAddress());
                }
                if (this.current_v6 != null) {
                    object.put("c_v6", this.current_v6.getHostAddress());
                }
                if (this.param_e_enable.getValue()) {
                    String string;
                    object6 = this.param_host.getValue().trim();
                    if (((String)object6).length() > 0) {
                        object.put("e_h", object6);
                    }
                    if ((string = this.param_ipv4.getValue().trim()).length() > 0) {
                        object.put("e_v4", string);
                    }
                    if (((String)(object4 = this.param_ipv6.getValue().trim())).length() > 0) {
                        object.put("e_v4", object4);
                    }
                }
                try {
                    UPnPPlugin uPnPPlugin;
                    object6 = this.azureus_core.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
                    if (object6 != null && (uPnPPlugin = (UPnPPlugin)object6.getPlugin()).isEnabled()) {
                        object4 = new ArrayList();
                        object.put("upnp", object4);
                        UPnPPluginService[] uPnPPluginServiceArray = uPnPPlugin.getServices();
                        HashSet<UPnPRootDevice> hashSet = new HashSet<UPnPRootDevice>();
                        for (UPnPPluginService uPnPPluginService : uPnPPluginServiceArray) {
                            UPnPRootDevice uPnPRootDevice = uPnPPluginService.getService().getGenericService().getDevice().getRootDevice();
                            if (hashSet.contains(uPnPRootDevice)) continue;
                            hashSet.add(uPnPRootDevice);
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            object4.add(hashMap);
                            hashMap.put("i", uPnPRootDevice.getInfo());
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    object6 = NetworkAdmin.getSingleton();
                    NetworkAdminHTTPProxy networkAdminHTTPProxy = ((NetworkAdmin)object6).getHTTPProxy();
                    if (networkAdminHTTPProxy != null) {
                        object.put("hp", networkAdminHTTPProxy.getName());
                    }
                    if (((NetworkAdminSocksProxy[])(object4 = ((NetworkAdmin)object6).getSocksProxies())).length > 0) {
                        object.put("sp", object4[0].getName());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                object.put("_enabled", bl ? 1L : 0L);
            }
            this.sendRequest("update", (Map<String, Object>)object);
            object2 = this;
            synchronized (object2) {
                this.consec_update_fails = 0;
                this.must_update_once = false;
                if (this.deferred_update_event == null) {
                    COConfigurationManager.setParameter("pairing.updateoutstanding", false);
                }
                if (this.global_update_event == null) {
                    this.setStatus(MessageText.getString("pairing.status.disabled"));
                } else {
                    this.setStatus(MessageText.getString("pairing.status.registered", new String[]{new SimpleDateFormat().format(new Date(SystemTime.getCurrentTime()))}));
                }
            }
        }
        catch (Throwable throwable) {
            PairingManagerImpl pairingManagerImpl = this;
            synchronized (pairingManagerImpl) {
                ++this.consec_update_fails;
                long l3 = this.min_update_period;
                for (int i = 0; i < this.consec_update_fails; ++i) {
                    if ((l3 *= 2L) <= (long)this.max_update_period) continue;
                    l3 = this.max_update_period;
                    break;
                }
                this.deferUpdate(l3);
            }
        }
    }

    protected void deferUpdate(long l) {
        long l2 = SystemTime.getOffsetTime(l += 5000L);
        this.setStatus(MessageText.getString("pairing.status.pending", new String[]{new SimpleDateFormat().format(new Date(l2))}));
        COConfigurationManager.setParameter("pairing.updateoutstanding", true);
        this.deferred_update_event = SimpleTimer.addEvent("PM:defer", l2, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent timerEvent2) {
                PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                synchronized (pairingManagerImpl) {
                    PairingManagerImpl.this.deferred_update_event = null;
                }
                COConfigurationManager.setParameter("pairing.updateoutstanding", false);
                PairingManagerImpl.this.updateNeeded();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> sendRequest(String string, Map<String, Object> map) throws PairingException {
        try {
            Object object;
            String string2;
            HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
            CryptoManager cryptoManager = CryptoManagerFactory.getSingleton();
            String string3 = Base32.encode(cryptoManager.getSecureID());
            map.put("_azid", string3);
            try {
                string2 = Base32.encode(cryptoManager.getECCHandler().getPublicKey("pairing"));
                map.put("_pk", string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            hashMap.put("req", map);
            string2 = Base32.encode(BEncoder.encode(hashMap));
            String string4 = "&ver=" + UrlUtils.encode("4.3.0.4") + "&app=" + UrlUtils.encode(SystemProperties.getApplicationName()) + "&locale=" + UrlUtils.encode(MessageText.getCurrentLocale().toString());
            URL uRL = new URL(SERVICE_URL + "/client/" + string + "?request=" + string2 + string4);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            InputStream inputStream = httpURLConnection.getInputStream();
            Map map2 = BDecoder.decode(new BufferedInputStream(inputStream));
            Object object2 = this;
            synchronized (object2) {
                Long l;
                object = (Long)map2.get("min_secs");
                if (object != null) {
                    this.min_update_period = ((Long)object).intValue() * 1000;
                }
                if ((l = (Long)map2.get("max_secs")) != null) {
                    this.max_update_period = l.intValue() * 1000;
                }
            }
            object2 = this.getString(map2, "message");
            if (!(object2 == null || this.last_message != null && this.last_message.equals(object2))) {
                this.last_message = object2;
                try {
                    object = (byte[])map2.get("message_sig");
                    AEVerifier.verifyData((String)object2, (byte[])object);
                    new AEThread2("PairMsg", true, (String)object2){
                        final /* synthetic */ String val$message;
                        {
                            this.val$message = string2;
                            super(string, bl);
                        }

                        public void run() {
                            UIManager uIManager = StaticUtilities.getUIManager(120000L);
                            if (uIManager != null) {
                                uIManager.showMessageBox("pairing.server.warning.title", "!" + this.val$message + "!", 1L);
                            }
                        }
                    }.start();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((object = this.getString(map2, "error")) != null) {
                throw new PairingException((String)object);
            }
            return (Map)map2.get("rep");
        }
        catch (Throwable throwable) {
            throw new PairingException("invocation failed", throwable);
        }
    }

    protected void fireChanged() {
        for (PairingManagerListener pairingManagerListener : this.listeners) {
            try {
                pairingManagerListener.somethingChanged(this);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    @Override
    public void addListener(PairingManagerListener pairingManagerListener) {
        this.listeners.add(pairingManagerListener);
    }

    @Override
    public void removeListener(PairingManagerListener pairingManagerListener) {
        this.listeners.remove(pairingManagerListener);
    }

    protected String getString(Map<String, Object> map, String string) throws IOException {
        byte[] byArray = (byte[])map.get(string);
        if (byArray == null) {
            return null;
        }
        return new String(byArray, "UTF-8");
    }

    static {
        String string = System.getProperty("az.pairing.url", "");
        SERVICE_URL = string.length() == 0 ? "http://pair.vuze.com/pairing" : string;
        singleton = new PairingManagerImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PairedServiceImpl
    implements PairedService,
    PairingConnectionData {
        private String sid;
        private Map<String, String> attributes = new HashMap<String, String>();

        protected PairedServiceImpl(String string) {
            this.sid = string;
        }

        @Override
        public String getSID() {
            return this.sid;
        }

        @Override
        public PairingConnectionData getConnectionData() {
            return this;
        }

        @Override
        public void remove() {
            PairingManagerImpl.this.remove(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAttribute(String string, String string2) {
            PairedServiceImpl pairedServiceImpl = this;
            synchronized (pairedServiceImpl) {
                this.attributes.put(string, string2);
            }
        }

        @Override
        public String getAttribute(String string) {
            return this.attributes.get(string);
        }

        @Override
        public void sync() {
            PairingManagerImpl.this.sync(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map<String, String> toMap() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sid", this.sid);
            PairedServiceImpl pairedServiceImpl = this;
            synchronized (pairedServiceImpl) {
                hashMap.putAll(this.attributes);
            }
            return hashMap;
        }
    }
}

