/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.networkmanager.impl.RawMessageImpl;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessageManager;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZBadPiece;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZGenericMapPayload;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZHandshake;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZHave;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZPeerExchange;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZRequestHint;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTChoke;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTInterested;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTPiece;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTUnchoke;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTUninterested;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class AZMessageFactory {
    public static final byte MESSAGE_VERSION_INITIAL = 1;
    public static final byte MESSAGE_VERSION_SUPPORTS_PADDING = 2;
    public static final int AZ_HANDSHAKE_PAD_MAX = 64;
    public static final int SMALL_PAD_MAX = 8;
    public static final int BIG_PAD_MAX = 20;
    private static final byte bss = 11;
    private static final Map legacy_data = new HashMap();

    public static void init() {
        try {
            MessageManager.getSingleton().registerMessageType(new AZHandshake(new byte[20], null, null, "", "", 0, 0, 0, null, new String[0], new byte[0], 0, 2, false));
            MessageManager.getSingleton().registerMessageType(new AZPeerExchange(new byte[20], null, null, 2));
            MessageManager.getSingleton().registerMessageType(new AZRequestHint(-1, -1, -1, -1, 2));
            MessageManager.getSingleton().registerMessageType(new AZHave(new int[0], 2));
            MessageManager.getSingleton().registerMessageType(new AZBadPiece(-1, 2));
        }
        catch (MessageException messageException) {
            messageException.printStackTrace();
        }
    }

    public static void registerGenericMapPayloadMessageType(String string) throws MessageException {
        MessageManager.getSingleton().registerMessageType(new AZGenericMapPayload(string, null, 1));
    }

    public static Message createAZMessage(DirectByteBuffer directByteBuffer) throws MessageException {
        byte by;
        int n = directByteBuffer.getInt((byte)11);
        if (n < 1 || n > 1024 || n > directByteBuffer.remaining((byte)11) - 1) {
            byte by2 = directByteBuffer.get((byte)0, 0);
            throw new MessageException("invalid AZ id length given: " + n + ", stream_payload.remaining(): " + directByteBuffer.remaining((byte)11) + ", BT id?=" + by2);
        }
        byte[] byArray = new byte[n];
        directByteBuffer.get((byte)11, byArray);
        byte by3 = directByteBuffer.get((byte)11);
        byte by4 = (byte)(by3 & 0xF);
        if (by4 >= 2 && ((by = (byte)(by3 >> 4 & 0xF)) & 1) != 0) {
            short s = directByteBuffer.getShort((byte)11);
            byte[] byArray2 = new byte[s];
            directByteBuffer.get((byte)11, byArray2);
        }
        return MessageManager.getSingleton().createMessage(byArray, directByteBuffer, by4);
    }

    public static RawMessage createAZRawMessage(Message message, boolean bl) {
        int n;
        DirectByteBuffer directByteBuffer;
        int n2;
        short s;
        byte[] byArray = message.getIDBytes();
        byte by = message.getVersion();
        DirectByteBuffer[] directByteBufferArray = message.getData();
        int n3 = 0;
        for (int i = 0; i < directByteBufferArray.length; ++i) {
            n3 += directByteBufferArray[i].remaining((byte)11);
        }
        if (by >= 2) {
            s = bl ? (short)(Math.random() * (double)(n3 > 256 ? 8 : 20) + 1.0) : (short)0;
            n2 = bl ? 1 : 0;
            int n4 = 8 + byArray.length + 1 + (bl ? 2 + s : 0);
            directByteBuffer = DirectByteBufferPool.getBuffer((byte)22, n4);
            directByteBuffer.putInt((byte)11, n4 - 4 + n3);
            directByteBuffer.putInt((byte)11, byArray.length);
            directByteBuffer.put((byte)11, byArray);
            n = n2 << 4 | by;
            directByteBuffer.put((byte)11, (byte)n);
            if (bl) {
                byte[] byArray2 = new byte[s];
                directByteBuffer.putShort((byte)11, s);
                directByteBuffer.put((byte)11, byArray2);
            }
        } else {
            s = 8 + byArray.length + 1;
            directByteBuffer = DirectByteBufferPool.getBuffer((byte)22, s);
            directByteBuffer.putInt((byte)11, s - 4 + n3);
            directByteBuffer.putInt((byte)11, byArray.length);
            directByteBuffer.put((byte)11, byArray);
            directByteBuffer.put((byte)11, by);
        }
        directByteBuffer.flip((byte)11);
        DirectByteBuffer[] directByteBufferArray2 = new DirectByteBuffer[directByteBufferArray.length + 1];
        directByteBufferArray2[0] = directByteBuffer;
        for (n2 = 0; n2 < directByteBufferArray.length; ++n2) {
            directByteBufferArray2[n2 + 1] = directByteBufferArray[n2];
        }
        String string = message.getID();
        LegacyData legacyData = (LegacyData)legacy_data.get(string);
        if (legacyData != null) {
            return new RawMessageImpl(message, directByteBufferArray2, legacyData.priority, legacyData.is_no_delay, legacyData.to_remove);
        }
        boolean bl2 = true;
        if (string == "AZ_HANDSHAKE") {
            n = 2;
        } else if (string == "AZ_HAVE") {
            n = 0;
            bl2 = false;
        } else {
            n = message.getType() == 1 ? 0 : 1;
        }
        return new RawMessageImpl(message, directByteBufferArray2, n, bl2, null);
    }

    static {
        legacy_data.put("BT_CHOKE", new LegacyData(2, true, new Message[]{new BTUnchoke(0), new BTPiece(-1, -1, null, 0)}));
        legacy_data.put("BT_UNCHOKE", new LegacyData(1, true, new Message[]{new BTChoke(0)}));
        legacy_data.put("BT_INTERESTED", new LegacyData(2, true, new Message[]{new BTUninterested(0)}));
        legacy_data.put("BT_UNINTERESTED", new LegacyData(1, false, new Message[]{new BTInterested(0)}));
        legacy_data.put("BT_HAVE", new LegacyData(0, false, null));
        legacy_data.put("BT_BITFIELD", new LegacyData(2, true, null));
        legacy_data.put("BT_REQUEST", new LegacyData(1, true, null));
        legacy_data.put("BT_PIECE", new LegacyData(0, false, null));
        legacy_data.put("BT_CANCEL", new LegacyData(2, true, null));
        legacy_data.put("BT_HANDSHAKE", new LegacyData(2, true, null));
        legacy_data.put("BT_KEEP_ALIVE", new LegacyData(0, false, null));
        legacy_data.put("BT_DHT_PORT", new LegacyData(0, false, null));
    }

    protected static class LegacyData {
        protected final int priority;
        protected final boolean is_no_delay;
        protected final Message[] to_remove;

        protected LegacyData(int n, boolean bl, Message[] messageArray) {
            this.priority = n;
            this.is_no_delay = bl;
            this.to_remove = messageArray;
        }
    }
}

