/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessage;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class BTDHTPort
implements BTMessage {
    private int port;
    private DirectByteBuffer buffer;

    public BTDHTPort(int n) {
        this.port = n;
    }

    public Message deserialize(DirectByteBuffer directByteBuffer, byte by) throws MessageException {
        if (directByteBuffer == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (directByteBuffer.remaining((byte)11) != 2) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + directByteBuffer.remaining((byte)11) + "] != 2");
        }
        short s = directByteBuffer.getShort((byte)11);
        directByteBuffer.returnToPool();
        return new BTDHTPort(0xFFFF & s);
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            this.buffer = DirectByteBufferPool.getBuffer((byte)30, 2);
            short s = (short)this.port;
            this.buffer.put((byte)11, (byte)(s >> 8));
            this.buffer.put((byte)11, (byte)(s & 0xFF));
            this.buffer.flip((byte)11);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public String getDescription() {
        return this.getID() + " (port " + this.port + ")";
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }

    public String getFeatureID() {
        return "BT1";
    }

    public int getFeatureSubID() {
        return 9;
    }

    public String getID() {
        return "BT_DHT_PORT";
    }

    public byte[] getIDBytes() {
        return BTMessage.ID_BT_DHT_PORT_BYTES;
    }

    public int getType() {
        return 0;
    }

    public byte getVersion() {
        return 1;
    }

    public int getDHTPort() {
        return this.port;
    }
}

