/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent;

import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessage;
import com.aelitis.azureus.core.peermanager.utils.PeerClassifier;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class BTHandshake
implements BTMessage,
RawMessage {
    public static final String PROTOCOL = "BitTorrent protocol";
    private static final byte[] BT_RESERVED = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] AZ_RESERVED = new byte[]{-128, 0, 0, 0, 0, 19, 0, 0};
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final byte[] reserved_bytes;
    private final byte[] datahash_bytes;
    private final byte[] peer_id_bytes;
    private final byte version;

    public static void setMainlineDHTEnabled(boolean bl) {
        BTHandshake.AZ_RESERVED[7] = bl ? (byte)(AZ_RESERVED[7] | 1) : (byte)(AZ_RESERVED[7] & 0xFE);
    }

    private static byte[] duplicate(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public BTHandshake(byte[] byArray, byte[] byArray2, boolean bl, byte by) {
        this(BTHandshake.duplicate(bl ? AZ_RESERVED : BT_RESERVED), byArray, byArray2, by);
    }

    private BTHandshake(byte[] byArray, byte[] byArray2, byte[] byArray3, byte by) {
        this.reserved_bytes = byArray;
        this.datahash_bytes = byArray2;
        this.peer_id_bytes = byArray3;
        this.version = by;
    }

    private void constructBuffer() {
        this.buffer = DirectByteBufferPool.getBuffer((byte)16, 68);
        this.buffer.put((byte)11, (byte)PROTOCOL.length());
        this.buffer.put((byte)11, PROTOCOL.getBytes());
        this.buffer.put((byte)11, this.reserved_bytes);
        this.buffer.put((byte)11, this.datahash_bytes);
        this.buffer.put((byte)11, this.peer_id_bytes);
        this.buffer.flip((byte)11);
    }

    public byte[] getReserved() {
        return this.reserved_bytes;
    }

    public byte[] getDataHash() {
        return this.datahash_bytes;
    }

    public byte[] getPeerId() {
        return this.peer_id_bytes;
    }

    public String getID() {
        return "BT_HANDSHAKE";
    }

    public byte[] getIDBytes() {
        return BTMessage.ID_BT_HANDSHAKE_BYTES;
    }

    public String getFeatureID() {
        return "BT1";
    }

    public int getFeatureSubID() {
        return 10;
    }

    public int getType() {
        return 0;
    }

    public byte getVersion() {
        return this.version;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "BT_HANDSHAKE of dataID: " + ByteFormatter.nicePrint(this.datahash_bytes, true) + " peerID: " + PeerClassifier.getPrintablePeerID(this.peer_id_bytes);
        }
        return this.description;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            this.constructBuffer();
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer directByteBuffer, byte by) throws MessageException {
        if (directByteBuffer == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (directByteBuffer.remaining((byte)11) != 68) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + directByteBuffer.remaining((byte)11) + "] != 68");
        }
        if (directByteBuffer.get((byte)11) != (byte)PROTOCOL.length()) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.get() != (byte)PROTOCOL.length()");
        }
        byte[] byArray = new byte[PROTOCOL.getBytes().length];
        directByteBuffer.get((byte)11, byArray);
        if (!PROTOCOL.equals(new String(byArray))) {
            throw new MessageException("[" + this.getID() + "] decode error: invalid protocol given: " + new String(byArray));
        }
        byte[] byArray2 = new byte[8];
        directByteBuffer.get((byte)11, byArray2);
        byte[] byArray3 = new byte[20];
        directByteBuffer.get((byte)11, byArray3);
        byte[] byArray4 = new byte[20];
        directByteBuffer.get((byte)11, byArray4);
        directByteBuffer.returnToPool();
        return new BTHandshake(byArray2, byArray3, byArray4, by);
    }

    public DirectByteBuffer[] getRawData() {
        if (this.buffer == null) {
            this.constructBuffer();
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public int getPriority() {
        return 2;
    }

    public boolean isNoDelay() {
        return true;
    }

    public void setNoDelay() {
    }

    public Message[] messagesToRemove() {
        return null;
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }

    public Message getBaseMessage() {
        return this;
    }
}

