/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.peerdb;

import com.aelitis.azureus.core.peermanager.peerdb.PeerExchangerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemTime;

public class PeerDatabase {
    private static final int MIN_REBUILD_WAIT_TIME = 60000;
    private static final int MAX_DISCOVERED_PEERS = 500;
    private static final int BLOOM_ROTATION_PERIOD = 420000;
    private static final int BLOOM_FILTER_SIZE = 10000;
    private final HashMap peer_connections = new HashMap();
    private final LinkedList discovered_peers = new LinkedList();
    private final AEMonitor map_mon = new AEMonitor("PeerDatabase");
    private PeerItem[] cached_peer_popularities = null;
    private int popularity_pos = 0;
    private long last_rebuild_time = 0L;
    private long last_rotation_time = 0L;
    private PeerItem self_peer;
    private BloomFilter filter_one = null;
    private BloomFilter filter_two = BloomFilterFactory.createAddOnly(10000);

    protected PeerDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerExchangerItem registerPeerConnection(PeerItem peerItem, PeerExchangerItem.Helper helper) {
        try {
            this.map_mon.enter();
            PeerExchangerItem peerExchangerItem = new PeerExchangerItem(this, peerItem, helper);
            for (Map.Entry entry : this.peer_connections.entrySet()) {
                PeerItem peerItem2 = (PeerItem)entry.getKey();
                PeerExchangerItem peerExchangerItem2 = (PeerExchangerItem)entry.getValue();
                if (peerExchangerItem2.getHelper().isSeed() && peerExchangerItem.getHelper().isSeed()) continue;
                peerExchangerItem2.notifyAdded(peerItem);
                peerExchangerItem.notifyAdded(peerItem2);
            }
            this.peer_connections.put(peerItem, peerExchangerItem);
            PeerExchangerItem peerExchangerItem3 = peerExchangerItem;
            return peerExchangerItem3;
        }
        finally {
            this.map_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterPeerConnection(PeerItem peerItem) {
        try {
            this.map_mon.enter();
            this.peer_connections.remove(peerItem);
            for (PeerExchangerItem peerExchangerItem : this.peer_connections.values()) {
                peerExchangerItem.notifyDropped(peerItem);
            }
        }
        finally {
            this.map_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seedStatusChanged(PeerExchangerItem peerExchangerItem) {
        if (peerExchangerItem.getHelper().isSeed()) {
            try {
                this.map_mon.enter();
                for (PeerExchangerItem peerExchangerItem2 : this.peer_connections.values()) {
                    if (peerExchangerItem2 == peerExchangerItem || !peerExchangerItem2.getHelper().isSeed()) continue;
                    peerExchangerItem2.notifyDropped(peerExchangerItem.getBasePeer());
                    peerExchangerItem.notifyDropped(peerExchangerItem2.getBasePeer());
                }
            }
            finally {
                this.map_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoveredPeer(PeerItem peerItem) {
        try {
            this.map_mon.enter();
            for (PeerExchangerItem peerExchangerItem : this.peer_connections.values()) {
                if (!peerExchangerItem.isConnectedToPeer(peerItem)) continue;
                return;
            }
            if (!this.discovered_peers.contains(peerItem)) {
                this.discovered_peers.addLast(peerItem);
                int n = PeerUtils.MAX_CONNECTIONS_PER_TORRENT;
                if (n < 1 || n > 500) {
                    n = 500;
                }
                if (this.discovered_peers.size() > n) {
                    this.discovered_peers.removeFirst();
                }
            }
        }
        finally {
            this.map_mon.exit();
        }
    }

    public void setSelfPeer(PeerItem peerItem) {
        this.self_peer = peerItem;
    }

    public PeerItem getSelfPeer() {
        return this.self_peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerItem[] getDiscoveredPeers() {
        try {
            this.map_mon.enter();
            PeerItem[] peerItemArray = this.discovered_peers.toArray(new PeerItem[this.discovered_peers.size()]);
            return peerItemArray;
        }
        finally {
            this.map_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerItem[] getDiscoveredPeers(String string) {
        ArrayList<PeerItem> arrayList = null;
        try {
            this.map_mon.enter();
            for (int i = 0; i < this.discovered_peers.size(); ++i) {
                PeerItem peerItem = (PeerItem)this.discovered_peers.get(i);
                if (!peerItem.getIP().equals(string)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<PeerItem>();
                }
                arrayList.add(peerItem);
            }
        }
        finally {
            this.map_mon.exit();
        }
        if (arrayList == null) {
            return new PeerItem[0];
        }
        return arrayList.toArray(new PeerItem[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDiscoveredPeerCount() {
        try {
            this.map_mon.enter();
            int n = this.discovered_peers.size();
            return n;
        }
        finally {
            this.map_mon.exit();
        }
    }

    public PeerItem getNextOptimisticConnectPeer() {
        return this.getNextOptimisticConnectPeer(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PeerItem getNextOptimisticConnectPeer(int n) {
        long l;
        PeerItem peerItem = null;
        boolean bl = false;
        try {
            this.map_mon.enter();
            if (!this.discovered_peers.isEmpty()) {
                peerItem = (PeerItem)this.discovered_peers.removeFirst();
                bl = true;
            }
        }
        finally {
            this.map_mon.exit();
        }
        if (peerItem == null) {
            if (this.cached_peer_popularities == null || this.popularity_pos == this.cached_peer_popularities.length) {
                this.cached_peer_popularities = null;
                l = SystemTime.getCurrentTime() - this.last_rebuild_time;
                if (l > 60000L || l < 0L) {
                    this.cached_peer_popularities = this.getExchangedPeersSortedByLeastPopularFirst();
                    this.popularity_pos = 0;
                    this.last_rebuild_time = SystemTime.getCurrentTime();
                }
            }
            if (this.cached_peer_popularities != null && this.cached_peer_popularities.length > 0) {
                peerItem = this.cached_peer_popularities[this.popularity_pos];
                ++this.popularity_pos;
                this.last_rebuild_time = SystemTime.getCurrentTime();
            }
        }
        if (peerItem != null) {
            PeerItem peerItem2;
            l = SystemTime.getCurrentTime() - this.last_rotation_time;
            if (l < 0L || l > 420000L) {
                this.filter_one = this.filter_two;
                this.filter_two = BloomFilterFactory.createAddOnly(10000);
                this.last_rotation_time = SystemTime.getCurrentTime();
            }
            boolean bl2 = false;
            byte[] byArray = peerItem.getSerialization();
            if (this.filter_one.contains(byArray) && n < 100 && (peerItem2 = this.getNextOptimisticConnectPeer(n + 1)) != null) {
                if (bl) {
                    try {
                        this.map_mon.enter();
                        this.discovered_peers.addLast(peerItem);
                    }
                    finally {
                        this.map_mon.exit();
                    }
                }
                peerItem = peerItem2;
                bl2 = true;
            }
            if (!bl2) {
                this.filter_one.add(byArray);
                this.filter_two.add(byArray);
            }
        }
        return peerItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PeerItem[] getExchangedPeersSortedByLeastPopularFirst() {
        PeerItem[] peerItemArray2;
        HashMap<PeerItem, Integer> hashMap = new HashMap<PeerItem, Integer>();
        try {
            this.map_mon.enter();
            for (PeerItem[] peerItemArray2 : this.peer_connections.values()) {
                PeerItem[] peerItemArray3 = peerItemArray2.getConnectedPeers();
                for (int i = 0; i < peerItemArray3.length; ++i) {
                    PeerItem peerItem = peerItemArray3[i];
                    Integer n = (Integer)hashMap.get(peerItem);
                    n = n == null ? new Integer(1) : new Integer(n + 1);
                    hashMap.put(peerItem, n);
                }
            }
        }
        finally {
            this.map_mon.exit();
        }
        if (hashMap.isEmpty()) {
            return null;
        }
        Map.Entry[] entryArray = new Map.Entry[hashMap.size()];
        hashMap.entrySet().toArray(entryArray);
        Arrays.sort(entryArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                return ((Integer)entry.getValue()).compareTo((Integer)entry2.getValue());
            }
        });
        peerItemArray2 = new PeerItem[entryArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            Map.Entry entry = entryArray[i];
            peerItemArray2[i] = (PeerItem)entry.getKey();
        }
        return peerItemArray2;
    }

    public String getString() {
        return "pc=" + this.peer_connections.size() + ",dp=" + this.discovered_peers.size();
    }
}

