/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.peerdb;

import com.aelitis.azureus.core.peermanager.peerdb.PeerDatabase;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import java.util.LinkedList;
import java.util.Map;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.LightHashMap;

public class PeerExchangerItem {
    public static final int MAX_PEERS_PER_VOLLEY = 50;
    private static final int MAX_KNOWN_PER_PEER = 500;
    private final PeerDatabase parent_db;
    private final PeerItem base_peer;
    private final LinkedList<PeerItem> connections_added = new LinkedList();
    private final LinkedList<PeerItem> connections_dropped = new LinkedList();
    private final Map<PeerItem, Object> connected_peers = new LightHashMap<PeerItem, Object>();
    private final AEMonitor peers_mon = new AEMonitor("PeerConnectionItem");
    private boolean maintain_peers_state = true;
    private final Helper helper;

    protected PeerExchangerItem(PeerDatabase peerDatabase, PeerItem peerItem, Helper helper) {
        this.parent_db = peerDatabase;
        this.base_peer = peerItem;
        this.helper = helper;
    }

    protected PeerItem getBasePeer() {
        return this.base_peer;
    }

    protected Helper getHelper() {
        return this.helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectedPeer(PeerItem peerItem) {
        try {
            this.peers_mon.enter();
            if (!this.maintain_peers_state) {
                return;
            }
            int n = PeerUtils.MAX_CONNECTIONS_PER_TORRENT;
            if (n < 1 || n > 500) {
                n = 500;
            }
            if (this.connected_peers.size() < n) {
                this.connected_peers.put(peerItem, null);
            }
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropConnectedPeer(PeerItem peerItem) {
        try {
            this.peers_mon.enter();
            this.connected_peers.remove(peerItem);
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyAdded(PeerItem peerItem) {
        try {
            this.peers_mon.enter();
            if (!this.maintain_peers_state) {
                return;
            }
            if (!this.connections_dropped.contains(peerItem)) {
                if (!this.connections_added.contains(peerItem)) {
                    this.connections_added.addLast(peerItem);
                }
            } else {
                this.connections_dropped.remove(peerItem);
            }
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDropped(PeerItem peerItem) {
        try {
            this.peers_mon.enter();
            if (!this.maintain_peers_state) {
                return;
            }
            if (!this.connections_added.contains(peerItem)) {
                if (!this.connections_dropped.contains(peerItem)) {
                    this.connections_dropped.addLast(peerItem);
                }
            } else {
                this.connections_added.remove(peerItem);
            }
        }
        finally {
            this.peers_mon.exit();
        }
    }

    public void seedStatusChanged() {
        this.parent_db.seedStatusChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerItem[] getNewlyAddedPeerConnections() {
        try {
            this.peers_mon.enter();
            if (this.connections_added.isEmpty()) {
                PeerItem[] peerItemArray = null;
                return peerItemArray;
            }
            int n = this.connections_added.size() > 50 ? 50 : this.connections_added.size();
            PeerItem[] peerItemArray = new PeerItem[n];
            for (int i = 0; i < n; ++i) {
                peerItemArray[i] = this.connections_added.removeFirst();
            }
            PeerItem[] peerItemArray2 = peerItemArray;
            return peerItemArray2;
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerItem[] getNewlyDroppedPeerConnections() {
        try {
            this.peers_mon.enter();
            if (this.connections_dropped.isEmpty()) {
                PeerItem[] peerItemArray = null;
                return peerItemArray;
            }
            int n = this.connections_dropped.size() > 50 ? 50 : this.connections_dropped.size();
            PeerItem[] peerItemArray = new PeerItem[n];
            for (int i = 0; i < n; ++i) {
                peerItemArray[i] = this.connections_dropped.removeFirst();
            }
            PeerItem[] peerItemArray2 = peerItemArray;
            return peerItemArray2;
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableStateMaintenance() {
        try {
            this.peers_mon.enter();
            this.maintain_peers_state = false;
            this.connections_added.clear();
            this.connections_dropped.clear();
            this.connected_peers.clear();
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isConnectedToPeer(PeerItem peerItem) {
        try {
            this.peers_mon.enter();
            boolean bl = this.connected_peers.containsKey(peerItem);
            return bl;
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PeerItem[] getConnectedPeers() {
        try {
            this.peers_mon.enter();
            PeerItem[] peerItemArray = new PeerItem[this.connected_peers.size()];
            this.connected_peers.keySet().toArray(peerItemArray);
            PeerItem[] peerItemArray2 = peerItemArray;
            return peerItemArray2;
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.parent_db.deregisterPeerConnection(this.base_peer);
        try {
            this.peers_mon.enter();
            this.connections_added.clear();
            this.connections_dropped.clear();
            this.connected_peers.clear();
        }
        finally {
            this.peers_mon.exit();
        }
    }

    public static interface Helper {
        public boolean isSeed();
    }
}

