/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.piecepicker.impl;

import com.aelitis.azureus.core.peermanager.control.PeerControlScheduler;
import com.aelitis.azureus.core.peermanager.control.PeerControlSchedulerFactory;
import com.aelitis.azureus.core.peermanager.control.SpeedTokenDispenser;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.piecepicker.EndGameModeChunk;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePickerListener;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePriorityProvider;
import com.aelitis.azureus.core.peermanager.piecepicker.PieceRTAProvider;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMap;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.PEPieceImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class PiecePickerImpl
implements PiecePicker {
    private static final boolean LOG_RTA = false;
    private static final LogIDs LOGID = LogIDs.PIECES;
    private static final long TIME_MIN_AVAILABILITY = 974L;
    private static final long TIME_MIN_PRIORITIES = 999L;
    private static final long TIME_AVAIL_REBUILD = 299976L;
    private static final int PRIORITY_W_FIRSTLAST = 1300;
    private static final long FIRST_PIECE_MIN_NB = 4L;
    private static final int PRIORITY_W_FILE = 1000;
    private static final int PRIORITY_W_COMPLETION = 2000;
    private static final int PRIORITY_W_AGE = 900;
    private static final int PRIORITY_DW_AGE = 60000;
    private static final int PRIORITY_DW_STALE = 120000;
    private static final int PRIORITY_W_PIECE_DONE = 900;
    private static final int PRIORITY_W_SAME_PIECE = 700;
    private static final int PRIORITY_OVERRIDES_RAREST = 9000;
    private static final int PRIORITY_REQUEST_HINT = 3000;
    private static final int PRIORITY_REALTIME = 9999999;
    private static final int REQUESTS_MIN = 2;
    private static final int REQUESTS_MAX = 256;
    private static final int SLOPE_REQUESTS = 4096;
    private static final long RTA_END_GAME_MODE_SIZE_TRIGGER = 262144L;
    private static final long END_GAME_MODE_SIZE_TRIGGER = 0x1400000L;
    private static final long END_GAME_MODE_TIMEOUT = 76800L;
    protected static volatile boolean firstPiecePriority = COConfigurationManager.getBooleanParameter("Prioritize First Piece");
    protected static volatile boolean completionPriority = COConfigurationManager.getBooleanParameter("Prioritize Most Completed Files");
    protected static volatile long paramPriorityChange = Long.MIN_VALUE;
    private static final int NO_REQUEST_BACKOFF_MAX_MILLIS = 5000;
    private static final int NO_REQUEST_BACKOFF_MAX_LOOPS = 5000 / PeerControlScheduler.SCHEDULE_PERIOD_MILLIS;
    private static Random random = new Random();
    private final DiskManager diskManager;
    private final PEPeerControl peerControl;
    private final DiskManagerListenerImpl diskManagerListener;
    protected final Map peerListeners;
    private final PEPeerManagerListener peerManagerListener;
    protected final int nbPieces;
    protected final DiskManagerPiece[] dmPieces;
    protected final PEPiece[] pePieces;
    private List rarestStartedPieces;
    protected final AEMonitor availabilityMon = new AEMonitor("PiecePicker:avail");
    private final AEMonitor endGameModeChunks_mon = new AEMonitor("PiecePicker:EGM");
    protected volatile int nbPiecesDone;
    protected volatile int[] availabilityAsynch;
    protected volatile long availabilityDrift;
    private long timeAvailRebuild = 299976L;
    protected volatile int[] availability;
    private long time_last_avail;
    protected volatile long availabilityChange;
    private volatile long availabilityComputeChange;
    private long time_last_rebuild;
    private long timeAvailLessThanOne;
    private float globalAvail;
    private float globalAvgAvail;
    private int nbRarestActive;
    private int globalMin;
    private int globalMax;
    private volatile int globalMinOthers;
    protected volatile long filePriorityChange;
    private volatile long priorityParamChange;
    private volatile long priorityFileChange;
    private volatile long priorityAvailChange;
    private boolean priorityRTAexists;
    private long timeLastPriorities;
    private int[] startPriorities;
    protected volatile boolean hasNeededUndonePiece;
    protected volatile long neededUndonePieceChange;
    private volatile boolean endGameMode;
    private volatile boolean endGameModeAbandoned;
    private volatile long timeEndGameModeEntered;
    private List endGameModeChunks;
    private long lastProviderRecalcTime;
    private CopyOnWriteList rta_providers = new CopyOnWriteList();
    private long[] provider_piece_rtas;
    private CopyOnWriteList priority_providers = new CopyOnWriteList();
    private long[] provider_piece_priorities;
    private int allocate_request_loop_count;
    private static boolean enable_request_hints;
    private static boolean includeLanPeersInReqLimiting;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private final SpeedTokenDispenser dispenser = PeerControlSchedulerFactory.getSingleton(0).getSpeedTokenDispenser();

    public PiecePickerImpl(PEPeerControl pEPeerControl) {
        this.peerControl = pEPeerControl;
        this.diskManager = this.peerControl.getDiskManager();
        this.dmPieces = this.diskManager.getPieces();
        this.nbPieces = this.diskManager.getNbPieces();
        this.nbPiecesDone = 0;
        this.pePieces = pEPeerControl.getPieces();
        this.availability = new int[this.nbPieces];
        this.hasNeededUndonePiece = false;
        this.neededUndonePieceChange = Long.MIN_VALUE;
        this.time_last_avail = Long.MIN_VALUE;
        this.availabilityChange = -9223372036854775807L;
        this.availabilityComputeChange = Long.MIN_VALUE;
        this.availabilityDrift = this.nbPieces;
        for (int i = 0; i < this.nbPieces; ++i) {
            if (this.dmPieces[i].isDone()) {
                int n = i;
                this.availability[n] = this.availability[n] + 1;
                ++this.nbPiecesDone;
                continue;
            }
            this.hasNeededUndonePiece |= this.dmPieces[i].calcNeeded();
        }
        if (this.hasNeededUndonePiece) {
            ++this.neededUndonePieceChange;
        }
        this.updateAvailability();
        this.peerListeners = new HashMap();
        this.peerManagerListener = new PEPeerManagerListenerImpl();
        this.peerControl.addListener(this.peerManagerListener);
        this.rarestStartedPieces = new ArrayList();
        this.filePriorityChange = Long.MIN_VALUE;
        this.priorityParamChange = Long.MIN_VALUE;
        this.priorityFileChange = Long.MIN_VALUE;
        this.priorityAvailChange = Long.MIN_VALUE;
        this.timeLastPriorities = Long.MIN_VALUE;
        this.endGameMode = false;
        this.endGameModeAbandoned = false;
        this.timeEndGameModeEntered = 0L;
        this.diskManagerListener = new DiskManagerListenerImpl();
        this.diskManager.addListener(this.diskManagerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addHavePiece(PEPeer pEPeer, int n) {
        try {
            this.availabilityMon.enter();
            if (this.availabilityAsynch == null) {
                this.availabilityAsynch = (int[])this.availability.clone();
            }
            int n2 = n;
            this.availabilityAsynch[n2] = this.availabilityAsynch[n2] + 1;
            ++this.availabilityChange;
            Object var4_3 = null;
            this.availabilityMon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.availabilityMon.exit();
            throw throwable;
        }
        if (pEPeer != null && this.dmPieces[n].isDownloadable()) {
            pEPeer.setConsecutiveNoRequestCount(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateAvailability() {
        int n;
        int n2;
        DiskManagerPiece diskManagerPiece;
        int n3;
        int n4;
        long l = SystemTime.getCurrentTime();
        if (l >= this.time_last_avail && l < this.time_last_avail + 974L) {
            return;
        }
        if (this.availabilityDrift > 0L || l < this.time_last_rebuild || l - this.time_last_rebuild > this.timeAvailRebuild) {
            try {
                this.availabilityMon.enter();
                this.time_last_rebuild = l;
                int[] nArray = this.recomputeAvailability();
                if (Constants.isCVSVersion()) {
                    int[] nArray2 = this.availabilityAsynch == null ? this.availability : this.availabilityAsynch;
                    n4 = 0;
                    for (n3 = 0; n3 < nArray.length; ++n3) {
                        if (nArray[n3] == nArray2[n3]) continue;
                        ++n4;
                    }
                    if (n4 > 0 && n4 != this.nbPieces) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent((Object)this.peerControl, LOGID, 3, "updateAvailability(): availability rebuild errors = " + n4 + " timeAvailRebuild =" + this.timeAvailRebuild));
                        }
                        this.timeAvailRebuild -= (long)n4;
                    } else {
                        ++this.timeAvailRebuild;
                    }
                }
                this.availabilityAsynch = nArray;
                this.availabilityDrift = 0L;
                ++this.availabilityChange;
                diskManagerPiece = null;
                this.availabilityMon.exit();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.availabilityMon.exit();
                throw throwable;
            }
        } else if (this.availabilityComputeChange >= this.availabilityChange) {
            return;
        }
        try {
            this.availabilityMon.enter();
            this.time_last_avail = l;
            this.availabilityComputeChange = this.availabilityChange;
            if (this.availabilityAsynch != null) {
                this.availability = this.availabilityAsynch;
                this.availabilityAsynch = null;
            }
            Object var10_13 = null;
            this.availabilityMon.exit();
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            this.availabilityMon.exit();
            throw throwable;
        }
        int n5 = Integer.MAX_VALUE;
        n4 = 0;
        n3 = Integer.MAX_VALUE;
        for (n2 = 0; n2 < this.nbPieces; ++n2) {
            n = this.availability[n2];
            diskManagerPiece = this.dmPieces[n2];
            PEPiece pEPiece = this.pePieces[n2];
            if (n > 0 && n < n3 && diskManagerPiece.isDownloadable() && (pEPiece == null || pEPiece.isRequestable())) {
                n3 = n;
            }
            if (n < n5) {
                n5 = n;
            }
            if (n <= n4) continue;
            n4 = n;
        }
        this.globalMin = n5;
        this.globalMax = n4;
        this.globalMinOthers = n3;
        n = 0;
        int n6 = 0;
        long l2 = 0L;
        for (n2 = 0; n2 < this.nbPieces; ++n2) {
            int n7 = this.availability[n2];
            DiskManagerPiece diskManagerPiece2 = this.dmPieces[n2];
            PEPiece pEPiece = this.pePieces[n2];
            if (n7 <= 0) continue;
            if (n7 > n5) {
                ++n;
            }
            if (n7 <= n3 && diskManagerPiece2.isDownloadable() && pEPiece != null && !pEPiece.isRequested()) {
                ++n6;
            }
            l2 += (long)n7;
        }
        float f = (float)n / (float)this.nbPieces + (float)n5;
        if ((double)this.globalAvail >= 1.0 && (double)f < 1.0) {
            this.timeAvailLessThanOne = l;
        } else if ((double)f >= 1.0) {
            this.timeAvailLessThanOne = 0L;
        }
        this.globalAvail = f;
        this.nbRarestActive = n6;
        this.globalAvgAvail = (float)l2 / (float)this.nbPieces / (float)(1 + this.peerControl.getNbSeeds() + this.peerControl.getNbPeers());
    }

    private final int[] recomputeAvailability() {
        int n;
        if (this.availabilityDrift > 0L && this.availabilityDrift != (long)this.nbPieces && Logger.isEnabled()) {
            Logger.log(new LogEvent((Object)this.diskManager.getTorrent(), LOGID, 0, "Recomputing availabiliy. Drift=" + this.availabilityDrift + ":" + this.peerControl.getDisplayName()));
        }
        List<PEPeer> list = this.peerControl.getPeers();
        int[] nArray = new int[this.nbPieces];
        for (n = 0; n < this.nbPieces; ++n) {
            nArray[n] = this.dmPieces[n].isDone() ? 1 : 0;
        }
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            BitFlags bitFlags;
            PEPeerTransport pEPeerTransport = (PEPeerTransport)list.get(i);
            if (pEPeerTransport == null || pEPeerTransport.getPeerState() != 30 || (bitFlags = pEPeerTransport.getAvailable()) == null || bitFlags.nbSet <= 0) continue;
            for (n = bitFlags.start; n <= bitFlags.end; ++n) {
                if (!bitFlags.flags[n]) continue;
                int n3 = n;
                nArray[n3] = nArray[n3] + 1;
            }
        }
        return nArray;
    }

    public int getNumberOfPieces() {
        return this.nbPieces;
    }

    public final int[] getAvailability() {
        return this.availability;
    }

    public final int getAvailability(int n) {
        return this.availability[n];
    }

    public final float getMinAvailability() {
        return this.globalAvail;
    }

    public final long getAvailWentBadTime() {
        return this.timeAvailLessThanOne;
    }

    public final int getMaxAvailability() {
        return this.globalMax;
    }

    public final float getAvgAvail() {
        return this.globalAvgAvail;
    }

    public int getNbPiecesDone() {
        return this.nbPiecesDone;
    }

    protected final void checkDownloadablePiece() {
        for (int i = 0; i < this.nbPieces; ++i) {
            if (!this.dmPieces[i].isInteresting()) continue;
            if (!this.hasNeededUndonePiece) {
                this.hasNeededUndonePiece = true;
                ++this.neededUndonePieceChange;
            }
            return;
        }
        if (this.hasNeededUndonePiece) {
            this.hasNeededUndonePiece = false;
            ++this.neededUndonePieceChange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void allocateRequests() {
        int n;
        Object object;
        int n2;
        if (!this.hasNeededUndonePiece) {
            return;
        }
        ++this.allocate_request_loop_count;
        List<PEPeer> list = this.peerControl.getPeers();
        int n3 = list.size();
        ArrayList<PEPeerTransport> arrayList = new ArrayList<PEPeerTransport>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            PEPeerTransport pEPeerTransport = (PEPeerTransport)list.get(n2);
            if (!pEPeerTransport.isDownloadPossible() || (n4 = pEPeerTransport.getConsecutiveNoRequestCount()) != 0 && this.allocate_request_loop_count % (n4 + 1) != 0) continue;
            arrayList.add(pEPeerTransport);
        }
        Collections.shuffle(arrayList);
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                PEPeerTransport pEPeerTransport = (PEPeerTransport)object2;
                PEPeerTransport pEPeerTransport2 = (PEPeerTransport)object;
                PEPeerStats pEPeerStats = pEPeerTransport.getStats();
                PEPeerStats pEPeerStats2 = pEPeerTransport2.getStats();
                int n = 0;
                if (pEPeerTransport2.isLANLocal() && !pEPeerTransport.isLANLocal()) {
                    n = -1;
                } else if (!pEPeerTransport2.isLANLocal() && pEPeerTransport.isLANLocal()) {
                    n = 1;
                }
                if (n == 0) {
                    n = (int)(pEPeerStats.getSmoothDataReceiveRate() - pEPeerStats2.getSmoothDataReceiveRate());
                }
                if (!(n != 0 || pEPeerTransport.isChokedByMe() && pEPeerTransport2.isChokedByMe())) {
                    n = (int)(pEPeerStats.getDataSendRate() - pEPeerStats2.getDataSendRate());
                }
                if (n == 0 && pEPeerTransport.isSnubbed() && !pEPeerTransport2.isSnubbed()) {
                    n = -1;
                }
                if (n == 0 && !pEPeerTransport.isSnubbed() && pEPeerTransport2.isSnubbed()) {
                    n = 1;
                }
                if (n == 0 && pEPeerStats.getTotalDataBytesReceived() == 0L && pEPeerStats2.getTotalDataBytesReceived() > 0L) {
                    n = 1;
                }
                if (n == 0 && pEPeerStats2.getTotalDataBytesReceived() == 0L && pEPeerStats.getTotalDataBytesReceived() > 0L) {
                    n = -1;
                }
                return n;
            }
        });
        n2 = arrayList.size();
        if (n2 == 0) {
            return;
        }
        boolean bl = false;
        if (this.priorityRTAexists) {
            Iterator iterator;
            Map[] mapArray = new Map[]{null};
            object = new HashMap(n2);
            TreeSet<PEPeerTransport> treeSet = new TreeSet<PEPeerTransport>(new Comparator((Map)object, mapArray, arrayList){
                final /* synthetic */ Map val$block_time_order_peers_metrics;
                final /* synthetic */ Map[] val$peer_randomiser;
                final /* synthetic */ ArrayList val$bestUploaders;
                {
                    this.val$block_time_order_peers_metrics = map;
                    this.val$peer_randomiser = mapArray;
                    this.val$bestUploaders = arrayList;
                }

                public int compare(Object object, Object object2) {
                    int n;
                    Integer n2;
                    PEPeerTransport pEPeerTransport = (PEPeerTransport)object;
                    PEPeerTransport pEPeerTransport2 = (PEPeerTransport)object2;
                    Integer n3 = (Integer)this.val$block_time_order_peers_metrics.get(pEPeerTransport);
                    if (n3 == null) {
                        n3 = new Integer(PiecePickerImpl.this.getNextBlockETAFromNow(pEPeerTransport));
                        this.val$block_time_order_peers_metrics.put(pEPeerTransport, n3);
                    }
                    if ((n2 = (Integer)this.val$block_time_order_peers_metrics.get(pEPeerTransport2)) == null) {
                        n2 = new Integer(PiecePickerImpl.this.getNextBlockETAFromNow(pEPeerTransport2));
                        this.val$block_time_order_peers_metrics.put(pEPeerTransport2, n2);
                    }
                    if ((n = n3 - n2) == 0) {
                        Integer n4;
                        Integer n5;
                        LightHashMap lightHashMap = this.val$peer_randomiser[0];
                        if (lightHashMap == null) {
                            lightHashMap = this.val$peer_randomiser[0] = new LightHashMap(this.val$bestUploaders.size());
                        }
                        if ((n5 = (Integer)lightHashMap.get(pEPeerTransport)) == null) {
                            n5 = new Integer(random.nextInt());
                            lightHashMap.put(pEPeerTransport, n5);
                        }
                        if ((n4 = (Integer)lightHashMap.get(pEPeerTransport2)) == null) {
                            n4 = new Integer(random.nextInt());
                            lightHashMap.put(pEPeerTransport2, n4);
                        }
                        if ((n = n5 - n4) == 0 && (n = pEPeerTransport.hashCode() - pEPeerTransport2.hashCode()) == 0) {
                            n = 1;
                        }
                    }
                    return n;
                }
            });
            treeSet.addAll(arrayList);
            PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(0);
            long l = SystemTime.getCurrentTime() + (long)this.getNextBlockETAFromNow(pEPeerTransport);
            n = 1;
            HashSet<PEPeerTransport> hashSet = new HashSet<PEPeerTransport>();
            try {
                block5: while (n != 0 && this.priorityRTAexists) {
                    n = 0;
                    while (!treeSet.isEmpty()) {
                        int n5;
                        int n6;
                        Iterator iterator2 = treeSet.iterator();
                        PEPeerTransport pEPeerTransport2 = (PEPeerTransport)iterator2.next();
                        iterator2.remove();
                        if (!pEPeerTransport2.isDownloadPossible() || pEPeerTransport2.isSnubbed()) continue;
                        int n7 = 2 + (int)(pEPeerTransport2.getStats().getDataReceiveRate() / 4096L) + 1;
                        if (n7 > 256 || n7 < 0) {
                            n7 = 256;
                        }
                        if ((n6 = n7 - (n5 = pEPeerTransport2.getNbRequests())) <= 0) continue;
                        if (!bl) {
                            bl = true;
                            this.computeBasePriorities();
                            if (!this.priorityRTAexists) continue block5;
                        }
                        if (!hashSet.contains(pEPeerTransport2)) {
                            pEPeerTransport2.requestAllocationStarts(this.startPriorities);
                            hashSet.add(pEPeerTransport2);
                        }
                        if (!this.findRTAPieceToDownload(pEPeerTransport2, pEPeerTransport2 == pEPeerTransport, l) || n6 <= 1) continue;
                        object.remove(pEPeerTransport2);
                        treeSet.add(pEPeerTransport2);
                    }
                }
                Object var20_24 = null;
                iterator = hashSet.iterator();
            }
            catch (Throwable throwable) {
                Object var20_25 = null;
                Iterator iterator3 = hashSet.iterator();
                while (iterator3.hasNext()) {
                    ((PEPeerTransport)iterator3.next()).requestAllocationComplete();
                }
                throw throwable;
            }
            while (iterator.hasNext()) {
                ((PEPeerTransport)iterator.next()).requestAllocationComplete();
            }
        }
        this.checkEndGameMode();
        for (int i = 0; i < n2; ++i) {
            Object var23_30;
            int n8;
            int n9;
            object = (PEPeerTransport)arrayList.get(i);
            if (this.dispenser.peek(16384) < 1 && (!object.isLANLocal() || includeLanPeersInReqLimiting)) break;
            if (!object.isDownloadPossible()) continue;
            int n10 = object.getMaxNbRequests();
            if (n10 != -1) {
                n9 = n10;
            } else if (!object.isSnubbed()) {
                if (!this.endGameMode) {
                    n9 = 2 + (int)(object.getStats().getDataReceiveRate() / 4096L);
                    if (n9 > 256 || n9 < 0) {
                        n9 = 256;
                    }
                } else {
                    n9 = 2;
                }
            } else {
                n9 = 1;
            }
            if (object.getNbRequests() > n9 * 3 / 5) continue;
            if (!bl) {
                bl = true;
                this.computeBasePriorities();
            }
            int n11 = 0;
            try {
                n8 = object.requestAllocationStarts(this.startPriorities);
                while (object.isDownloadPossible() && object.getNbRequests() < n9 && (n = n8 != 0 || !this.endGameMode ? this.findPieceToDownload((PEPeerTransport)object, n9) : this.findPieceInEndGameMode((PEPeerTransport)object, n9)) != 0) {
                    n11 += n;
                }
                var23_30 = null;
                object.requestAllocationComplete();
            }
            catch (Throwable throwable) {
                var23_30 = null;
                object.requestAllocationComplete();
                throw throwable;
            }
            if (n11 == 0) {
                n8 = object.getConsecutiveNoRequestCount();
                if (n8 >= NO_REQUEST_BACKOFF_MAX_LOOPS) continue;
                object.setConsecutiveNoRequestCount(n8 + 2);
                continue;
            }
            object.setConsecutiveNoRequestCount(0);
        }
    }

    protected int getNextBlockETAFromNow(PEPeerTransport pEPeerTransport) {
        long l = pEPeerTransport.getStats().getDataReceiveRate();
        if (l < 1L) {
            l = 1L;
        }
        int n = (pEPeerTransport.getNbRequests() + 1) * 16384;
        return (int)((long)(n * 1000) / l);
    }

    private int calcRarestAllowed() {
        int n = 1;
        if (this.globalMinOthers < 20) {
            n = 2;
        }
        if (this.globalMinOthers < 8) {
            n = 3;
        }
        if (this.globalMinOthers < 4) {
            n = 4;
        }
        if (this.nbPiecesDone < 4) {
            n = 0;
        }
        if (SystemTime.getCurrentTime() - this.peerControl.getTimeStarted() < 180000L) {
            n = 0;
        }
        if (this.rarestStartedPieces.size() > n + 2) {
            n = 0;
        }
        for (int i = 0; i < this.rarestStartedPieces.size(); ++i) {
            PEPiece pEPiece = (PEPiece)this.rarestStartedPieces.get(i);
            if (this.pePieces[pEPiece.getPieceNumber()] == null) {
                this.rarestStartedPieces.remove(i);
                --i;
                continue;
            }
            if (pEPiece.getAvailability() > this.globalMinOthers && this.globalMinOthers <= this.globalMin || SystemTime.getCurrentTime() - pEPiece.getLastDownloadTime(SystemTime.getCurrentTime()) >= 60000L && pEPiece.getNbWritten() != 0 || pEPiece.isDownloaded()) continue;
            --n;
        }
        return n;
    }

    private final void computeBasePriorities() {
        long l = SystemTime.getCurrentTime();
        if (l < this.lastProviderRecalcTime || l - this.lastProviderRecalcTime > 1000L) {
            this.lastProviderRecalcTime = l;
            this.priorityRTAexists = this.computeProviderPriorities();
        }
        if (!this.priorityRTAexists && this.startPriorities != null && (l > this.timeLastPriorities && l < this.time_last_avail + 999L || this.priorityParamChange >= paramPriorityChange && this.priorityFileChange >= this.filePriorityChange && this.priorityAvailChange >= this.availabilityChange)) {
            return;
        }
        this.timeLastPriorities = l;
        this.priorityParamChange = paramPriorityChange;
        this.priorityFileChange = this.filePriorityChange;
        this.priorityAvailChange = this.availabilityChange;
        boolean bl = false;
        int[] nArray = new int[this.nbPieces];
        boolean bl2 = firstPiecePriority;
        boolean bl3 = completionPriority;
        DMPieceMap dMPieceMap = this.diskManager.getPieceMap();
        try {
            boolean bl4 = this.calcRarestAllowed() < 1;
            int n = this.peerControl.getNbPeers() + this.peerControl.getNbSeeds();
            for (int i = 0; i < this.nbPieces; ++i) {
                int n2;
                DiskManagerPiece diskManagerPiece = this.dmPieces[i];
                if (diskManagerPiece.isDone()) continue;
                int n3 = Integer.MIN_VALUE;
                DMPieceList dMPieceList = dMPieceMap.getPieceList(diskManagerPiece.getPieceNumber());
                int n4 = dMPieceList.size();
                for (n2 = 0; n2 < n4; ++n2) {
                    DiskManagerFileInfoImpl diskManagerFileInfoImpl = dMPieceList.get(n2).getFile();
                    long l2 = diskManagerFileInfoImpl.getDownloaded();
                    long l3 = diskManagerFileInfoImpl.getLength();
                    if (l3 <= 0L || l2 >= l3 || diskManagerFileInfoImpl.isSkipped()) continue;
                    int n5 = 0;
                    if (bl2 && (long)diskManagerFileInfoImpl.getNbPieces() > 4L && (i == diskManagerFileInfoImpl.getFirstPieceNumber() || i == diskManagerFileInfoImpl.getLastPieceNumber())) {
                        n5 += 1300;
                    }
                    if (diskManagerFileInfoImpl.isPriority()) {
                        long l4;
                        n5 += 1000;
                        if (bl3 && (l4 = 1000L * l2 / l3) >= 900L) {
                            n5 = (int)((long)n5 + 2000L * l2 / this.diskManager.getTotalLength());
                        }
                    }
                    if (n5 <= n3) continue;
                    n3 = n5;
                }
                if (n3 >= 0) {
                    diskManagerPiece.setNeeded();
                    bl = true;
                    n2 = this.availability[i];
                    if (n2 > 0 && n > n2) {
                        n3 += n - n2;
                        if (!bl4 && n2 <= this.globalMinOthers) {
                            n3 += n / n2;
                        }
                    }
                    if (this.provider_piece_rtas != null) {
                        if (this.provider_piece_rtas[i] > 0L) {
                            n3 = 9999999;
                        }
                    } else if (this.provider_piece_priorities != null) {
                        n3 = (int)((long)n3 + this.provider_piece_priorities[i]);
                    }
                } else {
                    diskManagerPiece.clearNeeded();
                }
                nArray[i] = n3;
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        if (bl != this.hasNeededUndonePiece) {
            this.hasNeededUndonePiece = bl;
            ++this.neededUndonePieceChange;
        }
        this.startPriorities = nArray;
    }

    private final boolean isRarestOverride() {
        boolean bl;
        int n = this.peerControl.getNbSeeds();
        int n2 = this.peerControl.getNbPeers();
        int n3 = n2 > n ? n2 : n;
        int n4 = this.peerControl.getNbActivePieces();
        boolean bl2 = bl = this.nbPiecesDone < 4 || this.endGameMode || this.globalMinOthers > 1 && (this.nbRarestActive >= n3 || n4 >= n3);
        if (!bl && this.nbRarestActive > 1 && this.globalMinOthers > 1) {
            bl = this.globalMinOthers > this.globalMin || this.globalMinOthers >= 2 * n && 2 * this.globalMinOthers >= n2;
        }
        return bl;
    }

    protected final int findPieceToDownload(PEPeerTransport pEPeerTransport, int n) {
        int n2;
        int[] nArray;
        PEPiece pEPiece;
        int n3 = this.getRequestCandidate(pEPeerTransport);
        if (n3 < 0) {
            return 0;
        }
        int n4 = (int)pEPeerTransport.getStats().getDataReceiveRate() / 1000;
        if (n4 < 0) {
            n4 = 0;
        }
        if (pEPeerTransport.isSnubbed()) {
            n4 = 0;
        }
        if (this.pePieces[n3] != null) {
            pEPiece = this.pePieces[n3];
        } else {
            nArray = pEPeerTransport.getPriorityOffsets();
            n2 = nArray == null ? 0 : nArray[n3];
            pEPiece = new PEPieceImpl(pEPeerTransport.getManager(), this.dmPieces[n3], n4 >> 1);
            this.peerControl.addPiece(pEPiece, n3);
            if (this.startPriorities != null) {
                pEPiece.setResumePriority(this.startPriorities[n3] + n2);
            } else {
                pEPiece.setResumePriority(n2);
            }
            if (this.availability[n3] <= this.globalMinOthers) {
                ++this.nbRarestActive;
            }
        }
        if (!pEPeerTransport.isLANLocal() || includeLanPeersInReqLimiting) {
            n = this.dispenser.dispense(n, 16384);
        }
        nArray = pEPiece.getAndMarkBlocks(pEPeerTransport, n, enable_request_hints);
        n2 = nArray[0];
        int n5 = nArray[1];
        if ((!pEPeerTransport.isLANLocal() || includeLanPeersInReqLimiting) && n5 != n) {
            this.dispenser.returnUnusedChunks(n - n5, 16384);
        }
        if (n5 <= 0) {
            return 0;
        }
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            int n7 = n2 + i;
            if (pEPeerTransport.request(n3, n7 * 16384, pEPiece.getBlockSize(n7)) == null) continue;
            ++n6;
            pEPeerTransport.setLastPiece(n3);
            pEPiece.setLastRequestedPeerSpeed(n4);
        }
        if (n6 > 0 && pEPiece.getAvailability() <= this.globalMinOthers && this.calcRarestAllowed() > 0 && !this.rarestStartedPieces.contains(pEPiece)) {
            this.rarestStartedPieces.add(pEPiece);
        }
        return n6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean findRTAPieceToDownload(PEPeerTransport pEPeerTransport, boolean bl, long l) {
        int n;
        block20: {
            block21: {
                block22: {
                    if (pEPeerTransport == null || pEPeerTransport.getPeerState() != 30) {
                        return false;
                    }
                    BitFlags bitFlags = pEPeerTransport.getAvailable();
                    if (bitFlags == null || bitFlags.nbSet <= 0) {
                        return false;
                    }
                    String string = null;
                    try {
                        RealTimeData realTimeData;
                        Object object;
                        int n2 = (int)pEPeerTransport.getStats().getDataReceiveRate() / 1024;
                        int n3 = bitFlags.start;
                        int n4 = bitFlags.end;
                        int n5 = -1;
                        int n6 = 0;
                        long l2 = Long.MAX_VALUE;
                        long l3 = SystemTime.getCurrentTime();
                        long l4 = l3 + (long)this.getNextBlockETAFromNow(pEPeerTransport);
                        block5: for (n = n3; n <= n4; ++n) {
                            boolean bl2;
                            PEPiece pEPiece;
                            long l5 = this.provider_piece_rtas[n];
                            if (!bitFlags.flags[n] || this.startPriorities[n] != 9999999 || l5 <= 0L || !(object = this.dmPieces[n]).isDownloadable() || (pEPiece = this.pePieces[n]) != null && pEPiece.isDownloaded()) continue;
                            Object object2 = null;
                            boolean bl3 = bl2 = l4 > l5 && l > l5;
                            if (l5 >= l2 || l4 > l5 && !bl && l <= l5) continue;
                            if (pEPiece == null || (object2 = pEPiece.getRealTimeData()) == null) {
                                l2 = l5;
                                n5 = n;
                                continue;
                            }
                            RealTimeData realTimeData2 = (RealTimeData)object2;
                            List[] listArray = realTimeData2.getRequests();
                            for (int i = 0; i < listArray.length; ++i) {
                                if (pEPiece.isDownloaded(i) || pEPiece.isWritten(i)) continue;
                                List list = listArray[i];
                                long l6 = Long.MAX_VALUE;
                                boolean bl4 = false;
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    RealTimePeerRequest realTimePeerRequest = (RealTimePeerRequest)iterator.next();
                                    PEPeerTransport pEPeerTransport2 = realTimePeerRequest.getPeer();
                                    if (pEPeerTransport2.getPeerState() != 30) {
                                        iterator.remove();
                                        continue;
                                    }
                                    DiskManagerReadRequest diskManagerReadRequest = realTimePeerRequest.getRequest();
                                    int n7 = pEPeerTransport2.getRequestIndex(diskManagerReadRequest);
                                    if (n7 == -1) {
                                        iterator.remove();
                                        continue;
                                    }
                                    if (pEPeerTransport2 == pEPeerTransport) {
                                        bl4 = true;
                                        break;
                                    }
                                    long l7 = pEPeerTransport2.getStats().getDataReceiveRate();
                                    if (l7 < 1L) {
                                        l7 = 1L;
                                    }
                                    int n8 = (n7 + 1) * 16384;
                                    long l8 = l3 + (long)(n8 * 1000) / l7;
                                    l6 = Math.min(l6, l8);
                                }
                                if (bl4) continue;
                                if (list.size() == 0) {
                                    l2 = l5;
                                    n5 = n;
                                    n6 = i;
                                    continue block5;
                                }
                                if (l6 <= l5 || !bl && bl2 || l4 >= l6) continue;
                                l2 = l5;
                                n5 = n;
                                n6 = i;
                                continue block5;
                            }
                        }
                        if (n5 == -1) break block20;
                        if (this.dispenser.dispense(1, 16384) != 1 && (!pEPeerTransport.isLANLocal() || includeLanPeersInReqLimiting)) break block21;
                        PEPiece pEPiece = this.pePieces[n5];
                        if (pEPiece == null) {
                            pEPiece = new PEPieceImpl(pEPeerTransport.getManager(), this.dmPieces[n5], n2 >> 1);
                            this.peerControl.addPiece(pEPiece, n5);
                            pEPiece.setResumePriority(9999999);
                            if (this.availability[n5] <= this.globalMinOthers) {
                                ++this.nbRarestActive;
                            }
                        }
                        if ((realTimeData = (RealTimeData)pEPiece.getRealTimeData()) == null) {
                            realTimeData = new RealTimeData(pEPiece);
                            pEPiece.setRealTimeData(realTimeData);
                        }
                        pEPiece.getAndMarkBlock(pEPeerTransport, n6);
                        DiskManagerReadRequest diskManagerReadRequest = pEPeerTransport.request(n5, n6 * 16384, pEPiece.getBlockSize(n6));
                        if (diskManagerReadRequest == null) break block22;
                        object = realTimeData.getRequests()[n6];
                        object.add(new RealTimePeerRequest(pEPeerTransport, diskManagerReadRequest));
                        pEPeerTransport.setLastPiece(n5);
                        pEPiece.setLastRequestedPeerSpeed(n2);
                        boolean bl5 = true;
                        Object var43_39 = null;
                        return bl5;
                    }
                    catch (Throwable throwable) {
                        Object var43_43 = null;
                        throw throwable;
                    }
                }
                if (!pEPeerTransport.isLANLocal() || includeLanPeersInReqLimiting) {
                    this.dispenser.returnUnusedChunks(1, 16384);
                }
                boolean bl6 = false;
                Object var43_40 = null;
                return bl6;
            }
            n = 0;
            Object var43_41 = null;
            return n != 0;
        }
        n = 0;
        Object var43_42 = null;
        return n != 0;
    }

    private final int getRequestCandidate(PEPeerTransport pEPeerTransport) {
        int n;
        if (pEPeerTransport == null || pEPeerTransport.getPeerState() != 30) {
            return -1;
        }
        BitFlags bitFlags = pEPeerTransport.getAvailable();
        if (bitFlags == null || bitFlags.nbSet <= 0) {
            return -1;
        }
        int n2 = pEPeerTransport.getReservedPieceNumber();
        if (n2 >= 0) {
            String string;
            PEPiece pEPiece = this.pePieces[n2];
            if (pEPiece != null && (string = pEPiece.getReservedBy()) != null && string.equals(pEPeerTransport.getIp()) && bitFlags.flags[n2] && pEPiece.isRequestable()) {
                return n2;
            }
            pEPeerTransport.setReservedPieceNumber(-1);
            if (pEPiece != null && (string = pEPiece.getReservedBy()) != null && string.equals(pEPeerTransport.getIp())) {
                pEPiece.setReservedBy(null);
            }
            n2 = -1;
        }
        int n3 = (int)pEPeerTransport.getStats().getDataReceiveRate() / 1024;
        int n4 = pEPeerTransport.getLastPiece();
        int n5 = this.peerControl.getNbPeersSnubbed();
        long l = Long.MAX_VALUE;
        int n6 = Integer.MIN_VALUE;
        boolean bl = false;
        int n7 = -1;
        BitFlags bitFlags2 = null;
        int n8 = Integer.MIN_VALUE;
        int n9 = Integer.MAX_VALUE;
        boolean bl2 = false;
        boolean bl3 = false;
        int n10 = 0;
        boolean bl4 = this.calcRarestAllowed() > 0;
        int n11 = bitFlags.start;
        int n12 = bitFlags.end;
        int[] nArray = pEPeerTransport.getPriorityOffsets();
        long l2 = SystemTime.getCurrentTime();
        int[] nArray2 = pEPeerTransport.getRequestHint();
        if (nArray2 != null) {
            n = nArray2[0];
            if (this.dmPieces[n].isDone()) {
                pEPeerTransport.clearRequestHint();
                n = -1;
            }
        } else {
            n = -1;
        }
        for (int i = n11; i <= n12; ++i) {
            PEPiece pEPiece;
            if (!bitFlags.flags[i]) continue;
            int n13 = this.startPriorities[i];
            DiskManagerPiece diskManagerPiece = this.dmPieces[i];
            if (n13 < 0 || !diskManagerPiece.isDownloadable()) continue;
            if (nArray != null) {
                n13 += nArray[i];
            }
            if (enable_request_hints && i == n) {
                n13 += 3000;
                pEPiece = this.pePieces[i];
                if (pEPiece == null) {
                    bl3 = true;
                } else if (n2 != i) {
                    pEPiece.setReservedBy(pEPeerTransport.getIp());
                    pEPeerTransport.setReservedPieceNumber(i);
                }
            }
            if ((pEPiece = this.pePieces[i]) != null && !pEPiece.isRequestable()) continue;
            boolean bl5 = n13 >= 9000 ? true : bl4;
            n10 = this.availability[i];
            if (n10 == 0) {
                this.availability[i] = 1;
                n10 = 1;
            }
            if (pEPiece != null) {
                if (n13 != this.startPriorities[i]) {
                    pEPiece.setResumePriority(n13);
                }
                boolean bl6 = this.rarestStartedPieces.contains(pEPiece);
                boolean bl7 = n10 <= this.globalMinOthers && (bl6 || bl4);
                int n14 = pEPiece.getNbUnrequested();
                if (n14 <= 0) {
                    pEPiece.setRequested();
                    continue;
                }
                String string = pEPiece.getReservedBy();
                if (string != null) {
                    if (!string.equals(pEPeerTransport.getIp())) continue;
                    pEPeerTransport.setReservedPieceNumber(i);
                    return i;
                }
                int n15 = pEPiece.getSpeed();
                boolean bl8 = true;
                if (pEPeerTransport.isSnubbed()) {
                    bl8 &= n15 < 1;
                    bl8 &= n14 > 2 || n10 <= n5;
                } else {
                    bl8 &= n14 * n3 >= n15 / 2;
                    bl8 &= n3 < 2 || n15 > 0 || pEPiece.getNbRequests() == 0;
                    bl8 |= i == pEPeerTransport.getLastPiece();
                }
                if (n7 == -1 || n10 > this.availability[n7]) {
                    n7 = i;
                }
                if (!bl8 || (long)n10 > l) continue;
                n13 += n15;
                n13 += i == n4 ? 700 : 0;
                n13 = (int)((long)n13 + pEPiece.getTimeSinceLastActivity() / 120000L);
                long l3 = l2 - pEPiece.getCreationTime();
                if (l3 > 0L) {
                    n13 = (int)((long)n13 + 900L * l3 / (long)(60000 * diskManagerPiece.getNbBlocks()));
                }
                pEPiece.setResumePriority(n13 += 900 * diskManagerPiece.getNbWritten() / diskManagerPiece.getNbBlocks());
                if ((long)n10 >= l && ((long)n10 != l || n13 <= n6) || !pEPiece.hasUnrequestedBlock()) continue;
                n2 = i;
                l = n10;
                n6 = n13;
                l = n10;
                bl = bl7;
                continue;
            }
            if (n10 <= this.globalMinOthers && bl4) {
                if (!bl2) {
                    if (bitFlags2 == null) {
                        bitFlags2 = new BitFlags(this.nbPieces);
                    }
                    n8 = n13;
                    n9 = n10;
                    bl2 = n10 <= this.globalMinOthers;
                    bitFlags2.setOnly(i);
                    continue;
                }
                if (n13 > n8) {
                    if (bitFlags2 == null) {
                        bitFlags2 = new BitFlags(this.nbPieces);
                    }
                    n8 = n13;
                    bitFlags2.setOnly(i);
                    continue;
                }
                if (n13 != n8) continue;
                bitFlags2.setEnd(i);
                continue;
            }
            if (bl2 && bl4) continue;
            if (n13 > n8) {
                if (bitFlags2 == null) {
                    bitFlags2 = new BitFlags(this.nbPieces);
                }
                n8 = n13;
                n9 = n10;
                bl2 = n10 <= this.globalMinOthers;
                bitFlags2.setOnly(i);
                continue;
            }
            if (n13 != n8) continue;
            if (n10 < n9) {
                n9 = n10;
                bl2 = n10 <= this.globalMinOthers;
                bitFlags2.setOnly(i);
                continue;
            }
            if (n10 != n9) continue;
            bitFlags2.setEnd(i);
        }
        if (!bl3 || bitFlags2 == null || bitFlags2.nbSet <= 0) {
            if (!(n2 < 0 || !bl && bl2 && bl4 && bitFlags2 != null && bitFlags2.nbSet > 0)) {
                return n2;
            }
            if (n7 != -1 && (bitFlags2 == null || bitFlags2.nbSet <= 0)) {
                return n7;
            }
            if (n2 >= 0 && this.globalMinOthers > 0 && this.peerControl.getNbActivePieces() > 32) {
                boolean bl9;
                boolean bl10 = bl9 = (long)n6 / l > (long)(n8 / this.globalMinOthers);
                if (Constants.isCVSVersion() && Logger.isEnabled()) {
                    Logger.log(new LogEvent(new Object[]{pEPeerTransport, this.peerControl}, LOGID, "Start/resume choice; piece #:" + n2 + " resumeIsBetter:" + bl9 + " globalMinOthers=" + this.globalMinOthers + " startMaxPriority=" + n8 + " startMinAvail=" + n9 + " resumeMaxPriority=" + n6 + " resumeMinAvail=" + l + " : " + pEPeerTransport));
                }
                if (bl9) {
                    return n2;
                }
            }
        }
        return this.getPieceToStart(bitFlags2);
    }

    protected final int getPieceToStart(BitFlags bitFlags) {
        if (bitFlags == null || bitFlags.nbSet <= 0) {
            return -1;
        }
        if (bitFlags.nbSet == 1) {
            return bitFlags.start;
        }
        int n = RandomUtils.generateRandomPlusMinus1();
        int n2 = n == 1 ? bitFlags.start : bitFlags.end;
        int n3 = RandomUtils.generateRandomIntUpto(bitFlags.nbSet);
        int n4 = -1;
        for (int i = n2; i <= bitFlags.end && i >= bitFlags.start; i += n) {
            if (!bitFlags.flags[i] || ++n4 < n3) continue;
            return i;
        }
        return -1;
    }

    public final boolean hasDownloadablePiece() {
        return this.hasNeededUndonePiece;
    }

    public final long getNeededUndonePieceChange() {
        return this.neededUndonePieceChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkEndGameMode() {
        long l;
        int n;
        if (this.peerControl.getNbSeeds() + this.peerControl.getNbPeers() < 3) {
            return;
        }
        long l2 = SystemTime.getCurrentTime();
        if (this.endGameMode || this.endGameModeAbandoned) {
            if (!this.endGameModeAbandoned && l2 - this.timeEndGameModeEntered > 76800L) {
                this.abandonEndGameMode();
            }
            return;
        }
        int n2 = 0;
        for (n = 0; n < this.nbPieces; ++n) {
            PEPiece pEPiece;
            DiskManagerPiece diskManagerPiece = this.dmPieces[n];
            if (!diskManagerPiece.isDownloadable() || (pEPiece = this.pePieces[n]) != null && pEPiece.isDownloaded()) continue;
            if (pEPiece != null && pEPiece.isRequested() && diskManagerPiece.isNeeded()) {
                ++n2;
                continue;
            }
            return;
        }
        n = this.rta_providers.size() > 0 ? 1 : 0;
        long l3 = n2 * this.diskManager.getPieceLength();
        long l4 = l = n != 0 ? 262144L : 0x1400000L;
        if (l3 <= l) {
            try {
                this.endGameModeChunks_mon.enter();
                this.endGameModeChunks = new ArrayList();
                this.timeEndGameModeEntered = l2;
                this.endGameMode = true;
                this.computeEndGameModeChunks();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.diskManager.getTorrent(), LOGID, "Entering end-game mode: " + this.peerControl.getDisplayName()));
                }
                Object var10_8 = null;
                this.endGameModeChunks_mon.exit();
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                this.endGameModeChunks_mon.exit();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void computeEndGameModeChunks() {
        try {
            this.endGameModeChunks_mon.enter();
            for (int i = 0; i < this.nbPieces; ++i) {
                int n;
                boolean[] blArray;
                DiskManagerPiece diskManagerPiece = this.dmPieces[i];
                if (!diskManagerPiece.isInteresting()) continue;
                PEPiece pEPiece = this.pePieces[i];
                if (pEPiece == null) {
                    pEPiece = new PEPieceImpl(this.peerControl, diskManagerPiece, 0);
                    this.peerControl.addPiece(pEPiece, i);
                }
                if ((blArray = diskManagerPiece.getWritten()) == null) {
                    if (diskManagerPiece.isDone()) continue;
                    for (n = 0; n < pEPiece.getNbBlocks(); ++n) {
                        this.endGameModeChunks.add(new EndGameModeChunk(pEPiece, n));
                    }
                    continue;
                }
                for (n = 0; n < blArray.length; ++n) {
                    if (blArray[n]) continue;
                    this.endGameModeChunks.add(new EndGameModeChunk(pEPiece, n));
                }
            }
            Object var7_6 = null;
            this.endGameModeChunks_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.endGameModeChunks_mon.exit();
            throw throwable;
        }
    }

    public final boolean isInEndGameMode() {
        return this.endGameMode;
    }

    public boolean hasEndGameModeBeenAbandoned() {
        return this.endGameModeAbandoned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addEndGameChunks(PEPiece pEPiece) {
        if (!this.endGameMode) {
            return;
        }
        try {
            this.endGameModeChunks_mon.enter();
            int n = pEPiece.getNbBlocks();
            for (int i = 0; i < n; ++i) {
                this.endGameModeChunks.add(new EndGameModeChunk(pEPiece, i));
            }
            Object var5_4 = null;
            this.endGameModeChunks_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.endGameModeChunks_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int findPieceInEndGameMode(PEPeerTransport pEPeerTransport, int n) {
        block5: {
            int n2;
            EndGameModeChunk endGameModeChunk;
            block6: {
                if (pEPeerTransport == null || n <= 0 || pEPeerTransport.getPeerState() != 30) {
                    return 0;
                }
                try {
                    this.endGameModeChunks_mon.enter();
                    int n3 = this.endGameModeChunks.size();
                    if (n3 <= 0) break block5;
                    int n4 = RandomUtils.generateRandomIntUpto(n3);
                    endGameModeChunk = (EndGameModeChunk)this.endGameModeChunks.get(n4);
                    n2 = endGameModeChunk.getPieceNumber();
                    if (!this.dmPieces[n2].isWritten(endGameModeChunk.getBlockNumber())) break block6;
                    this.endGameModeChunks.remove(endGameModeChunk);
                    int n5 = 0;
                    Object var10_9 = null;
                    this.endGameModeChunks_mon.exit();
                    return n5;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    this.endGameModeChunks_mon.exit();
                    throw throwable;
                }
            }
            PEPiece pEPiece = this.pePieces[n2];
            if (!pEPeerTransport.isPieceAvailable(n2) || pEPiece == null || pEPeerTransport.isSnubbed() && this.availability[n2] > this.peerControl.getNbPeersSnubbed() || pEPeerTransport.request(n2, endGameModeChunk.getOffset(), endGameModeChunk.getLength()) == null) break block5;
            pEPiece.setRequested(pEPeerTransport, endGameModeChunk.getBlockNumber());
            pEPeerTransport.setLastPiece(n2);
            int n6 = 1;
            Object var10_10 = null;
            this.endGameModeChunks_mon.exit();
            return n6;
        }
        this.leaveEndGameMode();
        Object var10_11 = null;
        this.endGameModeChunks_mon.exit();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeFromEndGameModeChunks(int n, int n2) {
        if (!this.endGameMode) {
            return;
        }
        try {
            this.endGameModeChunks_mon.enter();
            Iterator iterator = this.endGameModeChunks.iterator();
            while (iterator.hasNext()) {
                EndGameModeChunk endGameModeChunk = (EndGameModeChunk)iterator.next();
                if (!endGameModeChunk.equals(n, n2)) continue;
                iterator.remove();
            }
            Object var6_5 = null;
            this.endGameModeChunks_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.endGameModeChunks_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearEndGameChunks() {
        if (!this.endGameMode) {
            return;
        }
        try {
            this.endGameModeChunks_mon.enter();
            this.endGameModeChunks.clear();
            this.endGameMode = false;
            Object var2_1 = null;
            this.endGameModeChunks_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.endGameModeChunks_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void leaveEndGameMode() {
        try {
            this.endGameModeChunks_mon.enter();
            if (this.endGameMode) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.diskManager.getTorrent(), LOGID, "Leaving end-game mode: " + this.peerControl.getDisplayName()));
                }
                this.endGameMode = false;
                this.endGameModeChunks.clear();
                this.timeEndGameModeEntered = 0L;
            }
            Object var2_1 = null;
            this.endGameModeChunks_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.endGameModeChunks_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abandonEndGameMode() {
        if (!this.endGameModeAbandoned) {
            try {
                this.endGameModeChunks_mon.enter();
                this.endGameModeAbandoned = true;
                this.endGameMode = false;
                this.clearEndGameChunks();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.diskManager.getTorrent(), LOGID, "Abandoning end-game mode: " + this.peerControl.getDisplayName()));
                }
                Object var2_1 = null;
                this.endGameModeChunks_mon.exit();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.endGameModeChunks_mon.exit();
                throw throwable;
            }
        }
    }

    private boolean computeProviderPriorities() {
        List list;
        Object object;
        List list2 = this.priority_providers.getList();
        if (list2.size() == 0) {
            if (this.provider_piece_priorities != null) {
                ++paramPriorityChange;
                this.provider_piece_priorities = null;
            }
        } else {
            ++paramPriorityChange;
            this.provider_piece_priorities = new long[this.nbPieces];
            for (int i = 0; i < list2.size(); ++i) {
                PiecePriorityProvider piecePriorityProvider = (PiecePriorityProvider)list2.get(i);
                object = piecePriorityProvider.updatePriorities(this);
                if (object == null) continue;
                for (int j = 0; j < ((Object)object).length; ++j) {
                    Object object2 = object[j];
                    if (object2 == 0L) continue;
                    int n = j;
                    this.provider_piece_priorities[n] = this.provider_piece_priorities[n] + object2;
                }
            }
        }
        if ((list = this.rta_providers.getList()).size() == 0) {
            if (this.provider_piece_rtas != null) {
                for (int i = 0; i < this.pePieces.length; ++i) {
                    object = this.pePieces[i];
                    if (object == null) continue;
                    object.setRealTimeData(null);
                }
                this.provider_piece_rtas = null;
            }
            return false;
        }
        boolean bl = false;
        this.provider_piece_rtas = new long[this.nbPieces];
        for (int i = 0; i < list.size(); ++i) {
            PieceRTAProvider pieceRTAProvider = (PieceRTAProvider)list.get(i);
            long[] lArray = pieceRTAProvider.updateRTAs(this);
            if (lArray == null) continue;
            for (int j = 0; j < lArray.length; ++j) {
                long l = lArray[j];
                if (l <= 0L) continue;
                this.provider_piece_rtas[j] = this.provider_piece_rtas[j] == 0L ? l : Math.min(this.provider_piece_rtas[j], l);
                bl = true;
            }
        }
        return bl;
    }

    public void addRTAProvider(PieceRTAProvider pieceRTAProvider) {
        this.rta_providers.add(pieceRTAProvider);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((PiecePickerListener)iterator.next()).providerAdded(pieceRTAProvider);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        this.leaveEndGameMode();
    }

    public void removeRTAProvider(PieceRTAProvider pieceRTAProvider) {
        this.rta_providers.remove(pieceRTAProvider);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((PiecePickerListener)iterator.next()).providerRemoved(pieceRTAProvider);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public List getRTAProviders() {
        return this.rta_providers.getList();
    }

    public void addPriorityProvider(PiecePriorityProvider piecePriorityProvider) {
        this.priority_providers.add(piecePriorityProvider);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((PiecePickerListener)iterator.next()).providerAdded(piecePriorityProvider);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public void removePriorityProvider(PiecePriorityProvider piecePriorityProvider) {
        this.priority_providers.remove(piecePriorityProvider);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((PiecePickerListener)iterator.next()).providerRemoved(piecePriorityProvider);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public List getPriorityProviders() {
        return this.rta_providers.getList();
    }

    public void addListener(PiecePickerListener piecePickerListener) {
        this.listeners.add(piecePickerListener);
        Iterator iterator = this.rta_providers.iterator();
        while (iterator.hasNext()) {
            piecePickerListener.providerAdded((PieceRTAProvider)iterator.next());
        }
    }

    public void removeListener(PiecePickerListener piecePickerListener) {
        this.listeners.remove(piecePickerListener);
    }

    public void destroy() {
    }

    public String getPieceString(int n) {
        String string;
        long[] lArray;
        long l;
        long l2 = l = this.startPriorities == null ? 0L : (long)this.startPriorities[n];
        if (l == 9999999L) {
            lArray = this.provider_piece_rtas;
            string = "pri=rta:" + (lArray == null ? "?" : "" + (lArray[n] - SystemTime.getCurrentTime()));
        } else {
            string = "pri=" + l;
        }
        lArray = this.provider_piece_priorities;
        if (lArray != null) {
            string = string + ",ext=" + lArray[n];
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println("Piece Picker");
        try {
            indentWriter.indent();
            indentWriter.println("globalAvail: " + this.globalAvail);
            indentWriter.println("globalAvgAvail: " + this.globalAvgAvail);
            indentWriter.println("nbRarestActive: " + this.nbRarestActive);
            indentWriter.println("globalMin: " + this.globalMin);
            indentWriter.println("globalMinOthers: " + this.globalMinOthers);
            indentWriter.println("hasNeededUndonePiece: " + this.hasNeededUndonePiece);
            indentWriter.println("endGameMode: " + this.endGameMode);
            indentWriter.println("endGameModeAbandoned: " + this.endGameModeAbandoned);
            indentWriter.println("endGameModeChunks: " + this.endGameModeChunks);
            Object var3_2 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    static {
        class ParameterListenerImpl
        implements ParameterListener {
            ParameterListenerImpl() {
            }

            public final void parameterChanged(String string) {
                if (string.equals("Prioritize Most Completed Files")) {
                    completionPriority = COConfigurationManager.getBooleanParameter(string);
                    ++paramPriorityChange;
                } else if (string.equals("Prioritize First Piece")) {
                    firstPiecePriority = COConfigurationManager.getBooleanParameter(string);
                    ++paramPriorityChange;
                } else if (string.equals("Piece Picker Request Hint Enabled")) {
                    enable_request_hints = COConfigurationManager.getBooleanParameter(string);
                }
                includeLanPeersInReqLimiting = !COConfigurationManager.getBooleanParameter("LAN Speed Enabled");
            }
        }
        ParameterListenerImpl parameterListenerImpl = new ParameterListenerImpl();
        COConfigurationManager.addParameterListener("Prioritize Most Completed Files", (ParameterListener)parameterListenerImpl);
        COConfigurationManager.addAndFireParameterListener("Prioritize First Piece", parameterListenerImpl);
        COConfigurationManager.addAndFireParameterListener("Piece Picker Request Hint Enabled", parameterListenerImpl);
        COConfigurationManager.addAndFireParameterListener("LAN Speed Enabled", parameterListenerImpl);
    }

    protected class RealTimePeerRequest {
        private PEPeerTransport peer;
        private DiskManagerReadRequest request;

        protected RealTimePeerRequest(PEPeerTransport pEPeerTransport, DiskManagerReadRequest diskManagerReadRequest) {
            this.peer = pEPeerTransport;
            this.request = diskManagerReadRequest;
        }

        protected PEPeerTransport getPeer() {
            return this.peer;
        }

        protected DiskManagerReadRequest getRequest() {
            return this.request;
        }
    }

    protected class RealTimeData {
        private List[] peer_requests;

        protected RealTimeData(PEPiece pEPiece) {
            int n = pEPiece.getNbBlocks();
            this.peer_requests = new List[n];
            for (int i = 0; i < this.peer_requests.length; ++i) {
                this.peer_requests[i] = new ArrayList(1);
            }
        }

        public final List[] getRequests() {
            return this.peer_requests;
        }
    }

    private class DiskManagerListenerImpl
    implements DiskManagerListener {
        private DiskManagerListenerImpl() {
        }

        public final void stateChanged(int n, int n2) {
        }

        public final void filePriorityChanged(DiskManagerFileInfo diskManagerFileInfo) {
            int n;
            int n2;
            ++PiecePickerImpl.this.filePriorityChange;
            boolean bl = false;
            if (PiecePickerImpl.this.hasNeededUndonePiece) {
                n2 = 0;
                n = PiecePickerImpl.this.nbPieces;
            } else {
                n2 = diskManagerFileInfo.getFirstPieceNumber();
                n = diskManagerFileInfo.getLastPieceNumber() + 1;
            }
            for (int i = n2; i < n; ++i) {
                DiskManagerPiece diskManagerPiece = PiecePickerImpl.this.dmPieces[i];
                if (diskManagerPiece.isDone()) continue;
                bl |= diskManagerPiece.calcNeeded();
            }
            if (bl ^ PiecePickerImpl.this.hasNeededUndonePiece) {
                PiecePickerImpl.this.hasNeededUndonePiece = bl;
                ++PiecePickerImpl.this.neededUndonePieceChange;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void pieceDoneChanged(DiskManagerPiece diskManagerPiece) {
            int n = diskManagerPiece.getPieceNumber();
            if (diskManagerPiece.isDone()) {
                PiecePickerImpl.this.addHavePiece(null, n);
                ++PiecePickerImpl.this.nbPiecesDone;
                if (PiecePickerImpl.this.nbPiecesDone >= PiecePickerImpl.this.nbPieces) {
                    PiecePickerImpl.this.checkDownloadablePiece();
                }
            } else {
                try {
                    PiecePickerImpl.this.availabilityMon.enter();
                    if (PiecePickerImpl.this.availabilityAsynch == null) {
                        PiecePickerImpl.this.availabilityAsynch = (int[])PiecePickerImpl.this.availability.clone();
                    }
                    if (PiecePickerImpl.this.availabilityAsynch[n] > 0) {
                        int n2 = n;
                        PiecePickerImpl.this.availabilityAsynch[n2] = PiecePickerImpl.this.availabilityAsynch[n2] - 1;
                    } else {
                        ++PiecePickerImpl.this.availabilityDrift;
                    }
                    ++PiecePickerImpl.this.availabilityChange;
                    Object var4_3 = null;
                    PiecePickerImpl.this.availabilityMon.exit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    PiecePickerImpl.this.availabilityMon.exit();
                    throw throwable;
                }
                --PiecePickerImpl.this.nbPiecesDone;
                if (diskManagerPiece.calcNeeded() && !PiecePickerImpl.this.hasNeededUndonePiece) {
                    PiecePickerImpl.this.hasNeededUndonePiece = true;
                    ++PiecePickerImpl.this.neededUndonePieceChange;
                }
            }
        }

        public final void fileAccessModeChanged(DiskManagerFileInfo diskManagerFileInfo, int n, int n2) {
        }
    }

    private class PEPeerListenerImpl
    implements PEPeerListener {
        private PEPeerListenerImpl() {
        }

        public final void stateChanged(PEPeer pEPeer, int n) {
        }

        public final void sentBadChunk(PEPeer pEPeer, int n, int n2) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addAvailability(PEPeer pEPeer, BitFlags bitFlags) {
            if (bitFlags == null || bitFlags.nbSet <= 0) {
                return;
            }
            try {
                PiecePickerImpl.this.availabilityMon.enter();
                if (PiecePickerImpl.this.availabilityAsynch == null) {
                    PiecePickerImpl.this.availabilityAsynch = (int[])PiecePickerImpl.this.availability.clone();
                }
                for (int i = bitFlags.start; i <= bitFlags.end; ++i) {
                    if (!bitFlags.flags[i]) continue;
                    int n = i;
                    PiecePickerImpl.this.availabilityAsynch[n] = PiecePickerImpl.this.availabilityAsynch[n] + 1;
                }
                ++PiecePickerImpl.this.availabilityChange;
                Object var5_4 = null;
                PiecePickerImpl.this.availabilityMon.exit();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                PiecePickerImpl.this.availabilityMon.exit();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeAvailability(PEPeer pEPeer, BitFlags bitFlags) {
            if (bitFlags == null || bitFlags.nbSet <= 0) {
                return;
            }
            try {
                PiecePickerImpl.this.availabilityMon.enter();
                if (PiecePickerImpl.this.availabilityAsynch == null) {
                    PiecePickerImpl.this.availabilityAsynch = (int[])PiecePickerImpl.this.availability.clone();
                }
                for (int i = bitFlags.start; i <= bitFlags.end; ++i) {
                    if (!bitFlags.flags[i]) continue;
                    if (PiecePickerImpl.this.availabilityAsynch[i] > (PiecePickerImpl.this.dmPieces[i].isDone() ? 1 : 0)) {
                        int n = i;
                        PiecePickerImpl.this.availabilityAsynch[n] = PiecePickerImpl.this.availabilityAsynch[n] - 1;
                        continue;
                    }
                    ++PiecePickerImpl.this.availabilityDrift;
                }
                ++PiecePickerImpl.this.availabilityChange;
                Object var5_4 = null;
                PiecePickerImpl.this.availabilityMon.exit();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                PiecePickerImpl.this.availabilityMon.exit();
                throw throwable;
            }
        }
    }

    private class PEPeerManagerListenerImpl
    implements PEPeerManagerListener {
        private PEPeerManagerListenerImpl() {
        }

        public final void peerAdded(PEPeerManager pEPeerManager, PEPeer pEPeer) {
            PEPeerListenerImpl pEPeerListenerImpl = (PEPeerListenerImpl)PiecePickerImpl.this.peerListeners.get(pEPeer);
            if (pEPeerListenerImpl == null) {
                pEPeerListenerImpl = new PEPeerListenerImpl();
                PiecePickerImpl.this.peerListeners.put(pEPeer, pEPeerListenerImpl);
            }
            pEPeer.addListener(pEPeerListenerImpl);
        }

        public final void peerRemoved(PEPeerManager pEPeerManager, PEPeer pEPeer) {
            PEPeerListenerImpl pEPeerListenerImpl = (PEPeerListenerImpl)PiecePickerImpl.this.peerListeners.remove(pEPeer);
            pEPeer.removeListener(pEPeerListenerImpl);
        }

        public void peerDiscovered(PEPeerManager pEPeerManager, PeerItem peerItem, PEPeer pEPeer) {
        }

        public void peerSentBadData(PEPeerManager pEPeerManager, PEPeer pEPeer, int n) {
        }

        public void destroyed() {
        }
    }
}

