/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.piecepicker.util;

import com.aelitis.azureus.core.util.HashCodeUtils;
import java.util.Arrays;

public class BitFlags
implements Cloneable {
    public int start;
    public int end;
    public int nbSet;
    public final boolean[] flags;

    public BitFlags(int n) {
        this.start = n;
        this.end = 0;
        this.nbSet = 0;
        this.flags = new boolean[n];
    }

    public BitFlags(boolean[] blArray) {
        this.start = blArray.length;
        this.flags = blArray;
        for (int i = 0; i < this.flags.length; ++i) {
            if (!this.flags[i]) continue;
            ++this.nbSet;
            if (i < this.start) {
                this.start = i;
            }
            this.end = i;
        }
    }

    public BitFlags(BitFlags bitFlags) {
        this.start = bitFlags.start;
        this.end = bitFlags.end;
        this.nbSet = bitFlags.nbSet;
        this.flags = (boolean[])bitFlags.flags.clone();
    }

    public Object clone() {
        return new BitFlags(this);
    }

    public int hashCode() {
        int n = HashCodeUtils.hashMore(0, this.flags);
        n = HashCodeUtils.hashMore(n, this.nbSet);
        n = HashCodeUtils.hashMore(n, this.end);
        return HashCodeUtils.hashMore(n, this.start);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BitFlags)) {
            return false;
        }
        BitFlags bitFlags = (BitFlags)object;
        if (this.start != bitFlags.start) {
            return false;
        }
        if (this.end != bitFlags.end) {
            return false;
        }
        if (this.nbSet != bitFlags.nbSet) {
            return false;
        }
        if (this.flags == null && bitFlags.flags == null) {
            return true;
        }
        if (this.flags == null || bitFlags.flags == null) {
            return false;
        }
        if (this.flags.length != bitFlags.flags.length) {
            return false;
        }
        for (int i = 0; i < this.flags.length; ++i) {
            if (!(this.flags[i] ^ bitFlags.flags[i])) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.flags.length;
    }

    public void clear() {
        Arrays.fill(this.flags, false);
        this.start = this.flags.length;
        this.end = 0;
        this.nbSet = 0;
    }

    public void setStart(int n) {
        this.flags[n] = true;
        ++this.nbSet;
        this.start = n;
    }

    public void set(int n) {
        if (!this.flags[n]) {
            this.flags[n] = true;
            ++this.nbSet;
            if (this.start > n) {
                this.start = n;
            }
            if (this.end < n) {
                this.end = n;
            }
        }
    }

    public void setEnd(int n) {
        this.flags[n] = true;
        ++this.nbSet;
        this.end = n;
    }

    public void setOnly(int n) {
        if (this.start < this.flags.length) {
            Arrays.fill(this.flags, this.start, this.end, false);
        }
        this.nbSet = 1;
        this.start = n;
        this.end = n;
        this.flags[n] = true;
    }

    public void setAll() {
        this.start = 0;
        this.end = this.flags.length - 1;
        Arrays.fill(this.flags, this.start, this.end, true);
        this.nbSet = this.flags.length;
    }

    public BitFlags and(BitFlags bitFlags) {
        BitFlags bitFlags2 = new BitFlags(this.flags.length);
        if (this.nbSet > 0 && bitFlags.nbSet > 0) {
            int n;
            int n2;
            int n3 = n2 = this.end < bitFlags.end ? this.end : bitFlags.end;
            for (n = this.start > bitFlags.start ? this.start : bitFlags.start; n <= n2; ++n) {
                if (!this.flags[n] || !bitFlags.flags[n]) continue;
                bitFlags2.flags[n] = true;
                ++bitFlags2.nbSet;
                bitFlags2.start = n;
                break;
            }
            while (n <= n2) {
                if (this.flags[n] && bitFlags.flags[n]) {
                    bitFlags2.flags[n] = true;
                    ++bitFlags2.nbSet;
                    bitFlags2.end = n;
                }
                ++n;
            }
            if (bitFlags2.end < bitFlags2.start) {
                bitFlags2.end = bitFlags2.start;
            }
        }
        return bitFlags2;
    }
}

