/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.peermanager.utils.BTPeerIDByteDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.ByteFormatter;

public class ClientIdentifier {
    private static int test_count = 1;

    public static String identifyBTOnly(String string, byte[] byArray) {
        if (string.equals("Mainline 4.4.0") && (byArray[7] & 1) == 0) {
            return ClientIdentifier.asDiscrepancy("BitThief*", string, "fake_client");
        }
        if (!string.startsWith("Azureus ")) {
            return string;
        }
        String string2 = string.substring(8);
        if (string2.startsWith("1") || string2.startsWith("2.0") || string2.startsWith("2.1") || string2.startsWith("2.2")) {
            return string;
        }
        return ClientIdentifier.asDiscrepancy(null, string, "fake_client");
    }

    public static String identifyAZMP(String string, String string2, String string3, byte[] byArray) {
        String string4;
        String string5;
        if (string2.endsWith("BitTyrant")) {
            return "BitTyrant " + string3.replaceAll("BitTyrant", "") + " (Azureus Mod)";
        }
        String string6 = string2 + " " + string3;
        if (string6.equals(string)) {
            return string6;
        }
        String string7 = string.split(" ", 2)[0];
        if (string7.equals(string5 = string2.split(" ", 2)[0])) {
            if (string5.equals("Azureus") && string7.equals("Azureus") && !string6.substring(0, 15).equals(string.substring(0, 15))) {
                return ClientIdentifier.asDiscrepancy("Azureus (Hacked)", string, string6, "fake_client", "AZMP", byArray);
            }
            return string6;
        }
        String string8 = ClientIdentifier.checkForTransmissionBasedClients(string6, string7, string, string6, byArray, "AZMP");
        if (string8 != null) {
            return string8;
        }
        String string9 = null;
        boolean bl = string.startsWith("Azureus ");
        boolean bl2 = string2.equals("Azureus");
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = string.startsWith(MessageText.getString("PeerSocket.unknown"));
        if (bl) {
            if (bl2) {
                throw new RuntimeException("logic error in getExtendedClientName - both clients are Azureus");
            }
            bl3 = true;
            if (string6.equals("Transmission 0.7-svn")) {
                string9 = "XTorrent";
            }
        } else if (bl2) {
            bl3 = true;
        } else if (bl5) {
            string9 = string6;
            bl4 = false;
            BTPeerIDByteDecoder.logClientDiscrepancy(string, string6, "unknown_client", "AZMP", byArray);
        } else if (string6.startsWith("Ares") && string7.equals("ArcticTorrent")) {
            return string6;
        }
        if ((string4 = bl3 ? "fake_client" : (bl4 ? "mismatch_id" : null)) != null) {
            return ClientIdentifier.asDiscrepancy(null, string, string6, string4, "AZMP", byArray);
        }
        return string9;
    }

    public static String identifyLTEP(String string, String string2, byte[] byArray) {
        if (string2 == null) {
            return string;
        }
        String string3 = string2;
        if (string2.startsWith("BitTorrent ")) {
            string3 = string2.replaceFirst("BitTorrent", "Mainline");
        }
        if (string.startsWith("\u00b5Torrent")) {
            if (string.equals("\u00b5Torrent 1.6.0")) {
                return string;
            }
            if (!string2.startsWith("\u00b5Torrent") && string2.startsWith("Torrent", 1)) {
                string3 = "\u00b5" + string2.substring(1);
            }
            if (string.endsWith("Beta") && string.startsWith(string3)) {
                return string;
            }
        }
        if (string.startsWith("Mainline 4.") && string2.startsWith("Torrent", 1)) {
            return string;
        }
        if (string.startsWith("Azureus") && string2.startsWith("Azureus")) {
            return ClientIdentifier.asDiscrepancy(null, string, string2, "fake_client", "LTEP", byArray);
        }
        String string4 = string.split(" ", 2)[0];
        String string5 = string3.split(" ", 2)[0].split("/", 2)[0];
        String string6 = ClientIdentifier.checkForTransmissionBasedClients(string3, string4, string, string2, byArray, "LTEP");
        if (string6 != null) {
            return string6;
        }
        if (string4.toLowerCase().equals(string5.toLowerCase())) {
            return string3;
        }
        if (string.startsWith(MessageText.getString("PeerSocket.unknown"))) {
            BTPeerIDByteDecoder.logClientDiscrepancy(string, string2, "unknown_client", "LTEP", byArray);
            return string3;
        }
        if (string.startsWith("libtorrent (Rasterbar)")) {
            if (string3.toLowerCase().indexOf("libtorrent") == -1) {
                string3 = string3 + " (" + string + ")";
            }
            return string3;
        }
        if (string5.startsWith("libtorrent") && string4.toLowerCase().indexOf("libtorrent") == -1 && string5.toLowerCase().indexOf(string4.toLowerCase()) == -1) {
            return string + " (" + string3 + ")";
        }
        return ClientIdentifier.asDiscrepancy(null, string, string2, "mismatch_id", "LTEP", byArray);
    }

    private static String checkForTransmissionBasedClients(String string, String string2, String string3, String string4, byte[] byArray, String string5) {
        if (string.equals("Transmission 0.7-svn") && string2.equals("Azureus")) {
            return ClientIdentifier.asDiscrepancy("XTorrent", string3, string4, "fake_client", string5, byArray);
        }
        if (string.startsWith("Transmission") && string2.startsWith("XTorrent")) {
            return ClientIdentifier.asDiscrepancy(string2, string, "fake_client");
        }
        if (string3.equals("Transmission 0.96") && string4.equals("Transmission 0.95")) {
            return string3;
        }
        return null;
    }

    private static String asDiscrepancy(String string, String string2, String string3, String string4, String string5, byte[] byArray) {
        if (string == null) {
            BTPeerIDByteDecoder.logClientDiscrepancy(string2, string3, string4, string5, byArray);
        }
        if (string2.equals(string3)) {
            return ClientIdentifier.asDiscrepancy(string, string2, string4);
        }
        return ClientIdentifier.asDiscrepancy(string, string2 + "\" / \"" + string3, string4);
    }

    private static String asDiscrepancy(String string, String string2, String string3) {
        if (string == null) {
            string = MessageText.getString("PeerSocket.unknown");
        }
        return string + " [" + MessageText.getString("PeerSocket." + string3) + ": \"" + string2 + "\"]";
    }

    private static void assertDecode(String string, String string2, String string3, String string4, byte[] byArray, String string5) throws Exception {
        String string6;
        byte[] byArray2 = BTPeerIDByteDecoder.peerIDStringToBytes(string2);
        String string7 = BTPeerIDByteDecoder.decode(byArray2);
        if (string5.equals("AZMP")) {
            string6 = ClientIdentifier.identifyAZMP(string7, string3, string4, byArray2);
        } else if (string5.equals("LTEP")) {
            string6 = ClientIdentifier.identifyLTEP(string7, string3, byArray2);
        } else if (string5.equals("BT")) {
            string6 = ClientIdentifier.identifyBTOnly(string7, byArray);
        } else {
            throw new RuntimeException("invalid extension type: " + string5);
        }
        boolean bl = string.equals(string6);
        System.out.println("  Test " + test_count++ + ": \"" + string + "\" - " + (bl ? "PASSED" : "FAILED"));
        if (!bl) {
            throw new Exception("\nDecoded      : " + string6 + "\n" + "Peer ID name : " + string7 + "\n" + "Extended name: " + string3 + "\n");
        }
    }

    private static void assertDecodeAZMP(String string, String string2, String string3, String string4) throws Exception {
        ClientIdentifier.assertDecode(string, string2, string3, string4, null, "AZMP");
    }

    private static void assertDecodeLTEP(String string, String string2, String string3) throws Exception {
        ClientIdentifier.assertDecode(string, string2, string3, null, null, "LTEP");
    }

    private static void assertDecodeExtProtocol(String string, String string2, String string3, String string4) throws Exception {
        ClientIdentifier.assertDecodeAZMP(string, string2, string3, string4);
        ClientIdentifier.assertDecodeLTEP(string, string2, string3 + " " + string4);
    }

    private static void assertDecodeBT(String string, String string2, String string3) throws Exception {
        byte[] byArray;
        if (string3 == null) {
            string3 = "0000000000000000";
        }
        if ((byArray = ByteFormatter.decodeString(string3 = string3.replaceAll("[ ]", ""))).length != 8) {
            throw new RuntimeException("invalid handshake reserved bytes");
        }
        ClientIdentifier.assertDecode(string, string2, null, null, byArray, "BT");
    }

    public static void main(String[] stringArray) throws Exception {
        System.setProperty("transitory.startup", "1");
        BTPeerIDByteDecoder.client_logging_allowed = false;
        System.out.println("Testing simple BT clients:");
        ClientIdentifier.assertDecodeBT("BitThief* [FAKE: \"Mainline 4.4.0\"]", "M4-4-0--9aa757efd5be", "0000000000000000");
        ClientIdentifier.assertDecodeBT("Mainline 4.4.0", "M4-4-0--9aa757efd5be", "0000000000000001");
        ClientIdentifier.assertDecodeBT("Unknown [FAKE: \"Azureus 3.0.3.4\"]", "-AZ3034-6wfG2wk6wWLc", "0000000000000000");
        System.out.println("");
        System.out.println("Testing AZMP clients:");
        ClientIdentifier.assertDecodeAZMP("Azureus 3.0.4.2", "-AZ3042-6ozMq5q6Q3NX", "Azureus", "3.0.4.2");
        ClientIdentifier.assertDecodeAZMP("Azureus 3.0.4.3_B02", "-AZ3043-6ozMq5q6Q3NX", "Azureus", "3.0.4.3_B02");
        ClientIdentifier.assertDecodeAZMP("BitTyrant 2.5.0.0 (Azureus Mod)", "AZ2500BTeyuzyabAfo6U", "AzureusBitTyrant", "2.5.0.0BitTyrant");
        ClientIdentifier.assertDecodeAZMP("Azureus (Hacked) [FAKE: \"Azureus 2.4.0.2\" / \"Azureus 2.3.0.6\"]", "2D415A32 3430322D 2E414794 2C57D644 4989CA58", "Azureus", "2.3.0.6");
        System.out.println("");
        System.out.println("Testing LTEP clients:");
        ClientIdentifier.assertDecodeLTEP("\u00b5Torrent 1.7.6", "2D555431 3736302D B39EC7AD F6B94610 AA4ACD4A", "\u00b5Torrent 1.7.6");
        ClientIdentifier.assertDecodeLTEP("\u00b5Torrent 1.6.1", "2D5554313631302DEA818D43F5E5EC3D67BF8D67", "\ufdffTorrent 1.6.1");
        ClientIdentifier.assertDecodeLTEP("Unknown [FAKE: \"Azureus 3.0.4.2\"]", "-AZ3042-6ozMq5q6Q3NX", "Azureus 3.0.4.2");
        ClientIdentifier.assertDecodeLTEP("Mainline 6.0", "4D362D30 2D302D2D 8B92860D 05055DF5 B01C2D94", "BitTorrent 6.0");
        ClientIdentifier.assertDecodeLTEP("\u00b5Torrent 1.8.0 Beta", "2D555431 3830422D E69C9942 D1A5A6C2 0BE2E4BD", "\u00b5Torrent 1.8");
        ClientIdentifier.assertDecodeLTEP("Miro 1.1.0.0 (libtorrent/0.13.0.0)", "-MR1100-00HS~T7*65rm", "libtorrent/0.13.0.0");
        ClientIdentifier.assertDecodeLTEP("linkage/0.1.4 libtorrent/0.12.0.0", "-LK0140-ATIV~nbEQAMr", "linkage/0.1.4 libtorrent/0.12.0.0");
        ClientIdentifier.assertDecodeLTEP("KTorrent 2.2.2", "-KT2210-347143496631", "KTorrent 2.2.2");
        ClientIdentifier.assertDecodeLTEP("Transmission 0.96", "-TR0960-6ep6svaa61r4", "Transmission 0.95");
        ClientIdentifier.assertDecodeLTEP("Opera 9.50", "O100634008270e29150a", "Opera 9.50");
        System.out.println("");
        System.out.println("Testing common clients:");
        ClientIdentifier.assertDecodeExtProtocol("XTorrent [FAKE: \"Azureus 2.5.0.4\" / \"Transmission 0.7-svn\"]", "-AZ2504-192gwethivju", "Transmission", "0.7-svn");
        System.out.println("");
        System.out.println("Done.");
    }
}

