/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTPiece;
import com.aelitis.azureus.core.peermanager.utils.OutgoingBTPieceMessageHandlerAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class OutgoingBTPieceMessageHandler {
    private final PEPeer peer;
    private final OutgoingMessageQueue outgoing_message_queue;
    private byte piece_version;
    private final LinkedList requests = new LinkedList();
    private final ArrayList loading_messages = new ArrayList();
    private final HashMap queued_messages = new HashMap();
    private final AEMonitor lock_mon = new AEMonitor("OutgoingBTPieceMessageHandler:lock");
    private boolean destroyed = false;
    private int request_read_ahead = 2;
    private OutgoingBTPieceMessageHandlerAdapter adapter;
    private final DiskManagerReadRequestListener read_req_listener = new DiskManagerReadRequestListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readCompleted(DiskManagerReadRequest diskManagerReadRequest, DirectByteBuffer directByteBuffer) {
            try {
                OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                if (!OutgoingBTPieceMessageHandler.this.loading_messages.contains(diskManagerReadRequest) || OutgoingBTPieceMessageHandler.this.destroyed) {
                    directByteBuffer.returnToPool();
                    Object var5_3 = null;
                    OutgoingBTPieceMessageHandler.this.lock_mon.exit();
                    return;
                }
                OutgoingBTPieceMessageHandler.this.loading_messages.remove(diskManagerReadRequest);
                BTPiece bTPiece = new BTPiece(diskManagerReadRequest.getPieceNumber(), diskManagerReadRequest.getOffset(), directByteBuffer, OutgoingBTPieceMessageHandler.this.piece_version);
                OutgoingBTPieceMessageHandler.this.queued_messages.put(bTPiece, diskManagerReadRequest);
                OutgoingBTPieceMessageHandler.this.outgoing_message_queue.addMessage(bTPiece, true);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                OutgoingBTPieceMessageHandler.this.lock_mon.exit();
                throw throwable;
            }
            Object var5_4 = null;
            OutgoingBTPieceMessageHandler.this.lock_mon.exit();
            OutgoingBTPieceMessageHandler.this.outgoing_message_queue.doListenerNotifications();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFailed(DiskManagerReadRequest diskManagerReadRequest, Throwable throwable) {
            try {
                block5: {
                    block4: {
                        OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                        if (!OutgoingBTPieceMessageHandler.this.loading_messages.contains(diskManagerReadRequest)) break block4;
                        if (!OutgoingBTPieceMessageHandler.this.destroyed) break block5;
                    }
                    Object var4_3 = null;
                    OutgoingBTPieceMessageHandler.this.lock_mon.exit();
                    return;
                }
                OutgoingBTPieceMessageHandler.this.loading_messages.remove(diskManagerReadRequest);
            }
            catch (Throwable throwable2) {
                Object var4_5 = null;
                OutgoingBTPieceMessageHandler.this.lock_mon.exit();
                throw throwable2;
            }
            Object var4_4 = null;
            OutgoingBTPieceMessageHandler.this.lock_mon.exit();
        }

        public int getPriority() {
            return -1;
        }

        public void requestExecuted(long l) {
            OutgoingBTPieceMessageHandler.this.adapter.diskRequestCompleted(l);
        }
    };
    private final OutgoingMessageQueue.MessageQueueListener sent_message_listener = new OutgoingMessageQueue.MessageQueueListener(){

        public boolean messageAdded(Message message) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageSent(Message message) {
            if (message.getID().equals("BT_PIECE")) {
                try {
                    OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                    OutgoingBTPieceMessageHandler.this.queued_messages.remove(message);
                    Object var3_2 = null;
                    OutgoingBTPieceMessageHandler.this.lock_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OutgoingBTPieceMessageHandler.this.lock_mon.exit();
                    throw throwable;
                }
                OutgoingBTPieceMessageHandler.this.doReadAheadLoads();
            }
        }

        public void messageQueued(Message message) {
        }

        public void messageRemoved(Message message) {
        }

        public void protocolBytesSent(int n) {
        }

        public void dataBytesSent(int n) {
        }

        public void flush() {
        }
    };

    public OutgoingBTPieceMessageHandler(PEPeer pEPeer, OutgoingMessageQueue outgoingMessageQueue, OutgoingBTPieceMessageHandlerAdapter outgoingBTPieceMessageHandlerAdapter, byte by) {
        this.peer = pEPeer;
        this.outgoing_message_queue = outgoingMessageQueue;
        this.adapter = outgoingBTPieceMessageHandlerAdapter;
        this.piece_version = by;
        this.outgoing_message_queue.registerQueueListener(this.sent_message_listener);
    }

    public void setPieceVersion(byte by) {
        this.piece_version = by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPieceRequest(int n, int n2, int n3) {
        if (this.destroyed) {
            return;
        }
        DiskManagerReadRequest diskManagerReadRequest = this.peer.getManager().getDiskManager().createReadRequest(n, n2, n3);
        try {
            this.lock_mon.enter();
            this.requests.addLast(diskManagerReadRequest);
            Object var6_5 = null;
            this.lock_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.lock_mon.exit();
            throw throwable;
        }
        this.doReadAheadLoads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removePieceRequest(int n, int n2, int n3) {
        block8: {
            block7: {
                if (this.destroyed) {
                    return;
                }
                DiskManagerReadRequest diskManagerReadRequest = this.peer.getManager().getDiskManager().createReadRequest(n, n2, n3);
                try {
                    this.lock_mon.enter();
                    if (this.requests.contains(diskManagerReadRequest)) {
                        this.requests.remove(diskManagerReadRequest);
                        Object var9_5 = null;
                        this.lock_mon.exit();
                        return;
                    }
                    if (this.loading_messages.contains(diskManagerReadRequest)) {
                        this.loading_messages.remove(diskManagerReadRequest);
                        break block7;
                    }
                    Iterator iterator = this.queued_messages.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (!entry.getValue().equals(diskManagerReadRequest)) continue;
                        BTPiece bTPiece = (BTPiece)entry.getKey();
                        if (this.outgoing_message_queue.removeMessage(bTPiece, true)) {
                            iterator.remove();
                        }
                        break block8;
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    this.lock_mon.exit();
                    throw throwable;
                }
            }
            Object var9_6 = null;
            this.lock_mon.exit();
            return;
        }
        Object var9_7 = null;
        this.lock_mon.exit();
        this.outgoing_message_queue.doListenerNotifications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPieceRequests() {
        if (this.destroyed) {
            return;
        }
        try {
            this.lock_mon.enter();
            for (BTPiece bTPiece : this.queued_messages.keySet()) {
                this.outgoing_message_queue.removeMessage(bTPiece, true);
            }
            this.queued_messages.clear();
            this.requests.clear();
            this.loading_messages.clear();
            Object var4_3 = null;
            this.lock_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock_mon.exit();
            throw throwable;
        }
        this.outgoing_message_queue.doListenerNotifications();
    }

    public void setRequestReadAhead(int n) {
        this.request_read_ahead = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.lock_mon.enter();
            this.removeAllPieceRequests();
            this.queued_messages.clear();
            this.destroyed = true;
            this.outgoing_message_queue.cancelQueueListener(this.sent_message_listener);
            Object var2_1 = null;
            this.lock_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReadAheadLoads() {
        ArrayList<DiskManagerReadRequest> arrayList = null;
        try {
            this.lock_mon.enter();
            while (this.loading_messages.size() + this.queued_messages.size() < this.request_read_ahead && !this.requests.isEmpty() && !this.destroyed) {
                DiskManagerReadRequest diskManagerReadRequest = (DiskManagerReadRequest)this.requests.removeFirst();
                this.loading_messages.add(diskManagerReadRequest);
                if (arrayList == null) {
                    arrayList = new ArrayList<DiskManagerReadRequest>();
                }
                arrayList.add(diskManagerReadRequest);
            }
            Object var4_4 = null;
            this.lock_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.lock_mon.exit();
            throw throwable;
        }
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.peer.getManager().getAdapter().enqueueReadRequest(this.peer, (DiskManagerReadRequest)arrayList.get(i), this.read_req_listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getRequestedPieceNumbers() {
        int[] nArray;
        if (this.destroyed) {
            return new int[0];
        }
        int n = -1;
        int n2 = 0;
        try {
            this.lock_mon.enter();
            nArray = new int[this.queued_messages.size() + this.loading_messages.size() + this.requests.size()];
            for (Object object : this.queued_messages.keySet()) {
                if (n == ((BTPiece)object).getPieceNumber()) continue;
                n = ((BTPiece)object).getPieceNumber();
                nArray[n2++] = n;
            }
            for (Object object : this.loading_messages) {
                if (n == object.getPieceNumber()) continue;
                n = object.getPieceNumber();
                nArray[n2++] = n;
            }
            for (Object object : this.requests) {
                if (n == object.getPieceNumber()) continue;
                n = object.getPieceNumber();
                nArray[n2++] = n;
            }
            Object var7_6 = null;
            this.lock_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock_mon.exit();
            throw throwable;
        }
        Object object = new int[n2];
        System.arraycopy(nArray, 0, object, 0, n2);
        return object;
    }

    public int getRequestCount() {
        return this.queued_messages.size() + this.loading_messages.size() + this.requests.size();
    }

    public boolean isStalledPendingLoad() {
        return this.queued_messages.size() == 0 && this.loading_messages.size() > 0;
    }
}

