/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.peermanager.utils.BTPeerIDByteDecoder;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.IPToHostNameResolver;

public class PeerClassifier {
    public static final String CACHE_LOGIC = "CacheLogic";
    private static Set platform_ips = Collections.synchronizedSet(new HashSet());

    public static String getClientDescription(byte[] byArray) {
        return BTPeerIDByteDecoder.decode(byArray);
    }

    public static String getPrintablePeerID(byte[] byArray) {
        return BTPeerIDByteDecoder.getPrintablePeerID(byArray);
    }

    public static boolean isClientTypeAllowed(String string) {
        return true;
    }

    public static boolean isAzureusIP(String string) {
        return platform_ips.contains(string);
    }

    public static void setAzureusIP(String string) {
        platform_ips.add(string);
    }

    public static boolean testIfAzureusIP(String string) {
        try {
            InetAddress inetAddress = HostNameToIPResolver.syncResolve(string);
            String string2 = inetAddress.getHostAddress();
            if (platform_ips.contains(string2)) {
                return true;
            }
            String string3 = IPToHostNameResolver.syncResolve(string, 10000);
            if (Constants.isAzureusDomain(string3)) {
                platform_ips.add(string2);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

