/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.security;

import com.aelitis.azureus.core.security.CryptoManagerException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

public class CryptoECCUtils {
    private static final ECNamedCurveParameterSpec ECCparam = ECNamedCurveTable.getParameterSpec("prime192v2");

    public static KeyPair createKeys() throws CryptoManagerException {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
            keyPairGenerator.initialize(ECCparam);
            return keyPairGenerator.genKeyPair();
        }
        catch (Throwable throwable) {
            throw new CryptoManagerException("Failed to create keys", throwable);
        }
    }

    public static Signature getSignature(Key key) throws CryptoManagerException {
        try {
            Signature signature = Signature.getInstance("SHA1withECDSA", "BC");
            if (key instanceof ECPrivateKey) {
                signature.initSign((ECPrivateKey)key);
            } else if (key instanceof ECPublicKey) {
                signature.initVerify((ECPublicKey)key);
            } else {
                throw new CryptoManagerException("Invalid Key Type, ECC keys required");
            }
            return signature;
        }
        catch (CryptoManagerException cryptoManagerException) {
            throw cryptoManagerException;
        }
        catch (Throwable throwable) {
            throw new CryptoManagerException("Failed to create Signature", throwable);
        }
    }

    public static byte[] keyToRawdata(PrivateKey privateKey) throws CryptoManagerException {
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new CryptoManagerException("Invalid private key");
        }
        return ((ECPrivateKey)privateKey).getD().toByteArray();
    }

    public static PrivateKey rawdataToPrivkey(byte[] byArray) throws CryptoManagerException {
        BigInteger bigInteger = new BigInteger(byArray);
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(bigInteger, ECCparam);
        PrivateKey privateKey = null;
        try {
            privateKey = KeyFactory.getInstance("ECDSA", "BC").generatePrivate(eCPrivateKeySpec);
            return privateKey;
        }
        catch (Throwable throwable) {
            throw new CryptoManagerException("Failed to decode private key");
        }
    }

    public static byte[] keyToRawdata(PublicKey publicKey) throws CryptoManagerException {
        if (!(publicKey instanceof ECPublicKey)) {
            throw new CryptoManagerException("Invalid public key");
        }
        return ((ECPublicKey)publicKey).getQ().getEncoded();
    }

    public static PublicKey rawdataToPubkey(byte[] byArray) throws CryptoManagerException {
        ECPoint eCPoint = ECCparam.getCurve().decodePoint(byArray);
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, ECCparam);
        try {
            return KeyFactory.getInstance("ECDSA", "BC").generatePublic(eCPublicKeySpec);
        }
        catch (Throwable throwable) {
            throw new CryptoManagerException("Failed to decode public key");
        }
    }
}

