/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTester;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterContact;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterContactListener;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerAdapter;
import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import com.aelitis.azureus.core.speedmanager.SpeedManagerListener;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingMapper;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingSource;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProvider;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerPingMapperImpl;
import com.aelitis.azureus.core.speedmanager.impl.TestPingSourceRandom;
import com.aelitis.azureus.core.speedmanager.impl.v1.SpeedManagerAlgorithmProviderV1;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerAlgorithmProviderV2;
import com.aelitis.azureus.core.speedmanager.impl.v3.SpeedManagerAlgorithmProviderV3;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class SpeedManagerImpl
implements SpeedManager,
SpeedManagerAlgorithmProviderAdapter,
AEDiagnosticsEvidenceGenerator {
    protected static final int UPDATE_PERIOD_MILLIS = 5000;
    private static final int CONTACT_NUMBER = 3;
    private static final int CONTACT_PING_SECS = 5;
    private static final int LONG_PERIOD_SECS = 3600;
    private static final int LONG_PERIOD_TICKS = 720;
    private static final int SHORT_ESTIMATE_SECS = 15;
    private static final int MEDIUM_ESTIMATE_SECS = 150;
    static final int SHORT_ESTIMATE_SAMPLES = 3;
    static final int MEDIUM_ESTIMATE_SAMPLES = 30;
    private static final int SAVE_PERIOD_SECS = 900;
    private static final int SAVE_PERIOD_TICKS = 180;
    private static final int SPEED_AVERAGE_PERIOD = 3000;
    private static boolean DEBUG;
    public static final String CONFIG_VERSION_STR = "Auto_Upload_Speed_Version_String";
    public static final String CONFIG_VERSION = "Auto Upload Speed Version";
    private static final String CONFIG_AVAIL = "AutoSpeed Available";
    private static final String CONFIG_DEBUG = "Auto Upload Speed Debug Enabled";
    private static final String[] CONFIG_PARAMS;
    private static boolean emulated_ping_source;
    private AzureusCore core;
    private DHTSpeedTester speed_tester;
    private SpeedManagerAdapter adapter;
    private SpeedManagerAlgorithmProvider provider = new nullProvider();
    private int provider_version = -1;
    private boolean enabled;
    private Map contacts = new HashMap();
    private volatile int total_contacts;
    private pingContact[] contacts_array = new pingContact[0];
    private Object original_limits;
    private AsyncDispatcher dispatcher = new AsyncDispatcher();
    private SpeedManagerPingMapperImpl ping_mapper;
    private SpeedManagerPingMapperImpl[] ping_mappers;
    private CopyOnWriteList transient_mappers = new CopyOnWriteList();
    private AEDiagnosticsLogger logger;
    private String asn;
    private CopyOnWriteList listeners = new CopyOnWriteList();

    public SpeedManagerImpl(AzureusCore azureusCore, SpeedManagerAdapter speedManagerAdapter) {
        Object object;
        this.core = azureusCore;
        this.adapter = speedManagerAdapter;
        AEDiagnostics.addEvidenceGenerator(this);
        this.logger = AEDiagnostics.getLogger("SpeedMan");
        this.ping_mapper = new SpeedManagerPingMapperImpl(this, "Var", 720, true, false);
        if (Constants.isCVSVersion()) {
            object = new SpeedManagerPingMapperImpl(this, "Abs", 720, false, false);
            this.ping_mappers = new SpeedManagerPingMapperImpl[]{object, this.ping_mapper};
        } else {
            this.ping_mappers = new SpeedManagerPingMapperImpl[]{this.ping_mapper};
        }
        object = new File(SystemProperties.getUserPath(), "net");
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        NetworkAdmin.getSingleton().addAndFirePropertyChangeListener(new NetworkAdminPropertyChangeListener((File)object){
            final /* synthetic */ File val$config_dir;
            {
                this.val$config_dir = file;
            }

            public void propertyChanged(String string) {
                if (string == "AS") {
                    NetworkAdminASN networkAdminASN = NetworkAdmin.getSingleton().getCurrentASN();
                    String string2 = networkAdminASN.getAS();
                    if (string2.length() == 0) {
                        string2 = "default";
                    }
                    File file = new File(this.val$config_dir, "pm_" + FileUtil.convertOSSpecificChars(string2, false) + ".dat");
                    SpeedManagerImpl.this.ping_mapper.loadHistory(file);
                    SpeedManagerImpl.this.asn = networkAdminASN.getASName();
                    if (SpeedManagerImpl.this.asn.length() == 0) {
                        SpeedManagerImpl.this.asn = "Unknown";
                    }
                    SpeedManagerImpl.this.informListeners(1);
                }
            }
        });
        this.core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void stopping(AzureusCore azureusCore) {
                SpeedManagerImpl.this.ping_mapper.saveHistory();
            }
        });
        COConfigurationManager.addAndFireParameterListener(CONFIG_VERSION, new ParameterListener(){

            public void parameterChanged(final String string) {
                SpeedManagerImpl.this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        boolean bl = SpeedManagerImpl.this.provider_version == -1;
                        int n = COConfigurationManager.getIntParameter(string);
                        if (n != SpeedManagerImpl.this.provider_version) {
                            SpeedManagerImpl.this.provider_version = n;
                            if (SpeedManagerImpl.this.isEnabled()) {
                                SpeedManagerImpl.this.setEnabledSupport(false);
                                SpeedManagerImpl.this.setEnabledSupport(true);
                            }
                        }
                        if (bl) {
                            SpeedManagerImpl.this.enableOrAlgChanged();
                        }
                    }
                });
            }
        });
        COConfigurationManager.setParameter(CONFIG_AVAIL, false);
        SimpleTimer.addPeriodicEvent("SpeedManager:timer", 5000L, new TimerEventPerformer(){
            private int tick_count;

            public void perform(TimerEvent timerEvent2) {
                if (!SpeedManagerImpl.this.enabled || SpeedManagerImpl.this.contacts_array.length == 0) {
                    int n = SpeedManagerImpl.this.adapter.getCurrentDataUploadSpeed(3000) + SpeedManagerImpl.this.adapter.getCurrentProtocolUploadSpeed(3000);
                    int n2 = SpeedManagerImpl.this.adapter.getCurrentDataDownloadSpeed(3000) + SpeedManagerImpl.this.adapter.getCurrentProtocolDownloadSpeed(3000);
                    for (int i = 0; i < SpeedManagerImpl.this.ping_mappers.length; ++i) {
                        SpeedManagerImpl.this.ping_mappers[i].addSpeed(n, n2);
                    }
                }
                ++this.tick_count;
                if (this.tick_count % 180 == 0) {
                    SpeedManagerImpl.this.ping_mapper.saveHistory();
                }
            }
        });
        emulated_ping_source = false;
        if (emulated_ping_source) {
            Debug.out("Emulated ping source!!!!");
            this.setSpeedTester(new TestPingSourceRandom(this));
        }
    }

    public SpeedManager getSpeedManager() {
        return this;
    }

    public String getASN() {
        return this.asn;
    }

    public SpeedManagerLimitEstimate getEstimatedUploadCapacityBytesPerSec() {
        return this.ping_mapper.getEstimatedUploadCapacityBytesPerSec();
    }

    public void setEstimatedUploadCapacityBytesPerSec(int n, float f) {
        this.ping_mapper.setEstimatedUploadCapacityBytesPerSec(n, f);
    }

    public SpeedManagerLimitEstimate getEstimatedDownloadCapacityBytesPerSec() {
        return this.ping_mapper.getEstimatedDownloadCapacityBytesPerSec();
    }

    public void setEstimatedDownloadCapacityBytesPerSec(int n, float f) {
        this.ping_mapper.setEstimatedDownloadCapacityBytesPerSec(n, f);
    }

    public void reset() {
        this.ping_mapper.reset();
    }

    protected void enableOrAlgChanged() {
        this.total_contacts = 0;
        SpeedManagerAlgorithmProvider speedManagerAlgorithmProvider = this.provider;
        if (this.provider_version == 1) {
            if (!(this.provider instanceof SpeedManagerAlgorithmProviderV1)) {
                this.provider = new SpeedManagerAlgorithmProviderV1(this);
            }
        } else if (this.provider_version == 2) {
            if (!(this.provider instanceof SpeedManagerAlgorithmProviderV2)) {
                this.provider = new SpeedManagerAlgorithmProviderV2(this);
            }
        } else if (this.provider_version == 3) {
            this.provider = new SpeedManagerAlgorithmProviderV3(this);
        } else {
            Debug.out("Unknown provider version " + this.provider_version);
            if (!(this.provider instanceof nullProvider)) {
                this.provider = new nullProvider();
            }
        }
        if (speedManagerAlgorithmProvider != this.provider) {
            this.log("Algorithm set to " + this.provider.getClass().getName());
        }
        if (speedManagerAlgorithmProvider != null) {
            speedManagerAlgorithmProvider.destroy();
        }
        this.provider.reset();
    }

    public SpeedManagerPingMapper createTransientPingMapper() {
        SpeedManagerPingMapperImpl speedManagerPingMapperImpl = new SpeedManagerPingMapperImpl(this, "Transient", 720, true, true);
        this.transient_mappers.add(speedManagerPingMapperImpl);
        if (this.transient_mappers.size() > 32) {
            Debug.out("Transient mappers are growing too large");
        }
        return speedManagerPingMapperImpl;
    }

    protected void destroy(SpeedManagerPingMapper speedManagerPingMapper) {
        this.transient_mappers.remove(speedManagerPingMapper);
    }

    public void setSpeedTester(DHTSpeedTester dHTSpeedTester) {
        if (this.speed_tester != null) {
            if (!emulated_ping_source) {
                Debug.out("speed tester already set!");
            }
            return;
        }
        COConfigurationManager.setParameter(CONFIG_AVAIL, true);
        this.speed_tester = dHTSpeedTester;
        this.speed_tester.addListener(new DHTSpeedTesterListener(){
            private DHTSpeedTesterContact[] last_contact_group = new DHTSpeedTesterContact[0];

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void contactAdded(DHTSpeedTesterContact dHTSpeedTesterContact) {
                if (SpeedManagerImpl.this.core.getInstanceManager().isLANAddress(dHTSpeedTesterContact.getAddress().getAddress())) {
                    dHTSpeedTesterContact.destroy();
                } else {
                    SpeedManagerImpl.this.log("activePing: " + dHTSpeedTesterContact.getString());
                    dHTSpeedTesterContact.setPingPeriod(5);
                    Map map = SpeedManagerImpl.this.contacts;
                    synchronized (map) {
                        pingContact pingContact2 = new pingContact(dHTSpeedTesterContact);
                        SpeedManagerImpl.this.contacts.put(dHTSpeedTesterContact, pingContact2);
                        SpeedManagerImpl.access$602(SpeedManagerImpl.this, new pingContact[SpeedManagerImpl.this.contacts.size()]);
                        SpeedManagerImpl.this.contacts.values().toArray(SpeedManagerImpl.this.contacts_array);
                        SpeedManagerImpl.this.total_contacts++;
                        SpeedManagerImpl.this.provider.pingSourceFound(pingContact2, SpeedManagerImpl.this.total_contacts > 3);
                    }
                    dHTSpeedTesterContact.addListener(new DHTSpeedTesterContactListener(){

                        public void ping(DHTSpeedTesterContact dHTSpeedTesterContact, int n) {
                        }

                        public void pingFailed(DHTSpeedTesterContact dHTSpeedTesterContact) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void contactDied(DHTSpeedTesterContact dHTSpeedTesterContact) {
                            SpeedManagerImpl.this.log("deadPing: " + dHTSpeedTesterContact.getString());
                            Map map = SpeedManagerImpl.this.contacts;
                            synchronized (map) {
                                pingContact pingContact2 = (pingContact)SpeedManagerImpl.this.contacts.remove(dHTSpeedTesterContact);
                                if (pingContact2 != null) {
                                    SpeedManagerImpl.access$602(SpeedManagerImpl.this, new pingContact[SpeedManagerImpl.this.contacts.size()]);
                                    SpeedManagerImpl.this.contacts.values().toArray(SpeedManagerImpl.this.contacts_array);
                                    SpeedManagerImpl.this.provider.pingSourceFailed(pingContact2);
                                }
                            }
                        }
                    });
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultGroup(DHTSpeedTesterContact[] dHTSpeedTesterContactArray, int[] nArray) {
                int n;
                boolean bl;
                if (!SpeedManagerImpl.this.enabled) {
                    for (int i = 0; i < dHTSpeedTesterContactArray.length; ++i) {
                        dHTSpeedTesterContactArray[i].destroy();
                    }
                    return;
                }
                boolean bl2 = false;
                for (int i = 0; i < dHTSpeedTesterContactArray.length; ++i) {
                    bl = false;
                    for (n = 0; n < this.last_contact_group.length; ++n) {
                        if (dHTSpeedTesterContactArray[i] != this.last_contact_group[n]) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    bl2 = true;
                    break;
                }
                this.last_contact_group = dHTSpeedTesterContactArray;
                SpeedManagerPingSource[] speedManagerPingSourceArray = new pingContact[dHTSpeedTesterContactArray.length];
                bl = false;
                n = -1;
                int n2 = Integer.MAX_VALUE;
                int n3 = 0;
                int n4 = 0;
                Map map = SpeedManagerImpl.this.contacts;
                synchronized (map) {
                    for (int i = 0; i < dHTSpeedTesterContactArray.length; ++i) {
                        speedManagerPingSourceArray[i] = (pingContact)SpeedManagerImpl.this.contacts.get(dHTSpeedTesterContactArray[i]);
                        SpeedManagerPingSource speedManagerPingSource = speedManagerPingSourceArray[i];
                        if (speedManagerPingSource != null) {
                            int n5 = nArray[i];
                            if (n5 >= 0) {
                                if (n5 > n) {
                                    n = n5;
                                }
                                if (n5 < n2) {
                                    n2 = n5;
                                }
                                ++n3;
                                n4 += n5;
                            }
                            speedManagerPingSource.setPingTime(n5);
                            continue;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    Debug.out("Auto-speed: source missing");
                } else {
                    SpeedManagerImpl.this.provider.calculate(speedManagerPingSourceArray);
                    if (n3 > 1) {
                        n4 -= n;
                        --n3;
                    }
                    if (n3 > 0) {
                        int n6 = n4 / n3;
                        n6 = (n6 + n2) / 2;
                        SpeedManagerImpl.this.addPingHistory(n6, bl2);
                    }
                }
            }
        });
        SimpleTimer.addPeriodicEvent("SpeedManager:stats", 1000L, new TimerEventPerformer(){

            public void perform(TimerEvent timerEvent2) {
                if (SpeedManagerImpl.this.enabled) {
                    SpeedManagerImpl.this.provider.updateStats();
                }
            }
        });
    }

    protected void addPingHistory(int n, boolean bl) {
        int n2 = this.adapter.getCurrentDataUploadSpeed(3000) + this.adapter.getCurrentProtocolUploadSpeed(3000);
        int n3 = this.adapter.getCurrentDataDownloadSpeed(3000) + this.adapter.getCurrentProtocolDownloadSpeed(3000);
        for (int i = 0; i < this.ping_mappers.length; ++i) {
            this.ping_mappers[i].addPing(n2, n3, n, bl);
        }
        Iterator iterator = this.transient_mappers.iterator();
        while (iterator.hasNext()) {
            ((SpeedManagerPingMapperImpl)iterator.next()).addPing(n2, n3, n, bl);
        }
    }

    public boolean isAvailable() {
        return this.speed_tester != null;
    }

    public void setEnabled(final boolean bl) {
        final AESemaphore aESemaphore = new AESemaphore("SpeedManagerImpl.setEnabled");
        this.dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    SpeedManagerImpl.this.setEnabledSupport(bl);
                    Object var2_1 = null;
                    aESemaphore.release();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    aESemaphore.release();
                    throw throwable;
                }
            }
        });
        if (!aESemaphore.reserve(10000L)) {
            Debug.out("operation didn't complete in time");
        }
    }

    protected void setEnabledSupport(boolean bl) {
        if (this.enabled != bl) {
            this.log("Enabled set to " + bl);
            if (bl) {
                this.original_limits = this.adapter.getLimits();
            } else {
                this.ping_mapper.saveHistory();
            }
            this.enableOrAlgChanged();
            this.enabled = bl;
            if (this.speed_tester != null) {
                this.speed_tester.setContactNumber(this.enabled ? 3 : 0);
            }
            if (!this.enabled) {
                this.adapter.setLimits(this.original_limits, true, this.provider.getAdjustsDownloadLimits());
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DHTSpeedTester getSpeedTester() {
        return this.speed_tester;
    }

    public SpeedManagerPingSource[] getPingSources() {
        return this.contacts_array;
    }

    public SpeedManagerPingMapper getActiveMapper() {
        return this.ping_mapper;
    }

    public SpeedManagerPingMapper getPingMapper() {
        return this.getActiveMapper();
    }

    public SpeedManagerPingMapper[] getMappers() {
        return this.ping_mappers;
    }

    public int getIdlePingMillis() {
        return this.provider.getIdlePingMillis();
    }

    public int getCurrentPingMillis() {
        return this.provider.getCurrentPingMillis();
    }

    public int getMaxPingMillis() {
        return this.provider.getMaxPingMillis();
    }

    public int getCurrentChokeSpeed() {
        return this.provider.getCurrentChokeSpeed();
    }

    public int getMaxUploadSpeed() {
        return this.provider.getMaxUploadSpeed();
    }

    public int getCurrentUploadLimit() {
        return this.adapter.getCurrentUploadLimit();
    }

    public void setCurrentUploadLimit(int n) {
        if (this.enabled) {
            this.adapter.setCurrentUploadLimit(n);
        }
    }

    public int getCurrentDownloadLimit() {
        return this.adapter.getCurrentDownloadLimit();
    }

    public void setCurrentDownloadLimit(int n) {
        if (this.enabled) {
            this.adapter.setCurrentDownloadLimit(n);
        }
    }

    public int getCurrentProtocolUploadSpeed() {
        return this.adapter.getCurrentProtocolUploadSpeed(-1);
    }

    public int getCurrentDataUploadSpeed() {
        return this.adapter.getCurrentDataUploadSpeed(-1);
    }

    public int getCurrentDataDownloadSpeed() {
        return this.adapter.getCurrentDataDownloadSpeed(-1);
    }

    public int getCurrentProtocolDownloadSpeed() {
        return this.adapter.getCurrentProtocolDownloadSpeed(-1);
    }

    public void setLoggingEnabled(boolean bl) {
        COConfigurationManager.setParameter(CONFIG_DEBUG, bl);
    }

    public void log(String string) {
        if (DEBUG) {
            this.logger.log(string);
        }
    }

    protected void informDownCapChanged() {
        this.informListeners(3);
    }

    protected void informUpCapChanged() {
        this.informListeners(2);
    }

    protected void informListeners(int n) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((SpeedManagerListener)iterator.next()).propertyChanged(n);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public void addListener(SpeedManagerListener speedManagerListener) {
        this.listeners.add(speedManagerListener);
    }

    public void removeListener(SpeedManagerListener speedManagerListener) {
        this.listeners.remove(speedManagerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter indentWriter) {
        indentWriter.println("SpeedManager: enabled=" + this.enabled + ",provider=" + this.provider);
        try {
            indentWriter.indent();
            this.ping_mapper.generateEvidence(indentWriter);
            Object var3_2 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    static /* synthetic */ pingContact[] access$602(SpeedManagerImpl speedManagerImpl, pingContact[] pingContactArray) {
        speedManagerImpl.contacts_array = pingContactArray;
        return pingContactArray;
    }

    static {
        CONFIG_PARAMS = new String[]{CONFIG_DEBUG};
        COConfigurationManager.addAndFireParameterListeners(CONFIG_PARAMS, new ParameterListener(){

            public void parameterChanged(String string) {
                DEBUG = COConfigurationManager.getBooleanParameter(SpeedManagerImpl.CONFIG_DEBUG);
            }
        });
    }

    protected class nullProvider
    implements SpeedManagerAlgorithmProvider {
        protected nullProvider() {
        }

        public void reset() {
        }

        public void destroy() {
        }

        public void updateStats() {
        }

        public void pingSourceFound(SpeedManagerPingSource speedManagerPingSource, boolean bl) {
        }

        public void pingSourceFailed(SpeedManagerPingSource speedManagerPingSource) {
        }

        public void calculate(SpeedManagerPingSource[] speedManagerPingSourceArray) {
        }

        public int getIdlePingMillis() {
            return 0;
        }

        public int getCurrentPingMillis() {
            return 0;
        }

        public int getMaxPingMillis() {
            return 0;
        }

        public int getCurrentChokeSpeed() {
            return 0;
        }

        public int getMaxUploadSpeed() {
            return 0;
        }

        public boolean getAdjustsDownloadLimits() {
            return false;
        }
    }

    protected class SMUnlimited
    implements SpeedManagerAlgorithmProvider {
        private int good_signals;

        protected SMUnlimited() {
        }

        public void destroy() {
        }

        public void reset() {
            SpeedManagerImpl.this.adapter.setCurrentDownloadLimit(0);
            SpeedManagerImpl.this.adapter.setCurrentUploadLimit(0);
        }

        public void updateStats() {
        }

        public void pingSourceFound(SpeedManagerPingSource speedManagerPingSource, boolean bl) {
        }

        public void pingSourceFailed(SpeedManagerPingSource speedManagerPingSource) {
        }

        public void calculate(SpeedManagerPingSource[] speedManagerPingSourceArray) {
            SpeedManagerLimitEstimate speedManagerLimitEstimate = SpeedManagerImpl.this.ping_mapper.getEstimatedUploadLimit(true);
            if (speedManagerLimitEstimate != null) {
                double d = SpeedManagerImpl.this.ping_mapper.getCurrentMetricRating();
                this.good_signals = d == 1.0 ? ++this.good_signals : 0;
                if (d == -1.0) {
                    SpeedManagerImpl.this.adapter.setCurrentUploadLimit(speedManagerLimitEstimate.getBytesPerSec() + (this.good_signals < 3 ? -1024 : 1024));
                } else if (d <= 0.0) {
                    SpeedManagerImpl.this.adapter.setCurrentUploadLimit(speedManagerLimitEstimate.getBytesPerSec() + 1024);
                } else {
                    SpeedManagerImpl.this.adapter.setCurrentUploadLimit(speedManagerLimitEstimate.getBytesPerSec() + 5120);
                }
            }
        }

        public int getIdlePingMillis() {
            return 0;
        }

        public int getCurrentPingMillis() {
            return 0;
        }

        public int getMaxPingMillis() {
            return 0;
        }

        public int getCurrentChokeSpeed() {
            return 0;
        }

        public int getMaxUploadSpeed() {
            return 0;
        }

        public boolean getAdjustsDownloadLimits() {
            return true;
        }
    }

    protected class pingContact
    implements SpeedManagerPingSource {
        private DHTSpeedTesterContact contact;
        private int ping_time;

        protected pingContact(DHTSpeedTesterContact dHTSpeedTesterContact) {
            this.contact = dHTSpeedTesterContact;
        }

        protected void setPingTime(int n) {
            this.ping_time = n;
        }

        public InetSocketAddress getAddress() {
            return this.contact.getAddress();
        }

        public int getPingTime() {
            return this.ping_time;
        }

        public void destroy() {
            this.contact.destroy();
        }
    }
}

