/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

public class SaturatedMode
implements Comparable {
    public static final SaturatedMode AT_LIMIT = new SaturatedMode("AT_LIMIT", 0.95f);
    public static final SaturatedMode HIGH = new SaturatedMode("HIGH", 0.75f);
    public static final SaturatedMode MED = new SaturatedMode("MED", 0.25f);
    public static final SaturatedMode LOW = new SaturatedMode("LOW", 0.03f);
    public static final SaturatedMode NONE = new SaturatedMode("NONE", 0.0f);
    private final String name;
    private final float percentCapacity;

    private SaturatedMode(String string, float f) {
        this.name = string;
        this.percentCapacity = f;
    }

    private float getThreshold() {
        return this.percentCapacity;
    }

    public static SaturatedMode getSaturatedMode(int n, int n2) {
        float f;
        if (n2 == 0) {
            n2 = 61440;
        }
        if ((f = (float)n / (float)n2) > AT_LIMIT.getThreshold()) {
            return AT_LIMIT;
        }
        if (f > HIGH.getThreshold()) {
            return HIGH;
        }
        if (f > MED.getThreshold()) {
            return MED;
        }
        if (f > LOW.getThreshold()) {
            return LOW;
        }
        return NONE;
    }

    public String toString() {
        return this.name;
    }

    public boolean isGreater(SaturatedMode saturatedMode) {
        return this.compareTo(saturatedMode) > 0;
    }

    public int compareTo(SaturatedMode saturatedMode) {
        if (this.percentCapacity < saturatedMode.getThreshold()) {
            return -1;
        }
        if (this.percentCapacity > saturatedMode.getThreshold()) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof SaturatedMode)) {
            throw new ClassCastException("Only comparable to SaturatedMode class.");
        }
        SaturatedMode saturatedMode = (SaturatedMode)object;
        return this.compareTo(saturatedMode);
    }
}

