/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.SpeedManagerPingSource;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProvider;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.aelitis.azureus.core.speedmanager.impl.v2.PingSourceManager;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMInstance;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMUpdate;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedLimitMonitor;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerLogger;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.SystemTime;

public class SpeedManagerAlgorithmProviderPingMap
implements SpeedManagerAlgorithmProvider,
COConfigurationListener {
    private SpeedManagerAlgorithmProviderAdapter adapter;
    private long timeSinceLastUpdate;
    private int consecutiveUpticks = 0;
    private int consecutiveDownticks = 0;
    private SpeedLimitMonitor limitMonitor;
    private float lastMetricValue;
    private static int numIntervalsBetweenCal = 2;
    private static boolean skipIntervalAfterAdjustment = true;
    private List pingTimeList = new ArrayList();
    private boolean hadAdjustmentLastInterval = false;
    private int intervalCount = 0;
    PingSourceManager pingSourceManager = new PingSourceManager();
    int sessionMaxUploadRate = 0;

    SpeedManagerAlgorithmProviderPingMap(SpeedManagerAlgorithmProviderAdapter speedManagerAlgorithmProviderAdapter) {
        this.adapter = speedManagerAlgorithmProviderAdapter;
        SpeedManagerLogger.setAdapter("pm", this.adapter);
        this.limitMonitor = new SpeedLimitMonitor(this.adapter.getSpeedManager());
        COConfigurationManager.addListener(this);
        SMInstance.init(speedManagerAlgorithmProviderAdapter);
        this.limitMonitor.initPingSpaceMap();
    }

    public void destroy() {
        COConfigurationManager.removeListener(this);
    }

    public void configurationSaved() {
        try {
            this.limitMonitor.readFromPersistentMap();
            this.limitMonitor.updateFromCOConfigManager();
            skipIntervalAfterAdjustment = COConfigurationManager.getBooleanParameter("SpeedManagerAlgorithmProviderV2.setting.wait.after.adjust");
            numIntervalsBetweenCal = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.intervals.between.adjust");
            this.limitMonitor.initPingSpaceMap();
            SpeedManagerLogger.trace("..VariancePingMap - configurationSaved called.");
        }
        catch (Throwable throwable) {
            SpeedManagerLogger.log(throwable.getMessage());
        }
    }

    public void reset() {
        this.log("reset");
        this.log("curr-data-m: curr-down-rate : curr-down-limit : down-capacity : down-bandwith-mode : down-limit-mode : curr-up-rate : curr-up-limit : up-capacity : upload-bandwidth-mode : upload-limit-mode : transfer-mode");
        this.log("new-limit:newLimit:currStep:signalStrength:multiple:currUpLimit:maxStep:uploadLimitMax:uploadLimitMin:transferMode");
        this.log("consecutive:up:down");
        this.log("metric:value:type");
        this.log("user-comment:log");
        this.log("pin:upload-status,download-status,upload-unpin-timer,download-unpin-timer");
        this.log("limits:down-max:down-min:down-conf:up-max:up-min:up-conf");
        this.limitMonitor.resetPingSpace();
    }

    public void updateStats() {
        int n = this.adapter.getCurrentUploadLimit();
        int n2 = this.adapter.getCurrentDataUploadSpeed();
        int n3 = this.adapter.getCurrentProtocolUploadSpeed();
        int n4 = n2 + n3;
        int n5 = this.adapter.getCurrentDownloadLimit();
        int n6 = this.adapter.getCurrentDataDownloadSpeed();
        int n7 = this.adapter.getCurrentProtocolDownloadSpeed();
        int n8 = n6 + n7;
        this.limitMonitor.setDownloadBandwidthMode(n8, n5);
        this.limitMonitor.setUploadBandwidthMode(n4, n);
        this.limitMonitor.setDownloadLimitSettingMode(n5);
        this.limitMonitor.setUploadLimitSettingMode(n);
        this.limitMonitor.updateTransferMode();
        if (this.limitMonitor.isConfTestingLimits()) {
            this.limitMonitor.updateLimitTestingData(n8, n4);
        }
        this.limitMonitor.setCurrentTransferRates(n8, n4);
        if (n4 > this.sessionMaxUploadRate) {
            this.sessionMaxUploadRate = n4;
        }
        this.logCurrentData(n8, n5, n4, n);
    }

    private void logCurrentData(int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer("curr-data-m:" + n + ":" + n2 + ":");
        stringBuffer.append(this.limitMonitor.getDownloadMaxLimit()).append(":");
        stringBuffer.append(this.limitMonitor.getDownloadBandwidthMode()).append(":");
        stringBuffer.append(this.limitMonitor.getDownloadLimitSettingMode()).append(":");
        stringBuffer.append(n3).append(":").append(n4).append(":");
        stringBuffer.append(this.limitMonitor.getUploadMaxLimit()).append(":");
        stringBuffer.append(this.limitMonitor.getUploadBandwidthMode()).append(":");
        stringBuffer.append(this.limitMonitor.getUploadLimitSettingMode()).append(":");
        stringBuffer.append(this.limitMonitor.getTransferModeAsString());
        SpeedManagerLogger.log(stringBuffer.toString());
    }

    public void pingSourceFound(SpeedManagerPingSource speedManagerPingSource, boolean bl) {
        this.log("pingSourceFound");
        this.pingSourceManager.pingSourceFound(speedManagerPingSource, bl);
    }

    public void pingSourceFailed(SpeedManagerPingSource speedManagerPingSource) {
        this.log("pingSourceFailed");
        this.pingSourceManager.pingSourceFailed(speedManagerPingSource);
    }

    public void calculate(SpeedManagerPingSource[] speedManagerPingSourceArray) {
        this.limitMonitor.logPMDataEx();
        int n = speedManagerPingSourceArray.length;
        for (int i = 0; i < n; ++i) {
            this.pingSourceManager.addPingTime(speedManagerPingSourceArray[i]);
            int n2 = speedManagerPingSourceArray[i].getPingTime();
            if (n2 <= 0) continue;
            ++this.intervalCount;
        }
        if (this.limitMonitor.isConfTestingLimits()) {
            if (this.limitMonitor.isConfLimitTestFinished()) {
                this.endLimitTesting();
                return;
            }
            SMUpdate sMUpdate = this.limitMonitor.rampTestingLimit(this.adapter.getCurrentUploadLimit(), this.adapter.getCurrentDownloadLimit());
            this.logNewLimits(sMUpdate);
            this.setNewLimits(sMUpdate);
        }
        long l = SystemTime.getCurrentTime();
        if (this.timeSinceLastUpdate == 0L) {
            this.timeSinceLastUpdate = l;
        }
        if (this.calculatePingMetric()) {
            return;
        }
        this.log("metric:" + this.lastMetricValue);
        this.logLimitStatus();
        float f = this.determineSignalStrength(this.lastMetricValue);
        if (f != 0.0f && !this.limitMonitor.isConfTestingLimits()) {
            this.hadAdjustmentLastInterval = true;
            float f2 = this.consectiveMultiplier();
            int n3 = this.adapter.getCurrentUploadLimit();
            int n4 = this.adapter.getCurrentDownloadLimit();
            this.limitMonitor.checkForUnpinningCondition();
            SMUpdate sMUpdate = this.limitMonitor.modifyLimits(f, f2, n3, n4);
            this.logNewLimits(sMUpdate);
            this.setNewLimits(sMUpdate);
        } else {
            int n5;
            this.hadAdjustmentLastInterval = false;
            int n6 = this.adapter.getCurrentUploadLimit();
            if (!this.limitMonitor.areSettingsInSpec(n6, n5 = this.adapter.getCurrentDownloadLimit())) {
                SMUpdate sMUpdate = this.limitMonitor.adjustLimitsToSpec(n6, n5);
                this.logNewLimits(sMUpdate);
                this.setNewLimits(sMUpdate);
            }
        }
        this.pingSourceManager.checkPingSources(speedManagerPingSourceArray);
    }

    private void endLimitTesting() {
        int n = this.limitMonitor.guessDownloadLimit();
        int n2 = this.limitMonitor.guessUploadLimit();
        SMUpdate sMUpdate = this.limitMonitor.endLimitTesting(n, n2);
        this.limitMonitor.logPingMapData();
        this.limitMonitor.resetPingSpace();
        this.logNewLimits(sMUpdate);
        this.setNewLimits(sMUpdate);
    }

    private void logLimitStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("limits:");
        stringBuffer.append(this.limitMonitor.getUploadMaxLimit()).append(":");
        stringBuffer.append(this.limitMonitor.getUploadMinLimit()).append(":");
        stringBuffer.append(this.limitMonitor.getUploadConfidence()).append(":");
        stringBuffer.append(this.limitMonitor.getDownloadMaxLimit()).append(":");
        stringBuffer.append(this.limitMonitor.getDownloadMinLimit()).append(":");
        stringBuffer.append(this.limitMonitor.getDownloadConfidence());
        SpeedManagerLogger.log(stringBuffer.toString());
    }

    private boolean calculatePingMetric() {
        if (skipIntervalAfterAdjustment && this.hadAdjustmentLastInterval) {
            this.hadAdjustmentLastInterval = false;
            this.pingTimeList = new ArrayList();
            this.intervalCount = 0;
            return true;
        }
        if (this.intervalCount < numIntervalsBetweenCal) {
            return true;
        }
        this.lastMetricValue = (float)this.adapter.getPingMapper().getCurrentMetricRating();
        this.intervalCount = 0;
        return false;
    }

    private void logNewLimits(SMUpdate sMUpdate) {
        int n;
        if (sMUpdate.hasNewUploadLimit) {
            n = sMUpdate.newUploadLimit / 1024;
            this.log(" new up limit  : " + n + " kb/s");
        }
        if (sMUpdate.hasNewDownloadLimit) {
            n = sMUpdate.newDownloadLimit / 1024;
            this.log(" new down limit: " + n + " kb/s");
        }
    }

    private void setNewLimits(SMUpdate sMUpdate) {
        this.adapter.setCurrentUploadLimit(sMUpdate.newUploadLimit);
        this.adapter.setCurrentDownloadLimit(sMUpdate.newDownloadLimit);
    }

    private float determineSignalStrength(float f) {
        float f2 = this.convertTestMetricToSignal(f);
        if (f2 > 0.0f) {
            ++this.consecutiveUpticks;
            this.consecutiveDownticks = 0;
        } else if (f2 < 0.0f) {
            this.consecutiveUpticks = 0;
            ++this.consecutiveDownticks;
        }
        this.log("consecutive:" + this.consecutiveUpticks + ":" + this.consecutiveDownticks);
        return f2;
    }

    private float convertTestMetricToSignal(float f) {
        if (f >= 1.0f) {
            return 1.0f;
        }
        if (f <= -1.0f) {
            return -1.0f;
        }
        if (f > -0.5f && f < 0.5f) {
            return 0.0f;
        }
        if (f > 0.0f) {
            return (f - 0.5f) * 2.0f;
        }
        return (f + 0.5f) * 2.0f;
    }

    private float consectiveMultiplier() {
        float f;
        if (this.consecutiveUpticks > this.consecutiveDownticks) {
            if (this.limitMonitor.bandwidthUsageLow()) {
                this.consecutiveUpticks = 0;
            }
            f = this.calculateUpTickMultiple(this.consecutiveUpticks);
        } else {
            f = this.calculateDownTickMultiple(this.consecutiveDownticks);
            this.limitMonitor.notifyOfDownSignal();
        }
        return f;
    }

    private float calculateUpTickMultiple(int n) {
        float f = 0.0f;
        if (n < 0) {
            return f;
        }
        switch (n) {
            case 0: 
            case 1: {
                f = 0.25f;
                break;
            }
            case 2: {
                f = 0.5f;
                break;
            }
            case 3: {
                f = 1.0f;
                break;
            }
            case 4: {
                f = 1.25f;
                break;
            }
            case 5: {
                f = 1.5f;
                break;
            }
            case 6: {
                f = 1.75f;
                break;
            }
            case 7: {
                f = 2.0f;
                break;
            }
            case 8: {
                f = 2.25f;
                break;
            }
            case 9: {
                f = 2.5f;
                break;
            }
            default: {
                f = 3.0f;
            }
        }
        if (this.limitMonitor.bandwidthUsageMedium()) {
            f /= 2.0f;
        }
        return f;
    }

    private float calculateDownTickMultiple(int n) {
        float f = 0.0f;
        if (n < 0) {
            return f;
        }
        switch (n) {
            case 0: 
            case 1: {
                f = 0.25f;
                break;
            }
            case 2: {
                f = 0.5f;
                break;
            }
            case 3: {
                f = 1.0f;
                break;
            }
            case 4: {
                f = 2.0f;
                break;
            }
            case 5: {
                f = 3.0f;
                break;
            }
            case 6: {
                f = 4.0f;
                break;
            }
            case 7: {
                f = 6.0f;
                break;
            }
            case 8: {
                f = 9.0f;
                break;
            }
            case 9: {
                f = 15.0f;
                break;
            }
            default: {
                f = 20.0f;
            }
        }
        return f;
    }

    public int getIdlePingMillis() {
        return 0;
    }

    public int getCurrentPingMillis() {
        return 0;
    }

    public int getMaxPingMillis() {
        return 910;
    }

    public int getCurrentChokeSpeed() {
        return 0;
    }

    public int getMaxUploadSpeed() {
        return this.sessionMaxUploadRate;
    }

    public boolean getAdjustsDownloadLimits() {
        return true;
    }

    protected void log(String string) {
        SpeedManagerLogger.log(string);
    }
}

