/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.security.CryptoECCUtils;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.impl.SubscriptionImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionManagerImpl;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import java.io.File;
import java.io.IOException;
import java.security.Signature;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;

public class SubscriptionBodyImpl {
    private static final int SIMPLE_ID_LENGTH = 10;
    private SubscriptionManagerImpl manager;
    private String name;
    private boolean is_public;
    private byte[] public_key;
    private int version;
    private int az_version;
    private String json;
    private Map singleton_details;
    private byte[] hash;
    private byte[] sig;
    private int sig_data_size;
    private Map map;

    protected static byte[] encode(byte[] byArray, int n, int n2) {
        int n3 = byArray.length;
        byte[] byArray2 = new byte[n3 + 4 + 4];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        System.arraycopy(SubscriptionImpl.intToBytes(n), 0, byArray2, n3, 4);
        System.arraycopy(SubscriptionImpl.intToBytes(n2), 0, byArray2, n3 + 4, 4);
        return byArray2;
    }

    protected static byte[] sign(byte[] byArray, byte[] byArray2, int n, int n2) throws Exception {
        Signature signature = CryptoECCUtils.getSignature(CryptoECCUtils.rawdataToPrivkey(byArray));
        signature.update(SubscriptionBodyImpl.encode(byArray2, n, n2));
        return signature.sign();
    }

    protected static boolean verify(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3) {
        try {
            Signature signature = CryptoECCUtils.getSignature(CryptoECCUtils.rawdataToPubkey(byArray));
            signature.update(SubscriptionBodyImpl.encode(byArray2, n, n2));
            return signature.verify(byArray3);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return false;
        }
    }

    protected static byte[] deriveShortID(byte[] byArray, Map map) {
        if (map != null) {
            return SubscriptionBodyImpl.deriveSingletonShortID(map);
        }
        byte[] byArray2 = new SHA1Simple().calculateHash(byArray);
        byte[] byArray3 = new byte[10];
        System.arraycopy(byArray2, 0, byArray3, 0, 10);
        return byArray3;
    }

    protected static byte[] deriveSingletonShortID(Map map) {
        byte[] byArray = new byte[10];
        byte[] byArray2 = new SHA1Simple().calculateHash((byte[])map.get("key"));
        System.arraycopy(byArray2, 0, byArray, 0, 10);
        return byArray;
    }

    protected SubscriptionBodyImpl(SubscriptionManagerImpl subscriptionManagerImpl, SubscriptionImpl subscriptionImpl) throws SubscriptionException {
        this.manager = subscriptionManagerImpl;
        try {
            File file = this.manager.getVuzeFile(subscriptionImpl);
            VuzeFile vuzeFile = VuzeFileHandler.getSingleton().loadVuzeFile(file.getAbsolutePath());
            if (vuzeFile == null) {
                throw new IOException("Failed to load vuze file '" + file + "'");
            }
            this.load(vuzeFile.getComponents()[0].getContent(), false);
        }
        catch (Throwable throwable) {
            this.rethrow(throwable);
        }
    }

    protected SubscriptionBodyImpl(SubscriptionManagerImpl subscriptionManagerImpl, Map map) throws IOException {
        this.manager = subscriptionManagerImpl;
        this.load(map, true);
    }

    protected void load(Map map, boolean bl) throws IOException {
        this.map = map;
        this.hash = (byte[])this.map.get("hash");
        this.sig = (byte[])this.map.get("sig");
        Long l = (Long)this.map.get("size");
        Map map2 = (Map)this.map.get("details");
        if (map2 == null || this.hash == null || this.sig == null || l == null) {
            throw new IOException("Invalid subscription - details missing");
        }
        this.sig_data_size = l.intValue();
        this.name = new String((byte[])map2.get("name"), "UTF-8");
        this.public_key = (byte[])map2.get("public_key");
        this.version = ((Long)map2.get("version")).intValue();
        this.is_public = ((Long)map2.get("is_public")).intValue() == 1;
        this.json = new String((byte[])map2.get("json"), "UTF-8");
        this.singleton_details = (Map)map2.get("sin_details");
        Long l2 = (Long)map2.get("az_version");
        int n = this.az_version = l2 == null ? 1 : l2.intValue();
        if (bl) {
            byte[] byArray = BEncoder.encode(map2);
            byte[] byArray2 = new SHA1Simple().calculateHash(byArray);
            if (!Arrays.equals(byArray2, this.hash)) {
                HashMap hashMap = new HashMap(map2);
                hashMap.remove("az_version");
                byArray = BEncoder.encode(hashMap);
                byArray2 = new SHA1Simple().calculateHash(byArray);
            }
            if (!Arrays.equals(byArray2, this.hash)) {
                throw new IOException("Hash mismatch");
            }
            if (this.sig_data_size != byArray.length) {
                throw new IOException("Signature data length mismatch");
            }
            if (!SubscriptionBodyImpl.verify(this.public_key, this.hash, this.version, this.sig_data_size, this.sig)) {
                throw new IOException("Signature verification failed");
            }
        }
    }

    protected SubscriptionBodyImpl(SubscriptionManagerImpl subscriptionManagerImpl, String string, boolean bl, String string2, byte[] byArray, int n, int n2, Map map) throws IOException {
        this.manager = subscriptionManagerImpl;
        this.name = string;
        this.is_public = bl;
        this.public_key = byArray;
        this.version = n;
        this.az_version = n2;
        this.json = string2;
        this.singleton_details = map;
        this.map = new HashMap();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.map.put("details", hashMap);
        hashMap.put("name", this.name.getBytes("UTF-8"));
        hashMap.put("is_public", new Long(this.is_public ? 1L : 0L));
        hashMap.put("public_key", this.public_key);
        hashMap.put("version", new Long(this.version));
        hashMap.put("az_version", new Long(this.az_version));
        hashMap.put("json", string2.getBytes("UTF-8"));
        if (this.singleton_details != null) {
            hashMap.put("sin_details", this.singleton_details);
        }
    }

    protected void updateDetails(SubscriptionImpl subscriptionImpl, Map map) throws IOException {
        this.is_public = subscriptionImpl.isPublic();
        this.version = subscriptionImpl.getVersion();
        this.az_version = subscriptionImpl.getAZVersion();
        this.name = subscriptionImpl.getName();
        map.put("name", this.name.getBytes("UTF-8"));
        map.put("is_public", new Long(this.is_public ? 1L : 0L));
        map.put("version", new Long(this.version));
        map.put("az_version", new Long(this.az_version));
        if (this.json != null) {
            map.put("json", this.json.getBytes("UTF-8"));
        }
        if (this.singleton_details != null) {
            map.put("sin_details", this.singleton_details);
        }
    }

    protected String getName() {
        return this.name;
    }

    protected byte[] getPublicKey() {
        return this.public_key;
    }

    public byte[] getShortID() {
        return SubscriptionBodyImpl.deriveShortID(this.public_key, this.singleton_details);
    }

    protected boolean isPublic() {
        return this.is_public;
    }

    protected String getJSON() {
        return this.json;
    }

    protected Map getSingletonDetails() {
        return this.singleton_details;
    }

    protected void setJSON(String string) {
        this.json = string;
    }

    protected int getVersion() {
        return this.version;
    }

    protected int getAZVersion() {
        return this.az_version;
    }

    protected byte[] getHash() {
        return this.hash;
    }

    protected byte[] getSig() {
        return this.sig;
    }

    protected int getSigDataSize() {
        return this.sig_data_size;
    }

    protected void writeVuzeFile(SubscriptionImpl subscriptionImpl) throws SubscriptionException {
        try {
            Object object;
            File file = this.manager.getVuzeFile(subscriptionImpl);
            Map map = (Map)this.map.get("details");
            this.updateDetails(subscriptionImpl, map);
            byte[] byArray = BEncoder.encode(map);
            byte[] byArray2 = new SHA1Simple().calculateHash(byArray);
            byte[] byArray3 = (byte[])this.map.get("hash");
            if (byArray3 != null && !Arrays.equals(byArray3, byArray2)) {
                object = new HashMap(map);
                object.remove("az_version");
                byArray = BEncoder.encode((Map)object);
                byArray2 = new SHA1Simple().calculateHash(byArray);
            }
            if (byArray3 == null || !Arrays.equals(byArray3, byArray2)) {
                object = subscriptionImpl.getPrivateKey();
                if (object == null) {
                    throw new SubscriptionException("Only the originator of a subscription can modify it");
                }
                this.map.put("size", new Long(byArray.length));
                try {
                    this.map.put("hash", byArray2);
                    this.map.put("sig", SubscriptionBodyImpl.sign(object, byArray2, this.version, byArray.length));
                }
                catch (Throwable throwable) {
                    throw new SubscriptionException("Crypto failed: " + Debug.getNestedExceptionMessage(throwable));
                }
            }
            object = null;
            if (file.exists()) {
                object = new File(file.getParent(), file.getName() + ".bak");
                object.delete();
                if (!file.renameTo((File)object)) {
                    throw new SubscriptionException("Backup failed");
                }
            }
            try {
                VuzeFile vuzeFile = VuzeFileHandler.getSingleton().create();
                vuzeFile.addComponent(16, this.map);
                vuzeFile.write(file);
                this.hash = byArray2;
                this.sig = (byte[])this.map.get("sig");
                this.sig_data_size = byArray.length;
            }
            catch (Throwable throwable) {
                if (object != null) {
                    object.renameTo(file);
                }
                throw new SubscriptionException("File write failed: " + Debug.getNestedExceptionMessage(throwable));
            }
        }
        catch (Throwable throwable) {
            this.rethrow(throwable);
        }
    }

    protected void rethrow(Throwable throwable) throws SubscriptionException {
        if (throwable instanceof SubscriptionException) {
            throw (SubscriptionException)throwable;
        }
        throw new SubscriptionException("Operation failed", throwable);
    }
}

