/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import com.aelitis.azureus.core.subs.SubscriptionResult;
import com.aelitis.azureus.core.subs.impl.SubscriptionImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionManagerImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionResultImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;

public class SubscriptionHistoryImpl
implements SubscriptionHistory {
    private SubscriptionManagerImpl manager;
    private SubscriptionImpl subs;
    private boolean enabled;
    private boolean auto_dl;
    private long last_scan;
    private long last_new_result;
    private int num_unread;
    private int num_read;
    private String last_error;
    private boolean auth_failed;
    private int consec_fails;
    private boolean auto_dl_supported;
    private boolean dl_with_ref = true;

    protected SubscriptionHistoryImpl(SubscriptionManagerImpl subscriptionManagerImpl, SubscriptionImpl subscriptionImpl) {
        this.manager = subscriptionManagerImpl;
        this.subs = subscriptionImpl;
        this.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SubscriptionResultImpl[] reconcileResults(Engine engine, SubscriptionResultImpl[] subscriptionResultImplArray) {
        Object object;
        SubscriptionResultImpl[] subscriptionResultImplArray2;
        this.auto_dl_supported = engine.getAutoDownloadSupported() == 1;
        int n = 0;
        int n2 = 0;
        if (this.last_scan == 0L) {
            GlobalManager globalManager = AzureusCoreFactory.getSingleton().getGlobalManager();
            for (int i = 0; i < subscriptionResultImplArray.length; ++i) {
                subscriptionResultImplArray2 = subscriptionResultImplArray[i];
                subscriptionResultImplArray2.setReadInternal(true);
                try {
                    DownloadManager downloadManager;
                    String string = subscriptionResultImplArray2.getAssetHash();
                    if (string == null || (downloadManager = globalManager.getDownloadManager(new HashWrapper((byte[])(object = (Object)Base32.decode(string))))) == null) continue;
                    this.log("Adding existing association on first read for '" + downloadManager.getDisplayName());
                    this.subs.addAssociation((byte[])object);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        long l = SystemTime.getCurrentTime();
        int n3 = this.manager.getMaxNonDeletedResults();
        object = this;
        synchronized (object) {
            Object object2;
            SubscriptionResultImpl subscriptionResultImpl;
            int n4;
            boolean bl = false;
            SubscriptionResultImpl[] subscriptionResultImplArray3 = this.manager.loadResults(this.subs);
            ByteArrayHashMap<SubscriptionResultImpl> byteArrayHashMap = new ByteArrayHashMap<SubscriptionResultImpl>();
            ByteArrayHashMap<SubscriptionResultImpl> byteArrayHashMap2 = new ByteArrayHashMap<SubscriptionResultImpl>();
            ArrayList<SubscriptionResultImpl> arrayList = new ArrayList<SubscriptionResultImpl>();
            for (n4 = 0; n4 < subscriptionResultImplArray3.length; ++n4) {
                subscriptionResultImpl = subscriptionResultImplArray3[n4];
                byteArrayHashMap.put(subscriptionResultImpl.getKey1(), subscriptionResultImpl);
                object2 = subscriptionResultImpl.getKey2();
                if (object2 != null) {
                    byteArrayHashMap2.put((byte[])object2, subscriptionResultImpl);
                }
                arrayList.add(subscriptionResultImpl);
                if (subscriptionResultImpl.isDeleted()) continue;
                if (subscriptionResultImpl.getRead()) {
                    ++n2;
                    continue;
                }
                ++n;
            }
            for (n4 = 0; n4 < subscriptionResultImplArray.length; ++n4) {
                byte[] byArray;
                subscriptionResultImpl = subscriptionResultImplArray[n4];
                object2 = (SubscriptionResultImpl)byteArrayHashMap.get(subscriptionResultImpl.getKey1());
                if (object2 == null && (byArray = subscriptionResultImpl.getKey2()) != null) {
                    object2 = (SubscriptionResultImpl)byteArrayHashMap2.get(byArray);
                }
                if (object2 == null) {
                    this.last_new_result = l;
                    arrayList.add(subscriptionResultImpl);
                    byteArrayHashMap.put(subscriptionResultImpl.getKey1(), subscriptionResultImpl);
                    byArray = subscriptionResultImpl.getKey2();
                    if (byArray != null) {
                        byteArrayHashMap2.put(byArray, subscriptionResultImpl);
                    }
                    bl = true;
                    if (subscriptionResultImpl.getRead()) {
                        ++n2;
                        continue;
                    }
                    ++n;
                    continue;
                }
                if (!((SubscriptionResultImpl)object2).updateFrom(subscriptionResultImpl)) continue;
                bl = true;
            }
            if (n3 > 0 && n + n2 > n3) {
                for (n4 = 0; n4 < arrayList.size(); ++n4) {
                    subscriptionResultImpl = (SubscriptionResultImpl)arrayList.get(n4);
                    if (subscriptionResultImpl.isDeleted()) continue;
                    if (subscriptionResultImpl.getRead()) {
                        --n2;
                    } else {
                        --n;
                    }
                    subscriptionResultImpl.deleteInternal();
                    bl = true;
                    if (n + n2 <= n3) break;
                }
            }
            if (bl) {
                subscriptionResultImplArray2 = arrayList.toArray(new SubscriptionResultImpl[arrayList.size()]);
                this.manager.saveResults(this.subs, subscriptionResultImplArray2);
            } else {
                subscriptionResultImplArray2 = subscriptionResultImplArray3;
            }
            this.last_scan = l;
            this.num_unread = n;
            this.num_read = n2;
        }
        this.saveConfig();
        return subscriptionResultImplArray2;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            this.enabled = bl;
            this.saveConfig();
        }
    }

    public boolean isAutoDownload() {
        return this.auto_dl;
    }

    public void setAutoDownload(boolean bl) {
        if (bl != this.auto_dl) {
            this.auto_dl = bl;
            this.saveConfig();
            if (this.auto_dl) {
                this.downloadNow();
            }
        }
    }

    public void setDetails(boolean bl, boolean bl2) {
        if (this.enabled != bl || this.auto_dl != bl2) {
            this.enabled = bl;
            this.auto_dl = bl2;
            this.saveConfig();
            if (this.enabled && this.auto_dl) {
                this.downloadNow();
            }
        }
    }

    protected void downloadNow() {
        try {
            this.subs.getManager().getScheduler().downloadAsync(this.subs, false);
        }
        catch (Throwable throwable) {
            this.log("Failed to initiate download", throwable);
        }
    }

    public long getLastScanTime() {
        return this.last_scan;
    }

    public long getLastNewResultTime() {
        return this.last_new_result;
    }

    public long getNextScanTime() {
        Map map = this.subs.getScheduleConfig();
        if (map.size() == 0) {
            this.log("Schedule is empty!");
            return Long.MAX_VALUE;
        }
        try {
            long l = (Long)map.get("interval");
            return this.last_scan + l * 60L * 1000L;
        }
        catch (Throwable throwable) {
            this.log("Failed to decode schedule " + map, throwable);
            return Long.MAX_VALUE;
        }
    }

    public int getCheckFrequencyMins() {
        Map map = this.subs.getScheduleConfig();
        if (map.size() == 0) {
            return 120;
        }
        try {
            int n = ((Long)map.get("interval")).intValue();
            return n;
        }
        catch (Throwable throwable) {
            return 120;
        }
    }

    public int getNumUnread() {
        return this.num_unread;
    }

    public int getNumRead() {
        return this.num_read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionResult[] getResults(boolean bl) {
        SubscriptionResult[] subscriptionResultArray;
        Object object = this;
        synchronized (object) {
            subscriptionResultArray = this.manager.loadResults(this.subs);
        }
        if (bl) {
            return subscriptionResultArray;
        }
        object = new ArrayList(subscriptionResultArray.length);
        for (int i = 0; i < subscriptionResultArray.length; ++i) {
            if (subscriptionResultArray[i].isDeleted()) continue;
            object.add(subscriptionResultArray[i]);
        }
        return object.toArray(new SubscriptionResult[object.size()]);
    }

    public SubscriptionResult getResult(String string) {
        SubscriptionResult[] subscriptionResultArray = this.getResults(true);
        for (int i = 0; i < subscriptionResultArray.length; ++i) {
            if (!subscriptionResultArray[i].getID().equals(string)) continue;
            return subscriptionResultArray[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateResult(SubscriptionResultImpl subscriptionResultImpl) {
        byte[] byArray = subscriptionResultImpl.getKey1();
        boolean bl = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            SubscriptionResultImpl[] subscriptionResultImplArray = this.manager.loadResults(this.subs);
            for (int i = 0; i < subscriptionResultImplArray.length; ++i) {
                if (!Arrays.equals(subscriptionResultImplArray[i].getKey1(), byArray)) continue;
                subscriptionResultImplArray[i] = subscriptionResultImpl;
                bl = true;
            }
            if (bl) {
                this.updateReadUnread(subscriptionResultImplArray);
                this.manager.saveResults(this.subs, subscriptionResultImplArray);
            }
        }
        if (bl) {
            this.saveConfig();
        }
        if (this.isAutoDownload() && !subscriptionResultImpl.getRead() && !subscriptionResultImpl.isDeleted()) {
            this.manager.getScheduler().download((Subscription)this.subs, subscriptionResultImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResults(String[] stringArray) {
        int n;
        ByteArrayHashMap<String> byteArrayHashMap = new ByteArrayHashMap<String>();
        for (n = 0; n < stringArray.length; ++n) {
            byteArrayHashMap.put(Base32.decode(stringArray[n]), "");
        }
        n = 0;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            SubscriptionResultImpl[] subscriptionResultImplArray = this.manager.loadResults(this.subs);
            for (int i = 0; i < subscriptionResultImplArray.length; ++i) {
                SubscriptionResultImpl subscriptionResultImpl = subscriptionResultImplArray[i];
                if (subscriptionResultImpl.isDeleted() || !byteArrayHashMap.containsKey(subscriptionResultImpl.getKey1())) continue;
                n = 1;
                subscriptionResultImpl.deleteInternal();
            }
            if (n != 0) {
                this.updateReadUnread(subscriptionResultImplArray);
                this.manager.saveResults(this.subs, subscriptionResultImplArray);
            }
        }
        if (n != 0) {
            this.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllResults() {
        boolean bl = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            SubscriptionResultImpl[] subscriptionResultImplArray = this.manager.loadResults(this.subs);
            for (int i = 0; i < subscriptionResultImplArray.length; ++i) {
                SubscriptionResultImpl subscriptionResultImpl = subscriptionResultImplArray[i];
                if (subscriptionResultImpl.isDeleted()) continue;
                bl = true;
                subscriptionResultImpl.deleteInternal();
            }
            if (bl) {
                this.updateReadUnread(subscriptionResultImplArray);
                this.manager.saveResults(this.subs, subscriptionResultImplArray);
            }
        }
        if (bl) {
            this.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAllResultsRead() {
        boolean bl = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            SubscriptionResultImpl[] subscriptionResultImplArray = this.manager.loadResults(this.subs);
            for (int i = 0; i < subscriptionResultImplArray.length; ++i) {
                SubscriptionResultImpl subscriptionResultImpl = subscriptionResultImplArray[i];
                if (subscriptionResultImpl.getRead()) continue;
                bl = true;
                subscriptionResultImpl.setReadInternal(true);
            }
            if (bl) {
                this.updateReadUnread(subscriptionResultImplArray);
                this.manager.saveResults(this.subs, subscriptionResultImplArray);
            }
        }
        if (bl) {
            this.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAllResultsUnread() {
        boolean bl = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            SubscriptionResultImpl[] subscriptionResultImplArray = this.manager.loadResults(this.subs);
            for (int i = 0; i < subscriptionResultImplArray.length; ++i) {
                SubscriptionResultImpl subscriptionResultImpl = subscriptionResultImplArray[i];
                if (!subscriptionResultImpl.getRead()) continue;
                bl = true;
                subscriptionResultImpl.setReadInternal(false);
            }
            if (bl) {
                this.updateReadUnread(subscriptionResultImplArray);
                this.manager.saveResults(this.subs, subscriptionResultImplArray);
            }
        }
        if (bl) {
            this.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markResults(String[] stringArray, boolean[] blArray) {
        int n;
        ByteArrayHashMap<Boolean> byteArrayHashMap = new ByteArrayHashMap<Boolean>();
        for (n = 0; n < stringArray.length; ++n) {
            byteArrayHashMap.put(Base32.decode(stringArray[n]), new Boolean(blArray[n]));
        }
        n = 0;
        ArrayList<SubscriptionResultImpl> arrayList = new ArrayList<SubscriptionResultImpl>();
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            SubscriptionResultImpl[] subscriptionResultImplArray = this.manager.loadResults(this.subs);
            for (int i = 0; i < subscriptionResultImplArray.length; ++i) {
                Boolean bl;
                SubscriptionResultImpl subscriptionResultImpl = subscriptionResultImplArray[i];
                if (subscriptionResultImpl.isDeleted() || (bl = (Boolean)byteArrayHashMap.get(subscriptionResultImpl.getKey1())) == null) continue;
                boolean bl2 = bl;
                if (subscriptionResultImpl.getRead() == bl2) continue;
                n = 1;
                subscriptionResultImpl.setReadInternal(bl2);
                if (bl2) continue;
                arrayList.add(subscriptionResultImpl);
            }
            if (n != 0) {
                this.updateReadUnread(subscriptionResultImplArray);
                this.manager.saveResults(this.subs, subscriptionResultImplArray);
            }
        }
        if (n != 0) {
            this.saveConfig();
        }
        if (this.isAutoDownload()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.manager.getScheduler().download((Subscription)this.subs, (SubscriptionResult)arrayList.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            SubscriptionResultImpl[] subscriptionResultImplArray = this.manager.loadResults(this.subs);
            if (subscriptionResultImplArray.length > 0) {
                subscriptionResultImplArray = new SubscriptionResultImpl[]{};
                this.manager.saveResults(this.subs, subscriptionResultImplArray);
            }
            this.updateReadUnread(subscriptionResultImplArray);
        }
        this.last_error = null;
        this.last_new_result = 0L;
        this.last_scan = 0L;
        this.saveConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkMaxResults(int n) {
        if (n <= 0) {
            return;
        }
        boolean bl = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            if (this.num_unread + this.num_read > n) {
                SubscriptionResultImpl[] subscriptionResultImplArray = this.manager.loadResults(this.subs);
                for (int i = 0; i < subscriptionResultImplArray.length; ++i) {
                    SubscriptionResultImpl subscriptionResultImpl = subscriptionResultImplArray[i];
                    if (subscriptionResultImpl.isDeleted()) continue;
                    if (subscriptionResultImpl.getRead()) {
                        --this.num_read;
                    } else {
                        --this.num_unread;
                    }
                    subscriptionResultImpl.deleteInternal();
                    bl = true;
                    if (this.num_unread + this.num_read <= n) break;
                }
                if (bl) {
                    this.manager.saveResults(this.subs, subscriptionResultImplArray);
                }
            }
        }
        if (bl) {
            this.saveConfig();
        }
    }

    protected void updateReadUnread(SubscriptionResultImpl[] subscriptionResultImplArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < subscriptionResultImplArray.length; ++i) {
            SubscriptionResultImpl subscriptionResultImpl = subscriptionResultImplArray[i];
            if (subscriptionResultImpl.isDeleted()) continue;
            if (subscriptionResultImpl.getRead()) {
                ++n2;
                continue;
            }
            ++n;
        }
        this.num_read = n2;
        this.num_unread = n;
    }

    protected boolean isAutoDownloadSupported() {
        return this.auto_dl_supported;
    }

    protected void setFatalError(String string) {
        this.last_error = string;
        this.consec_fails = 1024;
    }

    protected void setLastError(String string, boolean bl) {
        this.last_error = string;
        this.auth_failed = bl;
        this.consec_fails = this.last_error == null ? 0 : ++this.consec_fails;
        this.subs.fireChanged();
    }

    public String getLastError() {
        return this.last_error;
    }

    public boolean isAuthFail() {
        return this.auth_failed;
    }

    public int getConsecFails() {
        return this.consec_fails;
    }

    public boolean getDownloadWithReferer() {
        return this.dl_with_ref;
    }

    public void setDownloadWithReferer(boolean bl) {
        if (bl != this.dl_with_ref) {
            this.dl_with_ref = bl;
            this.saveConfig();
        }
    }

    protected void loadConfig() {
        Map map = this.subs.getHistoryConfig();
        Long l = (Long)map.get("enabled");
        this.enabled = l == null ? true : l == 1L;
        Long l2 = (Long)map.get("auto_dl");
        this.auto_dl = l2 == null ? false : l2 == 1L;
        Long l3 = (Long)map.get("last_scan");
        this.last_scan = l3 == null ? 0L : l3;
        Long l4 = (Long)map.get("last_new");
        this.last_new_result = l4 == null ? 0L : l4;
        Long l5 = (Long)map.get("num_unread");
        this.num_unread = l5 == null ? 0 : l5.intValue();
        Long l6 = (Long)map.get("num_read");
        this.num_read = l6 == null ? 0 : l6.intValue();
        Long l7 = (Long)map.get("auto_dl_supported");
        this.auto_dl_supported = l7 == null ? this.last_scan > 0L : l7 == 1L;
        Long l8 = (Long)map.get("dl_with_ref");
        this.dl_with_ref = l8 == null ? true : l8 == 1L;
    }

    protected void saveConfig() {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("enabled", new Long(this.enabled ? 1L : 0L));
        hashMap.put("auto_dl", new Long(this.auto_dl ? 1L : 0L));
        hashMap.put("auto_dl_supported", new Long(this.auto_dl_supported ? 1L : 0L));
        hashMap.put("last_scan", new Long(this.last_scan));
        hashMap.put("last_new", new Long(this.last_new_result));
        hashMap.put("num_unread", new Long(this.num_unread));
        hashMap.put("num_read", new Long(this.num_read));
        hashMap.put("dl_with_ref", new Long(this.dl_with_ref ? 1L : 0L));
        this.subs.updateHistoryConfig(hashMap);
    }

    protected void log(String string) {
        this.subs.log("History: " + string);
    }

    protected void log(String string, Throwable throwable) {
        this.subs.log("History: " + string, throwable);
    }
}

