/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionDownloadListener;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import com.aelitis.azureus.core.subs.SubscriptionManagerListener;
import com.aelitis.azureus.core.subs.SubscriptionResult;
import com.aelitis.azureus.core.subs.SubscriptionScheduler;
import com.aelitis.azureus.core.subs.impl.SubscriptionDownloader;
import com.aelitis.azureus.core.subs.impl.SubscriptionImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionManagerImpl;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.UrlFilter;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class SubscriptionSchedulerImpl
implements SubscriptionScheduler,
SubscriptionManagerListener {
    private static final Object SCHEDULER_NEXT_SCAN_KEY = new Object();
    private static final Object SCHEDULER_FAILED_SCAN_CONSEC_KEY = new Object();
    private static final Object SCHEDULER_FAILED_SCAN_TIME_KEY = new Object();
    private static final int FAIL_INIT_DELAY = 600000;
    private static final int FAIL_MAX_DELAY = 28800000;
    private SubscriptionManagerImpl manager;
    private Map active_subscription_downloaders = new HashMap();
    private boolean active_subs_download_is_auto;
    private Set active_result_downloaders = new HashSet();
    private AsyncDispatcher result_downloader = new AsyncDispatcher();
    private boolean schedulng_permitted;
    private TimerEvent schedule_event;
    private boolean schedule_in_progress;
    private long last_schedule;

    protected SubscriptionSchedulerImpl(SubscriptionManagerImpl subscriptionManagerImpl) {
        this.manager = subscriptionManagerImpl;
        this.manager.addListener(this);
        DelayedTask delayedTask = UtilitiesImpl.addDelayedTask("Subscriptions Scheduler", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SubscriptionSchedulerImpl subscriptionSchedulerImpl = SubscriptionSchedulerImpl.this;
                synchronized (subscriptionSchedulerImpl) {
                    SubscriptionSchedulerImpl.this.schedulng_permitted = true;
                }
                SubscriptionSchedulerImpl.this.calculateSchedule();
            }
        });
        delayedTask.queue();
    }

    public void downloadAsync(Subscription subscription, boolean bl) throws SubscriptionException {
        this.download(subscription, bl, new SubscriptionDownloadListener(){

            public void complete(Subscription subscription) {
            }

            public void failed(Subscription subscription, SubscriptionException subscriptionException) {
                SubscriptionSchedulerImpl.this.log("Async download of " + subscription.getName() + " failed", subscriptionException);
            }
        });
    }

    public void download(final Subscription subscription, final boolean bl, final SubscriptionDownloadListener subscriptionDownloadListener) {
        new AEThread2("SS:download", true){

            public void run() {
                try {
                    SubscriptionSchedulerImpl.this.download(subscription, bl);
                    subscriptionDownloadListener.complete(subscription);
                }
                catch (SubscriptionException subscriptionException) {
                    subscriptionDownloadListener.failed(subscription, subscriptionException);
                }
                catch (Throwable throwable) {
                    subscriptionDownloadListener.failed(subscription, new SubscriptionException("Download failed", throwable));
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(Subscription subscription, boolean bl) throws SubscriptionException {
        boolean bl2;
        Map map;
        SubscriptionDownloader subscriptionDownloader;
        AESemaphore aESemaphore = null;
        Map map2 = this.active_subscription_downloaders;
        synchronized (map2) {
            List list = (List)this.active_subscription_downloaders.get(subscription);
            if (list != null) {
                aESemaphore = new AESemaphore("SS:waiter");
                list.add(aESemaphore);
                if (!bl) {
                    this.active_subs_download_is_auto = false;
                }
            } else {
                this.active_subscription_downloaders.put(subscription, new ArrayList());
                this.active_subs_download_is_auto = bl;
            }
            subscriptionDownloader = new SubscriptionDownloader(this.manager, (SubscriptionImpl)subscription);
        }
        try {
            if (aESemaphore == null) {
                subscriptionDownloader.download();
            } else {
                aESemaphore.reserve();
            }
            Object var9_8 = null;
            map = this.active_subscription_downloaders;
        }
        catch (Throwable throwable) {
            boolean bl3;
            Object var9_9 = null;
            Map map3 = this.active_subscription_downloaders;
            synchronized (map3) {
                List list = (List)this.active_subscription_downloaders.remove(subscription);
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        ((AESemaphore)list.get(i)).release();
                    }
                }
                bl3 = this.active_subs_download_is_auto;
            }
            ((SubscriptionImpl)subscription).fireDownloaded(bl3);
            throw throwable;
        }
        synchronized (map) {
            List list = (List)this.active_subscription_downloaders.remove(subscription);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    ((AESemaphore)list.get(i)).release();
                }
            }
            bl2 = this.active_subs_download_is_auto;
        }
        ((SubscriptionImpl)subscription).fireDownloaded(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(final Subscription subscription, final SubscriptionResult subscriptionResult) {
        Object object;
        String string = subscriptionResult.getDownloadLink();
        if (string == null) {
            this.log(subscription.getName() + ": can't download " + subscriptionResult.getID() + " as no direct download link available");
            return;
        }
        if (UrlFilter.getInstance().isWhitelisted(string)) {
            object = ContentNetworkManagerFactory.getSingleton().getContentNetworkForURL(string);
            if (object == null) {
                object = ConstantsVuze.getDefaultContentNetwork();
            }
            string = object.appendURLSuffix(string, false, true);
        }
        object = subscription.getID() + ":" + subscriptionResult.getID();
        final String string2 = string;
        Set set = this.active_result_downloaders;
        synchronized (set) {
            if (this.active_result_downloaders.contains(object)) {
                return;
            }
            this.active_result_downloaders.add(object);
            this.result_downloader.dispatch(new AERunnable((String)object){
                final /* synthetic */ String val$key;
                {
                    this.val$key = string22;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    try {
                        boolean bl = true;
                        boolean bl2 = subscription.getHistory().getDownloadWithReferer();
                        boolean bl3 = false;
                        while (bl) {
                            bl = false;
                            try {
                                Object object;
                                Object object2;
                                URL uRL = new URL(string2);
                                ResourceDownloaderFactory resourceDownloaderFactory = StaticUtilities.getResourceDownloaderFactory();
                                ResourceDownloader resourceDownloader = resourceDownloaderFactory.create(uRL);
                                String string = bl2 ? subscription.getReferer() : null;
                                UrlUtils.setBrowserHeaders(resourceDownloader, string);
                                Engine engine = subscription.getEngine();
                                if (engine instanceof WebEngine && ((WebEngine)(object2 = (WebEngine)engine)).isNeedsAuth() && (object = ((WebEngine)object2).getCookies()) != null && ((String)object).length() > 0) {
                                    resourceDownloader.setProperty("URL_Cookie", object);
                                }
                                object2 = resourceDownloaderFactory.getMetaRefreshDownloader(resourceDownloader);
                                object = object2.download();
                                TorrentImpl torrentImpl = new TorrentImpl(TOTorrentFactory.deserialiseFromBEncodedInputStream((InputStream)object));
                                DownloadManager downloadManager = PluginInitializer.getDefaultInterface().getDownloadManager();
                                boolean bl4 = SubscriptionSchedulerImpl.this.manager.shouldAutoStart(torrentImpl);
                                Download download = bl4 ? downloadManager.addDownload(torrentImpl) : downloadManager.addDownloadStopped(torrentImpl, null, null);
                                SubscriptionSchedulerImpl.this.log(subscription.getName() + ": added download " + download.getName() + ": auto-start=" + bl4);
                                subscription.addAssociation(torrentImpl.getHash());
                                subscriptionResult.setRead(true);
                                if (!bl3) continue;
                                subscription.getHistory().setDownloadWithReferer(bl2);
                            }
                            catch (Throwable throwable) {
                                SubscriptionSchedulerImpl.this.log(subscription.getName() + ": Failed to download result " + string2, throwable);
                                if (!(throwable instanceof TOTorrentException) || bl3) continue;
                                bl2 = !bl2;
                                bl3 = true;
                                bl = true;
                                SubscriptionSchedulerImpl.this.log(subscription.getName() + ": Retrying " + (bl2 ? "with referer" : "without referer"));
                            }
                        }
                        Object var16_16 = null;
                    }
                    catch (Throwable throwable) {
                        Object var16_17 = null;
                        Set set = SubscriptionSchedulerImpl.this.active_result_downloaders;
                        synchronized (set) {
                            SubscriptionSchedulerImpl.this.active_result_downloaders.remove(this.val$key);
                        }
                        SubscriptionSchedulerImpl.this.calculateSchedule();
                        throw throwable;
                    }
                    Set set = SubscriptionSchedulerImpl.this.active_result_downloaders;
                    synchronized (set) {
                        SubscriptionSchedulerImpl.this.active_result_downloaders.remove(this.val$key);
                    }
                    SubscriptionSchedulerImpl.this.calculateSchedule();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateSchedule() {
        Subscription[] subscriptionArray = this.manager.getSubscriptions();
        SubscriptionSchedulerImpl subscriptionSchedulerImpl = this;
        synchronized (subscriptionSchedulerImpl) {
            if (!this.schedulng_permitted) {
                return;
            }
            if (this.schedule_in_progress) {
                return;
            }
            long l = Long.MAX_VALUE;
            for (int i = 0; i < subscriptionArray.length; ++i) {
                SubscriptionHistory subscriptionHistory;
                Subscription subscription = subscriptionArray[i];
                if (!subscription.isSubscribed() || !(subscriptionHistory = subscription.getHistory()).isEnabled()) continue;
                long l2 = this.getNextScan(subscription);
                subscription.setUserData(SCHEDULER_NEXT_SCAN_KEY, new Long(l2));
                if (l2 >= l) continue;
                l = l2;
            }
            long l3 = 0L;
            if (this.schedule_event != null) {
                l3 = this.schedule_event.getWhen();
                this.schedule_event.cancel();
                this.schedule_event = null;
            }
            if (l < Long.MAX_VALUE) {
                long l4 = SystemTime.getCurrentTime();
                if ((l4 < this.last_schedule || l4 - this.last_schedule < 30000L) && l - l4 < 30000L) {
                    l = l4 + 30000L;
                }
                this.log("Calculate : old_time=" + new SimpleDateFormat().format(new Date(l3)) + ", new_time=" + new SimpleDateFormat().format(new Date(l)));
                this.schedule_event = SimpleTimer.addEvent("SS:Scheduler", l, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent timerEvent2) {
                        SubscriptionSchedulerImpl subscriptionSchedulerImpl = SubscriptionSchedulerImpl.this;
                        synchronized (subscriptionSchedulerImpl) {
                            if (SubscriptionSchedulerImpl.this.schedule_in_progress) {
                                return;
                            }
                            SubscriptionSchedulerImpl.this.schedule_in_progress = true;
                            SubscriptionSchedulerImpl.this.last_schedule = SystemTime.getCurrentTime();
                            SubscriptionSchedulerImpl.this.schedule_event = null;
                        }
                        new AEThread2("SS:Sched", true){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                SubscriptionSchedulerImpl subscriptionSchedulerImpl;
                                try {
                                    SubscriptionSchedulerImpl.this.schedule();
                                    Object var2_1 = null;
                                    subscriptionSchedulerImpl = SubscriptionSchedulerImpl.this;
                                }
                                catch (Throwable throwable) {
                                    Object var2_2 = null;
                                    SubscriptionSchedulerImpl subscriptionSchedulerImpl2 = SubscriptionSchedulerImpl.this;
                                    synchronized (subscriptionSchedulerImpl2) {
                                        SubscriptionSchedulerImpl.this.schedule_in_progress = false;
                                    }
                                    SubscriptionSchedulerImpl.this.calculateSchedule();
                                    throw throwable;
                                }
                                synchronized (subscriptionSchedulerImpl) {
                                    SubscriptionSchedulerImpl.this.schedule_in_progress = false;
                                }
                                SubscriptionSchedulerImpl.this.calculateSchedule();
                            }
                        }.start();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule() {
        Subscription[] subscriptionArray = this.manager.getSubscriptions();
        long l = SystemTime.getCurrentTime();
        for (int i = 0; i < subscriptionArray.length; ++i) {
            SubscriptionHistory subscriptionHistory;
            Subscription subscription = subscriptionArray[i];
            if (!subscription.isSubscribed() || !(subscriptionHistory = subscription.getHistory()).isEnabled()) continue;
            SubscriptionSchedulerImpl subscriptionSchedulerImpl = this;
            synchronized (subscriptionSchedulerImpl) {
                Long l2 = (Long)subscription.getUserData(SCHEDULER_NEXT_SCAN_KEY);
                if (l2 == null) {
                    continue;
                }
                long l3 = l - l2;
                if (l3 < -10000L) {
                    continue;
                }
                subscription.setUserData(SCHEDULER_NEXT_SCAN_KEY, null);
            }
            long l4 = subscriptionHistory.getLastScanTime();
            try {
                this.download(subscription, true);
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                long l5 = subscriptionHistory.getLastScanTime();
                if (l5 == l4) {
                    this.scanFailed(subscription);
                } else {
                    this.scanSuccess(subscription);
                }
                throw throwable;
            }
        }
    }

    protected long getNextScan(Subscription subscription) {
        SubscriptionHistory subscriptionHistory = subscription.getHistory();
        Long l = (Long)subscription.getUserData(SCHEDULER_FAILED_SCAN_CONSEC_KEY);
        if (l != null) {
            long l2 = (Long)subscription.getUserData(SCHEDULER_FAILED_SCAN_TIME_KEY);
            long l3 = l;
            long l4 = 600000L;
            int n = 1;
            while ((long)n < l3) {
                if ((l4 <<= 1) > 28800000L) {
                    l4 = 28800000L;
                    break;
                }
                ++n;
            }
            return l2 + l4;
        }
        return subscriptionHistory.getNextScanTime();
    }

    protected void scanSuccess(Subscription subscription) {
        subscription.setUserData(SCHEDULER_FAILED_SCAN_CONSEC_KEY, null);
    }

    protected void scanFailed(Subscription subscription) {
        subscription.setUserData(SCHEDULER_FAILED_SCAN_TIME_KEY, new Long(SystemTime.getCurrentTime()));
        Long l = (Long)subscription.getUserData(SCHEDULER_FAILED_SCAN_CONSEC_KEY);
        l = l == null ? new Long(1L) : new Long(l + 1L);
        subscription.setUserData(SCHEDULER_FAILED_SCAN_CONSEC_KEY, l);
    }

    protected void log(String string) {
        this.manager.log("Scheduler: " + string);
    }

    protected void log(String string, Throwable throwable) {
        this.manager.log("Scheduler: " + string, throwable);
    }

    public void subscriptionAdded(Subscription subscription) {
        this.calculateSchedule();
    }

    public void subscriptionChanged(Subscription subscription) {
        this.calculateSchedule();
    }

    public void subscriptionSelected(Subscription subscription) {
    }

    public void subscriptionRemoved(Subscription subscription) {
        this.calculateSchedule();
    }

    public void associationsChanged(byte[] byArray) {
    }
}

