/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

public class Java15Utils {
    private static volatile Java15UtilsProvider provider;

    public static boolean isAvailable() {
        return provider != null;
    }

    public static void setProvider(Java15UtilsProvider java15UtilsProvider) {
        provider = java15UtilsProvider;
    }

    public static void setConnectTimeout(URLConnection uRLConnection, int n) {
        if (provider != null) {
            provider.setConnectTimeout(uRLConnection, n);
        }
    }

    public static void setReadTimeout(URLConnection uRLConnection, int n) {
        if (provider != null) {
            provider.setReadTimeout(uRLConnection, n);
        }
    }

    public static long getThreadCPUTime() {
        if (provider != null) {
            return provider.getThreadCPUTime();
        }
        return 0L;
    }

    public static void dumpThreads() {
        if (provider != null) {
            provider.dumpThreads();
        }
    }

    public static URLConnection openConnectionForceNoProxy(URL uRL) throws IOException {
        if (provider != null) {
            return provider.openConnectionForceNoProxy(uRL);
        }
        return uRL.openConnection();
    }

    public static interface Java15UtilsProvider {
        public void setConnectTimeout(URLConnection var1, int var2);

        public void setReadTimeout(URLConnection var1, int var2);

        public long getThreadCPUTime();

        public void dumpThreads();

        public URLConnection openConnectionForceNoProxy(URL var1) throws IOException;
    }
}

