/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.bloom.impl;

import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.impl.BloomFilterImpl;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BloomFilterAddRemove8Bit
extends BloomFilterImpl {
    private byte[] map;

    public BloomFilterAddRemove8Bit(int n) {
        super(n);
        this.map = new byte[this.getMaxEntries()];
    }

    public BloomFilterAddRemove8Bit(Map<String, Object> map) {
        super(map);
        this.map = (byte[])map.get("map");
    }

    @Override
    protected void serialiseToMap(Map<String, Object> map) {
        super.serialiseToMap(map);
        map.put("map", this.map.clone());
    }

    @Override
    public BloomFilter getReplica() {
        return new BloomFilterAddRemove8Bit(this.getMaxEntries());
    }

    @Override
    protected int trimValue(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 255) {
            return 255;
        }
        return n;
    }

    @Override
    protected int getValue(int n) {
        return this.map[n] & 0xFF;
    }

    @Override
    protected int incValue(int n) {
        int n2 = this.getValue(n);
        if (n2 >= 255) {
            return 255;
        }
        this.setValue(n, (byte)(n2 + 1));
        return n2;
    }

    @Override
    protected int decValue(int n) {
        int n2 = this.getValue(n);
        if (n2 <= 0) {
            return 0;
        }
        this.setValue(n, (byte)(n2 - 1));
        return n2;
    }

    private void setValue(int n, byte by) {
        this.map[n] = by;
    }
}

