/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.dht;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.control.DHTControlActivity;
import com.aelitis.azureus.core.dht.control.DHTControlContact;
import com.aelitis.azureus.core.dht.router.DHTRouterContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDPContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginKeyStats;
import com.aelitis.azureus.plugins.dht.DHTPluginListener;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginTransferHandler;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginContactImpl;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginImpl;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginImplAdapter;
import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfigListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.components.UITextField;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class DHTPlugin
implements Plugin {
    public static final int EVENT_DHT_AVAILABLE = 1024;
    public static final int STATUS_DISABLED = 1;
    public static final int STATUS_INITALISING = 2;
    public static final int STATUS_RUNNING = 3;
    public static final int STATUS_FAILED = 4;
    public static final byte FLAG_SINGLE_VALUE = 0;
    public static final byte FLAG_DOWNLOADING = 1;
    public static final byte FLAG_SEEDING = 2;
    public static final byte FLAG_MULTI_VALUE = 4;
    public static final byte FLAG_STATS = 8;
    public static final byte FLAG_ANON = 16;
    public static final byte FLAG_PRECIOUS = 32;
    public static final byte DT_NONE = 1;
    public static final byte DT_FREQUENCY = 2;
    public static final byte DT_SIZE = 3;
    public static final int MAX_VALUE_SIZE = 512;
    private static final String PLUGIN_VERSION = "1.0";
    private static final String PLUGIN_NAME = "Distributed DB";
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.dht";
    private static final String PLUGIN_RESOURCE_ID = "ConfigView.section.plugins.dht";
    private static final boolean MAIN_DHT_ENABLE = COConfigurationManager.getBooleanParameter("dht.net.main_v4.enable", true);
    private static final boolean CVS_DHT_ENABLE = COConfigurationManager.getBooleanParameter("dht.net.cvs_v4.enable", true);
    private static final boolean MAIN_DHT_V6_ENABLE = COConfigurationManager.getBooleanParameter("dht.net.main_v6.enable", true);
    private PluginInterface plugin_interface;
    private int status = 1;
    private DHTPluginImpl[] dhts;
    private DHTPluginImpl main_dht;
    private DHTPluginImpl cvs_dht;
    private DHTPluginImpl main_v6_dht;
    private ActionParameter reseed;
    private boolean enabled;
    private int dht_data_port;
    private boolean got_extended_use;
    private boolean extended_use;
    private AESemaphore init_sem = new AESemaphore("DHTPlugin:init");
    private AEMonitor port_change_mon = new AEMonitor("DHTPlugin:portChanger");
    private boolean port_changing;
    private int port_change_outstanding;
    private boolean[] ipfilter_logging = new boolean[1];
    private BooleanParameter warn_user;
    private UPnPMapping upnp_mapping;
    private LoggerChannel log;
    private DHTLogger dht_log;
    private List listeners = new ArrayList();
    private long start_mono_time = SystemTime.getMonotonousTime();

    public static void load(PluginInterface pluginInterface) {
        pluginInterface.getPluginProperties().setProperty("plugin.version", PLUGIN_VERSION);
        pluginInterface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    public void initialize(PluginInterface pluginInterface) {
        this.status = 2;
        this.plugin_interface = pluginInterface;
        this.dht_data_port = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(PLUGIN_NAME);
        UIManager uIManager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel basicPluginViewModel = uIManager.createBasicPluginViewModel(PLUGIN_RESOURCE_ID);
        basicPluginViewModel.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        BasicPluginConfigModel basicPluginConfigModel = uIManager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        basicPluginConfigModel.addLabelParameter2("dht.info");
        BooleanParameter booleanParameter = basicPluginConfigModel.addBooleanParameter2("dht.enabled", "dht.enabled", true);
        this.plugin_interface.getPluginconfig().addListener(new PluginConfigListener(){

            public void configSaved() {
                int n = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
                if (n != DHTPlugin.this.dht_data_port) {
                    DHTPlugin.this.changePort(n);
                }
            }
        });
        LabelParameter labelParameter = basicPluginConfigModel.addLabelParameter2("dht.reseed.label");
        final StringParameter stringParameter = basicPluginConfigModel.addStringParameter2("dht.reseed.ip", "dht.reseed.ip", "");
        final IntParameter intParameter = basicPluginConfigModel.addIntParameter2("dht.reseed.port", "dht.reseed.port", 0);
        this.reseed = basicPluginConfigModel.addActionParameter2("dht.reseed.info", "dht.reseed");
        this.reseed.setEnabled(false);
        basicPluginConfigModel.createGroup("dht.reseed.group", new Parameter[]{labelParameter, stringParameter, intParameter, this.reseed});
        final BooleanParameter booleanParameter2 = basicPluginConfigModel.addBooleanParameter2("dht.ipfilter.log", "dht.ipfilter.log", true);
        this.ipfilter_logging[0] = booleanParameter2.getValue();
        booleanParameter2.addListener(new ParameterListener(){

            public void parameterChanged(Parameter parameter) {
                ((DHTPlugin)DHTPlugin.this).ipfilter_logging[0] = booleanParameter2.getValue();
            }
        });
        this.warn_user = basicPluginConfigModel.addBooleanParameter2("dht.warn.user", "dht.warn.user", true);
        final BooleanParameter booleanParameter3 = basicPluginConfigModel.addBooleanParameter2("dht.advanced", "dht.advanced", false);
        LabelParameter labelParameter2 = basicPluginConfigModel.addLabelParameter2("dht.advanced.label");
        final StringParameter stringParameter2 = basicPluginConfigModel.addStringParameter2("dht.override.ip", "dht.override.ip", "");
        basicPluginConfigModel.createGroup("dht.advanced.group", new Parameter[]{labelParameter2, stringParameter2});
        booleanParameter3.addEnabledOnSelection(labelParameter2);
        booleanParameter3.addEnabledOnSelection(stringParameter2);
        final StringParameter stringParameter3 = basicPluginConfigModel.addStringParameter2("dht.execute.command", "dht.execute.command", "print");
        ActionParameter actionParameter = basicPluginConfigModel.addActionParameter2("dht.execute.info", "dht.execute");
        final BooleanParameter booleanParameter4 = basicPluginConfigModel.addBooleanParameter2("dht.logging", "dht.logging", false);
        basicPluginConfigModel.createGroup("dht.diagnostics.group", new Parameter[]{stringParameter3, actionParameter, booleanParameter4});
        booleanParameter4.addListener(new ParameterListener(){

            public void parameterChanged(Parameter parameter) {
                if (DHTPlugin.this.dhts != null) {
                    for (int i = 0; i < DHTPlugin.this.dhts.length; ++i) {
                        DHTPlugin.this.dhts[i].setLogging(booleanParameter4.getValue());
                    }
                }
            }
        });
        final DHTPluginOperationListener dHTPluginOperationListener = new DHTPluginOperationListener(){

            public void diversified() {
            }

            public void starts(byte[] byArray) {
            }

            public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                DHTPlugin.this.log.log("valueRead: " + new String(dHTPluginValue.getValue()) + " from " + dHTPluginContact.getName());
                if ((dHTPluginValue.getFlags() & 8) != 0) {
                    DHTPluginKeyStats dHTPluginKeyStats = DHTPlugin.this.decodeStats(dHTPluginValue);
                    DHTPlugin.this.log.log("    stats: size=" + dHTPluginKeyStats.getSize());
                }
            }

            public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                DHTPlugin.this.log.log("valueWritten:" + new String(dHTPluginValue.getValue()) + " to " + dHTPluginContact.getName());
            }

            public void complete(byte[] byArray, boolean bl) {
                DHTPlugin.this.log.log("complete: timeout = " + bl);
            }
        };
        actionParameter.addListener(new ParameterListener(){

            public void parameterChanged(Parameter parameter) {
                AEThread2 aEThread2 = new AEThread2("DHT:commandrunner", true){

                    /*
                     * WARNING - void declaration
                     */
                    public void run() {
                        if (DHTPlugin.this.dhts == null) {
                            return;
                        }
                        for (int i = 0; i < DHTPlugin.this.dhts.length; ++i) {
                            Object object;
                            Object object3;
                            DHT dHT = DHTPlugin.this.dhts[i].getDHT();
                            DHTTransportUDP dHTTransportUDP = (DHTTransportUDP)dHT.getTransport();
                            String string = stringParameter3.getValue().trim();
                            String string2 = string.toLowerCase();
                            if (string2.equals("print")) {
                                dHT.print(true);
                                DHTPlugin.this.dhts[i].logStats();
                                continue;
                            }
                            if (string2.equals("pingall")) {
                                if (i != 1) continue;
                                dHT.getControl().pingAll();
                                continue;
                            }
                            if (string2.equals("versions")) {
                                void var9_15;
                                List<DHTRouterContact> list = dHT.getRouter().getAllContacts();
                                object3 = new TreeMap();
                                for (DHTRouterContact throwable : list) {
                                    object = (DHTControlContact)((Object)throwable.getAttachment());
                                    byte by = object.getTransportContact().getProtocolVersion();
                                    Integer n = (Integer)object3.get(by);
                                    if (n == null) {
                                        object3.put(by, 1);
                                        continue;
                                    }
                                    object3.put(by, n + 1);
                                }
                                DHTPlugin.this.log.log("Net " + dHT.getTransport().getNetwork());
                                int n = list.size();
                                if (n == 0) {
                                    DHTPlugin.this.log.log("   no contacts");
                                    continue;
                                }
                                String string3 = "";
                                for (Map.Entry entry : object3.entrySet()) {
                                    String string4 = (String)var9_15 + (var9_15.length() == 0 ? "" : ", ") + entry.getKey() + "=" + 100 * (Integer)entry.getValue() / n + "%";
                                }
                                DHTPlugin.this.log.log("    contacts=" + n + ": " + (String)var9_15);
                                continue;
                            }
                            if (string2.equals("testca")) {
                                ((DHTTransportUDPImpl)dHTTransportUDP).testExternalAddressChange();
                                continue;
                            }
                            if (string2.equals("testnd")) {
                                ((DHTTransportUDPImpl)dHTTransportUDP).testNetworkAlive(false);
                                continue;
                            }
                            if (string2.equals("testna")) {
                                ((DHTTransportUDPImpl)dHTTransportUDP).testNetworkAlive(true);
                                continue;
                            }
                            int n = string.indexOf(32);
                            if (n == -1) continue;
                            object3 = string2.substring(0, n);
                            String string3 = string.substring(n + 1);
                            if (((String)object3).equals("set")) {
                                n = string3.indexOf(61);
                                if (n == -1) continue;
                                DHTPlugin.this.put(string3.substring(0, n).getBytes(), "DHT Plugin: set", string3.substring(n + 1).getBytes(), (byte)0, dHTPluginOperationListener);
                                continue;
                            }
                            if (((String)object3).equals("get")) {
                                DHTPlugin.this.get(string3.getBytes(), "DHT Plugin: get", (byte)0, 1, 10000L, true, false, dHTPluginOperationListener);
                                continue;
                            }
                            if (((String)object3).equals("query")) {
                                DHTPlugin.this.get(string3.getBytes(), "DHT Plugin: get", (byte)8, 1, 10000L, true, false, dHTPluginOperationListener);
                                continue;
                            }
                            if (((String)object3).equals("punch")) {
                                HashMap<String, String> hashMap = new HashMap<String, String>();
                                hashMap.put("hello", "mum");
                                object = dHT.getNATPuncher();
                                if (object == null) continue;
                                object.punch("Test", dHTTransportUDP.getLocalContact(), null, hashMap);
                                continue;
                            }
                            if (!((String)object3).equals("stats")) continue;
                            try {
                                void var9_20;
                                n = string3.lastIndexOf(":");
                                if (n == -1) {
                                    DHTTransportContact dHTTransportContact = dHTTransportUDP.getLocalContact();
                                } else {
                                    object = string3.substring(0, n);
                                    int n2 = Integer.parseInt(string3.substring(n + 1));
                                    DHTTransportUDPContact dHTTransportUDPContact = dHTTransportUDP.importContact(new InetSocketAddress((String)object, n2), dHTTransportUDP.getProtocolVersion());
                                }
                                DHTPlugin.this.log.log("Stats request to " + var9_20.getName());
                                object = var9_20.getStats();
                                DHTPlugin.this.log.log("Stats:" + (object == null ? "<null>" : object.getString()));
                                DHTControlActivity[] dHTControlActivityArray = dHT.getControl().getActivities();
                                for (int j = 0; j < dHTControlActivityArray.length; ++j) {
                                    DHTPlugin.this.log.log("    act:" + dHTControlActivityArray[j].getString());
                                }
                                continue;
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                    }
                };
                aEThread2.start();
            }
        });
        this.reseed.addListener(new ParameterListener(){

            public void parameterChanged(Parameter parameter) {
                DHTPlugin.this.reseed.setEnabled(false);
                AEThread2 aEThread2 = new AEThread2("DHT:reseeder", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            String string = stringParameter.getValue().trim();
                            if (DHTPlugin.this.dhts == null) {
                                return;
                            }
                            int n = intParameter.getValue();
                            for (int i = 0; i < DHTPlugin.this.dhts.length; ++i) {
                                DHTPluginImpl dHTPluginImpl = DHTPlugin.this.dhts[i];
                                if (string.length() == 0 || n == 0) {
                                    dHTPluginImpl.checkForReSeed(true);
                                    continue;
                                }
                                if (dHTPluginImpl.importSeed(string, n) == null) continue;
                                dHTPluginImpl.integrateDHT(false, null);
                            }
                        }
                        finally {
                            DHTPlugin.this.reseed.setEnabled(true);
                        }
                    }
                };
                aEThread2.start();
            }
        });
        basicPluginViewModel.getActivity().setVisible(false);
        basicPluginViewModel.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int n, String string) {
                basicPluginViewModel.getLogArea().appendText(string + "\n");
            }

            public void messageLogged(String string, Throwable throwable) {
                basicPluginViewModel.getLogArea().appendText(throwable.toString() + "\n");
            }
        });
        this.dht_log = new DHTLogger(){

            public void log(String string) {
                DHTPlugin.this.log.log(string);
            }

            public void log(Throwable throwable) {
                DHTPlugin.this.log.log(throwable);
            }

            public void log(int n, String string) {
                if (this.isEnabled(n)) {
                    DHTPlugin.this.log.log(string);
                }
            }

            public boolean isEnabled(int n) {
                if (n == 2) {
                    return DHTPlugin.this.ipfilter_logging[0];
                }
                return true;
            }

            public PluginInterface getPluginInterface() {
                return DHTPlugin.this.log.getLogger().getPluginInterface();
            }
        };
        if (!booleanParameter.getValue()) {
            basicPluginViewModel.getStatus().setText("Disabled");
            this.status = 1;
            this.init_sem.releaseForever();
            return;
        }
        this.setPluginInfo();
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                PluginInterface pluginInterface = DHTPlugin.this.plugin_interface.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
                if (pluginInterface == null) {
                    DHTPlugin.this.log.log("UPnP plugin not found, can't map port");
                } else {
                    DHTPlugin.this.upnp_mapping = ((UPnPPlugin)pluginInterface.getPlugin()).addMapping(DHTPlugin.this.plugin_interface.getPluginName(), false, DHTPlugin.this.dht_data_port, true);
                }
                String string = null;
                if (booleanParameter3.getValue() && (string = stringParameter2.getValue().trim()).length() == 0) {
                    string = null;
                }
                DHTPlugin.this.initComplete(basicPluginViewModel.getStatus(), booleanParameter4.getValue(), string);
            }

            public void closedownInitiated() {
                if (DHTPlugin.this.dhts != null) {
                    for (int i = 0; i < DHTPlugin.this.dhts.length; ++i) {
                        DHTPlugin.this.dhts[i].closedownInitiated();
                    }
                }
                DHTPlugin.this.saveClockSkew();
            }

            public void closedownComplete() {
            }
        });
        this.plugin_interface.getUtilities().createTimer("DHTStats", true).addPeriodicEvent(60000L, new UTTimerEventPerformer(){

            public void perform(UTTimerEvent uTTimerEvent) {
                if (DHTPlugin.this.dhts != null) {
                    for (int i = 0; i < DHTPlugin.this.dhts.length; ++i) {
                        DHTPlugin.this.dhts[i].updateStats(15);
                    }
                }
                DHTPlugin.this.setPluginInfo();
                DHTPlugin.this.saveClockSkew();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changePort(int n) {
        try {
            this.port_change_mon.enter();
            this.port_change_outstanding = n;
            if (this.port_changing) {
                return;
            }
            this.port_changing = true;
        }
        finally {
            this.port_change_mon.exit();
        }
        new AEThread2("DHTPlugin:portChanger", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block11: while (true) {
                    int n;
                    try {
                        DHTPlugin.this.port_change_mon.enter();
                        n = DHTPlugin.this.port_change_outstanding;
                    }
                    finally {
                        DHTPlugin.this.port_change_mon.exit();
                    }
                    try {
                        DHTPlugin.this.dht_data_port = n;
                        if (DHTPlugin.this.upnp_mapping != null && DHTPlugin.this.upnp_mapping.getPort() != n) {
                            DHTPlugin.this.upnp_mapping.setPort(n);
                        }
                        if (DHTPlugin.this.status != 3 || DHTPlugin.this.dhts == null) continue;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= DHTPlugin.this.dhts.length) continue block11;
                            if (DHTPlugin.this.dhts[n2].getPort() != n) {
                                DHTPlugin.this.dhts[n2].setPort(n);
                            }
                            ++n2;
                        }
                    }
                    finally {
                        try {
                            DHTPlugin.this.port_change_mon.enter();
                            if (n != DHTPlugin.this.port_change_outstanding) continue;
                            DHTPlugin.this.port_changing = false;
                        }
                        finally {
                            DHTPlugin.this.port_change_mon.exit();
                            continue;
                        }
                    }
                    break;
                }
            }
        }.start();
    }

    protected void initComplete(final UITextField uITextField, final boolean bl, final String string) {
        AEThread2 aEThread2 = new AEThread2("DHTPlugin.init", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean bl2 = false;
                try {
                    DHTPlugin.this.enabled = VersionCheckClient.getSingleton().DHTEnableAllowed();
                    if (DHTPlugin.this.enabled) {
                        uITextField.setText("Initialising");
                        DelayedTask delayedTask = DHTPlugin.this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

                            public void run() {
                                new AEThread2("DHTPlugin.init2", true){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void run() {
                                        try {
                                            ArrayList<DHTPluginImpl> arrayList = new ArrayList<DHTPluginImpl>();
                                            DHTPluginImplAdapter dHTPluginImplAdapter = new DHTPluginImplAdapter(){

                                                public void localContactChanged(DHTPluginContact dHTPluginContact) {
                                                    for (int i = 0; i < DHTPlugin.this.listeners.size(); ++i) {
                                                        ((DHTPluginListener)DHTPlugin.this.listeners.get(i)).localAddressChanged(dHTPluginContact);
                                                    }
                                                }
                                            };
                                            if (MAIN_DHT_ENABLE) {
                                                DHTPlugin.this.main_dht = new DHTPluginImpl(DHTPlugin.this.plugin_interface, AzureusCoreFactory.getSingleton().getNATTraverser(), dHTPluginImplAdapter, 26, 0, false, string, DHTPlugin.this.dht_data_port, DHTPlugin.this.reseed, DHTPlugin.this.warn_user, bl, DHTPlugin.this.log, DHTPlugin.this.dht_log);
                                                arrayList.add(DHTPlugin.this.main_dht);
                                                dHTPluginImplAdapter = null;
                                            }
                                            if (MAIN_DHT_V6_ENABLE && NetworkAdmin.getSingleton().hasIPV6Potential(false)) {
                                                DHTPlugin.this.main_v6_dht = new DHTPluginImpl(DHTPlugin.this.plugin_interface, AzureusCoreFactory.getSingleton().getNATTraverser(), dHTPluginImplAdapter, 26, 3, true, null, DHTPlugin.this.dht_data_port, DHTPlugin.this.reseed, DHTPlugin.this.warn_user, bl, DHTPlugin.this.log, DHTPlugin.this.dht_log);
                                                arrayList.add(DHTPlugin.this.main_v6_dht);
                                                dHTPluginImplAdapter = null;
                                            }
                                            if (Constants.isCVSVersion() && CVS_DHT_ENABLE) {
                                                DHTPlugin.this.cvs_dht = new DHTPluginImpl(DHTPlugin.this.plugin_interface, AzureusCoreFactory.getSingleton().getNATTraverser(), dHTPluginImplAdapter, 36, 1, false, string, DHTPlugin.this.dht_data_port, DHTPlugin.this.reseed, DHTPlugin.this.warn_user, bl, DHTPlugin.this.log, DHTPlugin.this.dht_log);
                                                arrayList.add(DHTPlugin.this.cvs_dht);
                                                dHTPluginImplAdapter = null;
                                            }
                                            DHTPluginImpl[] dHTPluginImplArray = new DHTPluginImpl[arrayList.size()];
                                            arrayList.toArray(dHTPluginImplArray);
                                            DHTPlugin.access$202(DHTPlugin.this, dHTPluginImplArray);
                                            DHTPlugin.this.status = DHTPlugin.this.dhts[0].getStatus();
                                            uITextField.setText(DHTPlugin.this.dhts[0].getStatusText());
                                        }
                                        catch (Throwable throwable) {
                                            DHTPlugin.this.enabled = false;
                                            DHTPlugin.this.status = 1;
                                            uITextField.setText("Disabled due to error during initialisation");
                                            DHTPlugin.this.log.log(throwable);
                                            Debug.printStackTrace(throwable);
                                        }
                                        finally {
                                            DHTPlugin.this.init_sem.releaseForever();
                                        }
                                        if (DHTPlugin.this.status == 3) {
                                            DHTPlugin.this.changePort(DHTPlugin.this.dht_data_port);
                                        }
                                    }
                                }.start();
                            }
                        });
                        delayedTask.queue();
                        bl2 = true;
                    } else {
                        DHTPlugin.this.status = 1;
                        uITextField.setText("Disabled administratively due to network problems");
                    }
                }
                catch (Throwable throwable) {
                    DHTPlugin.this.enabled = false;
                    DHTPlugin.this.status = 1;
                    uITextField.setText("Disabled due to error during initialisation");
                    DHTPlugin.this.log.log(throwable);
                    Debug.printStackTrace(throwable);
                }
                finally {
                    if (!bl2) {
                        DHTPlugin.this.init_sem.releaseForever();
                    }
                }
            }
        };
        aEThread2.start();
    }

    protected void setPluginInfo() {
        boolean bl = this.plugin_interface.getPluginconfig().getPluginBooleanParameter("dht.reachable.0", true);
        this.plugin_interface.getPluginconfig().setPluginParameter("plugin.info", bl ? "1" : "0");
    }

    public boolean isEnabled() {
        if (this.plugin_interface == null) {
            Debug.out("Called too early!");
            return false;
        }
        if (this.plugin_interface.isInitialisationThread() && !this.init_sem.isReleasedForever()) {
            Debug.out("Initialisation deadlock detected");
            return true;
        }
        this.init_sem.reserve();
        return this.enabled;
    }

    public boolean peekEnabled() {
        if (this.init_sem.isReleasedForever()) {
            return this.enabled;
        }
        return true;
    }

    public boolean isInitialising() {
        return !this.init_sem.isReleasedForever();
    }

    public boolean isExtendedUseAllowed() {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.got_extended_use) {
            this.got_extended_use = true;
            this.extended_use = VersionCheckClient.getSingleton().DHTExtendedUseAllowed();
        }
        return this.extended_use;
    }

    public boolean isReachable() {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        return this.dhts[0].isReachable();
    }

    public boolean isDiversified(byte[] byArray) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        return this.dhts[0].isDiversified(byArray);
    }

    public void put(byte[] byArray, String string, byte[] byArray2, byte by, DHTPluginOperationListener dHTPluginOperationListener) {
        this.put(byArray, string, byArray2, by, true, dHTPluginOperationListener);
    }

    public void put(byte[] byArray, String string, byte[] byArray2, byte by, boolean bl, final DHTPluginOperationListener dHTPluginOperationListener) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        if (this.dhts.length == 1) {
            this.dhts[0].put(byArray, string, byArray2, by, bl, dHTPluginOperationListener);
        } else {
            final int[] nArray = new int[]{this.dhts.length};
            DHTPluginOperationListener dHTPluginOperationListener2 = new DHTPluginOperationListener(){

                public void diversified() {
                    dHTPluginOperationListener.diversified();
                }

                public void starts(byte[] byArray) {
                    dHTPluginOperationListener.starts(byArray);
                }

                public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                    dHTPluginOperationListener.valueRead(dHTPluginContact, dHTPluginValue);
                }

                public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                    dHTPluginOperationListener.valueWritten(dHTPluginContact, dHTPluginValue);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void complete(byte[] byArray, boolean bl) {
                    int[] nArray2 = nArray;
                    synchronized (nArray) {
                        nArray[0] = nArray[0] - 1;
                        if (nArray[0] == 0) {
                            dHTPluginOperationListener.complete(byArray, bl);
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
            };
            this.dhts[0].put(byArray, string, byArray2, by, bl, dHTPluginOperationListener2);
            for (int i = 1; i < this.dhts.length; ++i) {
                this.dhts[i].put(byArray, string, byArray2, by, bl, new DHTPluginOperationListener(){

                    public void diversified() {
                    }

                    public void starts(byte[] byArray) {
                    }

                    public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                    }

                    public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void complete(byte[] byArray, boolean bl) {
                        int[] nArray2 = nArray;
                        synchronized (nArray) {
                            nArray[0] = nArray[0] - 1;
                            if (nArray[0] == 0) {
                                dHTPluginOperationListener.complete(byArray, bl);
                            }
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return;
                        }
                    }
                });
            }
        }
    }

    public DHTPluginValue getLocalValue(byte[] byArray) {
        if (this.main_dht != null) {
            return this.main_dht.getLocalValue(byArray);
        }
        return this.cvs_dht.getLocalValue(byArray);
    }

    public void get(final byte[] byArray, String string, byte by, int n, long l, boolean bl, boolean bl2, final DHTPluginOperationListener dHTPluginOperationListener) {
        Object[] objectArray;
        Object[] objectArray2;
        DHTPluginOperationListener dHTPluginOperationListener2;
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        if (this.cvs_dht == null) {
            dHTPluginOperationListener2 = dHTPluginOperationListener;
        } else {
            if (this.main_dht == null && this.main_v6_dht == null) {
                this.cvs_dht.get(byArray, string, by, n, l, bl, bl2, dHTPluginOperationListener);
                return;
            }
            objectArray2 = new int[]{2};
            objectArray = new boolean[]{false};
            dHTPluginOperationListener2 = new DHTPluginOperationListener((int[])objectArray2, (boolean[])objectArray){
                final /* synthetic */ int[] val$completes_to_go;
                final /* synthetic */ boolean[] val$main_timeout;
                {
                    this.val$completes_to_go = nArray;
                    this.val$main_timeout = blArray;
                }

                public void diversified() {
                    dHTPluginOperationListener.diversified();
                }

                public void starts(byte[] byArray2) {
                    dHTPluginOperationListener.starts(byArray);
                }

                public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                    dHTPluginOperationListener.valueRead(dHTPluginContact, dHTPluginValue);
                }

                public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                    dHTPluginOperationListener.valueWritten(dHTPluginContact, dHTPluginValue);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void complete(byte[] byArray2, boolean bl) {
                    int[] nArray = this.val$completes_to_go;
                    synchronized (this.val$completes_to_go) {
                        this.val$completes_to_go[0] = this.val$completes_to_go[0] - 1;
                        this.val$main_timeout[0] = bl;
                        if (this.val$completes_to_go[0] == 0) {
                            dHTPluginOperationListener.complete(byArray, bl);
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
            };
            this.cvs_dht.get(byArray, string, by, n, l, bl, bl2, new DHTPluginOperationListener((int[])objectArray2, dHTPluginOperationListener, byArray, (boolean[])objectArray){
                final /* synthetic */ int[] val$completes_to_go;
                final /* synthetic */ DHTPluginOperationListener val$original_listener;
                final /* synthetic */ byte[] val$original_key;
                final /* synthetic */ boolean[] val$main_timeout;
                {
                    this.val$completes_to_go = nArray;
                    this.val$original_listener = dHTPluginOperationListener;
                    this.val$original_key = byArray;
                    this.val$main_timeout = blArray;
                }

                public void diversified() {
                }

                public void starts(byte[] byArray) {
                }

                public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                }

                public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void complete(byte[] byArray, boolean bl) {
                    int[] nArray = this.val$completes_to_go;
                    synchronized (this.val$completes_to_go) {
                        this.val$completes_to_go[0] = this.val$completes_to_go[0] - 1;
                        if (this.val$completes_to_go[0] == 0) {
                            this.val$original_listener.complete(this.val$original_key, this.val$main_timeout[0]);
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
        if (this.main_dht != null && this.main_v6_dht == null) {
            this.main_dht.get(byArray, string, by, n, l, bl, bl2, dHTPluginOperationListener2);
        } else if (this.main_dht == null && this.main_v6_dht != null) {
            this.main_v6_dht.get(byArray, string, by, n, l, bl, bl2, dHTPluginOperationListener2);
        } else {
            objectArray2 = byArray;
            objectArray = (byte[])byArray.clone();
            DHTPluginOperationListener dHTPluginOperationListener3 = new DHTPluginOperationListener((byte[])objectArray, l){
                private long start_time = SystemTime.getCurrentTime();
                private boolean started;
                private int complete_count = 0;
                private int result_count = 0;
                final /* synthetic */ byte[] val$v6_key;
                final /* synthetic */ long val$timeout;
                {
                    this.val$v6_key = byArray2;
                    this.val$timeout = l;
                }

                public void diversified() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void starts(byte[] byArray2) {
                    17 var2_2 = this;
                    synchronized (var2_2) {
                        if (this.started) {
                            return;
                        }
                        this.started = true;
                    }
                    dHTPluginOperationListener2.starts(byArray);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                    17 var3_3 = this;
                    synchronized (var3_3) {
                        ++this.result_count;
                        if (this.complete_count < 2) {
                            dHTPluginOperationListener2.valueRead(dHTPluginContact, dHTPluginValue);
                        }
                    }
                }

                public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                    Debug.out("eh?");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void complete(final byte[] byArray2, boolean bl) {
                    17 var3_3 = this;
                    synchronized (var3_3) {
                        ++this.complete_count;
                        if (this.complete_count == 2) {
                            dHTPluginOperationListener2.complete(byArray, this.result_count > 0 ? false : bl);
                            return;
                        }
                        if (this.complete_count > 2) {
                            return;
                        }
                        if (bl) {
                            return;
                        }
                        if (byArray2 == this.val$v6_key) {
                            return;
                        }
                        long l = SystemTime.getCurrentTime();
                        long l2 = l - this.start_time;
                        long l3 = this.val$timeout - l2;
                        if (l3 <= 0L) {
                            this.complete(byArray2, true);
                        } else {
                            SimpleTimer.addEvent("DHTPlugin:dual_dht_early_timeout", l + l3, new TimerEventPerformer(){

                                public void perform(TimerEvent timerEvent2) {
                                    this.complete(byArray2, true);
                                }
                            });
                        }
                    }
                }
            };
            this.main_dht.get((byte[])objectArray2, string, by, n, l, bl, bl2, dHTPluginOperationListener3);
            this.main_v6_dht.get((byte[])objectArray, string, by, n, l, bl, bl2, dHTPluginOperationListener3);
        }
    }

    public boolean hasLocalKey(byte[] byArray) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        return this.dhts[0].getLocalValue(byArray) != null;
    }

    public void remove(final byte[] byArray, final String string, DHTPluginOperationListener dHTPluginOperationListener) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        this.dhts[0].remove(byArray, string, dHTPluginOperationListener);
        int n = 1;
        while (n < this.dhts.length) {
            final int n2 = n++;
            new AEThread2("multi-dht: remove", true){

                public void run() {
                    DHTPlugin.this.dhts[n2].remove(byArray, string, new DHTPluginOperationListener(){

                        public void diversified() {
                        }

                        public void starts(byte[] byArray) {
                        }

                        public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                        }

                        public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                        }

                        public void complete(byte[] byArray, boolean bl) {
                        }
                    });
                }
            }.start();
        }
    }

    public void remove(DHTPluginContact[] dHTPluginContactArray, byte[] byArray, String string, DHTPluginOperationListener dHTPluginOperationListener) {
        List list;
        Object object;
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        HashMap hashMap = new HashMap();
        for (int i = 0; i < dHTPluginContactArray.length; ++i) {
            DHTPluginContactImpl dHTPluginContactImpl = (DHTPluginContactImpl)dHTPluginContactArray[i];
            object = dHTPluginContactImpl.getDHT();
            list = (List)hashMap.get(object);
            if (list == null) {
                list = new ArrayList();
                hashMap.put(object, list);
            }
            list.add(dHTPluginContactImpl);
        }
        Iterator iterator = hashMap.entrySet().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            object = iterator.next();
            list = (DHTPluginImpl)object.getKey();
            List list2 = (List)object.getValue();
            DHTPluginContact[] dHTPluginContactArray2 = new DHTPluginContact[list2.size()];
            list2.toArray(dHTPluginContactArray2);
            if (bl) {
                bl = false;
                ((DHTPluginImpl)((Object)list)).remove(dHTPluginContactArray2, byArray, string, dHTPluginOperationListener);
                continue;
            }
            ((DHTPluginImpl)((Object)list)).remove(dHTPluginContactArray2, byArray, string, new DHTPluginOperationListener(){

                public void diversified() {
                }

                public void starts(byte[] byArray) {
                }

                public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                }

                public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                }

                public void complete(byte[] byArray, boolean bl) {
                }
            });
        }
    }

    public DHTPluginContact importContact(InetSocketAddress inetSocketAddress) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        return this.dhts[0].importContact(inetSocketAddress);
    }

    public DHTPluginContact importContact(InetSocketAddress inetSocketAddress, byte by) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        for (DHTPluginImpl dHTPluginImpl : this.dhts) {
            InetAddress inetAddress2 = dHTPluginImpl.getLocalAddress().getAddress().getAddress();
            if ((!(inetAddress instanceof Inet4Address) || !(inetAddress2 instanceof Inet4Address)) && (!(inetAddress instanceof Inet6Address) || !(inetAddress2 instanceof Inet6Address))) continue;
            return dHTPluginImpl.importContact(inetSocketAddress, by);
        }
        return null;
    }

    public DHTPluginContact getLocalAddress() {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        return this.dhts[0].getLocalAddress();
    }

    public void registerHandler(byte[] byArray, DHTPluginTransferHandler dHTPluginTransferHandler) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        for (int i = 0; i < this.dhts.length; ++i) {
            this.dhts[i].registerHandler(byArray, dHTPluginTransferHandler);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public DHT[] getDHTs() {
        if (this.dhts == null) {
            return new DHT[0];
        }
        DHT[] dHTArray = new DHT[this.dhts.length];
        for (int i = 0; i < dHTArray.length; ++i) {
            dHTArray[i] = this.dhts[i].getDHT();
        }
        return dHTArray;
    }

    public DHT getDHT(int n) {
        if (this.dhts == null) {
            return null;
        }
        for (int i = 0; i < this.dhts.length; ++i) {
            if (this.dhts[i].getDHT().getTransport().getNetwork() != n) continue;
            return this.dhts[i].getDHT();
        }
        return null;
    }

    protected long loadClockSkew() {
        return this.plugin_interface.getPluginconfig().getPluginLongParameter("dht.skew", 0L);
    }

    protected void saveClockSkew() {
        long l;
        long l2 = this.loadClockSkew();
        if (Math.abs(l2 - (l = this.getClockSkew())) > 5000L) {
            this.plugin_interface.getPluginconfig().setPluginParameter("dht.skew", this.getClockSkew());
        }
    }

    public long getClockSkew() {
        if (this.dhts == null || this.dhts.length == 0) {
            return 0L;
        }
        long l = SystemTime.getMonotonousTime() - this.start_mono_time;
        if (l < 300000L) {
            return this.loadClockSkew();
        }
        long l2 = this.dhts[0].getClockSkew();
        if (l2 > 86400000L) {
            l2 = 0L;
        }
        l2 = l2 / 500L * 500L;
        return l2;
    }

    public DHTPluginKeyStats decodeStats(DHTPluginValue dHTPluginValue) {
        return this.dhts[0].decodeStats(dHTPluginValue);
    }

    public void addListener(DHTPluginListener dHTPluginListener) {
        this.listeners.add(dHTPluginListener);
    }

    public void removeListener(DHTPluginListener dHTPluginListener) {
        this.listeners.remove(dHTPluginListener);
    }

    public void log(String string) {
        this.log.log(string);
    }

    static /* synthetic */ DHTPluginImpl[] access$202(DHTPlugin dHTPlugin, DHTPluginImpl[] dHTPluginImplArray) {
        dHTPlugin.dhts = dHTPluginImplArray;
        return dHTPluginImplArray;
    }
}

