/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReaderListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerEvent;
import org.gudy.azureus2.plugins.peers.PeerListener;
import org.gudy.azureus2.plugins.peers.PeerListener2;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;

public class ExternalSeedPeer
implements Peer,
ExternalSeedReaderListener {
    private ExternalSeedPlugin plugin;
    private Download download;
    private PeerManager manager;
    private PeerStats stats;
    private Map user_data;
    private ExternalSeedReader reader;
    private int state;
    private byte[] peer_id;
    private boolean[] available;
    private boolean availabilityAdded;
    private long snubbed;
    private boolean is_optimistic;
    private Monitor connection_mon;
    private boolean peer_added;
    private List request_list = new ArrayList();
    private CopyOnWriteList listeners;
    private Monitor listeners_mon;
    private boolean doing_allocations;

    protected ExternalSeedPeer(ExternalSeedPlugin externalSeedPlugin, Download download, ExternalSeedReader externalSeedReader) {
        this.plugin = externalSeedPlugin;
        this.download = download;
        this.reader = externalSeedReader;
        this.connection_mon = this.plugin.getPluginInterface().getUtilities().getMonitor();
        Torrent torrent = this.reader.getTorrent();
        this.available = new boolean[(int)torrent.getPieceCount()];
        Arrays.fill(this.available, true);
        this.peer_id = new byte[20];
        new Random().nextBytes(this.peer_id);
        this.peer_id[0] = 69;
        this.peer_id[1] = 120;
        this.peer_id[2] = 116;
        this.peer_id[3] = 32;
        this.listeners = new CopyOnWriteList();
        this.listeners_mon = this.plugin.getPluginInterface().getUtilities().getMonitor();
        externalSeedReader.addListener(this);
    }

    protected boolean sameAs(ExternalSeedPeer externalSeedPeer) {
        return this.reader.sameAs(externalSeedPeer.reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setManager(PeerManager peerManager) {
        this.setState(10);
        try {
            this.connection_mon.enter();
            this.manager = peerManager;
            this.stats = this.manager == null ? null : this.manager.createPeerStats(this);
            this.checkConnection();
            Object var3_2 = null;
            this.connection_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.connection_mon.exit();
            throw throwable;
        }
    }

    public PeerManager getManager() {
        return this.manager;
    }

    protected Download getDownload() {
        return this.download;
    }

    protected ExternalSeedReader getReader() {
        return this.reader;
    }

    protected void setState(int n) {
        this.state = n;
        this.fireEvent(1, new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkConnection() {
        boolean bl = false;
        try {
            this.connection_mon.enter();
            boolean bl2 = this.reader.checkActivation(this.manager, this);
            if (this.manager != null && bl2 != this.peer_added) {
                bl = true;
                boolean bl3 = this.peer_added;
                this.peer_added = bl2;
                if (bl2) {
                    this.addPeer();
                } else if (bl3) {
                    this.removePeer();
                }
            }
            Object var5_4 = null;
            this.connection_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.connection_mon.exit();
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPeer() {
        this.setState(20);
        this.manager.addPeer(this);
        if (this.peer_added) {
            this.setState(30);
            try {
                this.listeners_mon.enter();
                if (this.availabilityAdded) {
                    Debug.out("availabililty already added");
                } else {
                    this.availabilityAdded = true;
                    this.fireEvent(3, this.getAvailable());
                }
                Object var2_1 = null;
                this.listeners_mon.exit();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.listeners_mon.exit();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePeer() {
        this.setState(40);
        try {
            this.listeners_mon.enter();
            if (this.availabilityAdded) {
                this.availabilityAdded = false;
                this.fireEvent(4, this.getAvailable());
            }
            Object var2_1 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
        this.manager.removePeer(this);
        this.setState(50);
    }

    public void requestComplete(PeerReadRequest peerReadRequest, PooledByteBuffer pooledByteBuffer) {
        PeerManager peerManager = this.manager;
        if (peerReadRequest.isCancelled() || peerManager == null) {
            pooledByteBuffer.returnToPool();
        } else {
            try {
                peerManager.requestComplete(peerReadRequest, pooledByteBuffer, this);
            }
            catch (Throwable throwable) {
                pooledByteBuffer.returnToPool();
                throwable.printStackTrace();
            }
        }
    }

    public void requestCancelled(PeerReadRequest peerReadRequest) {
        PeerManager peerManager = this.manager;
        if (peerManager != null) {
            peerManager.requestCancelled(peerReadRequest, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFailed(PeerReadRequest peerReadRequest) {
        PeerManager peerManager = this.manager;
        if (peerManager != null) {
            peerManager.requestCancelled(peerReadRequest, this);
            try {
                this.connection_mon.enter();
                if (this.peer_added) {
                    this.plugin.log(this.reader.getName() + " failed - " + this.reader.getStatus() + ", permanent = " + this.reader.isPermanentlyUnavailable());
                    this.peer_added = false;
                    this.removePeer();
                }
                Object var4_3 = null;
                this.connection_mon.exit();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.connection_mon.exit();
                throw throwable;
            }
            if (this.reader.isTransient() && this.reader.isPermanentlyUnavailable()) {
                this.plugin.removePeer(this);
            }
        }
    }

    public int getState() {
        return this.state;
    }

    public byte[] getId() {
        return this.peer_id;
    }

    public String getIp() {
        return this.reader.getIP();
    }

    public int getTCPListenPort() {
        return 0;
    }

    public int getUDPListenPort() {
        return 0;
    }

    public int getUDPNonDataListenPort() {
        return 0;
    }

    public int getPort() {
        return this.reader.getPort();
    }

    public final boolean[] getAvailable() {
        return this.available;
    }

    public final boolean isPieceAvailable(int n) {
        return true;
    }

    public boolean isTransferAvailable() {
        return this.reader.isActive();
    }

    public boolean isDownloadPossible() {
        return this.peer_added && this.reader.isActive();
    }

    public boolean isChoked() {
        return false;
    }

    public boolean isChoking() {
        return false;
    }

    public boolean isInterested() {
        return false;
    }

    public boolean isInteresting() {
        return true;
    }

    public boolean isSeed() {
        return true;
    }

    public boolean isSnubbed() {
        if (this.snubbed != 0L && this.reader.getRequestCount() == 0) {
            this.snubbed = 0L;
        }
        return this.snubbed != 0L;
    }

    public long getSnubbedTime() {
        if (!this.isSnubbed()) {
            return 0L;
        }
        long l = this.plugin.getPluginInterface().getUtilities().getCurrentSystemTime();
        if (l < this.snubbed) {
            this.snubbed = l - 26L;
        }
        return l - this.snubbed;
    }

    public void setSnubbed(boolean bl) {
        if (!bl) {
            this.snubbed = 0L;
        } else if (this.snubbed == 0L) {
            this.snubbed = this.plugin.getPluginInterface().getUtilities().getCurrentSystemTime();
        }
    }

    public boolean isOptimisticUnchoke() {
        return this.is_optimistic;
    }

    public void setOptimisticUnchoke(boolean bl) {
        this.is_optimistic = bl;
    }

    public PeerStats getStats() {
        return this.stats;
    }

    public boolean isIncoming() {
        return false;
    }

    public int getPercentDone() {
        return 1000;
    }

    public int getPercentDoneInThousandNotation() {
        return 1000;
    }

    public String getClient() {
        return this.reader.getName();
    }

    public List getExpiredRequests() {
        return this.reader.getExpiredRequests();
    }

    public List getRequests() {
        return this.reader.getRequests();
    }

    public int getMaximumNumberOfRequests() {
        return this.reader.getMaximumNumberOfRequests();
    }

    public int getNumberOfRequests() {
        return this.reader.getRequestCount() + this.request_list.size();
    }

    public int[] getPriorityOffsets() {
        return this.reader.getPriorityOffsets();
    }

    public boolean requestAllocationStarts(int[] nArray) {
        PeerManager peerManager;
        if (this.doing_allocations) {
            Debug.out("recursive allocations");
        }
        this.doing_allocations = true;
        if (this.request_list.size() != 0) {
            Debug.out("req list must be empty");
        }
        if ((peerManager = this.manager) != null) {
            this.reader.calculatePriorityOffsets(peerManager, nArray);
        }
        return true;
    }

    public void requestAllocationComplete() {
        this.reader.addRequests(this.request_list);
        this.request_list.clear();
        this.doing_allocations = false;
    }

    public boolean addRequest(PeerReadRequest peerReadRequest) {
        if (!this.doing_allocations) {
            Debug.out("request added when not in allocation phase");
        }
        this.request_list.add(peerReadRequest);
        this.snubbed = 0L;
        return true;
    }

    public void cancelRequest(PeerReadRequest peerReadRequest) {
        this.reader.cancelRequest(peerReadRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String string, boolean bl, boolean bl2) {
        boolean bl3;
        try {
            this.connection_mon.enter();
            bl3 = this.peer_added;
            this.reader.cancelAllRequests();
            this.reader.deactivate(string);
            this.peer_added = false;
            try {
                this.listeners_mon.enter();
                if (this.availabilityAdded) {
                    this.availabilityAdded = false;
                    this.fireEvent(4, this.getAvailable());
                }
                Object var6_5 = null;
                this.listeners_mon.exit();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.listeners_mon.exit();
                throw throwable;
            }
            Object var8_8 = null;
            this.connection_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.connection_mon.exit();
            throw throwable;
        }
        if (bl3) {
            this.manager.removePeer(this);
        }
        this.setState(50);
        if (this.reader.isTransient()) {
            this.plugin.removePeer(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PeerListener peerListener) {
        try {
            this.listeners_mon.enter();
            this.listeners.add(peerListener);
            Object var3_2 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PeerListener peerListener) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(peerListener);
            Object var3_2 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PeerListener2 peerListener2) {
        try {
            this.listeners_mon.enter();
            this.listeners.add(peerListener2);
            Object var3_2 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PeerListener2 peerListener2) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(peerListener2);
            Object var3_2 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(final int n, final Object object) {
        try {
            this.listeners_mon.enter();
            List list = this.listeners.getList();
            for (int i = 0; i < list.size(); ++i) {
                try {
                    Object object2;
                    Object t = list.get(i);
                    if (t instanceof PeerListener) {
                        object2 = (PeerListener)t;
                        if (n == 1) {
                            object2.stateChanged((Integer)object);
                            continue;
                        }
                        if (n != 2) continue;
                        Integer[] integerArray = (Integer[])object;
                        object2.sentBadChunk(integerArray[0], integerArray[1]);
                        continue;
                    }
                    object2 = (PeerListener2)t;
                    object2.eventOccurred(new PeerEvent(){

                        public int getType() {
                            return n;
                        }

                        public Object getData() {
                            return object;
                        }
                    });
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            Object var9_9 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    public Connection getConnection() {
        return null;
    }

    public boolean supportsMessaging() {
        return false;
    }

    public Message[] getSupportedMessages() {
        return new Message[0];
    }

    public int readBytes(int n) {
        int n2 = this.reader.readBytes(n);
        if (n2 > 0) {
            this.stats.received(n2);
        }
        return n2;
    }

    public int writeBytes(int n) {
        throw new RuntimeException("Not supported");
    }

    public int getPercentDoneOfCurrentIncomingRequest() {
        return this.reader.getPercentDoneOfCurrentIncomingRequest();
    }

    public int getPercentDoneOfCurrentOutgoingRequest() {
        return 0;
    }

    public Map getProperties() {
        return new HashMap();
    }

    public String getName() {
        return this.reader.getName();
    }

    public void setUserData(Object object, Object object2) {
        if (this.user_data == null) {
            this.user_data = new HashMap();
        }
        this.user_data.put(object, object2);
    }

    public Object getUserData(Object object) {
        if (this.user_data == null) {
            return null;
        }
        return this.user_data.get(object);
    }

    public byte[] getHandshakeReservedBytes() {
        return null;
    }

    public boolean isPriorityConnection() {
        return false;
    }

    public void setPriorityConnection(boolean bl) {
    }
}

