/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed;

import com.aelitis.azureus.plugins.extseed.ExternalSeedManualPeer;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPeer;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReaderFactory;
import com.aelitis.azureus.plugins.extseed.impl.getright.ExternalSeedReaderFactoryGetRight;
import com.aelitis.azureus.plugins.extseed.impl.webseed.ExternalSeedReaderFactoryWebSeed;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadManagerStats;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.components.UITextField;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;
import org.gudy.azureus2.plugins.utils.Utilities;

public class ExternalSeedPlugin
implements Plugin,
DownloadManagerListener {
    private static ExternalSeedReaderFactory[] factories = new ExternalSeedReaderFactory[]{new ExternalSeedReaderFactoryGetRight(), new ExternalSeedReaderFactoryWebSeed()};
    private PluginInterface plugin_interface;
    private DownloadManagerStats dm_stats;
    private UITextField status_field;
    private LoggerChannel log;
    private Random random = new Random();
    private Map download_map = new HashMap();
    private Monitor download_mon;

    public static void load(PluginInterface pluginInterface) {
        pluginInterface.getPluginProperties().setProperty("plugin.version", "1.0");
        pluginInterface.getPluginProperties().setProperty("plugin.name", "External Seed");
    }

    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.dm_stats = this.plugin_interface.getDownloadManager().getStats();
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel("External Seeds");
        final BasicPluginViewModel basicPluginViewModel = this.plugin_interface.getUIManager().createBasicPluginViewModel("Plugin.extseed.name");
        basicPluginViewModel.getActivity().setVisible(false);
        basicPluginViewModel.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int n, String string) {
                basicPluginViewModel.getLogArea().appendText(string + "\n");
            }

            public void messageLogged(String string, Throwable throwable) {
                if (string.length() > 0) {
                    basicPluginViewModel.getLogArea().appendText(string + "\n");
                }
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                basicPluginViewModel.getLogArea().appendText(stringWriter.toString() + "\n");
            }
        });
        this.status_field = basicPluginViewModel.getStatus();
        this.setStatus("Initialising");
        this.download_mon = this.plugin_interface.getUtilities().getMonitor();
        Utilities utilities = this.plugin_interface.getUtilities();
        DelayedTask delayedTask = this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

            public void run() {
                AEThread2 aEThread2 = new AEThread2("ExternalSeedInitialise", true){

                    public void run() {
                        ExternalSeedPlugin.this.setStatus("Running");
                        ExternalSeedPlugin.this.plugin_interface.getDownloadManager().addListener(ExternalSeedPlugin.this);
                    }
                };
                aEThread2.setPriority(1);
                aEThread2.start();
            }
        });
        delayedTask.queue();
        UTTimer uTTimer = utilities.createTimer("ExternalPeerScheduler", true);
        uTTimer.addPeriodicEvent(5000L, new UTTimerEventPerformer(){

            public void perform(UTTimerEvent uTTimerEvent) {
                try {
                    Iterator iterator = ExternalSeedPlugin.this.download_map.values().iterator();
                    while (iterator.hasNext()) {
                        List list = ExternalSeedPlugin.this.randomiseList((List)iterator.next());
                        for (int i = 0; i < list.size() && !((ExternalSeedPeer)list.get(i)).checkConnection(); ++i) {
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public void downloadAdded(Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent == null) {
            return;
        }
        ArrayList<ExternalSeedPeer> arrayList = new ArrayList<ExternalSeedPeer>();
        for (int i = 0; i < factories.length; ++i) {
            ExternalSeedReader[] externalSeedReaderArray = factories[i].getSeedReaders(this, download);
            for (int j = 0; j < externalSeedReaderArray.length; ++j) {
                ExternalSeedReader externalSeedReader = externalSeedReaderArray[j];
                ExternalSeedPeer externalSeedPeer = new ExternalSeedPeer(this, download, externalSeedReader);
                arrayList.add(externalSeedPeer);
            }
        }
        this.addPeers(download, arrayList);
    }

    public void downloadChanged(Download download) {
        this.downloadRemoved(download);
        this.downloadAdded(download);
    }

    public void addSeed(Download download, Map map) {
        Torrent torrent = download.getTorrent();
        if (torrent == null) {
            return;
        }
        ArrayList<ExternalSeedPeer> arrayList = new ArrayList<ExternalSeedPeer>();
        for (int i = 0; i < factories.length; ++i) {
            ExternalSeedReader[] externalSeedReaderArray = factories[i].getSeedReaders(this, download, map);
            for (int j = 0; j < externalSeedReaderArray.length; ++j) {
                ExternalSeedReader externalSeedReader = externalSeedReaderArray[j];
                ExternalSeedPeer externalSeedPeer = new ExternalSeedPeer(this, download, externalSeedReader);
                arrayList.add(externalSeedPeer);
            }
        }
        this.addPeers(download, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPeers(final Download download, List list) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        if (arrayList.size() > 0) {
            ExternalSeedPeer externalSeedPeer;
            Object object;
            boolean bl = false;
            try {
                this.download_mon.enter();
                object = (ArrayList)this.download_map.get(download);
                if (object == null) {
                    bl = true;
                    object = new ArrayList();
                    this.download_map.put(download, object);
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    externalSeedPeer = (ExternalSeedPeer)iterator.next();
                    boolean bl2 = false;
                    for (int i = 0; i < object.size(); ++i) {
                        ExternalSeedPeer externalSeedPeer2 = (ExternalSeedPeer)object.get(i);
                        if (!externalSeedPeer2.sameAs(externalSeedPeer)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) {
                        iterator.remove();
                        continue;
                    }
                    this.log(download.getName() + " found seed " + externalSeedPeer.getName());
                    object.add(externalSeedPeer);
                }
                this.setStatus("Running: Downloads with external seeds = " + this.download_map.size());
                Object var12_12 = null;
                this.download_mon.exit();
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                this.download_mon.exit();
                throw throwable;
            }
            if (bl) {
                download.addPeerListener(new DownloadPeerListener(){

                    public void peerManagerAdded(Download download2, PeerManager peerManager) {
                        List list = this.getPeers();
                        if (list == null) {
                            return;
                        }
                        for (int i = 0; i < list.size(); ++i) {
                            ExternalSeedPeer externalSeedPeer = (ExternalSeedPeer)list.get(i);
                            externalSeedPeer.setManager(peerManager);
                        }
                    }

                    public void peerManagerRemoved(Download download2, PeerManager peerManager) {
                        List list = this.getPeers();
                        if (list == null) {
                            return;
                        }
                        for (int i = 0; i < list.size(); ++i) {
                            ExternalSeedPeer externalSeedPeer = (ExternalSeedPeer)list.get(i);
                            externalSeedPeer.setManager(null);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected List getPeers() {
                        ArrayList arrayList = null;
                        try {
                            ExternalSeedPlugin.this.download_mon.enter();
                            List list = (List)ExternalSeedPlugin.this.download_map.get(download);
                            if (list != null) {
                                arrayList = new ArrayList(list.size());
                                arrayList.addAll(list);
                            }
                            Object var4_3 = null;
                            ExternalSeedPlugin.this.download_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            ExternalSeedPlugin.this.download_mon.exit();
                            throw throwable;
                        }
                        return arrayList;
                    }
                });
            } else {
                object = download.getPeerManager();
                if (object != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        externalSeedPeer = (ExternalSeedPeer)arrayList.get(i);
                        if (externalSeedPeer.getManager() != null) continue;
                        externalSeedPeer.setManager((PeerManager)object);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePeer(ExternalSeedPeer externalSeedPeer) {
        Download download = externalSeedPeer.getDownload();
        try {
            this.download_mon.enter();
            List list = (List)this.download_map.get(download);
            if (list != null && list.remove(externalSeedPeer)) {
                this.log(download.getName() + " removed seed " + externalSeedPeer.getName());
            }
            Object var5_4 = null;
            this.download_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.download_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadRemoved(Download download) {
        try {
            this.download_mon.enter();
            this.download_map.remove(download);
            this.setStatus("Running: Downloads with external seeds = " + this.download_map.size());
            Object var3_2 = null;
            this.download_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.download_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalSeedManualPeer[] getManualWebSeeds(Download download) {
        try {
            this.download_mon.enter();
            List list = (List)this.download_map.get(download);
            ExternalSeedManualPeer[] externalSeedManualPeerArray = new ExternalSeedManualPeer[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                externalSeedManualPeerArray[i] = new ExternalSeedManualPeer((ExternalSeedPeer)list.get(i));
            }
            ExternalSeedManualPeer[] externalSeedManualPeerArray2 = externalSeedManualPeerArray;
            Object var6_6 = null;
            this.download_mon.exit();
            return externalSeedManualPeerArray2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.download_mon.exit();
            throw throwable;
        }
    }

    public int getGlobalDownloadRateBytesPerSec() {
        return this.dm_stats.getDataAndProtocolReceiveRate();
    }

    protected void setStatus(String string) {
        this.status_field.setText(string);
    }

    public void log(String string) {
        this.log.log(string);
    }

    public void log(String string, Throwable throwable) {
        this.log.log(string, throwable);
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    protected List randomiseList(List list) {
        if (list.size() < 2) {
            return list;
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(this.random.nextInt(arrayList.size() + 1), list.get(i));
        }
        return arrayList;
    }
}

