/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl;

import com.aelitis.azureus.core.util.CopyOnWriteSet;
import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPeer;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReaderListener;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderRequest;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerEvent;
import org.gudy.azureus2.plugins.peers.PeerManagerListener2;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.plugins.peers.Piece;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.plugins.utils.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExternalSeedReaderImpl
implements ExternalSeedReader,
PeerManagerListener2 {
    public static final int RECONNECT_DEFAULT = 30000;
    public static final int INITIAL_DELAY = 30000;
    public static final int STALLED_DOWNLOAD_SPEED = 20480;
    public static final int STALLED_PEER_SPEED = 5120;
    public static final int TOP_PIECE_PRIORITY = 100000;
    private ExternalSeedPlugin plugin;
    private Torrent torrent;
    private String host;
    private String ip_use_accessor;
    private String status;
    private boolean active;
    private boolean permanent_fail;
    private long last_failed_read;
    private int consec_failures;
    private String user_agent;
    private long peer_manager_change_time;
    private volatile PeerManager current_manager;
    private List<PeerReadRequest> requests = new LinkedList<PeerReadRequest>();
    private List<PeerReadRequest> dangling_requests;
    private Thread request_thread;
    private Semaphore request_sem;
    private Monitor requests_mon;
    private ExternalSeedReaderRequest active_read_request;
    private int[] priority_offsets;
    private boolean fast_activate;
    private int min_availability;
    private int min_download_speed;
    private int max_peer_speed;
    private long valid_until;
    private boolean transient_seed;
    private int reconnect_delay = 30000;
    private volatile ExternalSeedReaderRequest current_request;
    private List listeners = new ArrayList();
    private AESemaphore rate_sem = new AESemaphore("ExternalSeedReaderRequest");
    private int rate_bytes_read;
    private int rate_bytes_permitted;
    private volatile CopyOnWriteSet<MutableInteger> bad_pieces = new CopyOnWriteSet();

    protected ExternalSeedReaderImpl(ExternalSeedPlugin externalSeedPlugin, Torrent torrent, String string, Map map) {
        this.plugin = externalSeedPlugin;
        this.torrent = torrent;
        this.host = string;
        this.fast_activate = this.getBooleanParam(map, "fast_start", false);
        this.min_availability = this.getIntParam(map, "min_avail", 1);
        this.min_download_speed = this.getIntParam(map, "min_speed", 0);
        this.max_peer_speed = this.getIntParam(map, "max_speed", 0);
        this.valid_until = this.getIntParam(map, "valid_ms", 0);
        if (this.valid_until > 0L) {
            this.valid_until += this.getSystemTime();
        }
        this.transient_seed = this.getBooleanParam(map, "transient", false);
        this.requests_mon = this.plugin.getPluginInterface().getUtilities().getMonitor();
        this.request_sem = this.plugin.getPluginInterface().getUtilities().getSemaphore();
        PluginInterface pluginInterface = this.plugin.getPluginInterface();
        this.user_agent = pluginInterface.getAzureusName();
        try {
            Properties properties = new Properties();
            pluginInterface.getClientIDManager().getGenerator().generateHTTPProperties(properties);
            String string2 = properties.getProperty("User-Agent");
            if (string2 != null) {
                this.user_agent = string2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setActive(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIP() {
        String string = this.host;
        synchronized (string) {
            if (this.ip_use_accessor == null) {
                try {
                    this.ip_use_accessor = HostNameToIPResolver.syncResolve(this.host).getHostAddress();
                }
                catch (Throwable throwable) {
                    this.ip_use_accessor = this.host;
                    Debug.out(throwable);
                }
            }
            return this.ip_use_accessor;
        }
    }

    @Override
    public Torrent getTorrent() {
        return this.torrent;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public boolean isTransient() {
        return this.transient_seed;
    }

    protected void log(String string) {
        this.plugin.log(string);
    }

    protected String getUserAgent() {
        return this.user_agent;
    }

    protected long getSystemTime() {
        return this.plugin.getPluginInterface().getUtilities().getCurrentSystemTime();
    }

    protected int getFailureCount() {
        return this.consec_failures;
    }

    protected long getLastFailTime() {
        return this.last_failed_read;
    }

    @Override
    public boolean isPermanentlyUnavailable() {
        return this.permanent_fail;
    }

    protected void setReconnectDelay(int n, boolean bl) {
        this.reconnect_delay = n;
        if (bl) {
            this.consec_failures = 0;
        }
    }

    @Override
    public void eventOccurred(PeerManagerEvent peerManagerEvent) {
        if (peerManagerEvent.getType() == 4 && peerManagerEvent.getPeer().getIp().equals(this.getIP())) {
            if (this.bad_pieces.size() > 128) {
                return;
            }
            this.bad_pieces.add(new MutableInteger((Integer)peerManagerEvent.getData()));
        }
    }

    protected boolean readyToActivate(PeerManager peerManager, Peer peer, long l) {
        boolean bl = l < 30000L;
        try {
            int n = this.getFailureCount();
            if (n > 0) {
                int n2 = this.reconnect_delay;
                for (int i = 1; i < n && (n2 += n2) <= 1800000; ++i) {
                }
                long l2 = this.getSystemTime();
                long l3 = this.getLastFailTime();
                if (l3 < l2 && l2 - l3 < (long)n2) {
                    return false;
                }
            }
            if (this.valid_until > 0L && this.getSystemTime() > this.valid_until) {
                return false;
            }
            if (peerManager.getDownload().getState() != 4) {
                return false;
            }
            if (peerManager.getDownload().isComplete()) {
                return false;
            }
            if (this.transient_seed) {
                int n3;
                Peer[] peerArray = peerManager.getPeers(this.getIP());
                int n4 = peerArray.length;
                int n5 = TransferSpeedValidator.getGlobalDownloadRateLimitBytesPerSecond();
                if (n5 > 0 && n5 - (n3 = this.plugin.getGlobalDownloadRateBytesPerSec()) < 5120) {
                    return false;
                }
                int n6 = peerManager.getDownloadRateLimitBytesPerSecond();
                if (n5 > 0 && n5 < n6) {
                    n6 = n5;
                }
                if ((n6 == 0 || n6 > 25600) && peerManager.getStats().getDownloadAverage() < 20480L) {
                    for (int i = 0; i < peerArray.length; ++i) {
                        PeerStats peerStats;
                        Peer peer2 = peerArray[i];
                        if (peer2 instanceof ExternalSeedPeer || (peerStats = peer2.getStats()).getTimeSinceConnectionEstablished() <= 30000L || peerStats.getDownloadAverage() >= 5120) continue;
                        peer2.close("Replacing slow peer with web-seed", false, false);
                        --n4;
                    }
                }
                if (n4 == 0 && peerManager.getPendingPeers(this.getIP()).length == 0) {
                    this.log(this.getName() + ": activating as transient seed and nothing blocking it");
                    return true;
                }
            }
            if (this.fast_activate || !bl) {
                float f;
                if (this.min_availability > 0 && (f = peerManager.getDownload().getStats().getAvailability()) < (float)this.min_availability) {
                    this.log(this.getName() + ": activating as availability is poor");
                    return true;
                }
                if (this.min_download_speed > 0 && peerManager.getStats().getDownloadAverage() < (long)this.min_download_speed) {
                    this.log(this.getName() + ": activating as speed is slow");
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        return false;
    }

    protected boolean readyToDeactivate(PeerManager peerManager, Peer peer) {
        try {
            float f;
            if (this.valid_until > 0L && this.getSystemTime() > this.valid_until) {
                return true;
            }
            if (peerManager.getDownload().getState() == 5) {
                return true;
            }
            if (this.transient_seed) {
                return false;
            }
            boolean bl = false;
            String string = "";
            if (this.min_availability > 0 && (f = peerManager.getDownload().getStats().getAvailability()) >= (float)(this.min_availability + 1)) {
                string = "availability is good";
                bl = true;
            }
            if (this.min_download_speed > 0) {
                long l = peer.getStats().getDownloadAverage();
                long l2 = peerManager.getStats().getDownloadAverage();
                if (l2 - l > (long)(2 * this.min_download_speed)) {
                    string = string + (string.length() == 0 ? "" : ", ") + "speed is good";
                    bl = true;
                } else {
                    bl = false;
                }
            }
            if (bl) {
                this.log(this.getName() + ": deactivating as " + string);
                return true;
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        return false;
    }

    @Override
    public boolean checkActivation(PeerManager peerManager, Peer peer) {
        long l = this.getSystemTime();
        if (peerManager == this.current_manager) {
            if (this.peer_manager_change_time > l) {
                this.peer_manager_change_time = l;
            }
            long l2 = l - this.peer_manager_change_time;
            if (peerManager != null) {
                if (this.active) {
                    PeerStats peerStats;
                    if (l - this.peer_manager_change_time > 30000L && this.readyToDeactivate(peerManager, peer)) {
                        this.setActive(peerManager, false);
                    } else if (this.max_peer_speed > 0 && (peerStats = peer.getStats()) != null && peerStats.getDownloadRateLimit() != this.max_peer_speed) {
                        peerStats.setDownloadRateLimit(this.max_peer_speed);
                    }
                } else if (!this.isPermanentlyUnavailable() && this.readyToActivate(peerManager, peer, l2)) {
                    PeerStats peerStats;
                    if (this.max_peer_speed > 0 && (peerStats = peer.getStats()) != null) {
                        peerStats.setDownloadRateLimit(this.max_peer_speed);
                    }
                    this.setActive(peerManager, true);
                }
            }
        } else {
            this.peer_manager_change_time = l;
            PeerManager peerManager2 = this.current_manager;
            if (this.current_manager != null) {
                this.current_manager.removeListener(this);
            }
            this.current_manager = peerManager;
            if (this.current_manager != null) {
                this.current_manager.addListener(this);
            }
            this.setActive(peerManager2, false);
        }
        return this.active;
    }

    @Override
    public void deactivate(String string) {
        this.plugin.log(this.getName() + ": deactivating (" + string + ")");
        this.checkActivation(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setActive(PeerManager peerManager, boolean bl) {
        try {
            this.requests_mon.enter();
            this.active = bl;
            this.status = this.active ? "Active" : "Idle";
            this.setActiveSupport(peerManager, bl);
            Object var4_3 = null;
            this.requests_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.requests_mon.exit();
            throw throwable;
        }
    }

    protected void setActiveSupport(PeerManager peerManager, boolean bl) {
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequests() {
        try {
            this.requests_mon.enter();
            if (this.request_thread != null) {
                Object var2_1 = null;
                this.requests_mon.exit();
                return;
            }
            this.request_thread = Thread.currentThread();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.requests_mon.exit();
            throw throwable;
        }
        PeerReadRequest peerReadRequest = null;
        this.requests_mon.exit();
        block8: while (true) {
            try {
                while (true) {
                    Object var7_15;
                    if (!this.request_sem.reserve(30000L)) {
                        try {
                            this.requests_mon.enter();
                            if (this.requests.size() == 0) {
                                this.dangling_requests = null;
                                this.request_thread = null;
                                Object var4_10 = null;
                                this.requests_mon.exit();
                                break block8;
                            }
                            Object var4_11 = null;
                            this.requests_mon.exit();
                            continue block8;
                        }
                        catch (Throwable throwable) {
                            Object var4_12 = null;
                            this.requests_mon.exit();
                            throw throwable;
                        }
                    }
                    ArrayList<PeerReadRequest> arrayList = new ArrayList<PeerReadRequest>();
                    peerReadRequest = null;
                    try {
                        this.requests_mon.enter();
                        int n = this.selectRequests(this.requests);
                        if (n <= 0 || n > this.requests.size()) {
                            Debug.out("invalid count");
                            n = 1;
                        }
                        for (int i = 0; i < n; ++i) {
                            PeerReadRequest peerReadRequest2 = this.requests.remove(0);
                            if (peerReadRequest2.isCancelled()) {
                                if (i == 0) {
                                    peerReadRequest = peerReadRequest2;
                                    break;
                                }
                                this.requests.add(0, peerReadRequest2);
                                break;
                            }
                            arrayList.add(peerReadRequest2);
                            if (i <= 0) continue;
                            this.request_sem.reserve();
                        }
                        this.dangling_requests = new ArrayList<PeerReadRequest>(arrayList);
                        var7_15 = null;
                        this.requests_mon.exit();
                    }
                    catch (Throwable throwable) {
                        var7_15 = null;
                        this.requests_mon.exit();
                        throw throwable;
                    }
                    if (peerReadRequest != null) {
                        this.informCancelled(peerReadRequest);
                        continue;
                    }
                    this.processRequests(arrayList);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readBytes(int n) {
        int n2 = 0;
        AESemaphore aESemaphore = this.rate_sem;
        synchronized (aESemaphore) {
            int n3;
            if (this.rate_bytes_read > 0) {
                n2 = this.rate_bytes_read;
                if (n2 > n) {
                    n2 = n;
                }
                this.rate_bytes_read -= n2;
            }
            if ((n3 = n - n2) > this.rate_bytes_permitted) {
                if (this.rate_bytes_permitted == 0) {
                    this.rate_sem.release();
                }
                this.rate_bytes_permitted = n3;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPermittedBytes() throws ExternalSeedException {
        AESemaphore aESemaphore = this.rate_sem;
        synchronized (aESemaphore) {
            if (this.rate_bytes_permitted > 0) {
                return this.rate_bytes_permitted;
            }
        }
        if (!this.rate_sem.reserve(1000L)) {
            return 1;
        }
        return this.rate_bytes_permitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportBytesRead(int n) {
        AESemaphore aESemaphore = this.rate_sem;
        synchronized (aESemaphore) {
            this.rate_bytes_read += n;
            this.rate_bytes_permitted -= n;
            if (this.rate_bytes_permitted < 0) {
                this.rate_bytes_permitted = 0;
            }
        }
    }

    @Override
    public int getPercentDoneOfCurrentIncomingRequest() {
        ExternalSeedReaderRequest externalSeedReaderRequest = this.current_request;
        if (externalSeedReaderRequest == null) {
            return 0;
        }
        return externalSeedReaderRequest.getPercentDoneOfCurrentIncomingRequest();
    }

    @Override
    public int getMaximumNumberOfRequests() {
        if (this.getRequestCount() == 0) {
            return (int)((long)this.getPieceGroupSize() * this.torrent.getPieceSize() / 16384L);
        }
        return 0;
    }

    @Override
    public void calculatePriorityOffsets(PeerManager peerManager, int[] nArray) {
        try {
            int n;
            Piece[] pieceArray = peerManager.getPieces();
            int n2 = this.getPieceGroupSize();
            int[] nArray2 = new int[n2];
            int[] nArray3 = new int[n2];
            Arrays.fill(nArray3, -1);
            int n3 = 0;
            int n4 = -1;
            int n5 = 0;
            int n6 = 0;
            int n7 = -1;
            MutableInteger mutableInteger2 = new MutableInteger(0);
            for (n = 0; n < pieceArray.length; ++n) {
                int n8;
                mutableInteger2.setValue(n);
                if (this.bad_pieces.contains(mutableInteger2)) continue;
                Piece piece = pieceArray[n];
                if (piece.isFullyAllocatable()) {
                    ++n3;
                    n8 = nArray[n];
                    if (n8 > n4) {
                        n4 = n8;
                    }
                    for (int i = 0; i < n3 && i < nArray3.length; ++i) {
                        if (n4 > nArray3[i]) {
                            nArray3[i] = n4;
                            nArray2[i] = n - i;
                        }
                        if (i + 1 <= n5) continue;
                        n5 = i + 1;
                    }
                    continue;
                }
                n3 = 0;
                n4 = -1;
                if (n5 != 0 || (n8 = piece.getAllocatableRequestCount()) <= n6) continue;
                n6 = n8;
                n7 = n;
            }
            if (n5 == 0) {
                if (n7 >= 0) {
                    this.priority_offsets = new int[(int)this.getTorrent().getPieceCount()];
                    this.priority_offsets[n7] = 100000;
                } else {
                    this.priority_offsets = null;
                }
            } else {
                this.priority_offsets = new int[(int)this.getTorrent().getPieceCount()];
                for (int i = n = nArray2[n5 - 1]; i < n + n5; ++i) {
                    this.priority_offsets[i] = 100000 - (i - n);
                }
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            this.priority_offsets = null;
        }
    }

    protected abstract int getPieceGroupSize();

    protected abstract boolean getRequestCanSpanPieces();

    @Override
    public int[] getPriorityOffsets() {
        return this.priority_offsets;
    }

    protected int selectRequests(List<PeerReadRequest> list) {
        long l = -1L;
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            PeerReadRequest peerReadRequest = list.get(i);
            int n2 = peerReadRequest.getPieceNumber();
            if (n != -1 && n != n2 && !this.getRequestCanSpanPieces()) {
                return i;
            }
            long l2 = (long)n2 * this.torrent.getPieceSize() + (long)peerReadRequest.getOffset();
            if (l != -1L && l2 != l) {
                return i;
            }
            l = l2 + (long)peerReadRequest.getLength();
            n = n2;
        }
        return list.size();
    }

    @Override
    public byte[] read(int n, int n2, int n3, final int n4) throws ExternalSeedException {
        final byte[] byArray = new byte[n3];
        ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener = new ExternalSeedHTTPDownloaderListener(){
            private int bp;
            private long start_time = SystemTime.getCurrentTime();

            public byte[] getBuffer() throws ExternalSeedException {
                return byArray;
            }

            public void setBufferPosition(int n) {
                this.bp = n;
            }

            public int getBufferPosition() {
                return this.bp;
            }

            public int getBufferLength() {
                return byArray.length;
            }

            public int getPermittedBytes() throws ExternalSeedException {
                return byArray.length;
            }

            public int getPermittedTime() {
                if (n4 == 0) {
                    return 0;
                }
                int n = n4 - (int)(SystemTime.getCurrentTime() - this.start_time);
                if (n <= 0) {
                    return -1;
                }
                return n;
            }

            public void reportBytesRead(int n) {
            }

            public boolean isCancelled() {
                return false;
            }

            public void done() {
            }
        };
        this.readData(n, n2, n3, externalSeedHTTPDownloaderListener);
        return byArray;
    }

    protected void readData(ExternalSeedReaderRequest externalSeedReaderRequest) throws ExternalSeedException {
        this.readData(externalSeedReaderRequest.getStartPieceNumber(), externalSeedReaderRequest.getStartPieceOffset(), externalSeedReaderRequest.getLength(), externalSeedReaderRequest);
    }

    protected abstract void readData(int var1, int var2, int var3, ExternalSeedHTTPDownloaderListener var4) throws ExternalSeedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequests(List<PeerReadRequest> list) {
        block14: {
            ExternalSeedReaderRequest externalSeedReaderRequest;
            boolean bl = false;
            this.active_read_request = externalSeedReaderRequest = new ExternalSeedReaderRequest(this, list);
            try {
                try {
                    this.current_request = externalSeedReaderRequest;
                    this.readData(externalSeedReaderRequest);
                    bl = true;
                }
                catch (ExternalSeedException externalSeedException) {
                    if (externalSeedException.isPermanentFailure()) {
                        this.permanent_fail = true;
                    }
                    this.status = "Failed: " + Debug.getNestedExceptionMessage(externalSeedException);
                    externalSeedReaderRequest.failed();
                    Object var6_5 = null;
                    this.active_read_request = null;
                    if (bl) {
                        this.last_failed_read = 0L;
                        this.consec_failures = 0;
                    } else {
                        this.last_failed_read = this.getSystemTime();
                        ++this.consec_failures;
                    }
                    break block14;
                }
                catch (Throwable throwable) {
                    this.status = "Failed: " + Debug.getNestedExceptionMessage(throwable);
                    externalSeedReaderRequest.failed();
                    Object var6_6 = null;
                    this.active_read_request = null;
                    if (bl) {
                        this.last_failed_read = 0L;
                        this.consec_failures = 0;
                    } else {
                        this.last_failed_read = this.getSystemTime();
                        ++this.consec_failures;
                    }
                }
                Object var6_4 = null;
                this.active_read_request = null;
                if (bl) {
                    this.last_failed_read = 0L;
                    this.consec_failures = 0;
                } else {
                    this.last_failed_read = this.getSystemTime();
                    ++this.consec_failures;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.active_read_request = null;
                if (bl) {
                    this.last_failed_read = 0L;
                    this.consec_failures = 0;
                } else {
                    this.last_failed_read = this.getSystemTime();
                    ++this.consec_failures;
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRequests(List<PeerReadRequest> list) {
        try {
            this.requests_mon.enter();
            if (!this.active) {
                Debug.out("request added when not active!!!!");
            }
            for (int i = 0; i < list.size(); ++i) {
                this.requests.add(list.get(i));
                this.request_sem.release();
            }
            if (this.request_thread == null) {
                this.plugin.getPluginInterface().getUtilities().createThread("RequestProcessor", new Runnable(){

                    public void run() {
                        ExternalSeedReaderImpl.this.processRequests();
                    }
                });
            }
            Object var4_3 = null;
            this.requests_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.requests_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRequest(PeerReadRequest peerReadRequest) {
        try {
            this.requests_mon.enter();
            if (this.requests.contains(peerReadRequest) && !peerReadRequest.isCancelled()) {
                peerReadRequest.cancel();
            }
            if (this.dangling_requests != null & this.dangling_requests.contains(peerReadRequest) && !peerReadRequest.isCancelled()) {
                peerReadRequest.cancel();
            }
            Object var3_2 = null;
            this.requests_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.requests_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAllRequests() {
        try {
            this.requests_mon.enter();
            for (PeerReadRequest peerReadRequest : this.requests) {
                if (peerReadRequest.isCancelled()) continue;
                peerReadRequest.cancel();
            }
            if (this.dangling_requests != null) {
                for (PeerReadRequest peerReadRequest : this.dangling_requests) {
                    if (peerReadRequest.isCancelled()) continue;
                    peerReadRequest.cancel();
                }
            }
            if (this.active_read_request != null) {
                this.active_read_request.cancel();
            }
            Object var4_3 = null;
            this.requests_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.requests_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestCount() {
        try {
            this.requests_mon.enter();
            int n = this.requests.size();
            Object var3_2 = null;
            this.requests_mon.exit();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.requests_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PeerReadRequest> getExpiredRequests() {
        ArrayList<PeerReadRequest> arrayList = null;
        try {
            this.requests_mon.enter();
            for (int i = 0; i < this.requests.size(); ++i) {
                PeerReadRequest peerReadRequest = this.requests.get(i);
                if (!peerReadRequest.isExpired()) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<PeerReadRequest>();
                }
                arrayList.add(peerReadRequest);
            }
            Object var5_4 = null;
            this.requests_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.requests_mon.exit();
            throw throwable;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PeerReadRequest> getRequests() {
        ArrayList<PeerReadRequest> arrayList = null;
        try {
            this.requests_mon.enter();
            arrayList = new ArrayList<PeerReadRequest>(this.requests);
            Object var3_2 = null;
            this.requests_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.requests_mon.exit();
            throw throwable;
        }
        return arrayList;
    }

    protected void informComplete(PeerReadRequest peerReadRequest, byte[] byArray) {
        PooledByteBuffer pooledByteBuffer = this.plugin.getPluginInterface().getUtilities().allocatePooledByteBuffer(byArray);
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((ExternalSeedReaderListener)this.listeners.get(i)).requestComplete(peerReadRequest, pooledByteBuffer);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected void informCancelled(PeerReadRequest peerReadRequest) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((ExternalSeedReaderListener)this.listeners.get(i)).requestCancelled(peerReadRequest);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected void informFailed(PeerReadRequest peerReadRequest) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((ExternalSeedReaderListener)this.listeners.get(i)).requestFailed(peerReadRequest);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public void addListener(ExternalSeedReaderListener externalSeedReaderListener) {
        this.listeners.add(externalSeedReaderListener);
    }

    @Override
    public void removeListener(ExternalSeedReaderListener externalSeedReaderListener) {
        this.listeners.remove(externalSeedReaderListener);
    }

    protected int getIntParam(Map map, String string, int n) {
        Object v = map.get(string);
        if (v instanceof Long) {
            return ((Long)v).intValue();
        }
        return n;
    }

    protected boolean getBooleanParam(Map map, String string, boolean bl) {
        return this.getIntParam(map, string, bl ? 1 : 0) != 0;
    }

    protected static class MutableInteger {
        private int value;

        protected MutableInteger(int n) {
            this.value = n;
        }

        protected void setValue(int n) {
            this.value = n;
        }

        protected int getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object instanceof MutableInteger) {
                return this.value == ((MutableInteger)object).value;
            }
            return false;
        }
    }
}

