/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl.getright;

import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePriorityProvider;
import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderImpl;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderRequest;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloader;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderLinear;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderRange;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class ExternalSeedReaderGetRight
extends ExternalSeedReaderImpl
implements PiecePriorityProvider {
    private static final int TARGET_REQUEST_SIZE_DEFAULT = 262144;
    private URL url;
    private int port;
    private ExternalSeedHTTPDownloader[] http_downloaders;
    private long[] downloader_offsets;
    private long[] downloader_lengths;
    private int piece_size;
    private int piece_group_size;
    private long[] piece_priorities;
    private boolean linear_download;

    protected ExternalSeedReaderGetRight(ExternalSeedPlugin externalSeedPlugin, Torrent torrent, URL uRL, Map map) throws Exception {
        super(externalSeedPlugin, torrent, uRL.getHost(), map);
        int n = this.getIntParam(map, "req_size", 262144);
        this.linear_download = this.getBooleanParam(map, "linear", false);
        this.url = uRL;
        this.port = this.url.getPort();
        if (this.port == -1) {
            this.port = this.url.getDefaultPort();
        }
        this.piece_size = (int)this.getTorrent().getPieceSize();
        this.piece_group_size = n / this.piece_size;
        if (this.piece_group_size == 0) {
            this.piece_group_size = 1;
        }
        TOTorrent tOTorrent = ((TorrentImpl)torrent).getTorrent();
        String string = this.getUserAgent();
        if (tOTorrent.isSimpleTorrent()) {
            this.http_downloaders = new ExternalSeedHTTPDownloader[]{this.linear_download ? new ExternalSeedHTTPDownloaderLinear(this.url, string) : new ExternalSeedHTTPDownloaderRange(this.url, string)};
            this.downloader_offsets = new long[]{0L};
            this.downloader_lengths = new long[]{tOTorrent.getSize()};
        } else {
            TOTorrentFile[] tOTorrentFileArray = tOTorrent.getFiles();
            this.http_downloaders = new ExternalSeedHTTPDownloader[tOTorrentFileArray.length];
            this.downloader_offsets = new long[tOTorrentFileArray.length];
            this.downloader_lengths = new long[tOTorrentFileArray.length];
            long l = 0L;
            String string2 = this.url.toString();
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            string2 = string2 + "/" + URLEncoder.encode(new String(tOTorrent.getName(), "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
            for (int i = 0; i < tOTorrentFileArray.length; ++i) {
                TOTorrentFile tOTorrentFile = tOTorrentFileArray[i];
                long l2 = tOTorrentFile.getLength();
                String string3 = string2;
                byte[][] byArray = tOTorrentFile.getPathComponents();
                for (int j = 0; j < byArray.length; ++j) {
                    string3 = string3 + "/" + URLEncoder.encode(new String(byArray[j], "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
                }
                this.http_downloaders[i] = this.linear_download ? new ExternalSeedHTTPDownloaderLinear(new URL(string3), string) : new ExternalSeedHTTPDownloaderRange(new URL(string3), string);
                this.downloader_offsets[i] = l;
                this.downloader_lengths[i] = l2;
                l += l2;
            }
        }
    }

    public boolean sameAs(ExternalSeedReader externalSeedReader) {
        if (externalSeedReader instanceof ExternalSeedReaderGetRight) {
            return this.url.toString().equals(((ExternalSeedReaderGetRight)externalSeedReader).url.toString());
        }
        return false;
    }

    public String getName() {
        return "GR: " + this.url;
    }

    public int getPort() {
        return this.port;
    }

    protected int getPieceGroupSize() {
        return this.piece_group_size;
    }

    protected boolean getRequestCanSpanPieces() {
        return true;
    }

    protected void setActiveSupport(PeerManager peerManager, boolean bl) {
        if (this.linear_download) {
            if (peerManager != null) {
                ExternalSeedHTTPDownloader[] externalSeedHTTPDownloaderArray = PluginCoreUtils.unwrap(peerManager).getPiecePicker();
                if (bl) {
                    this.piece_priorities = new long[peerManager.getPieces().length];
                    for (int i = 0; i < this.piece_priorities.length; ++i) {
                        this.piece_priorities[i] = 10000 + i;
                    }
                    externalSeedHTTPDownloaderArray.addPriorityProvider(this);
                } else {
                    this.piece_priorities = null;
                    externalSeedHTTPDownloaderArray.removePriorityProvider(this);
                }
            }
            if (!bl) {
                for (ExternalSeedHTTPDownloader externalSeedHTTPDownloader : this.http_downloaders) {
                    externalSeedHTTPDownloader.deactivate();
                }
            }
        }
    }

    public long[] updatePriorities(PiecePicker piecePicker) {
        return this.piece_priorities;
    }

    public void calculatePriorityOffsets(PeerManager peerManager, int[] nArray) {
        if (this.linear_download) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = 100000 + nArray.length - (i + 1);
            }
        } else {
            super.calculatePriorityOffsets(peerManager, nArray);
        }
    }

    protected void readData(ExternalSeedReaderRequest externalSeedReaderRequest) throws ExternalSeedException {
        this.readData(externalSeedReaderRequest.getStartPieceNumber(), externalSeedReaderRequest.getStartPieceOffset(), externalSeedReaderRequest.getLength(), externalSeedReaderRequest);
    }

    protected void readData(int n, int n2, int n3, final ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener) throws ExternalSeedException {
        this.setReconnectDelay(30000, false);
        long l = n * this.piece_size + n2;
        int n4 = n3;
        if (this.http_downloaders.length == 1) {
            ExternalSeedHTTPDownloader externalSeedHTTPDownloader = this.http_downloaders[0];
            try {
                externalSeedHTTPDownloader.downloadRange(l, n4, externalSeedHTTPDownloaderListener, this.isTransient());
            }
            catch (ExternalSeedException externalSeedException) {
                if (externalSeedHTTPDownloader.getLastResponse() == 503 && externalSeedHTTPDownloader.getLast503RetrySecs() >= 0) {
                    int n5 = externalSeedHTTPDownloader.getLast503RetrySecs();
                    this.setReconnectDelay(n5 * 1000, true);
                    throw new ExternalSeedException("Server temporarily unavailable, retrying in " + n5 + " seconds");
                }
                throw externalSeedException;
            }
        } else {
            long l2 = l + (long)n4;
            final byte[][] byArrayArray = new byte[][]{null};
            final int[] nArray = new int[]{0};
            for (int i = 0; i < this.http_downloaders.length; ++i) {
                long l3 = this.downloader_offsets[i];
                long l4 = l3 + this.downloader_lengths[i];
                if (l4 <= l) continue;
                if (l3 >= l2) break;
                long l5 = Math.max(l, l3);
                long l6 = Math.min(l2, l4);
                final int n6 = (int)(l6 - l5);
                if (n6 == 0) continue;
                ExternalSeedHTTPDownloader externalSeedHTTPDownloader = this.http_downloaders[i];
                ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener2 = new ExternalSeedHTTPDownloaderListener(){
                    private int bytes_read;
                    private byte[] current_buffer;
                    private int current_buffer_position;
                    private int current_buffer_length;
                    {
                        this.current_buffer = byArrayArray[0];
                        this.current_buffer_position = nArray[0];
                        this.current_buffer_length = this.current_buffer == null ? -1 : Math.min(this.current_buffer.length, this.current_buffer_position + n6);
                    }

                    public byte[] getBuffer() throws ExternalSeedException {
                        if (this.current_buffer == null) {
                            this.current_buffer = externalSeedHTTPDownloaderListener.getBuffer();
                            this.current_buffer_position = 0;
                            this.current_buffer_length = Math.min(this.current_buffer.length, n6 - this.bytes_read);
                        }
                        return this.current_buffer;
                    }

                    public void setBufferPosition(int n) {
                        this.current_buffer_position = n;
                        externalSeedHTTPDownloaderListener.setBufferPosition(n);
                    }

                    public int getBufferPosition() {
                        return this.current_buffer_position;
                    }

                    public int getBufferLength() {
                        return this.current_buffer_length;
                    }

                    public int getPermittedBytes() throws ExternalSeedException {
                        return externalSeedHTTPDownloaderListener.getPermittedBytes();
                    }

                    public int getPermittedTime() {
                        return externalSeedHTTPDownloaderListener.getPermittedTime();
                    }

                    public void reportBytesRead(int n) {
                        this.bytes_read += n;
                        externalSeedHTTPDownloaderListener.reportBytesRead(n);
                    }

                    public boolean isCancelled() {
                        return externalSeedHTTPDownloaderListener.isCancelled();
                    }

                    public void done() {
                        int n = this.current_buffer.length - this.current_buffer_length;
                        if (this.bytes_read == n6) {
                            if (n == 0) {
                                byArrayArray[0] = null;
                                nArray[0] = 0;
                            } else {
                                byArrayArray[0] = this.current_buffer;
                                nArray[0] = this.current_buffer_length;
                            }
                        }
                        this.current_buffer = null;
                        if (n == 0) {
                            externalSeedHTTPDownloaderListener.done();
                        }
                    }
                };
                try {
                    externalSeedHTTPDownloader.downloadRange(l5 - l3, n6, externalSeedHTTPDownloaderListener2, this.isTransient());
                    continue;
                }
                catch (ExternalSeedException externalSeedException) {
                    if (externalSeedHTTPDownloader.getLastResponse() == 503 && externalSeedHTTPDownloader.getLast503RetrySecs() >= 0) {
                        int n7 = externalSeedHTTPDownloader.getLast503RetrySecs();
                        this.setReconnectDelay(n7 * 1000, true);
                        throw new ExternalSeedException("Server temporarily unavailable, retrying in " + n7 + " seconds");
                    }
                    throw externalSeedException;
                }
            }
        }
    }
}

