/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.security.CryptoHandler;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.security.CryptoManagerKeyListener;
import com.aelitis.azureus.core.security.CryptoManagerPasswordException;
import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.azureus.plugins.magnet.MagnetPlugin;
import com.aelitis.azureus.plugins.magnet.MagnetPluginProgressListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginAZ2;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginAZ2TrackerListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyRequestListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginException;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginPasswordException;
import com.aelitis.azureus.plugins.net.buddy.tracker.BuddyPluginTracker;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.core3.util.protocol.azplug.AZPluginConnection;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseEvent;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.ipc.IPCException;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnection;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageHandler;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageRegistration;
import org.gudy.azureus2.plugins.network.RateLimiter;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringListParameter;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.utils.LocaleListener;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.plugins.utils.security.SEPublicKey;
import org.gudy.azureus2.plugins.utils.security.SEPublicKeyLocator;
import org.gudy.azureus2.plugins.utils.security.SESecurityManager;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddyPlugin
implements Plugin {
    public static final boolean SUPPORT_ONLINE_STATUS = true;
    public static final int VERSION_INITIAL = 1;
    public static final int VERSION_CHAT = 2;
    public static final int VERSION_CURRENT = 2;
    public static final int MT_V3_CHAT = 1;
    private static final int FEED_UPDATE_MIN_MILLIS = 21600000;
    public static final int MAX_MESSAGE_SIZE = 0x400000;
    public static final int SUBSYSTEM_INTERNAL = 0;
    public static final int SUBSYSTEM_AZ2 = 1;
    public static final int SUBSYSTEM_AZ3 = 2;
    protected static final int SUBSYSTEM_MSG_TYPE_BASE = 1024;
    public static final int STATUS_ONLINE = 0;
    public static final int STATUS_AWAY = 1;
    public static final int STATUS_NOT_AVAILABLE = 2;
    public static final int STATUS_BUSY = 3;
    public static final int STATUS_APPEAR_OFFLINE = 4;
    public static final String[] STATUS_VALUES = new String[]{"0", "1", "2", "3", "4"};
    public static final String[] STATUS_KEYS = new String[]{"os_online", "os_away", "os_not_avail", "os_busy", "os_offline"};
    public static final String[] STATUS_STRINGS = new String[STATUS_KEYS.length];
    protected static final int RT_INTERNAL_REQUEST_PING = 1;
    protected static final int RT_INTERNAL_REPLY_PING = 2;
    protected static final int RT_INTERNAL_REQUEST_CLOSE = 3;
    protected static final int RT_INTERNAL_REPLY_CLOSE = 4;
    protected static final int RT_INTERNAL_FRAGMENT = 5;
    protected static final boolean TRACE = false;
    private static final String VIEW_ID = "azbuddy";
    private static final int INIT_UNKNOWN = 0;
    private static final int INIT_OK = 1;
    private static final int INIT_BAD = 2;
    private static final int MAX_UNAUTH_BUDDIES = 16;
    public static final int TIMER_PERIOD = 10000;
    private static final int BUDDY_STATUS_CHECK_PERIOD_MIN = 180000;
    private static final int BUDDY_STATUS_CHECK_PERIOD_INC = 60000;
    protected static final int STATUS_REPUBLISH_PERIOD = 600000;
    private static final int STATUS_REPUBLISH_TICKS = 60;
    private static final int CHECK_YGM_PERIOD = 300000;
    private static final int CHECK_YGM_TICKS = 30;
    private static final int YGM_BLOOM_LIFE_PERIOD = 3600000;
    private static final int YGM_BLOOM_LIFE_TICKS = 360;
    private static final int SAVE_CONFIG_PERIOD = 60000;
    private static final int SAVE_CONFIG_TICKS = 6;
    public static final int PERSISTENT_MSG_RETRY_PERIOD = 300000;
    private static final int PERSISTENT_MSG_CHECK_PERIOD = 60000;
    private static final int PERSISTENT_MSG_CHECK_TICKS = 6;
    private static final int UNAUTH_BLOOM_RECREATE = 120000;
    private static final int UNAUTH_BLOOM_CHUNK = 1000;
    private static BloomFilter unauth_bloom;
    private static long unauth_bloom_create_time;
    private static final int BLOOM_CHECK_PERIOD = 60000;
    private static final int BLOOM_CHECK_TICKS = 6;
    private static BloomFilter ygm_unauth_bloom;
    public static final int STREAM_CRYPTO = 3;
    public static final int BLOCK_CRYPTO = 2;
    private volatile int initialisation_state = 0;
    private PluginInterface plugin_interface;
    private LoggerChannel logger;
    private BooleanParameter enabled_param;
    private StringParameter nick_name_param;
    private StringListParameter online_status_param;
    private BooleanParameter enable_chat_notifications;
    private StringParameter cat_pub;
    private boolean ready_to_publish;
    private publishDetails current_publish;
    private publishDetails latest_publish = this.current_publish = new publishDetails();
    private long last_publish_start;
    private TimerEvent republish_delay_event;
    private AsyncDispatcher publish_dispatcher = new AsyncDispatcher();
    private DistributedDatabase ddb;
    private CryptoHandler ecc_handler = CryptoManagerFactory.getSingleton().getECCHandler();
    private List<BuddyPluginBuddy> buddies = new ArrayList<BuddyPluginBuddy>();
    private List<BuddyPluginBuddy> connected_at_close;
    private Map<String, BuddyPluginBuddy> buddies_map = new HashMap<String, BuddyPluginBuddy>();
    private CopyOnWriteList<BuddyPluginListener> listeners = new CopyOnWriteList();
    private CopyOnWriteList<BuddyPluginBuddyRequestListener> request_listeners = new CopyOnWriteList();
    private SESecurityManager sec_man;
    private GenericMessageRegistration msg_registration;
    private int inbound_limit;
    private int outbound_limit;
    private RateLimiter inbound_limiter = new RateLimiter(){

        public String getName() {
            return "buddy_up";
        }

        public int getRateLimitBytesPerSecond() {
            return BuddyPlugin.this.inbound_limit;
        }
    };
    private RateLimiter outbound_limiter = new RateLimiter(){

        public String getName() {
            return "buddy_down";
        }

        public int getRateLimitBytesPerSecond() {
            return BuddyPlugin.this.outbound_limit;
        }
    };
    private boolean config_dirty;
    private Random random = RandomUtils.SECURE_RANDOM;
    private BuddyPluginAZ2 az2_handler;
    private List<DistributedDatabaseContact> publish_write_contacts = new ArrayList<DistributedDatabaseContact>();
    private int status_seq;
    private Set<BuddyPluginBuddy> pd_preinit;
    private List<BuddyPluginBuddy> pd_queue;
    private AESemaphore pd_queue_sem;
    private AEThread2 pd_thread;
    private boolean bogus_ygm_written;
    private BuddyPluginTracker buddy_tracker;
    private TorrentAttribute ta_category;
    private Set<String> public_categories;

    public BuddyPlugin() {
        while (this.status_seq == 0) {
            this.status_seq = this.random.nextInt();
        }
        this.pd_preinit = new HashSet<BuddyPluginBuddy>();
        this.pd_queue = new ArrayList<BuddyPluginBuddy>();
        this.pd_queue_sem = new AESemaphore("BuddyPlugin:persistDispatch");
        this.public_categories = new HashSet<String>();
    }

    public static void load(PluginInterface pluginInterface) {
        String string = pluginInterface.getUtilities().getLocaleUtilities().getLocalisedMessageText("Views.plugins.azbuddy.title");
        pluginInterface.getPluginProperties().setProperty("plugin.version", "1.0");
        pluginInterface.getPluginProperties().setProperty("plugin.name", string);
    }

    @Override
    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.ta_category = this.plugin_interface.getTorrentManager().getAttribute("Category");
        this.az2_handler = new BuddyPluginAZ2(this);
        this.sec_man = this.plugin_interface.getUtilities().getSecurityManager();
        this.logger = this.plugin_interface.getLogger().getChannel("Friends");
        this.logger.setDiagnostic();
        final LocaleUtilities localeUtilities = this.plugin_interface.getUtilities().getLocaleUtilities();
        localeUtilities.addListener(new LocaleListener(){

            public void localeChanged(Locale locale) {
                BuddyPlugin.this.updateLocale(localeUtilities);
            }
        });
        this.updateLocale(localeUtilities);
        BasicPluginConfigModel basicPluginConfigModel = this.plugin_interface.getUIManager().createBasicPluginConfigModel("Views.plugins.azbuddy.title");
        this.enabled_param = basicPluginConfigModel.addBooleanParameter2("azbuddy.enabled", "azbuddy.enabled", false);
        this.nick_name_param = basicPluginConfigModel.addStringParameter2("azbuddy.nickname", "azbuddy.nickname", "");
        this.nick_name_param.setGenerateIntermediateEvents(false);
        this.nick_name_param.addListener(new ParameterListener(){

            public void parameterChanged(Parameter parameter) {
                BuddyPlugin.this.updateNickName(BuddyPlugin.this.nick_name_param.getValue());
            }
        });
        String[] stringArray = STATUS_VALUES;
        String[] stringArray2 = STATUS_STRINGS;
        this.online_status_param = basicPluginConfigModel.addStringListParameter2("azbuddy.online_status", "azbuddy.online_status", stringArray, stringArray2, stringArray[0]);
        this.online_status_param.addListener(new ParameterListener(){

            public void parameterChanged(Parameter parameter) {
                int n = Integer.parseInt(BuddyPlugin.this.online_status_param.getValue());
                BuddyPlugin.this.updateOnlineStatus(n);
            }
        });
        this.online_status_param.setVisible(true);
        final IntParameter intParameter = basicPluginConfigModel.addIntParameter2("azbuddy.protocolspeed", "azbuddy.protocolspeed", 32);
        intParameter.setMinimumRequiredUserMode(2);
        this.inbound_limit = intParameter.getValue() * 1024;
        intParameter.addListener(new ParameterListener(){

            public void parameterChanged(Parameter parameter) {
                BuddyPlugin.this.inbound_limit = intParameter.getValue() * 1024;
            }
        });
        this.enable_chat_notifications = basicPluginConfigModel.addBooleanParameter2("azbuddy.enable_chat_notif", "azbuddy.enable_chat_notif", true);
        this.cat_pub = basicPluginConfigModel.addStringParameter2("azbuddy.enable_cat_pub", "azbuddy.enable_cat_pub", "");
        this.cat_pub.setGenerateIntermediateEvents(false);
        this.setPublicCats(this.cat_pub.getValue(), false);
        this.cat_pub.addListener(new ParameterListener(){

            public void parameterChanged(Parameter parameter) {
                BuddyPlugin.this.setPublicCats(BuddyPlugin.this.cat_pub.getValue(), false);
            }
        });
    }

    protected void updateLocale(LocaleUtilities localeUtilities) {
        for (int i = 0; i < STATUS_STRINGS.length; ++i) {
            BuddyPlugin.STATUS_STRINGS[i] = localeUtilities.getLocalisedMessageText("azbuddy." + STATUS_KEYS[i]);
        }
        if (this.online_status_param != null) {
            this.online_status_param.setLabels(STATUS_STRINGS);
        }
    }

    protected void setupDisablePrompt(UIInstance uIInstance) {
        if (this.plugin_interface == null) {
            return;
        }
        String string = "PluginInfo." + this.plugin_interface.getPluginID() + ".enabled";
        COConfigurationManager.addParameterListener(string, new org.gudy.azureus2.core3.config.ParameterListener(){

            public void parameterChanged(String string) {
                BuddyPlugin.this.fireEnabledStateChanged();
            }
        });
    }

    public void showConfig() {
        this.plugin_interface.getUIManager().showConfigSection("Views.plugins.azbuddy.title");
    }

    protected void startup() {
        try {
            this.ddb = this.plugin_interface.getDistributedDatabase();
            if (!this.ddb.isAvailable()) {
                throw new Exception("DDB Unavailable");
            }
            this.ddb.addListener(new DistributedDatabaseListener(){

                public void event(DistributedDatabaseEvent distributedDatabaseEvent) {
                    if (distributedDatabaseEvent.getType() == 10) {
                        BuddyPlugin.this.updateIP();
                    }
                }
            });
            this.updateIP();
            this.updateNickName(this.nick_name_param.getValue());
            this.updateOnlineStatus(Integer.parseInt(this.online_status_param.getValue()));
            COConfigurationManager.addAndFireParameterListeners(new String[]{"TCP.Listen.Port", "TCP.Listen.Port.Enable", "UDP.Listen.Port", "UDP.Listen.Port.Enable"}, new org.gudy.azureus2.core3.config.ParameterListener(){

                public void parameterChanged(String string) {
                    BuddyPlugin.this.updateListenPorts();
                }
            });
            CryptoManagerFactory.getSingleton().addKeyListener(new CryptoManagerKeyListener(){

                public void keyChanged(CryptoHandler cryptoHandler) {
                    BuddyPlugin.this.updateKey();
                }

                public void keyLockStatusChanged(CryptoHandler cryptoHandler) {
                    boolean bl = cryptoHandler.isUnlocked();
                    if (bl) {
                        if (BuddyPlugin.this.latest_publish.isEnabled()) {
                            BuddyPlugin.this.updatePublish(BuddyPlugin.this.latest_publish);
                        }
                    } else {
                        new AEThread2("BuddyPlugin:disc", true){

                            public void run() {
                                List<BuddyPluginBuddy> list = BuddyPlugin.this.getAllBuddies();
                                for (int i = 0; i < list.size(); ++i) {
                                    list.get(i).disconnect();
                                }
                            }
                        }.start();
                    }
                }
            });
            this.ready_to_publish = true;
            this.setEnabledInternal(this.enabled_param.getValue());
            this.checkBuddiesAndRepublish();
            this.fireInitialised(true);
            List<BuddyPluginBuddy> list = this.getBuddies();
            for (BuddyPluginBuddy buddyPluginBuddy : list) {
                if (buddyPluginBuddy.getIP() == null || buddyPluginBuddy.isConnected()) continue;
                this.log("Attempting reconnect to " + buddyPluginBuddy.getString());
                buddyPluginBuddy.sendKeepAlive();
            }
        }
        catch (Throwable throwable) {
            this.log("Initialisation failed", throwable);
            this.fireInitialised(false);
        }
    }

    public boolean isEnabled() {
        if (this.enabled_param == null) {
            return false;
        }
        return this.enabled_param.getValue();
    }

    public void setEnabled(boolean bl) {
        if (this.enabled_param == null) {
            return;
        }
        this.enabled_param.setValue(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setEnabledInternal(boolean bl) {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            if (this.latest_publish.isEnabled() != bl) {
                publishDetails publishDetails2 = this.latest_publish.getCopy();
                publishDetails2.setEnabled(bl);
                this.updatePublish(publishDetails2);
            }
        }
    }

    public BuddyPluginTracker getTracker() {
        return this.buddy_tracker;
    }

    public String getNickname() {
        return this.nick_name_param.getValue();
    }

    public void setNickname(String string) {
        this.nick_name_param.setValue(string);
    }

    public void setOnlineStatus(int n) {
        this.online_status_param.setValue("" + n);
    }

    public int getOnlineStatus() {
        return this.latest_publish.getOnlineStatus();
    }

    public BooleanParameter getEnableChatNotificationsParameter() {
        return this.enable_chat_notifications;
    }

    protected String normaliseCat(String string) {
        if (string == null) {
            return null;
        }
        if (string.toLowerCase().equals("all")) {
            return "All";
        }
        return string;
    }

    protected void normaliseCats(Set<String> set) {
        if (set != null) {
            boolean bl = false;
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().toLowerCase().equals("all")) continue;
                iterator.remove();
                bl = true;
            }
            if (bl) {
                set.add("All");
            }
        }
    }

    public boolean isPublicCategory(String string) {
        string = this.normaliseCat(string);
        return this.public_categories.contains(string);
    }

    public void addPublicCategory(String string) {
        HashSet<String> hashSet = new HashSet<String>(this.public_categories);
        if (hashSet.add(string = this.normaliseCat(string))) {
            this.setPublicCats(hashSet, true);
        }
    }

    public void removePublicCategory(String string) {
        HashSet<String> hashSet = new HashSet<String>(this.public_categories);
        if (hashSet.remove(string = this.normaliseCat(string))) {
            this.setPublicCats(hashSet, true);
        }
    }

    protected void setPublicCats(String string, boolean bl) {
        String[] stringArray;
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : stringArray = string.split(",")) {
            string2 = string2.trim();
            if (stringArray.length <= 0) continue;
            hashSet.add(this.normaliseCat(string2));
        }
        this.setPublicCats(hashSet, bl);
    }

    protected void setPublicCats(Set<String> set, boolean bl) {
        if (!((Object)this.public_categories).equals(set)) {
            Object object;
            HashSet<String> hashSet = new HashSet<String>(this.public_categories);
            hashSet.removeAll(set);
            this.public_categories = set;
            if (bl) {
                object = "";
                for (String object2 : this.public_categories) {
                    object = (String)object + (((String)object).length() == 0 ? "" : ",") + object2;
                }
                this.cat_pub.setValue((String)object);
            }
            object = this.getBuddies();
            Iterator<String> iterator = object.iterator();
            while (iterator.hasNext()) {
                BuddyPluginBuddy buddyPluginBuddy = (BuddyPluginBuddy)((Object)iterator.next());
                Set<String> set2 = buddyPluginBuddy.getLocalAuthorisedRSSCategories();
                if (set2 == null && set.size() <= 0) continue;
                set2 = set2 == null ? new HashSet<String>() : new HashSet<String>(set2);
                set2.addAll(set);
                set2.removeAll(hashSet);
                buddyPluginBuddy.setLocalAuthorisedRSSCategories(set2);
            }
        }
    }

    protected void registerMessageHandler() {
        try {
            this.addRequestListener(new BuddyPluginBuddyRequestListener(){

                public Map requestReceived(BuddyPluginBuddy buddyPluginBuddy, int n, Map map) throws BuddyPluginException {
                    if (n == 0) {
                        if (!buddyPluginBuddy.isAuthorised()) {
                            throw new BuddyPluginException("Unauthorised");
                        }
                        return BuddyPlugin.this.processInternalRequest(buddyPluginBuddy, map);
                    }
                    return null;
                }

                public void pendingMessages(BuddyPluginBuddy[] buddyPluginBuddyArray) {
                }
            });
            this.msg_registration = this.plugin_interface.getMessageManager().registerGenericMessageType("AZBUDDY", "Buddy message handler", 3, new GenericMessageHandler(){

                public boolean accept(GenericMessageConnection genericMessageConnection) throws MessageException {
                    if (!BuddyPlugin.this.isEnabled()) {
                        return false;
                    }
                    final String string = genericMessageConnection.getEndpoint().getNotionalAddress().getAddress().getHostAddress();
                    try {
                        String string2 = "Friend: Incoming connection establishment (" + string + ")";
                        BuddyPlugin.this.addRateLimiters(genericMessageConnection);
                        genericMessageConnection = BuddyPlugin.this.sec_man.getSTSConnection(genericMessageConnection, BuddyPlugin.this.sec_man.getPublicKey(1, string2), new SEPublicKeyLocator(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public boolean accept(Object object, SEPublicKey sEPublicKey) {
                                String string2 = Base32.encode(sEPublicKey.encodeRawPublicKey());
                                try {
                                    BuddyPlugin buddyPlugin = BuddyPlugin.this;
                                    synchronized (buddyPlugin) {
                                        int n = 0;
                                        for (int i = 0; i < BuddyPlugin.this.buddies.size(); ++i) {
                                            BuddyPluginBuddy buddyPluginBuddy = (BuddyPluginBuddy)BuddyPlugin.this.buddies.get(i);
                                            if (buddyPluginBuddy.getPublicKey().equals(string2)) {
                                                if (!buddyPluginBuddy.isAuthorised()) {
                                                    BuddyPlugin.this.log("Incoming connection from " + string + " failed as for unauthorised buddy");
                                                    return false;
                                                }
                                                buddyPluginBuddy.incomingConnection((GenericMessageConnection)object);
                                                return true;
                                            }
                                            if (buddyPluginBuddy.isAuthorised()) continue;
                                            ++n;
                                        }
                                        if (n < 16) {
                                            if (BuddyPlugin.this.tooManyUnauthConnections(string)) {
                                                BuddyPlugin.this.log("Too many recent unauthorised connections from " + string);
                                                return false;
                                            }
                                            BuddyPluginBuddy buddyPluginBuddy = BuddyPlugin.this.addBuddy(string2, 1, false);
                                            buddyPluginBuddy.incomingConnection((GenericMessageConnection)object);
                                            return true;
                                        }
                                    }
                                    BuddyPlugin.this.log("Incoming connection from " + string + " failed due to pk mismatch");
                                    return false;
                                }
                                catch (Throwable throwable) {
                                    BuddyPlugin.this.log("Incomming connection from " + string + " failed", throwable);
                                    return false;
                                }
                            }
                        }, string2, 2);
                    }
                    catch (Throwable throwable) {
                        genericMessageConnection.close();
                        BuddyPlugin.this.log("Incoming connection from " + string + " failed", throwable);
                    }
                    return true;
                }
            });
        }
        catch (Throwable throwable) {
            this.log("Failed to register message listener", throwable);
        }
    }

    protected void addRateLimiters(GenericMessageConnection genericMessageConnection) {
        genericMessageConnection.addInboundRateLimiter(this.inbound_limiter);
        genericMessageConnection.addOutboundRateLimiter(this.outbound_limiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tooManyUnauthConnections(String string) {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            int n;
            if (unauth_bloom == null) {
                unauth_bloom = BloomFilterFactory.createAddRemove4Bit(1000);
                unauth_bloom_create_time = SystemTime.getCurrentTime();
            }
            if ((n = unauth_bloom.add(string.getBytes())) >= 8) {
                Debug.out("Too many recent unauthorised connection attempts from " + string);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkUnauthBloom() {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            if (unauth_bloom != null) {
                long l = SystemTime.getCurrentTime();
                if (l < unauth_bloom_create_time) {
                    unauth_bloom_create_time = l;
                } else if (l - unauth_bloom_create_time > 120000L) {
                    unauth_bloom = null;
                }
            }
        }
    }

    protected void checkMaxMessageSize(int n) throws BuddyPluginException {
        if (n > 0x400000) {
            throw new BuddyPluginException("Message is too large to send, limit is " + DisplayFormatters.formatByteCountToKiBEtc(0x400000));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPersistentDispatch() {
        ArrayList<BuddyPluginBuddy> arrayList;
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            arrayList = new ArrayList<BuddyPluginBuddy>(this.buddies);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            BuddyPluginBuddy buddyPluginBuddy = (BuddyPluginBuddy)arrayList.get(i);
            buddyPluginBuddy.checkPersistentDispatch();
        }
    }

    protected void persistentDispatchInit() {
        Iterator<BuddyPluginBuddy> iterator = this.pd_preinit.iterator();
        while (iterator.hasNext()) {
            this.persistentDispatchPending(iterator.next());
        }
        this.pd_preinit = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistentDispatchPending(BuddyPluginBuddy buddyPluginBuddy) {
        List<BuddyPluginBuddy> list = this.pd_queue;
        synchronized (list) {
            if (this.initialisation_state == 0) {
                this.pd_preinit.add(buddyPluginBuddy);
                return;
            }
            if (!this.pd_queue.contains(buddyPluginBuddy)) {
                this.pd_queue.add(buddyPluginBuddy);
                this.pd_queue_sem.release();
                if (this.pd_thread == null) {
                    this.pd_thread = new AEThread2("BuddyPlugin:persistDispatch", true){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            while (true) {
                                Object object;
                                if (!BuddyPlugin.this.pd_queue_sem.reserve(30000L)) {
                                    object = BuddyPlugin.this.pd_queue;
                                    synchronized (object) {
                                        if (BuddyPlugin.this.pd_queue.isEmpty()) {
                                            BuddyPlugin.this.pd_thread = null;
                                            break;
                                        }
                                    }
                                }
                                List list = BuddyPlugin.this.pd_queue;
                                synchronized (list) {
                                    object = (BuddyPluginBuddy)BuddyPlugin.this.pd_queue.remove(0);
                                }
                                ((BuddyPluginBuddy)object).persistentDispatch();
                            }
                        }
                    };
                    this.pd_thread.start();
                }
            }
        }
    }

    protected Map processInternalRequest(BuddyPluginBuddy buddyPluginBuddy, Map map) throws BuddyPluginException {
        int n = ((Long)map.get("type")).intValue();
        if (n == 1) {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("type", new Long(2L));
            return hashMap;
        }
        if (n == 3) {
            buddyPluginBuddy.receivedCloseRequest(map);
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("type", new Long(4L));
            return hashMap;
        }
        throw new BuddyPluginException("Unrecognised request type " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateListenPorts() {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            int n = COConfigurationManager.getIntParameter("TCP.Listen.Port");
            boolean bl = COConfigurationManager.getBooleanParameter("TCP.Listen.Port.Enable");
            int n2 = COConfigurationManager.getIntParameter("UDP.Listen.Port");
            boolean bl2 = COConfigurationManager.getBooleanParameter("UDP.Listen.Port.Enable");
            if (!bl) {
                n = 0;
            }
            if (!bl2) {
                n2 = 0;
            }
            if (this.latest_publish.getTCPPort() != n || this.latest_publish.getUDPPort() != n2) {
                publishDetails publishDetails2 = this.latest_publish.getCopy();
                publishDetails2.setTCPPort(n);
                publishDetails2.setUDPPort(n2);
                this.updatePublish(publishDetails2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIP() {
        if (this.ddb == null || !this.ddb.isAvailable()) {
            return;
        }
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            InetAddress inetAddress = this.ddb.getLocalContact().getAddress().getAddress();
            if (this.latest_publish.getIP() == null || !this.latest_publish.getIP().equals(inetAddress)) {
                publishDetails publishDetails2 = this.latest_publish.getCopy();
                publishDetails2.setIP(inetAddress);
                this.updatePublish(publishDetails2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNickName(String string) {
        if ((string = string.trim()).length() == 0) {
            string = null;
        }
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            String string2 = this.latest_publish.getNickName();
            if (!this.stringsEqual(string, string2)) {
                publishDetails publishDetails2 = this.latest_publish.getCopy();
                publishDetails2.setNickName(string);
                this.updatePublish(publishDetails2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateOnlineStatus(int n) {
        Object object;
        boolean bl;
        int n2;
        Object object2 = this;
        synchronized (object2) {
            n2 = this.latest_publish.getOnlineStatus();
            boolean bl2 = bl = n2 != n;
            if (bl) {
                object = this.latest_publish.getCopy();
                ((publishDetails)object).setOnlineStatus(n);
                this.updatePublish((publishDetails)object);
            }
        }
        if (bl) {
            object2 = this.getAllBuddies();
            for (n2 = 0; n2 < object2.size(); ++n2) {
                object = (BuddyPluginBuddy)object2.get(n2);
                if (!((BuddyPluginBuddy)object).isConnected()) continue;
                ((BuddyPluginBuddy)object).sendKeepAlive();
            }
        }
    }

    public String getOnlineStatus(int n) {
        if (n >= STATUS_STRINGS.length || n < 0) {
            n = 0;
        }
        return STATUS_STRINGS[n];
    }

    protected boolean stringsEqual(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateKey() {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            publishDetails publishDetails2 = this.latest_publish.getCopy();
            publishDetails2.setPublicKey(null);
            this.updatePublish(publishDetails2);
        }
    }

    protected void updatePublish(final publishDetails publishDetails2) {
        this.latest_publish = publishDetails2;
        if (this.ddb == null || !this.ready_to_publish) {
            return;
        }
        this.publish_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                if (BuddyPlugin.this.publish_dispatcher.getQueueSize() > 0) {
                    return;
                }
                BuddyPlugin.this.updatePublishSupport(publishDetails2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePublishSupport(publishDetails publishDetails2) {
        block29: {
            Object object;
            publishDetails publishDetails3;
            boolean bl;
            byte[] byArray = null;
            Object object2 = this;
            synchronized (object2) {
                bl = !this.current_publish.getString().equals(publishDetails2.getString());
                publishDetails3 = this.current_publish;
                if (!publishDetails2.isEnabled()) {
                    if (this.current_publish.isPublished()) {
                        byArray = this.current_publish.getPublicKey();
                    }
                } else {
                    if (publishDetails2.getPublicKey() == null) {
                        try {
                            publishDetails2.setPublicKey(this.ecc_handler.getPublicKey("Creating online status key"));
                        }
                        catch (Throwable throwable) {
                            this.log("Failed to publish details", throwable);
                            return;
                        }
                    }
                    if (this.current_publish.isPublished() && !Arrays.equals((byte[])(object = this.current_publish.getPublicKey()), publishDetails2.getPublicKey())) {
                        byArray = object;
                    }
                }
                this.current_publish = publishDetails2;
            }
            if (byArray != null) {
                this.log("Removing old status publish: " + publishDetails3.getString());
                try {
                    this.ddb.delete(new DistributedDatabaseListener(){

                        public void event(DistributedDatabaseEvent distributedDatabaseEvent) {
                        }
                    }, this.getStatusKey(byArray, "Friend status de-registration for old key"));
                }
                catch (Throwable throwable) {
                    this.log("Failed to remove existing publish", throwable);
                }
            }
            if (publishDetails2.isEnabled()) {
                object2 = publishDetails2.getIP();
                if (((InetAddress)object2).isLoopbackAddress() || ((InetAddress)object2).isLinkLocalAddress() || ((InetAddress)object2).isSiteLocalAddress()) {
                    this.log("Can't publish as ip address is invalid: " + publishDetails2.getString());
                    return;
                }
                publishDetails2.setPublished(true);
                object = new HashMap();
                if (publishDetails2.getTCPPort() > 0) {
                    object.put("t", new Long(publishDetails2.getTCPPort()));
                }
                if (publishDetails2.getUDPPort() > 0) {
                    object.put("u", new Long(publishDetails2.getUDPPort()));
                }
                object.put("i", ((InetAddress)object2).getAddress());
                String string = publishDetails2.getNickName();
                if (string != null) {
                    if (string.length() > 32) {
                        string = string.substring(0, 32);
                    }
                    object.put("n", string);
                }
                object.put("o", new Long(publishDetails2.getOnlineStatus()));
                ++this.status_seq;
                int n = this.status_seq++;
                if (n == 0) {
                    n = this.status_seq;
                }
                publishDetails2.setSequence(n);
                object.put("s", new Long(n));
                object.put("v", new Long(2L));
                boolean bl2 = true;
                try {
                    byte[] byArray2 = BEncoder.encode((Map)object);
                    DistributedDatabaseKey distributedDatabaseKey = this.getStatusKey(publishDetails2.getPublicKey(), "My buddy status registration " + object);
                    byte[] byArray3 = this.ecc_handler.sign(byArray2, "Friend online status");
                    bl2 = false;
                    byte[] byArray4 = new byte[1 + byArray3.length + byArray2.length];
                    byArray4[0] = (byte)byArray3.length;
                    System.arraycopy(byArray3, 0, byArray4, 1, byArray3.length);
                    System.arraycopy(byArray2, 0, byArray4, 1 + byArray3.length, byArray2.length);
                    DistributedDatabaseValue distributedDatabaseValue = this.ddb.createValue(byArray4);
                    final AESemaphore aESemaphore = new AESemaphore("BuddyPlugin:reg");
                    if (bl) {
                        this.logMessage("Publishing status starts: " + publishDetails2.getString());
                    }
                    this.last_publish_start = SystemTime.getMonotonousTime();
                    this.ddb.write(new DistributedDatabaseListener(){
                        private List<DistributedDatabaseContact> write_contacts = new ArrayList<DistributedDatabaseContact>();

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void event(DistributedDatabaseEvent distributedDatabaseEvent) {
                            int n = distributedDatabaseEvent.getType();
                            if (n == 1) {
                                this.write_contacts.add(distributedDatabaseEvent.getContact());
                            } else if (n == 5 || n == 4) {
                                List list = BuddyPlugin.this.publish_write_contacts;
                                synchronized (list) {
                                    BuddyPlugin.this.publish_write_contacts.clear();
                                    BuddyPlugin.this.publish_write_contacts.addAll(this.write_contacts);
                                }
                                aESemaphore.release();
                            }
                        }
                    }, distributedDatabaseKey, distributedDatabaseValue);
                    aESemaphore.reserve();
                    if (bl) {
                        this.logMessage("My status publish complete");
                    }
                }
                catch (Throwable throwable) {
                    this.logMessage("Failed to publish online status", throwable);
                    if (!bl2) break block29;
                    BuddyPlugin buddyPlugin = this;
                    synchronized (buddyPlugin) {
                        if (this.republish_delay_event != null) {
                            return;
                        }
                        if (this.last_publish_start == 0L || SystemTime.getMonotonousTime() - this.last_publish_start > 600000L) {
                            this.log("Rescheduling publish as failed to get key");
                            this.republish_delay_event = SimpleTimer.addEvent("BuddyPlugin:republish", SystemTime.getCurrentTime() + 60000L, new TimerEventPerformer(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void perform(TimerEvent timerEvent2) {
                                    BuddyPlugin buddyPlugin = BuddyPlugin.this;
                                    synchronized (buddyPlugin) {
                                        BuddyPlugin.this.republish_delay_event = null;
                                    }
                                    if ((BuddyPlugin.this.last_publish_start == 0L || SystemTime.getMonotonousTime() - BuddyPlugin.this.last_publish_start > 600000L) && BuddyPlugin.this.latest_publish.isEnabled()) {
                                        BuddyPlugin.this.updatePublish(BuddyPlugin.this.latest_publish);
                                    }
                                }
                            });
                        }
                    }
                }
            }
        }
    }

    protected int getCurrentStatusSeq() {
        return this.current_publish.getSequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void closedown() {
        this.logMessage("Closing down");
        List<BuddyPluginBuddy> list = this.getAllBuddies();
        DistributedDatabaseContact[] distributedDatabaseContactArray = this;
        synchronized (this) {
            this.connected_at_close = new ArrayList<BuddyPluginBuddy>();
            for (BuddyPluginBuddy buddyPluginBuddy : list) {
                if (!buddyPluginBuddy.isConnected()) continue;
                this.connected_at_close.add(buddyPluginBuddy);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.ddb == null) return;
            boolean bl = AzureusCoreFactory.isCoreAvailable() ? AzureusCoreFactory.getSingleton().isRestarting() : false;
            this.logMessage("   closing buddy connections");
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).sendCloseRequest(bl);
            }
            if (bl) return;
            this.logMessage("   updating online status");
            ArrayList<DistributedDatabaseContact> arrayList = new ArrayList<DistributedDatabaseContact>();
            List<DistributedDatabaseContact> list2 = this.publish_write_contacts;
            synchronized (list2) {
                arrayList.addAll(this.publish_write_contacts);
            }
            DistributedDatabaseContact[] distributedDatabaseContactArray2 = this;
            synchronized (this) {
                byte[] byArray = this.current_publish.getPublicKey();
                // ** MonitorExit[var5_11] (shouldn't be in output)
                if (arrayList.size() == 0 || byArray == null) {
                    return;
                }
                distributedDatabaseContactArray2 = new DistributedDatabaseContact[arrayList.size()];
                arrayList.toArray(distributedDatabaseContactArray2);
                try {
                    this.ddb.delete(new DistributedDatabaseListener(){

                        public void event(DistributedDatabaseEvent distributedDatabaseEvent) {
                            if (distributedDatabaseEvent.getType() == 3) {
                                // empty if block
                            }
                        }
                    }, this.getStatusKey(byArray, "Friend status de-registration for closedown"), distributedDatabaseContactArray2);
                    return;
                }
                catch (Throwable throwable) {
                    this.log("Failed to remove existing publish", throwable);
                }
                return;
            }
        }
    }

    protected DistributedDatabaseKey getStatusKey(byte[] byArray, String string) throws Exception {
        byte[] byArray2 = "azbuddy:status".getBytes();
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        DistributedDatabaseKey distributedDatabaseKey = this.ddb.createKey(byArray3, string);
        return distributedDatabaseKey;
    }

    protected DistributedDatabaseKey getYGMKey(byte[] byArray, String string) throws Exception {
        byte[] byArray2 = "azbuddy:ygm".getBytes();
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        DistributedDatabaseKey distributedDatabaseKey = this.ddb.createKey(byArray3, string);
        return distributedDatabaseKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConfigDirty() {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            this.config_dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig() {
        long l = SystemTime.getCurrentTime();
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            int n;
            Map map = this.readConfig();
            List list = (List)map.get("friends");
            if (list != null) {
                if (list.size() == 0) {
                    this.deleteConfig();
                } else {
                    for (n = 0; n < list.size(); ++n) {
                        Long l2;
                        int n2;
                        long l3;
                        long l4;
                        Iterator<BuddyPluginBuddy> iterator = list.get(n);
                        if (!(iterator instanceof Map)) continue;
                        Map object = (Map)((Object)iterator);
                        Long l5 = (Long)object.get("ct");
                        long l6 = l4 = l5 == null ? l : l5;
                        if (l4 > l) {
                            l4 = l;
                        }
                        String string = new String((byte[])object.get("pk"));
                        List list2 = (List)object.get("ygm");
                        String string2 = this.decodeString((byte[])object.get("n"));
                        Long l7 = (Long)object.get("ls");
                        int n3 = l7 == null ? 0 : l7.intValue();
                        Long l8 = (Long)object.get("lo");
                        long l9 = l3 = l8 == null ? 0L : l8;
                        if (l3 > l) {
                            l3 = l;
                        }
                        int n4 = n2 = (l2 = (Long)object.get("ss")) == null ? 1 : l2.intValue();
                        if (n2 == 2) continue;
                        Long l10 = (Long)object.get("v");
                        int n5 = l10 == null ? 1 : l10.intValue();
                        String string3 = this.decodeString((byte[])object.get("lc"));
                        String string4 = this.decodeString((byte[])object.get("rc"));
                        BuddyPluginBuddy buddyPluginBuddy = new BuddyPluginBuddy(this, l4, n2, true, string, string2, n5, string3, string4, n3, l3, list2);
                        byte[] byArray = (byte[])object.get("ip");
                        if (byArray != null) {
                            try {
                                InetAddress inetAddress = InetAddress.getByAddress(byArray);
                                int n6 = ((Long)object.get("tcp")).intValue();
                                int n7 = ((Long)object.get("udp")).intValue();
                                buddyPluginBuddy.setCachedStatus(inetAddress, n6, n7);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        this.logMessage("Loaded buddy " + buddyPluginBuddy.getString());
                        this.buddies.add(buddyPluginBuddy);
                        this.buddies_map.put(string, buddyPluginBuddy);
                    }
                }
            }
            n = this.buddies.size();
            for (BuddyPluginBuddy buddyPluginBuddy : this.buddies) {
                buddyPluginBuddy.setInitialStatus(l, n);
            }
        }
    }

    protected String decodeString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, "UTF8");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void saveConfig() {
        this.saveConfig(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig(boolean bl) {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            if (this.config_dirty || bl) {
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < this.buddies.size(); ++i) {
                    boolean bl2;
                    String string;
                    BuddyPluginBuddy buddyPluginBuddy = this.buddies.get(i);
                    if (!buddyPluginBuddy.isAuthorised()) continue;
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("ct", new Long(buddyPluginBuddy.getCreatedTime()));
                    hashMap.put("pk", buddyPluginBuddy.getPublicKey());
                    List list = buddyPluginBuddy.getYGMMarkers();
                    if (list != null) {
                        hashMap.put("ygm", list);
                    }
                    if ((string = buddyPluginBuddy.getNickName()) != null) {
                        hashMap.put("n", string);
                    }
                    hashMap.put("ls", new Long(buddyPluginBuddy.getLastStatusSeq()));
                    hashMap.put("lo", new Long(buddyPluginBuddy.getLastTimeOnline()));
                    hashMap.put("ss", new Long(buddyPluginBuddy.getSubsystem()));
                    hashMap.put("v", new Long(buddyPluginBuddy.getVersion()));
                    if (buddyPluginBuddy.getLocalAuthorisedRSSCategoriesAsString() != null) {
                        hashMap.put("lc", buddyPluginBuddy.getLocalAuthorisedRSSCategoriesAsString());
                    }
                    if (buddyPluginBuddy.getRemoteAuthorisedRSSCategoriesAsString() != null) {
                        hashMap.put("rc", buddyPluginBuddy.getRemoteAuthorisedRSSCategoriesAsString());
                    }
                    boolean bl3 = bl2 = buddyPluginBuddy.isConnected() || this.connected_at_close != null && this.connected_at_close.contains(buddyPluginBuddy);
                    if (bl2) {
                        InetAddress inetAddress = buddyPluginBuddy.getIP();
                        int n = buddyPluginBuddy.getTCPPort();
                        int n2 = buddyPluginBuddy.getUDPPort();
                        if (inetAddress != null) {
                            hashMap.put("ip", inetAddress.getAddress());
                            hashMap.put("tcp", new Long(n));
                            hashMap.put("udp", new Long(n2));
                        }
                    }
                    arrayList.add(hashMap);
                }
                HashMap hashMap = new HashMap();
                if (arrayList.size() > 0) {
                    hashMap.put("friends", arrayList);
                    this.writeConfig(hashMap);
                } else {
                    this.deleteConfig();
                }
                this.config_dirty = false;
            }
        }
    }

    public BuddyPluginBuddy addBuddy(String string, int n) {
        return this.addBuddy(string, n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BuddyPluginBuddy addBuddy(String string, int n, boolean bl) {
        if (string.length() == 0 || !this.verifyPublicKey(string)) {
            return null;
        }
        BuddyPluginBuddy buddyPluginBuddy = null;
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            for (int i = 0; i < this.buddies.size(); ++i) {
                BuddyPluginBuddy buddyPluginBuddy2 = this.buddies.get(i);
                if (!buddyPluginBuddy2.getPublicKey().equals(string)) continue;
                if (buddyPluginBuddy2.getSubsystem() != n) {
                    this.log("Buddy " + buddyPluginBuddy2.getString() + ": subsystem changed from " + buddyPluginBuddy2.getSubsystem() + " to " + n);
                    buddyPluginBuddy2.setSubsystem(n);
                    this.saveConfig(true);
                }
                if (bl && !buddyPluginBuddy2.isAuthorised()) {
                    this.log("Buddy " + buddyPluginBuddy2.getString() + ": no authorised");
                    buddyPluginBuddy2.setAuthorised(true);
                    buddyPluginBuddy = buddyPluginBuddy2;
                    continue;
                }
                return buddyPluginBuddy2;
            }
            if (buddyPluginBuddy == null) {
                buddyPluginBuddy = new BuddyPluginBuddy(this, SystemTime.getCurrentTime(), n, bl, string, null, 2, null, null, 0, 0L, null);
                this.buddies.add(buddyPluginBuddy);
                this.buddies_map.put(string, buddyPluginBuddy);
                if (!bl) {
                    this.log("Added unauthorised buddy: " + buddyPluginBuddy.getString());
                }
            }
            if (buddyPluginBuddy.isAuthorised()) {
                this.logMessage("Added buddy " + buddyPluginBuddy.getString());
                this.saveConfig(true);
            }
        }
        this.fireAdded(buddyPluginBuddy);
        return buddyPluginBuddy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBuddy(BuddyPluginBuddy buddyPluginBuddy) {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            if (!this.buddies.remove(buddyPluginBuddy)) {
                return;
            }
            this.buddies_map.remove(buddyPluginBuddy.getPublicKey());
            this.logMessage("Removed friend " + buddyPluginBuddy.getString());
            this.saveConfig(true);
        }
        buddyPluginBuddy.destroy();
        this.fireRemoved(buddyPluginBuddy);
    }

    protected Map readConfig() {
        File file = new File(this.plugin_interface.getUtilities().getAzureusUserDir(), "friends.config");
        return this.readConfigFile(file);
    }

    protected void writeConfig(Map map) {
        File file = new File(this.plugin_interface.getUtilities().getAzureusUserDir(), "friends.config");
        this.writeConfigFile(file, map);
    }

    protected void deleteConfig() {
        File file = new File(this.plugin_interface.getUtilities().getAzureusUserDir(), "friends.config");
        Utilities utilities = this.plugin_interface.getUtilities();
        this.plugin_interface.getUtilities().deleteResilientBEncodedFile(file.getParentFile(), file.getName(), true);
    }

    protected Map readConfigFile(File file) {
        Utilities utilities = this.plugin_interface.getUtilities();
        HashMap hashMap = utilities.readResilientBEncodedFile(file.getParentFile(), file.getName(), true);
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        return hashMap;
    }

    protected boolean writeConfigFile(File file, Map map) {
        Utilities utilities = this.plugin_interface.getUtilities();
        this.plugin_interface.getUtilities().writeResilientBEncodedFile(file.getParentFile(), file.getName(), map, true);
        return file.exists();
    }

    protected File getBuddyConfigDir() {
        return new File(this.plugin_interface.getUtilities().getAzureusUserDir(), "friends");
    }

    public BuddyPluginAZ2 getAZ2Handler() {
        return this.az2_handler;
    }

    public String getPublicKey() {
        try {
            return Base32.encode(this.ecc_handler.getPublicKey("Friend get key"));
        }
        catch (Throwable throwable) {
            this.logMessage("Failed to access public key", throwable);
            return null;
        }
    }

    public boolean verifyPublicKey(String string) {
        return this.ecc_handler.verifyPublicKey(Base32.decode(string));
    }

    protected void checkBuddiesAndRepublish() {
        this.updateBuddys();
        this.plugin_interface.getUtilities().createTimer("Buddy checker").addPeriodicEvent(10000L, new UTTimerEventPerformer(){
            int tick_count;

            public void perform(UTTimerEvent uTTimerEvent) {
                ++this.tick_count;
                if (!BuddyPlugin.this.isEnabled()) {
                    return;
                }
                BuddyPlugin.this.updateBuddys();
                if (this.tick_count % 60 == 0 && BuddyPlugin.this.latest_publish.isEnabled()) {
                    BuddyPlugin.this.updatePublish(BuddyPlugin.this.latest_publish);
                }
                if (this.tick_count % 30 == 0) {
                    BuddyPlugin.this.checkMessagePending(this.tick_count);
                }
                if (this.tick_count % 6 == 0) {
                    BuddyPlugin.this.checkUnauthBloom();
                }
                if (this.tick_count % 6 == 0) {
                    BuddyPlugin.this.saveConfig();
                }
                if (this.tick_count % 6 == 0) {
                    BuddyPlugin.this.checkPersistentDispatch();
                }
                if (BuddyPlugin.this.buddy_tracker != null) {
                    BuddyPlugin.this.buddy_tracker.tick(this.tick_count);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBuddys() {
        ArrayList<BuddyPluginBuddy> arrayList;
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            arrayList = new ArrayList<BuddyPluginBuddy>(this.buddies);
        }
        long l = SystemTime.getCurrentTime();
        Random random = new Random();
        for (int i = 0; i < arrayList.size(); ++i) {
            BuddyPluginBuddy buddyPluginBuddy = (BuddyPluginBuddy)arrayList.get(i);
            long l2 = buddyPluginBuddy.getLastStatusCheckTime();
            buddyPluginBuddy.checkTimeouts();
            int n = 180000 + 60000 * arrayList.size() / 5;
            if (l - l2 <= (long)(n += random.nextInt(120000)) || buddyPluginBuddy.statusCheckActive() || !buddyPluginBuddy.isAuthorised()) continue;
            this.updateBuddyStatus(buddyPluginBuddy);
        }
        BuddyPlugin buddyPlugin2 = this;
        synchronized (buddyPlugin2) {
            for (int i = 0; i < arrayList.size(); ++i) {
                BuddyPluginBuddy buddyPluginBuddy = (BuddyPluginBuddy)arrayList.get(i);
                if (!buddyPluginBuddy.isIdle() || buddyPluginBuddy.isAuthorised()) continue;
                this.removeBuddy(buddyPluginBuddy);
            }
        }
    }

    protected void updateBuddyStatus(final BuddyPluginBuddy buddyPluginBuddy) {
        if (!buddyPluginBuddy.statusCheckStarts()) {
            return;
        }
        this.log("Updating buddy status: " + buddyPluginBuddy.getString());
        try {
            final byte[] byArray = buddyPluginBuddy.getRawPublicKey();
            DistributedDatabaseKey distributedDatabaseKey = this.getStatusKey(byArray, "Friend status check for " + buddyPluginBuddy.getName());
            this.ddb.read(new DistributedDatabaseListener(){
                private long latest_time;
                private Map status;

                public void event(DistributedDatabaseEvent distributedDatabaseEvent) {
                    int n = distributedDatabaseEvent.getType();
                    if (n == 2) {
                        try {
                            byte[] byArray2;
                            Map map;
                            DistributedDatabaseValue distributedDatabaseValue = distributedDatabaseEvent.getValue();
                            long l = distributedDatabaseValue.getCreationTime();
                            if (l > this.latest_time && (map = BuddyPlugin.this.verifyAndExtract(byArray2 = (byte[])distributedDatabaseValue.getValue(byte[].class), byArray)) != null) {
                                this.status = map;
                                this.latest_time = l;
                            }
                        }
                        catch (Throwable throwable) {
                            BuddyPlugin.this.log("Read failed", throwable);
                        }
                    } else if (n == 5 || n == 4) {
                        if (this.status == null) {
                            buddyPluginBuddy.statusCheckFailed();
                        } else {
                            try {
                                int n2 = ((Long)this.status.get("t")).intValue();
                                int n3 = ((Long)this.status.get("u")).intValue();
                                InetAddress inetAddress = InetAddress.getByAddress((byte[])this.status.get("i"));
                                String string = BuddyPlugin.this.decodeString((byte[])this.status.get("n"));
                                Long l = (Long)this.status.get("s");
                                int n4 = l == null ? 0 : l.intValue();
                                Long l2 = (Long)this.status.get("o");
                                int n5 = l2 == null ? 0 : l2.intValue();
                                Long l3 = (Long)this.status.get("v");
                                int n6 = l3 == null ? 1 : l3.intValue();
                                buddyPluginBuddy.statusCheckComplete(this.latest_time, inetAddress, n2, n3, string, n5, n4, n6);
                            }
                            catch (Throwable throwable) {
                                buddyPluginBuddy.statusCheckFailed();
                                BuddyPlugin.this.log("Status decode failed", throwable);
                            }
                        }
                    }
                }
            }, distributedDatabaseKey, 120000L);
        }
        catch (Throwable throwable) {
            buddyPluginBuddy.statusCheckFailed();
            this.log("Friend status update failed: " + buddyPluginBuddy.getString(), throwable);
        }
    }

    protected Map verifyAndExtract(byte[] byArray, byte[] byArray2) throws BuddyPluginException {
        int n = byArray[0] & 0xFF;
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[byArray.length - 1 - n];
        System.arraycopy(byArray, 1, byArray3, 0, n);
        System.arraycopy(byArray, 1 + n, byArray4, 0, byArray4.length);
        try {
            if (this.ecc_handler.verify(byArray2, byArray4, byArray3)) {
                return BDecoder.decode(byArray4);
            }
            this.logMessage("Signature verification failed");
            return null;
        }
        catch (Throwable throwable) {
            this.rethrow("Verification failed", throwable);
            return null;
        }
    }

    protected byte[] signAndInsert(Map map, String string) throws BuddyPluginException {
        try {
            byte[] byArray = BEncoder.encode(map);
            byte[] byArray2 = this.ecc_handler.sign(byArray, string);
            byte[] byArray3 = new byte[1 + byArray2.length + byArray.length];
            byArray3[0] = (byte)byArray2.length;
            System.arraycopy(byArray2, 0, byArray3, 1, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, 1 + byArray2.length, byArray.length);
            return byArray3;
        }
        catch (Throwable throwable) {
            this.rethrow("Signing failed", throwable);
            return null;
        }
    }

    public boolean verify(String string, byte[] byArray, byte[] byArray2) throws BuddyPluginException {
        return this.verify(Base32.decode(string), byArray, byArray2);
    }

    protected boolean verify(BuddyPluginBuddy buddyPluginBuddy, byte[] byArray, byte[] byArray2) throws BuddyPluginException {
        return this.verify(buddyPluginBuddy.getRawPublicKey(), byArray, byArray2);
    }

    protected boolean verify(byte[] byArray, byte[] byArray2, byte[] byArray3) throws BuddyPluginException {
        try {
            return this.ecc_handler.verify(byArray, byArray2, byArray3);
        }
        catch (Throwable throwable) {
            this.rethrow("Verification failed", throwable);
            return false;
        }
    }

    public byte[] sign(byte[] byArray) throws BuddyPluginException {
        try {
            return this.ecc_handler.sign(byArray, "Friend message signing");
        }
        catch (Throwable throwable) {
            this.rethrow("Signing failed", throwable);
            return null;
        }
    }

    protected cryptoResult encrypt(BuddyPluginBuddy buddyPluginBuddy, byte[] byArray) throws BuddyPluginException {
        return this.encrypt(buddyPluginBuddy.getPublicKey(), byArray, buddyPluginBuddy.getName());
    }

    public cryptoResult encrypt(String string, byte[] byArray, String string2) throws BuddyPluginException {
        try {
            byte[] byArray2 = new byte[20];
            this.random.nextBytes(byArray2);
            HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
            hashMap.put("h", byArray2);
            hashMap.put("p", byArray);
            final byte[] byArray3 = this.ecc_handler.encrypt(Base32.decode(string), BEncoder.encode(hashMap), "Encrypting message for " + string2);
            final byte[] byArray4 = new SHA1Simple().calculateHash(byArray2);
            return new cryptoResult(){

                public byte[] getChallenge() {
                    return byArray4;
                }

                public byte[] getPayload() {
                    return byArray3;
                }
            };
        }
        catch (Throwable throwable) {
            this.rethrow("Encryption failed", throwable);
            return null;
        }
    }

    protected cryptoResult decrypt(BuddyPluginBuddy buddyPluginBuddy, byte[] byArray, String string) throws BuddyPluginException {
        try {
            byte[] byArray2 = this.ecc_handler.decrypt(buddyPluginBuddy.getRawPublicKey(), byArray, "Decrypting message for " + buddyPluginBuddy.getName());
            final Map map = BDecoder.decode(byArray2);
            return new cryptoResult(){

                public byte[] getChallenge() {
                    return (byte[])map.get("h");
                }

                public byte[] getPayload() {
                    return (byte[])map.get("p");
                }
            };
        }
        catch (Throwable throwable) {
            this.rethrow("Decryption failed", throwable);
            return null;
        }
    }

    public cryptoResult decrypt(String string, byte[] byArray) throws BuddyPluginException {
        try {
            byte[] byArray2 = this.ecc_handler.decrypt(Base32.decode(string), byArray, "Decrypting message for " + string);
            final Map map = BDecoder.decode(byArray2);
            return new cryptoResult(){

                public byte[] getChallenge() {
                    return (byte[])map.get("h");
                }

                public byte[] getPayload() {
                    return (byte[])map.get("p");
                }
            };
        }
        catch (Throwable throwable) {
            this.rethrow("Decryption failed", throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMessagePending(BuddyPluginBuddy buddyPluginBuddy, final operationListener operationListener2) throws BuddyPluginException {
        try {
            this.checkAvailable();
            final String string = "Friend YGM write for " + buddyPluginBuddy.getName();
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("r", new Long(this.random.nextLong()));
            byte[] byArray = this.signAndInsert(hashMap, string);
            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
            hashMap2.put("pk", this.ecc_handler.getPublicKey(string));
            hashMap2.put("ss", byArray);
            DistributedDatabaseValue distributedDatabaseValue = this.ddb.createValue(BEncoder.encode(hashMap2));
            this.logMessage(string + " starts: " + hashMap);
            DistributedDatabaseKey distributedDatabaseKey = this.getYGMKey(buddyPluginBuddy.getRawPublicKey(), string);
            this.ddb.write(new DistributedDatabaseListener(){

                public void event(DistributedDatabaseEvent distributedDatabaseEvent) {
                    int n = distributedDatabaseEvent.getType();
                    if (n == 5 || n == 4) {
                        BuddyPlugin.this.logMessage(string + " complete");
                        operationListener2.complete();
                    }
                }
            }, distributedDatabaseKey, distributedDatabaseValue);
        }
        catch (Throwable throwable) {
            try {
                this.rethrow("Failed to publish YGM", throwable);
                Object var10_10 = null;
                operationListener2.complete();
            }
            catch (Throwable throwable2) {
                Object var10_11 = null;
                operationListener2.complete();
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMessagePending(int n) {
        Object object;
        this.log("Checking YGM");
        if (n % 360 == 0) {
            object = this;
            synchronized (object) {
                ygm_unauth_bloom = null;
            }
        }
        try {
            object = "Friend YGM check";
            byte[] byArray = this.ecc_handler.getPublicKey((String)object);
            DistributedDatabaseKey distributedDatabaseKey = this.getYGMKey(byArray, (String)object);
            this.ddb.read(new DistributedDatabaseListener(){
                private List new_ygm_buddies = new ArrayList();
                private boolean unauth_permitted = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void event(DistributedDatabaseEvent distributedDatabaseEvent) {
                    block15: {
                        int n = distributedDatabaseEvent.getType();
                        if (n == 2) {
                            try {
                                long l;
                                DistributedDatabaseValue distributedDatabaseValue = distributedDatabaseEvent.getValue();
                                byte[] byArray = (byte[])distributedDatabaseValue.getValue(byte[].class);
                                Map map = BDecoder.decode(byArray);
                                byte[] byArray2 = (byte[])map.get("pk");
                                if (byArray2 == null) {
                                    return;
                                }
                                String string = Base32.encode(byArray2);
                                BuddyPluginBuddy buddyPluginBuddy = BuddyPlugin.this.getBuddyFromPublicKey(string);
                                if (buddyPluginBuddy == null || !buddyPluginBuddy.isAuthorised()) {
                                    if (buddyPluginBuddy == null) {
                                        BuddyPlugin.this.log("YGM entry from unknown friend '" + string + "' - ignoring");
                                    } else {
                                        BuddyPlugin.this.log("YGM entry from unauthorised friend '" + string + "' - ignoring");
                                    }
                                    byte[] byArray3 = distributedDatabaseEvent.getContact().getAddress().getAddress().getAddress();
                                    BuddyPlugin buddyPlugin = BuddyPlugin.this;
                                    synchronized (buddyPlugin) {
                                        if (ygm_unauth_bloom == null) {
                                            ygm_unauth_bloom = BloomFilterFactory.createAddOnly(512);
                                        }
                                        if (!ygm_unauth_bloom.contains(byArray3)) {
                                            ygm_unauth_bloom.add(byArray3);
                                            this.unauth_permitted = true;
                                        }
                                        break block15;
                                    }
                                }
                                byte[] byArray4 = (byte[])map.get("ss");
                                Map map2 = BuddyPlugin.this.verifyAndExtract(byArray4, byArray2);
                                if (map2 != null && buddyPluginBuddy.addYGMMarker(l = ((Long)map2.get("r")).longValue())) {
                                    this.new_ygm_buddies.add(buddyPluginBuddy);
                                }
                            }
                            catch (Throwable throwable) {
                                BuddyPlugin.this.log("Read failed", throwable);
                            }
                        } else if (!(n != 5 && n != 4 || this.new_ygm_buddies.size() <= 0 && !this.unauth_permitted)) {
                            BuddyPluginBuddy[] buddyPluginBuddyArray = new BuddyPluginBuddy[this.new_ygm_buddies.size()];
                            this.new_ygm_buddies.toArray(buddyPluginBuddyArray);
                            BuddyPlugin.this.fireYGM(buddyPluginBuddyArray);
                        }
                    }
                }
            }, distributedDatabaseKey, 120000L, 1);
            boolean bl = false;
            BuddyPlugin buddyPlugin = this;
            synchronized (buddyPlugin) {
                if (!this.bogus_ygm_written) {
                    bl = true;
                    this.bogus_ygm_written = true;
                }
            }
            if (bl) {
                HashMap hashMap = new HashMap();
                DistributedDatabaseValue distributedDatabaseValue = this.ddb.createValue(BEncoder.encode(hashMap));
                this.logMessage("Friend YGM write for myself starts");
                this.ddb.write(new DistributedDatabaseListener(){

                    public void event(DistributedDatabaseEvent distributedDatabaseEvent) {
                        int n = distributedDatabaseEvent.getType();
                        if (n == 4) {
                            BuddyPlugin.this.logMessage("Friend YGM write for myself complete");
                        }
                    }
                }, distributedDatabaseKey, distributedDatabaseValue);
            }
        }
        catch (Throwable throwable) {
            this.logMessage("YGM check failed", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuddyPluginBuddy getBuddyFromPublicKey(String string) {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            return this.buddies_map.get(string);
        }
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    protected SESecurityManager getSecurityManager() {
        return this.sec_man;
    }

    protected GenericMessageRegistration getMessageRegistration() {
        return this.msg_registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BuddyPluginBuddy> getBuddies() {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            ArrayList<BuddyPluginBuddy> arrayList = new ArrayList<BuddyPluginBuddy>();
            for (int i = 0; i < this.buddies.size(); ++i) {
                BuddyPluginBuddy buddyPluginBuddy = this.buddies.get(i);
                if (!buddyPluginBuddy.isAuthorised()) continue;
                arrayList.add(buddyPluginBuddy);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<BuddyPluginBuddy> getAllBuddies() {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            return new ArrayList<BuddyPluginBuddy>(this.buddies);
        }
    }

    public boolean isAvailable() {
        try {
            this.checkAvailable();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected void checkAvailable() throws BuddyPluginException {
        if (this.initialisation_state == 0) {
            throw new BuddyPluginException("Plugin not yet initialised");
        }
        if (this.initialisation_state == 2) {
            throw new BuddyPluginException("Plugin unavailable");
        }
    }

    protected void fireInitialised(boolean bl) {
        this.initialisation_state = bl ? 1 : 2;
        this.persistentDispatchInit();
        if (bl) {
            this.buddy_tracker.initialise();
        }
        List<BuddyPluginListener> list = this.listeners.getList();
        for (int i = 0; i < list.size(); ++i) {
            try {
                list.get(i).initialised(bl);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public void addListener(BuddyPluginListener buddyPluginListener) {
        if (this.listeners.contains(buddyPluginListener)) {
            return;
        }
        this.listeners.add(buddyPluginListener);
        if (this.initialisation_state != 0) {
            buddyPluginListener.initialised(this.initialisation_state == 1);
        }
    }

    public void removeListener(BuddyPluginListener buddyPluginListener) {
        this.listeners.remove(buddyPluginListener);
    }

    protected Map requestReceived(BuddyPluginBuddy buddyPluginBuddy, int n, Map map) throws BuddyPluginException {
        List<BuddyPluginBuddyRequestListener> list = this.request_listeners.getList();
        for (int i = 0; i < list.size(); ++i) {
            try {
                Map map2 = list.get(i).requestReceived(buddyPluginBuddy, n, map);
                if (map2 == null) continue;
                return map2;
            }
            catch (BuddyPluginException buddyPluginException) {
                throw buddyPluginException;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                throw new BuddyPluginException("Request processing failed", throwable);
            }
        }
        return null;
    }

    protected void fireAdded(BuddyPluginBuddy buddyPluginBuddy) {
        if (buddyPluginBuddy.isAuthorised()) {
            buddyPluginBuddy.setLocalAuthorisedRSSCategories(this.public_categories);
            List<BuddyPluginListener> list = this.listeners.getList();
            for (int i = 0; i < list.size(); ++i) {
                try {
                    list.get(i).buddyAdded(buddyPluginBuddy);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    protected void fireRemoved(BuddyPluginBuddy buddyPluginBuddy) {
        if (buddyPluginBuddy.isAuthorised()) {
            List<BuddyPluginListener> list = this.listeners.getList();
            for (int i = 0; i < list.size(); ++i) {
                try {
                    list.get(i).buddyRemoved(buddyPluginBuddy);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    protected void fireDetailsChanged(BuddyPluginBuddy buddyPluginBuddy) {
        if (buddyPluginBuddy.isAuthorised()) {
            List<BuddyPluginListener> list = this.listeners.getList();
            for (int i = 0; i < list.size(); ++i) {
                try {
                    list.get(i).buddyChanged(buddyPluginBuddy);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    protected void fireYGM(BuddyPluginBuddy[] buddyPluginBuddyArray) {
        List<BuddyPluginBuddyRequestListener> list = this.request_listeners.getList();
        for (int i = 0; i < list.size(); ++i) {
            try {
                list.get(i).pendingMessages(buddyPluginBuddyArray);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void fireEnabledStateChanged() {
        boolean bl = !this.plugin_interface.getPluginState().isDisabled() && this.isEnabled();
        List<BuddyPluginListener> list = this.listeners.getList();
        for (int i = 0; i < list.size(); ++i) {
            try {
                list.get(i).enabledStateChanged(bl);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void rethrow(String string, Throwable throwable) throws BuddyPluginException {
        this.logMessage(string, throwable);
        if (throwable instanceof CryptoManagerPasswordException) {
            throw new BuddyPluginPasswordException(((CryptoManagerPasswordException)throwable).wasIncorrect(), string, throwable);
        }
        throw new BuddyPluginException(string, throwable);
    }

    public InputStream handleURLProtocol(AZPluginConnection aZPluginConnection, String string) throws IPCException {
        String[] stringArray = string.split("&");
        String string2 = null;
        String string3 = "All";
        byte[] byArray = null;
        for (String string4 : stringArray) {
            String[] stringArray2 = string4.split("=");
            String string5 = stringArray2[0];
            String string6 = UrlUtils.decode(stringArray2[1]);
            if (string5.equals("pk")) {
                string2 = string6;
                continue;
            }
            if (string5.equals("cat")) {
                string3 = string6;
                continue;
            }
            if (!string5.equals("hash")) continue;
            byArray = Base32.decode(string6);
        }
        if (string2 == null) {
            throw new IPCException("Public key missing from '" + string + "'");
        }
        BuddyPluginBuddy buddyPluginBuddy = this.getBuddyFromPublicKey(string2);
        if (buddyPluginBuddy == null) {
            throw new IPCException("Buddy with public key '" + string2 + "' not found");
        }
        if (byArray == null) {
            return this.handleUPRSS(aZPluginConnection, buddyPluginBuddy, string3);
        }
        return this.handleUPTorrent(aZPluginConnection, buddyPluginBuddy, string3, byArray);
    }

    public InputStream handleUPRSS(final AZPluginConnection aZPluginConnection, BuddyPluginBuddy buddyPluginBuddy, String string) throws IPCException {
        if (!buddyPluginBuddy.isOnline(true)) {
            throw new IPCException("Buddy isn't online");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        final String string2 = aZPluginConnection.getRequestProperty("If-Modified-Since");
        try {
            hashMap.put("cat", string.getBytes("UTF-8"));
            if (string2 != null) {
                hashMap.put("if_mod", string2);
            }
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
        final Object[] objectArray = new Object[]{null};
        final AESemaphore aESemaphore = new AESemaphore("BuddyPlugin:rss");
        final String string3 = buddyPluginBuddy.getPublicKey() + "-" + string;
        this.az2_handler.sendAZ2RSSMessage(buddyPluginBuddy, hashMap, new BuddyPluginAZ2TrackerListener(){

            public Map messageReceived(BuddyPluginBuddy buddyPluginBuddy, Map map) {
                try {
                    byte[] byArray = (byte[])map.get("rss");
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    objectArray[0] = byteArrayInputStream;
                    aZPluginConnection.setHeaderField("ETag", string3);
                    byte[] byArray2 = (byte[])map.get("last_mod");
                    if (byArray2 != null) {
                        String string = new String(byArray2, "UTF-8");
                        aZPluginConnection.setHeaderField("Last-Modified", string);
                        if (string2 != null && string2.equals(string) && byArray.length == 0) {
                            aZPluginConnection.setResponse(304, "Not Modified");
                        }
                    }
                    aESemaphore.release();
                }
                catch (Throwable throwable) {
                    this.messageFailed(buddyPluginBuddy, throwable);
                }
                return null;
            }

            public void messageFailed(BuddyPluginBuddy buddyPluginBuddy, Throwable throwable) {
                objectArray[0] = new IPCException("Read failed", throwable);
                aESemaphore.release();
            }
        });
        aESemaphore.reserve(60000L);
        if (objectArray[0] == null) {
            throw new IPCException("Timeout");
        }
        if (objectArray[0] instanceof InputStream) {
            return (InputStream)objectArray[0];
        }
        throw (IPCException)objectArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream handleUPTorrent(AZPluginConnection aZPluginConnection, final BuddyPluginBuddy buddyPluginBuddy, String string, byte[] byArray) throws IPCException {
        Object object;
        final Object[] objectArray = new Object[]{null};
        final AESemaphore aESemaphore = new AESemaphore("BuddyPlugin:upt");
        this.log("Attempting to download torrent for " + Base32.encode(byArray));
        if (buddyPluginBuddy.isOnline(true)) {
            try {
                object = new HashMap<String, byte[]>();
                try {
                    object.put("cat", string.getBytes("UTF-8"));
                    object.put("hash", byArray);
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
                this.az2_handler.sendAZ2RSSMessage(buddyPluginBuddy, (Map)object, new BuddyPluginAZ2TrackerListener(){
                    private boolean result_set;

                    public Map messageReceived(BuddyPluginBuddy buddyPluginBuddy, Map map) {
                        try {
                            byte[] byArray = (byte[])map.get("torrent");
                            BuddyPlugin.this.log("    torrent downloaded from buddy");
                            this.setResult(byArray);
                        }
                        catch (Throwable throwable) {
                            this.messageFailed(buddyPluginBuddy, throwable);
                        }
                        return null;
                    }

                    public void messageFailed(BuddyPluginBuddy buddyPluginBuddy, Throwable throwable) {
                        this.setResult(new IPCException("Read failed", throwable));
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void setResult(Object object) {
                        Object[] objectArray2 = objectArray;
                        synchronized (objectArray) {
                            if (this.result_set) {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return;
                            }
                            this.result_set = true;
                            if (!(objectArray[0] instanceof byte[])) {
                                objectArray[0] = object;
                            }
                            aESemaphore.release();
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                objectArray[0] = new IPCException("Buddy torrent get failed", throwable);
                aESemaphore.release();
            }
        } else {
            objectArray[0] = new IPCException("Buddy is offline");
            aESemaphore.release();
        }
        object = this.getMagnetPlugin();
        if (object == null) {
            Object[] objectArray2 = objectArray;
            synchronized (objectArray) {
                if (objectArray[0] == null) {
                    objectArray[0] = new IPCException("Magnet plugin unavailable");
                }
                // ** MonitorExit[var10_10] (shouldn't be in output)
                aESemaphore.release();
            }
        } else {
            new AEThread2("BuddyPlugin:mag", true, (MagnetPlugin)object, byArray, aESemaphore){
                private boolean result_set;
                final /* synthetic */ MagnetPlugin val$magnet_plugin;
                final /* synthetic */ byte[] val$hash;
                final /* synthetic */ AESemaphore val$result_sem;
                {
                    this.val$magnet_plugin = magnetPlugin;
                    this.val$hash = byArray;
                    this.val$result_sem = aESemaphore;
                    super(string, bl);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        if (buddyPluginBuddy.isOnline(true)) {
                            Thread.sleep(10000L);
                        }
                        Object[] objectArray2 = objectArray;
                        synchronized (objectArray) {
                            if (objectArray[0] instanceof byte[]) {
                                this.setResult(null);
                                // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                                return;
                            }
                            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                            objectArray2 = this.val$magnet_plugin.download(new MagnetPluginProgressListener(){

                                public void reportSize(long l) {
                                }

                                public void reportActivity(String string) {
                                    if (string.indexOf(" found ") == -1 && string.indexOf(" is dead ") == -1) {
                                        BuddyPlugin.this.log("    MagnetDownload: " + string);
                                    }
                                }

                                public void reportCompleteness(int n) {
                                }

                                public void reportContributor(InetSocketAddress inetSocketAddress) {
                                }
                            }, this.val$hash, "", new InetSocketAddress[0], 120000L);
                            if (objectArray2 == null) {
                                this.setResult(new IPCException("Magnet timeout"));
                            } else {
                                BuddyPlugin.this.log("    torrent downloaded from magnet");
                                this.setResult(objectArray2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        this.setResult(new IPCException("Magnet get failed", throwable));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void setResult(Object object) {
                    Object[] objectArray2 = objectArray;
                    synchronized (objectArray) {
                        if (this.result_set) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                        this.result_set = true;
                        if (object != null && (objectArray[0] == null || object instanceof byte[] && !(objectArray[0] instanceof byte[]))) {
                            objectArray[0] = object;
                        }
                        this.val$result_sem.release();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            }.start();
        }
        {
            long l;
            long l2 = SystemTime.getMonotonousTime();
            if (aESemaphore.reserve(120000L) && !(objectArray[0] instanceof byte[]) && (l = 120000L - (SystemTime.getMonotonousTime() - l2)) > 0L) {
                aESemaphore.reserve(l);
            }
            if (objectArray[0] == null) {
                this.log("    torrent download timeout");
                throw new IPCException("Timeout");
            }
            if (objectArray[0] instanceof byte[]) {
                return new ByteArrayInputStream((byte[])objectArray[0]);
            }
            IPCException iPCException = (IPCException)objectArray[0];
            this.log("    torrent downloaded failed: " + Debug.getNestedExceptionMessage(iPCException));
            throw iPCException;
        }
    }

    protected MagnetPlugin getMagnetPlugin() {
        PluginInterface pluginInterface = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(MagnetPlugin.class);
        if (pluginInterface == null) {
            return null;
        }
        return (MagnetPlugin)pluginInterface.getPlugin();
    }

    public feedDetails getRSS(BuddyPluginBuddy buddyPluginBuddy, String string, String string2) throws BuddyPluginException {
        Object object;
        Object object2;
        if (!buddyPluginBuddy.isLocalRSSCategoryAuthorised(string)) {
            throw new BuddyPluginException("Unauthorised category '" + string + "'");
        }
        buddyPluginBuddy.localRSSCategoryRead(string);
        Download[] downloadArray = this.plugin_interface.getDownloadManager().getDownloads();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        long l = 0L;
        for (int i = 0; i < downloadArray.length; ++i) {
            object2 = downloadArray[i];
            object = object2.getTorrent();
            if (object == null) continue;
            String string3 = object2.getAttribute(this.ta_category);
            if (!string.equalsIgnoreCase("all") && (string3 == null || !string3.equals(string)) || TorrentUtils.isReallyPrivate(PluginCoreUtils.unwrap((Torrent)object))) continue;
            arrayList.add(object2);
            byte[] byArray = object.getHash();
            int n = byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
            l += (long)n;
        }
        PluginConfig pluginConfig = this.plugin_interface.getPluginconfig();
        object2 = "feed_finger.category." + string;
        object = "feed_date.category." + string;
        long l2 = pluginConfig.getPluginLongParameter((String)object2, 0L);
        long l3 = pluginConfig.getPluginLongParameter((String)object, 0L);
        long l4 = SystemTime.getCurrentTime();
        if (l2 == l) {
            if (arrayList.size() > 0 && (l4 < l3 || l4 - l3 > 21600000L)) {
                l3 = l4;
                pluginConfig.setPluginParameter((String)object, l3);
            }
        } else {
            pluginConfig.setPluginParameter((String)object2, l);
            l3 = l4 <= l3 ? ++l3 : l4;
            pluginConfig.setPluginParameter((String)object, l3);
        }
        String string4 = TimeFormatter.getHTTPDate(l3);
        if (string2 != null && string2.equals(string4)) {
            return new feedDetails(new byte[0], string4);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        AZ3Functions.provider provider2 = AZ3Functions.getProvider();
        try {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8"));
            printWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            printWriter.println("<rss version=\"2.0\" xmlns:vuze=\"http://www.vuze.com\">");
            printWriter.println("<channel>");
            printWriter.println("<title>" + this.escape(string) + "</title>");
            Collections.sort(arrayList, new Comparator<Download>(){

                @Override
                public int compare(Download download, Download download2) {
                    long l = BuddyPlugin.this.getAddedTime(download) / 1000L;
                    long l2 = BuddyPlugin.this.getAddedTime(download2) / 1000L;
                    return (int)(l2 - l);
                }
            });
            printWriter.println("<pubDate>" + string4 + "</pubDate>");
            for (int i = 0; i < arrayList.size(); ++i) {
                String string5;
                Download download = (Download)arrayList.get(i);
                DownloadManager downloadManager = PluginCoreUtils.unwrap(download);
                Torrent torrent = download.getTorrent();
                String string6 = Base32.encode(torrent.getHash());
                printWriter.println("<item>");
                printWriter.println("<title>" + this.escape(download.getName()) + "</title>");
                printWriter.println("<guid>" + string6 + "</guid>");
                if (provider2 != null && (string5 = provider2.getCDPURL(downloadManager)) != null) {
                    printWriter.println("<link>" + this.escape(string5) + "</link>");
                }
                long l5 = downloadManager.getDownloadState().getLongParameter("stats.download.added.time");
                printWriter.println("<pubDate>" + TimeFormatter.getHTTPDate(l5) + "</pubDate>");
                printWriter.println("<vuze:size>" + torrent.getSize() + "</vuze:size>");
                printWriter.println("<vuze:assethash>" + string6 + "</vuze:assethash>");
                String string7 = "azplug:?id=azbuddy&name=Friends&arg=";
                String string8 = "pk=" + this.getPublicKey() + "&cat=" + string + "&hash=" + Base32.encode(torrent.getHash());
                string7 = string7 + URLEncoder.encode(string8, "UTF-8");
                printWriter.println("<vuze:downloadurl>" + this.escape(string7) + "</vuze:downloadurl>");
                DownloadScrapeResult downloadScrapeResult = download.getLastScrapeResult();
                if (downloadScrapeResult != null && downloadScrapeResult.getResponseType() == 1) {
                    printWriter.println("<vuze:seeds>" + downloadScrapeResult.getSeedCount() + "</vuze:seeds>");
                    printWriter.println("<vuze:peers>" + downloadScrapeResult.getNonSeedCount() + "</vuze:peers>");
                }
                printWriter.println("</item>");
            }
            printWriter.println("</channel>");
            printWriter.println("</rss>");
            printWriter.flush();
            return new feedDetails(byteArrayOutputStream.toByteArray(), string4);
        }
        catch (IOException iOException) {
            throw new BuddyPluginException("", iOException);
        }
    }

    public byte[] getRSSTorrent(BuddyPluginBuddy buddyPluginBuddy, String string, byte[] byArray) throws BuddyPluginException {
        if (!buddyPluginBuddy.isLocalRSSCategoryAuthorised(string)) {
            throw new BuddyPluginException("Unauthorised category '" + string + "'");
        }
        try {
            Torrent torrent;
            Download download = this.plugin_interface.getDownloadManager().getDownload(byArray);
            if (download != null && (torrent = download.getTorrent()) != null) {
                String string2 = download.getAttribute(this.ta_category);
                if ((string.equalsIgnoreCase("all") || string2 != null && string2.equals(string)) && !TorrentUtils.isReallyPrivate(PluginCoreUtils.unwrap(torrent))) {
                    torrent = torrent.removeAdditionalProperties();
                    return torrent.writeToBEncodedData();
                }
            }
        }
        catch (Throwable throwable) {
            throw new BuddyPluginException("getTorrent failed", throwable);
        }
        throw new BuddyPluginException("Not found");
    }

    protected long getAddedTime(Download download) {
        DownloadManager downloadManager = PluginCoreUtils.unwrap(download);
        return downloadManager.getDownloadState().getLongParameter("stats.download.added.time");
    }

    protected String escape(String string) {
        return XUXmlWriter.escapeXML(string);
    }

    public void addRequestListener(BuddyPluginBuddyRequestListener buddyPluginBuddyRequestListener) {
        this.request_listeners.add(buddyPluginBuddyRequestListener);
    }

    public void removeRequestListener(BuddyPluginBuddyRequestListener buddyPluginBuddyRequestListener) {
        this.request_listeners.remove(buddyPluginBuddyRequestListener);
    }

    public void logMessage(String string, Throwable throwable) {
        this.logMessage(string + ": " + Debug.getNestedExceptionMessage(throwable), true);
    }

    public void logMessage(String string) {
        this.logMessage(string, false);
    }

    public void logMessage(String string, boolean bl) {
        this.log(string);
        Iterator<BuddyPluginListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().messageLogged(string, bl);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public void log(String string) {
        this.logger.log(string);
    }

    public void log(String string, Throwable throwable) {
        this.logger.log(string + ": " + Debug.getNestedExceptionMessageAndStack(throwable));
    }

    protected class feedDetails {
        private byte[] contents;
        private String last_modified;

        protected feedDetails(byte[] byArray, String string) {
            this.contents = byArray;
            this.last_modified = string;
        }

        protected byte[] getContent() {
            return this.contents;
        }

        protected String getLastModified() {
            return this.last_modified;
        }
    }

    public static interface cryptoResult {
        public byte[] getChallenge();

        public byte[] getPayload();
    }

    protected static interface operationListener {
        public void complete();
    }

    private class publishDetails
    implements Cloneable {
        private byte[] public_key;
        private InetAddress ip;
        private int tcp_port;
        private int udp_port;
        private String nick_name;
        private int online_status = 0;
        private boolean enabled;
        private boolean published;
        private int sequence;

        private publishDetails() {
        }

        protected publishDetails getCopy() {
            try {
                publishDetails publishDetails2 = (publishDetails)this.clone();
                publishDetails2.published = false;
                return publishDetails2;
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        protected boolean isPublished() {
            return this.published;
        }

        protected void setPublished(boolean bl) {
            this.published = bl;
        }

        protected boolean isEnabled() {
            return this.enabled;
        }

        protected void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        protected void setSequence(int n) {
            this.sequence = n;
        }

        protected int getSequence() {
            return this.sequence;
        }

        protected byte[] getPublicKey() {
            return this.public_key;
        }

        protected void setPublicKey(byte[] byArray) {
            this.public_key = byArray;
        }

        protected InetAddress getIP() {
            return this.ip;
        }

        protected void setIP(InetAddress inetAddress) {
            this.ip = inetAddress;
        }

        protected int getTCPPort() {
            return this.tcp_port;
        }

        protected void setTCPPort(int n) {
            this.tcp_port = n;
        }

        protected int getUDPPort() {
            return this.udp_port;
        }

        protected void setUDPPort(int n) {
            this.udp_port = n;
        }

        protected String getNickName() {
            return this.nick_name;
        }

        protected void setNickName(String string) {
            this.nick_name = string;
        }

        protected int getOnlineStatus() {
            return this.online_status;
        }

        protected void setOnlineStatus(int n) {
            this.online_status = n;
        }

        protected String getString() {
            return "enabled=" + this.enabled + ",ip=" + this.ip + ",tcp=" + this.tcp_port + ",udp=" + this.udp_port + ",stat=" + this.online_status + ",key=" + (this.public_key == null ? "<none>" : Base32.encode(this.public_key));
        }
    }
}

