/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.netstatus;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.peermanager.PeerManager;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistrationAdapter;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTBitfield;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHandshake;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHave;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessage;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageEncoder;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTester;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTesterListener;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class NetStatusProtocolTesterBT {
    private static Random random = RandomUtils.SECURE_RANDOM;
    private NetStatusProtocolTester tester;
    private boolean test_initiator;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private byte[] my_hash;
    private byte[] peer_id;
    private PeerManagerRegistration pm_reg;
    private long start_time = SystemTime.getCurrentTime();
    private List sessions = new ArrayList();
    private int session_id_next;
    private int outbound_attempts = 0;
    private int outbound_connects = 0;
    private int inbound_connects = 0;
    private boolean outbound_connections_complete;
    private AESemaphore completion_sem = new AESemaphore("Completion");
    private boolean destroyed;

    protected NetStatusProtocolTesterBT(NetStatusProtocolTester netStatusProtocolTester, boolean bl) {
        this.tester = netStatusProtocolTester;
        this.test_initiator = bl;
    }

    protected void start() {
        this.my_hash = new byte[20];
        random.nextBytes(this.my_hash);
        this.peer_id = new byte[20];
        random.nextBytes(this.peer_id);
        this.pm_reg = PeerManager.getSingleton().registerLegacyManager(new HashWrapper(this.my_hash), new PeerManagerRegistrationAdapter(){

            public byte[][] getSecrets() {
                return new byte[][]{NetStatusProtocolTesterBT.this.my_hash};
            }

            public boolean manualRoute(NetworkConnection networkConnection) {
                NetStatusProtocolTesterBT.this.log("Got incoming connection from " + networkConnection.getEndpoint().getNotionalAddress());
                new Session(networkConnection, null);
                return true;
            }

            public boolean isPeerSourceEnabled(String string) {
                return true;
            }

            public boolean activateRequest(InetSocketAddress inetSocketAddress) {
                return true;
            }

            public void deactivateRequest(InetSocketAddress inetSocketAddress) {
            }

            public String getDescription() {
                return "NetStatusPlugin - router";
            }
        });
        this.log("Incoming routing established for " + ByteFormatter.encodeString(this.my_hash));
    }

    protected byte[] getServerHash() {
        return this.my_hash;
    }

    protected long getStartTime(long l) {
        if (l < this.start_time) {
            this.start_time = l;
        }
        return this.start_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testOutbound(InetSocketAddress inetSocketAddress, byte[] byArray, boolean bl) {
        if (NetworkManager.getCryptoRequired(0)) {
            bl = true;
        }
        this.log("Making outbound connection to " + inetSocketAddress);
        NetStatusProtocolTesterBT netStatusProtocolTesterBT = this;
        synchronized (netStatusProtocolTesterBT) {
            ++this.outbound_attempts;
        }
        boolean bl2 = false;
        ProtocolEndpointTCP protocolEndpointTCP = new ProtocolEndpointTCP(inetSocketAddress);
        ConnectionEndpoint connectionEndpoint = new ConnectionEndpoint(inetSocketAddress);
        connectionEndpoint.addProtocol(protocolEndpointTCP);
        NetworkConnection networkConnection = NetworkManager.getSingleton().createConnection(connectionEndpoint, new BTMessageEncoder(), new BTMessageDecoder(), bl, bl2, new byte[][]{byArray});
        new Session(networkConnection, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList arrayList = new ArrayList();
        List list = this.sessions;
        synchronized (list) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            arrayList.addAll(this.sessions);
            this.sessions.clear();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Session session = (Session)arrayList.get(i);
            session.close();
        }
        this.pm_reg.unregister();
        this.checkCompletion();
        this.log("Incoming routing destroyed for " + ByteFormatter.encodeString(this.my_hash));
    }

    protected boolean isDestroyed() {
        return this.destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutboundConnectionsComplete() {
        List list = this.sessions;
        synchronized (list) {
            this.outbound_connections_complete = true;
        }
        this.checkCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCompletion() {
        boolean bl = false;
        Object object = this.sessions;
        synchronized (object) {
            if (this.completion_sem.isReleasedForever()) {
                return;
            }
            if (this.destroyed || this.outbound_connections_complete && this.sessions.size() == 0) {
                bl = true;
                this.completion_sem.releaseForever();
            }
        }
        if (bl) {
            object = this.listeners.iterator();
            while (object.hasNext()) {
                try {
                    ((NetStatusProtocolTesterListener)object.next()).complete(this);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public boolean waitForCompletion(long l) {
        if (l == 0L) {
            this.completion_sem.reserve();
            return true;
        }
        return this.completion_sem.reserve(l);
    }

    public void addListener(NetStatusProtocolTesterListener netStatusProtocolTesterListener) {
        this.listeners.add(netStatusProtocolTesterListener);
    }

    public void removeListener(NetStatusProtocolTesterListener netStatusProtocolTesterListener) {
        this.listeners.remove(netStatusProtocolTesterListener);
    }

    public int getOutboundConnects() {
        return this.outbound_connects;
    }

    public int getInboundConnects() {
        return this.inbound_connects;
    }

    public String getStatus() {
        return "sessions=" + this.sessions.size() + ", out_attempts=" + this.outbound_attempts + ", out_connect=" + this.outbound_connects + ", in_connect=" + this.inbound_connects;
    }

    protected void log(String string) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((NetStatusProtocolTesterListener)iterator.next()).log(string);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        this.tester.log(string);
    }

    protected void logError(String string) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((NetStatusProtocolTesterListener)iterator.next()).logError(string);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        this.tester.log(string);
    }

    protected void logError(String string, Throwable throwable) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((NetStatusProtocolTesterListener)iterator.next()).logError(string, throwable);
            }
            catch (Throwable throwable2) {
                Debug.printStackTrace(throwable2);
            }
        }
        this.tester.log(string, throwable);
    }

    public class Session {
        private NetworkConnection connection;
        private int session_id;
        private boolean initiator;
        private byte[] info_hash;
        private boolean handshake_sent;
        private boolean handshake_received;
        private boolean bitfield_sent;
        private boolean bitfield_received;
        private int num_pieces;
        private boolean is_seed;
        private Set missing_pieces = new HashSet();
        private boolean connected;
        private boolean closing;
        private boolean closed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Session(NetworkConnection networkConnection, byte[] byArray) {
            this.connection = networkConnection;
            this.info_hash = byArray;
            this.initiator = this.info_hash != null;
            Object object = NetStatusProtocolTesterBT.this.sessions;
            synchronized (object) {
                NetStatusProtocolTesterBT.this.session_id_next++;
                this.session_id = NetStatusProtocolTesterBT.this.session_id_next;
                if (NetStatusProtocolTesterBT.this.destroyed) {
                    this.log("Already destroyed");
                    this.close();
                    return;
                }
                if (!NetStatusProtocolTesterBT.this.test_initiator && !this.initiator) {
                    int n = 0;
                    for (int i = 0; i < NetStatusProtocolTesterBT.this.sessions.size(); ++i) {
                        Session session = (Session)NetStatusProtocolTesterBT.this.sessions.get(i);
                        if (session.isInitiator()) continue;
                        ++n;
                    }
                    if (n >= 2) {
                        this.log("Too many responder sessions");
                        this.close();
                        return;
                    }
                }
                NetStatusProtocolTesterBT.this.sessions.add(this);
                this.is_seed = this.initiator && NetStatusProtocolTesterBT.this.sessions.size() % 2 == 0;
            }
            object = NetStatusProtocolTesterBT.this.listeners.iterator();
            while (object.hasNext()) {
                try {
                    ((NetStatusProtocolTesterListener)object.next()).sessionAdded(this);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            this.connection.connect(3, new NetworkConnection.ConnectionListener(){
                final String type;
                {
                    this.type = Session.this.initiator ? "Outbound" : "Inbound";
                }

                public final void connectStarted() {
                    Session.this.log(this.type + " connect start");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void connectSuccess(ByteBuffer byteBuffer) {
                    Session.this.log(this.type + " connect success");
                    Session.this.connected = true;
                    NetStatusProtocolTesterBT netStatusProtocolTesterBT = NetStatusProtocolTesterBT.this;
                    synchronized (netStatusProtocolTesterBT) {
                        if (Session.this.initiator) {
                            NetStatusProtocolTesterBT.this.outbound_connects++;
                        } else {
                            NetStatusProtocolTesterBT.this.inbound_connects++;
                        }
                    }
                    Session.this.connected();
                }

                public final void connectFailure(Throwable throwable) {
                    if (!Session.this.closing) {
                        Session.this.logError(this.type + " connection fail", throwable);
                    }
                    Session.this.close();
                }

                public final void exceptionThrown(Throwable throwable) {
                    if (!Session.this.closing) {
                        Session.this.logError(this.type + " connection fail", throwable);
                    }
                    Session.this.close();
                }

                public String getDescription() {
                    return "NetStatusPlugin - " + this.type;
                }
            });
        }

        public boolean isInitiator() {
            return this.initiator;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public boolean isSeed() {
            return this.is_seed;
        }

        public boolean isOK() {
            return this.bitfield_received;
        }

        protected void connected() {
            this.connection.getIncomingMessageQueue().registerQueueListener(new IncomingMessageQueue.MessageQueueListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean messageReceived(Message message) {
                    try {
                        BTMessage bTMessage;
                        String string = message.getID();
                        Session.this.log("Incoming message received: " + message.getID());
                        if (string.equals("BT_HANDSHAKE")) {
                            Session.this.handshake_received = true;
                            bTMessage = (BTHandshake)message;
                            Session.access$1202(Session.this, ((BTHandshake)bTMessage).getDataHash());
                            Session.this.num_pieces = 500 + (Session.this.info_hash[0] & 0xFF);
                            if (Session.this.num_pieces % 8 == 0) {
                                Session.this.num_pieces--;
                            }
                            if (!Session.this.is_seed) {
                                int n = random.nextInt(Session.this.num_pieces / 2) + 5;
                                for (int i = 0; i < n; ++i) {
                                    Session.this.missing_pieces.add(new Integer(random.nextInt(Session.this.num_pieces)));
                                }
                            }
                            Session.this.sendHandshake();
                            Session.this.sendBitfield();
                            Session.this.connection.getIncomingMessageQueue().getDecoder().resumeDecoding();
                        } else if (string.equals("BT_BITFIELD")) {
                            Session.this.bitfield_received = true;
                            bTMessage = (BTBitfield)message;
                            ByteBuffer byteBuffer = ((BTBitfield)bTMessage).getBitfield().getBuffer((byte)0);
                            byte[] byArray = new byte[byteBuffer.remaining()];
                            byteBuffer.get(byArray);
                        } else if (string.equals("BT_HAVE") && ((BTHave)(bTMessage = (BTHave)message)).getPieceNumber() == Session.this.num_pieces) {
                            List list = NetStatusProtocolTesterBT.this.sessions;
                            synchronized (list) {
                                Session.this.closing = true;
                            }
                            Session.this.close();
                        }
                        boolean bl = true;
                        Object var8_11 = null;
                        message.destroy();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        message.destroy();
                        throw throwable;
                    }
                }

                public final void protocolBytesReceived(int n) {
                }

                public final void dataBytesReceived(int n) {
                }
            });
            this.connection.getOutgoingMessageQueue().registerQueueListener(new OutgoingMessageQueue.MessageQueueListener(){

                public final boolean messageAdded(Message message) {
                    return true;
                }

                public final void messageQueued(Message message) {
                }

                public final void messageRemoved(Message message) {
                }

                public final void messageSent(Message message) {
                    Session.this.log("Outgoing message sent: " + message.getID());
                }

                public final void protocolBytesSent(int n) {
                }

                public final void dataBytesSent(int n) {
                }

                public void flush() {
                }
            });
            this.connection.startMessageProcessing();
            if (this.initiator) {
                this.sendHandshake();
            }
        }

        protected void sendHandshake() {
            if (!this.handshake_sent) {
                this.handshake_sent = true;
                this.connection.getOutgoingMessageQueue().addMessage(new BTHandshake(this.info_hash, NetStatusProtocolTesterBT.this.peer_id, false, 1), false);
            }
        }

        protected void sendHave(int n) {
            BTHave bTHave = new BTHave(n, 1);
            OutgoingMessageQueue outgoingMessageQueue = this.connection.getOutgoingMessageQueue();
            outgoingMessageQueue.addMessage(bTHave, false);
            outgoingMessageQueue.flush();
        }

        protected void sendBitfield() {
            if (!this.bitfield_sent) {
                int n;
                this.bitfield_sent = true;
                byte[] byArray = new byte[(this.num_pieces + 7) / 8];
                int n2 = 0;
                int n3 = 0;
                for (n = 0; n < this.num_pieces; ++n) {
                    boolean bl;
                    if (n % 8 == 0) {
                        n3 = 0;
                    }
                    n3 <<= 1;
                    boolean bl2 = bl = !this.missing_pieces.contains(new Integer(n));
                    if (bl) {
                        ++n3;
                    }
                    if (n % 8 != 7) continue;
                    byArray[n2++] = (byte)n3;
                }
                if (n % 8 != 0) {
                    byArray[n2++] = (byte)(n3 <<= 8 - n % 8);
                }
                DirectByteBuffer directByteBuffer = new DirectByteBuffer(ByteBuffer.wrap(byArray));
                this.connection.getOutgoingMessageQueue().addMessage(new BTBitfield(directByteBuffer, 1), false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close() {
            List list = NetStatusProtocolTesterBT.this.sessions;
            synchronized (list) {
                NetStatusProtocolTesterBT.this.sessions.remove(this);
                if (!this.closing) {
                    this.closing = true;
                } else {
                    this.closed = true;
                }
            }
            if (this.closed) {
                this.log("Closing connection");
                this.connection.close();
            } else {
                this.sendHave(this.num_pieces);
                new DelayedEvent("NetStatus:delayClose", 5000L, new AERunnable(){

                    public void runSupport() {
                        if (!Session.this.closed) {
                            Session.this.close();
                        }
                    }
                });
            }
            NetStatusProtocolTesterBT.this.checkCompletion();
        }

        public String getProtocolString() {
            String string = "";
            if (this.connected) {
                string = "connected";
                string = string + this.addSent("hand", this.handshake_sent);
                string = string + this.addRecv("hand", this.handshake_received);
                string = string + this.addSent("bitf", this.bitfield_sent);
                string = string + this.addRecv("bitf", this.bitfield_received);
            } else {
                string = "not connected";
            }
            return string;
        }

        protected String addSent(String string, boolean bl) {
            if (bl) {
                return ", " + string + " sent";
            }
            return ", " + string + " !sent";
        }

        protected String addRecv(String string, boolean bl) {
            if (bl) {
                return ", " + string + " recv";
            }
            return ", " + string + " !recv";
        }

        protected String getLogPrefix() {
            return "(" + (this.initiator ? "L" : "R") + (this.is_seed ? "S" : "L") + " " + this.session_id + ") ";
        }

        protected void log(String string) {
            NetStatusProtocolTesterBT.this.log(this.getLogPrefix() + string);
        }

        protected void logError(String string) {
            NetStatusProtocolTesterBT.this.logError(this.getLogPrefix() + string);
        }

        protected void logError(String string, Throwable throwable) {
            NetStatusProtocolTesterBT.this.logError(this.getLogPrefix() + string, throwable);
        }

        static /* synthetic */ byte[] access$1202(Session session, byte[] byArray) {
            session.info_hash = byArray;
            return byArray;
        }
    }
}

