/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.tracker.local;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.instancemanager.AZInstance;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerListener;
import com.aelitis.azureus.core.instancemanager.AZInstanceTracked;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfigListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class LocalTrackerPlugin
implements Plugin,
AZInstanceManagerListener,
DownloadManagerListener,
DownloadListener {
    private static final String PLUGIN_NAME = "LAN Peer Finder";
    private static final String PLUGIN_CONFIGSECTION_ID = "Plugin.localtracker.name";
    private static final long ANNOUNCE_PERIOD = 300000L;
    private static final long RE_ANNOUNCE_PERIOD = 60000L;
    private PluginInterface plugin_interface;
    private AZInstanceManager instance_manager;
    private boolean active;
    private TorrentAttribute ta_networks;
    private TorrentAttribute ta_peer_sources;
    private Map downloads = new HashMap();
    private Map track_times = new HashMap();
    private String last_autoadd = "";
    private String last_subnets = "";
    private BooleanParameter enabled;
    private long plugin_start_time;
    private long current_time;
    private LoggerChannel log;
    private Monitor mon;
    private AsyncDispatcher dispatcher = new AsyncDispatcher(30000);

    public static void load(PluginInterface pluginInterface) {
        pluginInterface.getPluginProperties().setProperty("plugin.version", "1.0");
        pluginInterface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.ta_networks = this.plugin_interface.getTorrentManager().getAttribute("Networks");
        this.ta_peer_sources = this.plugin_interface.getTorrentManager().getAttribute("PeerSources");
        this.mon = this.plugin_interface.getUtilities().getMonitor();
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(PLUGIN_NAME);
        UIManager uIManager = this.plugin_interface.getUIManager();
        BasicPluginConfigModel basicPluginConfigModel = uIManager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        basicPluginConfigModel.addLabelParameter2("Plugin.localtracker.info");
        this.enabled = basicPluginConfigModel.addBooleanParameter2("Plugin.localtracker.enable", "Plugin.localtracker.enable", true);
        basicPluginConfigModel.addLabelParameter2("Plugin.localtracker.networks.info");
        final StringParameter stringParameter = basicPluginConfigModel.addStringParameter2("Plugin.localtracker.networks", "Plugin.localtracker.networks", "");
        final BooleanParameter booleanParameter = basicPluginConfigModel.addBooleanParameter2("Plugin.localtracker.wellknownlocals", "Plugin.localtracker.wellknownlocals", true);
        basicPluginConfigModel.addLabelParameter2("Plugin.localtracker.autoadd.info");
        final StringParameter stringParameter2 = basicPluginConfigModel.addStringParameter2("Plugin.localtracker.autoadd", "Plugin.localtracker.autoadd", "");
        final BasicPluginViewModel basicPluginViewModel = this.plugin_interface.getUIManager().createBasicPluginViewModel(PLUGIN_CONFIGSECTION_ID);
        basicPluginViewModel.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        basicPluginViewModel.getActivity().setVisible(false);
        basicPluginViewModel.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int n, String string) {
                basicPluginViewModel.getLogArea().appendText(string + "\n");
            }

            public void messageLogged(String string, Throwable throwable) {
                if (string.length() > 0) {
                    basicPluginViewModel.getLogArea().appendText(string + "\n");
                }
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                basicPluginViewModel.getLogArea().appendText(stringWriter.toString() + "\n");
            }
        });
        this.plugin_start_time = this.plugin_interface.getUtilities().getCurrentSystemTime();
        this.instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
        this.instance_manager.addListener(this);
        this.plugin_interface.getPluginconfig().addListener(new PluginConfigListener(){

            public void configSaved() {
                LocalTrackerPlugin.this.processSubNets(stringParameter.getValue(), booleanParameter.getValue());
                LocalTrackerPlugin.this.processAutoAdd(stringParameter2.getValue());
            }
        });
        this.processSubNets(stringParameter.getValue(), booleanParameter.getValue());
        this.processAutoAdd(stringParameter2.getValue());
        DelayedTask delayedTask = this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

            public void run() {
                LocalTrackerPlugin.this.plugin_interface.getDownloadManager().addListener(LocalTrackerPlugin.this);
            }
        });
        delayedTask.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instanceFound(AZInstance aZInstance) {
        if (!this.enabled.getValue()) {
            return;
        }
        this.log.log("Found: " + aZInstance.getString());
        try {
            this.mon.enter();
            this.track_times.put(aZInstance.getID(), new HashMap());
            Object var3_2 = null;
            this.mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mon.exit();
            throw throwable;
        }
        this.checkActivation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkActivation() {
        try {
            this.mon.enter();
            if (this.active) {
                Object var2_1 = null;
                this.mon.exit();
                return;
            }
            this.active = true;
            this.plugin_interface.getUtilities().createThread("Tracker", new Runnable(){

                public void run() {
                    LocalTrackerPlugin.this.track();
                }
            });
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.mon.exit();
            throw throwable;
        }
        Object var2_2 = null;
        this.mon.exit();
    }

    public void instanceChanged(AZInstance aZInstance) {
        if (!this.enabled.getValue()) {
            return;
        }
        this.log.log("Changed: " + aZInstance.getString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instanceLost(AZInstance aZInstance) {
        try {
            this.mon.enter();
            this.track_times.remove(aZInstance.getID());
            Object var3_2 = null;
            this.mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mon.exit();
            throw throwable;
        }
        if (!this.enabled.getValue()) {
            return;
        }
        this.log.log("Lost: " + aZInstance.getString());
    }

    public void instanceTracked(AZInstanceTracked aZInstanceTracked) {
        if (!this.enabled.getValue()) {
            return;
        }
        this.handleTrackResult(aZInstanceTracked);
    }

    protected void track() {
        long l = this.plugin_interface.getUtilities().getCurrentSystemTime();
        if (l - this.plugin_start_time < 60000L) {
            try {
                Thread.sleep(15000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.plugin_interface.getUtilities().createTimer("LanPeerFinder:Tracker", true).addPeriodicEvent(30000L, new UTTimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(UTTimerEvent uTTimerEvent) {
                LocalTrackerPlugin.this.current_time = LocalTrackerPlugin.this.plugin_interface.getUtilities().getCurrentSystemTime();
                try {
                    ArrayList<Download> arrayList = new ArrayList<Download>();
                    try {
                        LocalTrackerPlugin.this.mon.enter();
                        for (Map.Entry entry : LocalTrackerPlugin.this.downloads.entrySet()) {
                            Download download = (Download)entry.getKey();
                            long l = (Long)entry.getValue();
                            if (l <= LocalTrackerPlugin.this.current_time && LocalTrackerPlugin.this.current_time - l <= 300000L) continue;
                            arrayList.add(download);
                        }
                        Object var9_9 = null;
                        LocalTrackerPlugin.this.mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        LocalTrackerPlugin.this.mon.exit();
                        throw throwable;
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        LocalTrackerPlugin.this.track((Download)arrayList.get(i));
                    }
                }
                catch (Throwable throwable) {
                    LocalTrackerPlugin.this.log.log(throwable);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void track(Download download) {
        long l = this.plugin_interface.getUtilities().getCurrentSystemTime();
        boolean bl = false;
        try {
            this.mon.enter();
            Long l2 = (Long)this.downloads.get(download);
            if (l2 == null) {
                Object var9_5 = null;
                this.mon.exit();
                return;
            }
            long l3 = l2;
            if (l3 > l || l - l3 > 60000L) {
                bl = true;
                this.downloads.put(download, new Long(l));
            }
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.mon.exit();
            throw throwable;
        }
        Object var9_6 = null;
        this.mon.exit();
        if (bl) {
            this.trackSupport(download);
        }
    }

    protected void trackSupport(final Download download) {
        if (!this.enabled.getValue()) {
            return;
        }
        int n = download.getState();
        if (n == 8 || n == 7) {
            return;
        }
        String[] stringArray = download.getListAttribute(this.ta_peer_sources);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("Plugin")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        if (download.getTorrent() == null) {
            return;
        }
        byte[] byArray = new SHA1Simple().calculateHash(download.getTorrent().getHash());
        AZInstanceTracked[] aZInstanceTrackedArray = this.instance_manager.track(byArray, new AZInstanceTracked.TrackTarget(){

            public Object getTarget() {
                return download;
            }

            public boolean isSeed() {
                return download.isComplete();
            }
        });
        for (int i = 0; i < aZInstanceTrackedArray.length; ++i) {
            this.handleTrackResult(aZInstanceTrackedArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceTrack(final Download download) {
        try {
            this.mon.enter();
            this.downloads.put(download, new Long(0L));
            String string = this.plugin_interface.getUtilities().getFormatters().encodeBytesToString(download.getTorrent().getHash());
            Iterator iterator = this.track_times.values().iterator();
            while (iterator.hasNext()) {
                ((Map)iterator.next()).remove(string);
            }
            Object var5_4 = null;
            this.mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.mon.exit();
            throw throwable;
        }
        this.dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                LocalTrackerPlugin.this.track(download);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTrackResult(AZInstanceTracked aZInstanceTracked) {
        String string;
        Object object;
        AZInstance aZInstance = aZInstanceTracked.getInstance();
        Download download = (Download)aZInstanceTracked.getTarget().getTarget();
        boolean bl = aZInstanceTracked.isSeed();
        long l = this.plugin_interface.getUtilities().getCurrentSystemTime();
        boolean bl2 = false;
        try {
            long l2;
            Long l3;
            this.mon.enter();
            object = (HashMap<String, Long>)this.track_times.get(aZInstance.getID());
            if (object == null) {
                object = new HashMap<String, Long>();
                this.track_times.put(aZInstance.getID(), object);
            }
            if ((l3 = (Long)object.get(string = this.plugin_interface.getUtilities().getFormatters().encodeBytesToString(download.getTorrent().getHash()))) != null && l - (l2 = l3.longValue()) < 30000L) {
                bl2 = true;
            }
            object.put(string, new Long(l));
            Object var14_13 = null;
            this.mon.exit();
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            this.mon.exit();
            throw throwable;
        }
        if (bl2) {
            return;
        }
        this.log.log("Tracked: " + aZInstance.getString() + ": " + download.getName() + ", seed = " + bl);
        if (download.isComplete() && bl) {
            return;
        }
        object = download.getPeerManager();
        if (object != null) {
            string = aZInstance.getInternalAddress().getHostAddress();
            int n = aZInstance.getTCPListenPort();
            int n2 = aZInstance.getUDPListenPort();
            this.log.log("    " + download.getName() + ": Injecting peer " + string + ":" + n + "/" + n2);
            object.addPeer(string, n, n2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void downloadAdded(Download download) {
        block9: {
            block8: {
                block7: {
                    try {
                        this.mon.enter();
                        Torrent torrent = download.getTorrent();
                        if (torrent == null) {
                            Object var7_3 = null;
                            this.mon.exit();
                            return;
                        }
                        if (TorrentUtils.isReallyPrivate(PluginCoreUtils.unwrap(torrent))) {
                            this.log.log("Not tracking " + download.getName() + ": torrent is private");
                            break block7;
                        }
                        String[] stringArray = download.getListAttribute(this.ta_networks);
                        boolean bl = false;
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!stringArray[i].equalsIgnoreCase("Public")) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            this.log.log("Not tracking " + download.getName() + ": torrent has no public network");
                            break block8;
                        }
                        if (this.enabled.getValue()) {
                            this.log.log("Tracking " + download.getName());
                        }
                        this.downloads.put(download, new Long(0L));
                        download.addListener(this);
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        this.mon.exit();
                        throw throwable;
                    }
                }
                Object var7_4 = null;
                this.mon.exit();
                return;
            }
            Object var7_5 = null;
            this.mon.exit();
            return;
        }
        Object var7_6 = null;
        this.mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadRemoved(Download download) {
        try {
            this.mon.enter();
            this.downloads.remove(download);
            download.removeListener(this);
            Object var3_2 = null;
            this.mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mon.exit();
            throw throwable;
        }
    }

    public void stateChanged(Download download, int n, int n2) {
        if (n2 == 4 || n2 == 5) {
            this.forceTrack(download);
        }
    }

    public void positionChanged(Download download, int n, int n2) {
    }

    protected void processSubNets(String string, boolean bl) {
        if (bl != this.instance_manager.getIncludeWellKnownLANs()) {
            this.instance_manager.setIncludeWellKnownLANs(bl);
            this.log.log("Include well known local networks set to " + bl);
        }
        if (string.equals(this.last_subnets)) {
            return;
        }
        this.last_subnets = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            try {
                if (!this.instance_manager.addLANSubnet(string2)) continue;
                this.log.log("Added network '" + string2 + "'");
            }
            catch (Throwable throwable) {
                this.log.log("Failed to add network '" + string2 + "'", throwable);
            }
        }
    }

    protected void processAutoAdd(String string) {
        if (string.equals(this.last_autoadd)) {
            return;
        }
        this.last_autoadd = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                InetAddress inetAddress = InetAddress.getByName(string2.trim());
                if (!this.instance_manager.addInstance(inetAddress)) continue;
                this.log.log("Added peer '" + string2 + "'");
            }
            catch (Throwable throwable) {
                this.log.log("Failed to decode peer '" + string2 + "'", throwable);
            }
        }
    }
}

