/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.util.ConstantsVuze;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;

public class DataSourceUtils {
    public static DownloadManager getDM(Object object) {
        try {
            if (object instanceof DownloadManager) {
                return (DownloadManager)object;
            }
            if (object instanceof VuzeActivitiesEntry) {
                String string;
                VuzeActivitiesEntry vuzeActivitiesEntry = (VuzeActivitiesEntry)object;
                DownloadManager downloadManager = vuzeActivitiesEntry.getDownloadManger();
                if (downloadManager == null && (string = vuzeActivitiesEntry.getAssetHash()) != null && AzureusCoreFactory.isCoreRunning()) {
                    GlobalManager globalManager = AzureusCoreFactory.getSingleton().getGlobalManager();
                    downloadManager = globalManager.getDownloadManager(new HashWrapper(Base32.decode(string)));
                    vuzeActivitiesEntry.setDownloadManager(downloadManager);
                }
                return downloadManager;
            }
            if (object instanceof TOTorrent && AzureusCoreFactory.isCoreRunning()) {
                GlobalManager globalManager = AzureusCoreFactory.getSingleton().getGlobalManager();
                return globalManager.getDownloadManager((TOTorrent)object);
            }
            if (object instanceof ISelectedContent) {
                return DataSourceUtils.getDM(((ISelectedContent)object).getDownloadManager());
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
        return null;
    }

    public static TOTorrent getTorrent(Object object) {
        Object object2;
        if (object instanceof TOTorrent) {
            return (TOTorrent)object;
        }
        if (object instanceof DownloadManager && (object2 = ((DownloadManager)object).getTorrent()) != null) {
            return object2;
        }
        if (object instanceof VuzeActivitiesEntry) {
            DownloadManager downloadManager;
            object2 = ((VuzeActivitiesEntry)object).getTorrent();
            if (object2 == null && (downloadManager = DataSourceUtils.getDM(object)) != null) {
                object2 = downloadManager.getTorrent();
            }
            return object2;
        }
        if (object instanceof ISelectedContent) {
            return ((ISelectedContent)object).getTorrent();
        }
        if (object instanceof String) {
            object2 = (String)object;
            try {
                GlobalManager globalManager = AzureusCoreFactory.getSingleton().getGlobalManager();
                DownloadManager downloadManager = globalManager.getDownloadManager(new HashWrapper(Base32.decode((String)object2)));
                if (downloadManager != null) {
                    return downloadManager.getTorrent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isPlatformContent(Object object) {
        TOTorrent tOTorrent = DataSourceUtils.getTorrent(object);
        if (tOTorrent != null) {
            return PlatformTorrentUtils.isContent(tOTorrent, true);
        }
        return object instanceof VuzeActivitiesEntry && ((VuzeActivitiesEntry)object).isPlatformContent();
    }

    public static String getHash(Object object) {
        try {
            if (object instanceof DownloadManager) {
                return ((DownloadManager)object).getTorrent().getHashWrapper().toBase32String();
            }
            if (object instanceof TOTorrent) {
                return ((TOTorrent)object).getHashWrapper().toBase32String();
            }
            if (object instanceof VuzeActivitiesEntry) {
                VuzeActivitiesEntry vuzeActivitiesEntry = (VuzeActivitiesEntry)object;
                return vuzeActivitiesEntry.getAssetHash();
            }
            if (object instanceof ISelectedContent) {
                return ((ISelectedContent)object).getHash();
            }
            if (object instanceof String) {
                return (String)object;
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
        return null;
    }

    public static ContentNetwork getContentNetwork(Object object) {
        long l = -1L;
        try {
            if (object instanceof DownloadManager) {
                l = PlatformTorrentUtils.getContentNetworkID(((DownloadManager)object).getTorrent());
            } else if (object instanceof TOTorrent) {
                l = PlatformTorrentUtils.getContentNetworkID((TOTorrent)object);
            } else {
                if (object instanceof VuzeActivitiesEntry) {
                    VuzeActivitiesEntry vuzeActivitiesEntry = (VuzeActivitiesEntry)object;
                    return vuzeActivitiesEntry.getContentNetwork();
                }
                if (object instanceof ISelectedContent) {
                    return DataSourceUtils.getContentNetwork(((ISelectedContent)object).getDownloadManager());
                }
                if (object instanceof String && ((String)object).length() == 32) {
                    l = ConstantsVuze.getDefaultContentNetwork().getID();
                } else if (object instanceof RelatedContent) {
                    l = ((RelatedContent)object).getContentNetwork();
                } else {
                    Debug.out("Tux: UH OH NO CN for " + object + "\n" + Debug.getCompressedStackTrace());
                }
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
        ContentNetwork contentNetwork = ContentNetworkManagerFactory.getSingleton().getContentNetwork(l);
        return contentNetwork;
    }

    public static DownloadUrlInfo getDownloadInfo(Object object) {
        if (object instanceof ISelectedContent) {
            return ((ISelectedContent)object).getDownloadInfo();
        }
        return null;
    }
}

