/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.content.AzureusPlatformContentDirectory;
import com.aelitis.azureus.core.content.RelatedContentManager;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.peer.cache.CacheDiscovery;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.DownloadUtils;
import com.aelitis.azureus.util.ExternalStimulusHandler;
import com.aelitis.azureus.util.NavigationHelper;
import java.net.URL;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeAddedListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class InitialisationFunctions {
    private static final String EXTENSION_PREFIX = "azid";

    public static void earlyInitialisation(AzureusCore azureusCore) {
        DownloadUtils.initialise();
        DownloadManagerEnhancer downloadManagerEnhancer = DownloadManagerEnhancer.initialise(azureusCore);
        InitialisationFunctions.hookDownloadAddition();
        AzureusPlatformContentDirectory.register();
        CacheDiscovery.initialise(downloadManagerEnhancer);
        ContentNetworkManagerFactory.preInitialise();
        MetaSearchManagerFactory.preInitialise();
        SubscriptionManagerFactory.preInitialise();
        NavigationHelper.initialise();
        RelatedContentManager.preInitialise(azureusCore);
        AZ3Functions.setProvider(new AZ3Functions.provider(){

            public void subscribeToRSS(String string, URL uRL, int n, boolean bl, String string2) throws Exception {
                Subscription subscription = SubscriptionManagerFactory.getSingleton().createSingletonRSS(string, uRL, n);
                if (subscription.isPublic() != bl) {
                    subscription.setPublic(bl);
                }
                if (string2 != null) {
                    subscription.setCreatorRef(string2);
                }
            }

            public boolean canShowCDP(org.gudy.azureus2.core3.download.DownloadManager downloadManager) {
                return false;
            }

            public void showCDP(org.gudy.azureus2.core3.download.DownloadManager downloadManager, String string) {
            }

            public String getCDPURL(org.gudy.azureus2.core3.download.DownloadManager downloadManager) {
                return null;
            }
        });
    }

    public static void lateInitialisation(AzureusCore azureusCore) {
        ExternalStimulusHandler.initialise(azureusCore);
        PluginInitializer.getDefaultInterface().getUtilities().createDelayedTask(new Runnable(){

            public void run() {
                MetaSearchManagerFactory.getSingleton();
                SubscriptionManagerFactory.getSingleton();
                try {
                    RelatedContentManager.getSingleton();
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
            }
        }).queue();
    }

    protected static void hookDownloadAddition() {
        PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
        DownloadManager downloadManager = pluginInterface.getDownloadManager();
        downloadManager.addDownloadWillBeAddedListener(new DownloadWillBeAddedListener(){

            public void initialised(Download download) {
                org.gudy.azureus2.core3.download.DownloadManager downloadManager = PluginCoreUtils.unwrap(download);
                if (PlatformTorrentUtils.getHasBeenOpened(downloadManager)) {
                    PlatformTorrentUtils.setHasBeenOpened(downloadManager, false);
                }
                InitialisationFunctions.register(download);
            }
        });
        downloadManager.addListener(new DownloadManagerListener(){

            public void downloadAdded(Download download) {
                InitialisationFunctions.register(download);
            }

            public void downloadRemoved(Download download) {
            }
        });
    }

    protected static void register(final Download download) {
        DownloadManagerStateAttributeListener downloadManagerStateAttributeListener = new DownloadManagerStateAttributeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void attributeEventOccurred(org.gudy.azureus2.core3.download.DownloadManager downloadManager, String string, int n) {
                block5: {
                    block4: {
                        try {
                            Torrent torrent = download.getTorrent();
                            if (torrent == null) {
                                Object var6_5 = null;
                                downloadManager.getDownloadState().removeListener(this, "trackerclientextensions", 2);
                                return;
                            }
                            if (!PlatformTorrentUtils.isContent(torrent, true)) {
                                break block4;
                            }
                            DownloadUtils.addTrackerExtension(download, InitialisationFunctions.EXTENSION_PREFIX, ConstantsVuze.AZID);
                            download.setFlag(32L, true);
                            break block5;
                        }
                        catch (Throwable throwable) {
                            Object var6_8 = null;
                            downloadManager.getDownloadState().removeListener(this, "trackerclientextensions", 2);
                            throw throwable;
                        }
                    }
                    Object var6_6 = null;
                    downloadManager.getDownloadState().removeListener(this, "trackerclientextensions", 2);
                    return;
                }
                Object var6_7 = null;
                downloadManager.getDownloadState().removeListener(this, "trackerclientextensions", 2);
            }
        };
        PluginCoreUtils.unwrap(download).getDownloadState().addListener(downloadManagerStateAttributeListener, "trackerclientextensions", 2);
    }
}

