/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.util.DataSourceUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;

public class PlayUtils {
    private static boolean triedLoadingEmpPluginClass = false;
    private static Method methodIsExternallyPlayable;
    private static PluginInterface piEmp;

    public static boolean prepareForPlay(DownloadManager downloadManager) {
        EnhancedDownloadManager enhancedDownloadManager = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(downloadManager);
        if (enhancedDownloadManager != null) {
            enhancedDownloadManager.setProgressiveMode(true);
            return true;
        }
        return false;
    }

    public static boolean canProgressiveOrIsComplete(TOTorrent tOTorrent) {
        if (tOTorrent == null) {
            return false;
        }
        try {
            DownloadManagerEnhancer downloadManagerEnhancer = DownloadManagerEnhancer.getSingleton();
            EnhancedDownloadManager enhancedDownloadManager = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(tOTorrent.getHash());
            if (enhancedDownloadManager == null) {
                return downloadManagerEnhancer.isProgressiveAvailable() && PlatformTorrentUtils.isContentProgressive(tOTorrent);
            }
            boolean bl = enhancedDownloadManager.getDownloadManager().isDownloadComplete(false);
            if (bl) {
                return true;
            }
            if (!enhancedDownloadManager.supportsProgressiveMode()) {
                return false;
            }
        }
        catch (TOTorrentException tOTorrentException) {
            return false;
        }
        return true;
    }

    public static boolean canUseEMP(TOTorrent tOTorrent) {
        if (PlayUtils.canPlayViaExternalEMP(tOTorrent)) {
            return true;
        }
        if (!PlatformTorrentUtils.useEMP(tOTorrent) || !PlatformTorrentUtils.embeddedPlayerAvail()) {
            return false;
        }
        return PlayUtils.canProgressiveOrIsComplete(tOTorrent);
    }

    private static boolean canPlay(DownloadManager downloadManager) {
        if (downloadManager == null) {
            return false;
        }
        TOTorrent tOTorrent = downloadManager.getTorrent();
        return PlayUtils.canUseEMP(tOTorrent);
    }

    private static boolean canPlay(TOTorrent tOTorrent) {
        if (!PlatformTorrentUtils.isContent(tOTorrent, false)) {
            return false;
        }
        if (!AzureusCoreFactory.isCoreRunning()) {
            return false;
        }
        GlobalManager globalManager = AzureusCoreFactory.getSingleton().getGlobalManager();
        DownloadManager downloadManager = globalManager.getDownloadManager(tOTorrent);
        if (downloadManager != null) {
            return downloadManager.getAssumedComplete() || PlayUtils.canUseEMP(tOTorrent);
        }
        return PlayUtils.canUseEMP(tOTorrent);
    }

    public static boolean canPlayDS(Object object) {
        if (object == null) {
            return false;
        }
        DownloadManager downloadManager = DataSourceUtils.getDM(object);
        if (downloadManager != null) {
            return PlayUtils.canPlay(downloadManager);
        }
        TOTorrent tOTorrent = DataSourceUtils.getTorrent(object);
        if (tOTorrent != null) {
            return PlayUtils.canPlay(tOTorrent);
        }
        if (object instanceof VuzeActivitiesEntry) {
            return ((VuzeActivitiesEntry)object).isPlayable();
        }
        if (object instanceof SelectedContentV3) {
            SelectedContentV3 selectedContentV3 = (SelectedContentV3)object;
            return selectedContentV3.canPlay();
        }
        return false;
    }

    public static String getContentUrl(DownloadManager downloadManager) {
        String string;
        if (downloadManager.isDownloadComplete(false)) {
            EnhancedDownloadManager enhancedDownloadManager = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(downloadManager);
            File file = enhancedDownloadManager != null ? enhancedDownloadManager.getPrimaryFile().getFile(true) : new File(downloadManager.getDownloadState().getPrimaryFile());
            try {
                string = file.toURL().toString();
            }
            catch (MalformedURLException malformedURLException) {
                string = file.getAbsolutePath();
            }
        } else {
            string = PlayUtils.getMediaServerContentURL(downloadManager);
        }
        return string;
    }

    public static String getMediaServerContentURL(DownloadManager downloadManager) {
        try {
            return PlayUtils.getMediaServerContentURL(DownloadManagerImpl.getDownloadStatic(downloadManager));
        }
        catch (DownloadException downloadException) {
            return null;
        }
    }

    public static String getMediaServerContentURL(Download download) {
        PluginManager pluginManager = AzureusCoreFactory.getSingleton().getPluginManager();
        PluginInterface pluginInterface = pluginManager.getPluginInterfaceByID("azupnpav", false);
        if (pluginInterface == null) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not found"));
            return null;
        }
        if (!pluginInterface.getPluginState().isOperational()) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not operational"));
            return null;
        }
        return null;
    }

    private static final synchronized boolean loadEmpPluginClass() {
        if (piEmp != null && piEmp.getPluginState().isUnloaded()) {
            piEmp = null;
            triedLoadingEmpPluginClass = false;
            methodIsExternallyPlayable = null;
        }
        if (!triedLoadingEmpPluginClass) {
            triedLoadingEmpPluginClass = true;
            try {
                piEmp = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp");
                if (piEmp == null) {
                    return false;
                }
                Class<?> clazz = piEmp.getPlugin().getClass();
                methodIsExternallyPlayable = clazz.getMethod("isExternallyPlayabale", TOTorrent.class);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private static final boolean canPlayViaExternalEMP(TOTorrent tOTorrent) {
        block5: {
            if (!PlayUtils.loadEmpPluginClass()) {
                return false;
            }
            if (methodIsExternallyPlayable == null) {
                return false;
            }
            try {
                Object object = methodIsExternallyPlayable.invoke(null, tOTorrent);
                if (object instanceof Boolean) {
                    return (Boolean)object;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (throwable.getMessage() != null && throwable.getMessage().toLowerCase().endsWith("only")) break block5;
                Debug.out(throwable);
            }
        }
        return false;
    }
}

