/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkListener;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManager;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.util.ConstantsVuze;
import java.util.Iterator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;

public class UrlFilter {
    private static UrlFilter instance = null;
    private String default_site_host = (String)ConstantsVuze.getDefaultContentNetwork().getProperty(1);
    private String DEFAULT_RPC_WHITELIST = "https?://" + this.default_site_host.replaceAll("\\.", "\\\\.") + ":?[0-9]*/" + ".*";
    private CopyOnWriteList<String> listUrlBlacklist = new CopyOnWriteList();
    private CopyOnWriteList<String> listUrlWhitelist = new CopyOnWriteList();
    private AEMonitor mon = new AEMonitor("UrlFilter");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UrlFilter getInstance() {
        Class<UrlFilter> clazz = UrlFilter.class;
        synchronized (UrlFilter.class) {
            if (instance == null) {
                instance = new UrlFilter();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public UrlFilter() {
        this.listUrlWhitelist.add(this.DEFAULT_RPC_WHITELIST);
        ContentNetworkManager contentNetworkManager = ContentNetworkManagerFactory.getSingleton();
        ContentNetwork[] contentNetworkArray = contentNetworkManager.getContentNetworks();
        contentNetworkManager.addListener(new ContentNetworkListener(){

            public void networkRemoved(ContentNetwork contentNetwork) {
            }

            public void networkChanged(ContentNetwork contentNetwork) {
            }

            public void networkAdded(ContentNetwork contentNetwork) {
                UrlFilter.this.addNetworkFilters(contentNetwork);
            }

            public void networkAddFailed(long l, Throwable throwable) {
            }
        });
        for (ContentNetwork contentNetwork : contentNetworkArray) {
            this.addNetworkFilters(contentNetwork);
        }
    }

    protected void addNetworkFilters(ContentNetwork contentNetwork) {
        int[] nArray;
        if (contentNetwork == null) {
            return;
        }
        for (int n : nArray = new int[]{15, 5, 4, 3}) {
            if (!contentNetwork.isServiceSupported(n)) continue;
            this.addUrlWhitelist(contentNetwork.getServiceURL(n) + ".*");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUrlWhitelist(String string) {
        this.mon.enter();
        try {
            if (!this.listUrlWhitelist.contains(string)) {
                PlatformMessenger.debug("add whitelist of " + string);
                this.listUrlWhitelist.add(string);
            } else {
                PlatformMessenger.debug("whitelist already exists: " + string);
            }
            Object var3_2 = null;
            this.mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUrlBlacklist(String string) {
        this.mon.enter();
        try {
            if (!this.listUrlBlacklist.contains(string)) {
                PlatformMessenger.debug("add blacklist of " + string);
                this.listUrlBlacklist.add(string);
            }
            Object var3_2 = null;
            this.mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mon.exit();
            throw throwable;
        }
    }

    public String[] getUrlWhitelist() {
        return this.listUrlWhitelist.toArray((String[])new String[0]);
    }

    public boolean isWhitelisted(String string) {
        Iterator<String> iterator = this.listUrlWhitelist.iterator();
        while (iterator.hasNext()) {
            if (!string.matches(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean urlCanRPC(String string) {
        return this.urlCanRPC(string, false);
    }

    public boolean urlCanRPC(String string, boolean bl) {
        if (string == null) {
            Debug.out("URL null and should be blocked");
            return false;
        }
        if (Constants.isCVSVersion() && string.startsWith("file://")) {
            return true;
        }
        if (this.isWhitelisted(string)) {
            return true;
        }
        if (bl) {
            Debug.out("urlCanRPC: URL '" + string + "' " + " does not match one of the " + this.listUrlWhitelist.size() + " whitelist entries");
        }
        return false;
    }

    public boolean urlIsBlocked(String string) {
        if (string == null) {
            Debug.out("URL null and should be blocked");
            return true;
        }
        for (String string2 : this.listUrlBlacklist) {
            if (!string.matches(string2)) continue;
            Debug.out("URL '" + string + "' " + " is blocked by " + string2);
            return true;
        }
        return false;
    }
}

