/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.vivaldi.ver2;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.vivaldi.ver2.SyrahPosition;
import edu.harvard.syrah.nc.Coordinate;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class DeserializedPosition
extends SyrahPosition {
    private Coordinate coords;
    private float error;
    private long age;

    protected DeserializedPosition(DataInputStream dataInputStream) throws IOException {
        this.coords = new Coordinate(5, dataInputStream);
        this.error = dataInputStream.readFloat();
        this.age = dataInputStream.readLong();
    }

    public Coordinate getCoords() {
        return this.coords;
    }

    public Coordinate getStableCoords() {
        return this.coords;
    }

    public float getError() {
        return this.error;
    }

    public long getAge() {
        return this.age;
    }

    public float estimateRTT(DHTNetworkPosition dHTNetworkPosition) {
        SyrahPosition syrahPosition = (SyrahPosition)dHTNetworkPosition;
        if (Float.isNaN(this.getError()) || Float.isNaN(syrahPosition.getError())) {
            return Float.NaN;
        }
        return (float)this.coords.distanceToNonOriginCoord(syrahPosition.getCoords());
    }

    public void update(byte[] byArray, DHTNetworkPosition dHTNetworkPosition, float f) {
        SyrahPosition syrahPosition = (SyrahPosition)dHTNetworkPosition;
        this.coords = syrahPosition.getCoords();
        this.error = syrahPosition.getError();
        this.age = syrahPosition.getAge();
    }

    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        this.coords.toSerialized(dataOutputStream);
        dataOutputStream.writeFloat(this.error);
        dataOutputStream.writeLong(this.age);
    }
}

