/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.vivaldi.ver2;

import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDWrapper
implements Comparable<IDWrapper> {
    public static final char[] hex_char = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final byte[] raw_id;

    public IDWrapper(byte[] byArray) {
        this.raw_id = byArray;
    }

    public byte[] getRawId() {
        return this.raw_id;
    }

    public boolean equals(Object object) {
        if (object instanceof IDWrapper) {
            IDWrapper iDWrapper = (IDWrapper)object;
            return Arrays.equals(this.raw_id, iDWrapper.raw_id);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.raw_id);
    }

    @Override
    public int compareTo(IDWrapper iDWrapper) {
        if (this == iDWrapper) {
            return 0;
        }
        for (int i = 0; i < this.raw_id.length; ++i) {
            if (this.raw_id[i] == iDWrapper.raw_id[i]) continue;
            return (this.raw_id[i] & 0xFF) < (iDWrapper.raw_id[i] & 0xFF) ? -1 : 1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("0x");
        for (int i = 0; i < this.raw_id.length; ++i) {
            stringBuffer.append(hex_char[this.raw_id[i] >> 4 & 0xF]);
            stringBuffer.append(hex_char[this.raw_id[i] & 0xF]);
        }
        return stringBuffer.toString();
    }
}

