/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.vivaldi.ver2;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.vivaldi.ver2.SyrahPosition;
import com.aelitis.azureus.vivaldi.ver2.VivaldiV2PositionProvider;
import edu.harvard.syrah.nc.Coordinate;

class InitialPosition
extends SyrahPosition {
    static final Coordinate zero_coords = new Coordinate(5);
    static final float error = 1.0f;

    public Coordinate getCoords() {
        return zero_coords;
    }

    public Coordinate getStableCoords() {
        return zero_coords;
    }

    public float getError() {
        return 1.0f;
    }

    public long getAge() {
        return 0L;
    }

    public float estimateRTT(DHTNetworkPosition dHTNetworkPosition) {
        VivaldiV2PositionProvider.doLog("method estimateRTT invoked on initial position");
        SyrahPosition syrahPosition = (SyrahPosition)dHTNetworkPosition;
        return (float)zero_coords.distanceTo(syrahPosition.getCoords());
    }

    public void update(byte[] byArray, DHTNetworkPosition dHTNetworkPosition, float f) {
        VivaldiV2PositionProvider.doLog("method update invoked on initial position");
    }
}

