/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.vivaldi.ver2;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.vivaldi.ver2.IDWrapper;
import com.aelitis.azureus.vivaldi.ver2.SyrahPosition;
import com.aelitis.azureus.vivaldi.ver2.VivaldiV2PositionProvider;
import edu.harvard.syrah.nc.Coordinate;

class LocalPosition
extends SyrahPosition {
    private final VivaldiV2PositionProvider v2_provider;

    protected LocalPosition(VivaldiV2PositionProvider vivaldiV2PositionProvider) {
        this.v2_provider = vivaldiV2PositionProvider;
    }

    public Coordinate getCoords() {
        return this.v2_provider.getCoords();
    }

    public Coordinate getStableCoords() {
        return this.v2_provider.getStableCoords();
    }

    public float getError() {
        return this.v2_provider.getError();
    }

    public long getAge() {
        return this.v2_provider.getAge();
    }

    public float estimateRTT(DHTNetworkPosition dHTNetworkPosition) {
        SyrahPosition syrahPosition = (SyrahPosition)dHTNetworkPosition;
        if (Float.isNaN(this.getError()) || Float.isNaN(syrahPosition.getError())) {
            return Float.NaN;
        }
        return (float)this.getCoords().distanceToNonOriginCoord(syrahPosition.getCoords());
    }

    public void update(byte[] byArray, DHTNetworkPosition dHTNetworkPosition, float f) {
        this.v2_provider.update(this, new IDWrapper(byArray), (SyrahPosition)dHTNetworkPosition, f);
    }
}

