/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.vivaldi.ver2;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionProvider;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionProviderInstance;
import com.aelitis.azureus.core.dht.router.DHTRouter;
import com.aelitis.azureus.core.dht.router.DHTRouterContact;
import com.aelitis.azureus.core.dht.router.DHTRouterFactory;
import com.aelitis.azureus.core.dht.router.DHTRouterFactoryObserver;
import com.aelitis.azureus.core.dht.router.DHTRouterObserver;
import com.aelitis.azureus.vivaldi.ver2.IDWrapper;
import com.aelitis.azureus.vivaldi.ver2.InitialPosition;
import com.aelitis.azureus.vivaldi.ver2.LocalPosition;
import com.aelitis.azureus.vivaldi.ver2.RemotePosition;
import com.aelitis.azureus.vivaldi.ver2.StableLocalPosition;
import com.aelitis.azureus.vivaldi.ver2.SyrahPosition;
import com.aelitis.azureus.vivaldi.ver2.TransientTuple;
import com.aelitis.azureus.vivaldi.ver2.stats.SerializationController;
import com.aelitis.azureus.vivaldi.ver2.stats.V1Serializer;
import edu.harvard.syrah.nc.Coordinate;
import edu.harvard.syrah.nc.VivaldiClient;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VivaldiV2PositionProvider
implements DHTNetworkPositionProvider,
DHTRouterFactoryObserver,
DHTRouterObserver {
    public static final int NUM_DIMS = 5;
    public static final int TRANSIENT_TIME = 45000;
    public static final long MIN_NC_UPDATE_INTERVAL = 10000L;
    private static final boolean LOGGING_ENABLED = false;
    private static boolean initialised = false;
    private static volatile DHTNetworkPositionProviderInstance provider = null;
    private final VivaldiClient<IDWrapper> vc;
    private final InitialPosition ip;
    protected final SortedSet<IDWrapper> transient_ids;
    protected final LinkedList<TransientTuple> transient_list;
    protected final SerializationController serializer;
    protected final SortedSet<IDWrapper> router_entries;
    protected DHTRouter router = null;
    protected long last_nc_update = 0L;
    private boolean started_up = false;

    public static synchronized void initialise() {
        if (!initialised) {
            initialised = true;
            provider = DHTNetworkPositionManager.registerProvider(new VivaldiV2PositionProvider());
            VivaldiV2PositionProvider.doLog("Vivaldi V2 position provider created");
        }
    }

    protected VivaldiV2PositionProvider() {
        DHTRouterFactory.addObserver(this);
        this.vc = new VivaldiClient(5);
        this.ip = new InitialPosition();
        this.transient_ids = new TreeSet<IDWrapper>();
        this.transient_list = new LinkedList();
        this.serializer = new SerializationController();
        this.router_entries = new TreeSet<IDWrapper>();
        Timer timer = new Timer("VivaldiV2PositionProvider:ping");
        timer.addPeriodicEvent(10000L, new TimerEventPerformer(){

            public void perform(TimerEvent timerEvent2) {
                VivaldiV2PositionProvider.this.ping();
            }
        });
    }

    protected void resetPingClock(long l) {
        this.last_nc_update = l;
    }

    protected void ping() {
        IDWrapper iDWrapper;
        long l = System.currentTimeMillis();
        if (l > this.last_nc_update + 10000L && this.router != null && (iDWrapper = this.vc.getNeighborToPing(l)) != null) {
            byte[] byArray = iDWrapper.getRawId();
            this.router.requestPing(byArray);
        }
    }

    @Override
    public byte getPositionType() {
        return 5;
    }

    @Override
    public DHTNetworkPosition create(byte[] byArray, boolean bl) {
        if (bl) {
            VivaldiV2PositionProvider.doLog("Returning position for local peer");
            return new LocalPosition(this);
        }
        this.purgeTransient(System.currentTimeMillis());
        return this.ip;
    }

    @Override
    public DHTNetworkPosition deserialisePosition(DataInputStream dataInputStream) throws IOException {
        return new RemotePosition(dataInputStream);
    }

    @Override
    public void serialiseStats(DataOutputStream dataOutputStream) throws IOException {
        if (!this.serializer.contains((byte)1)) {
            this.serializer.addSerializer(V1Serializer.getInstance());
        }
        this.serializer.toSerialized((byte)1, dataOutputStream, this.vc);
    }

    @Override
    public void routerCreated(DHTRouter dHTRouter) {
        VivaldiV2PositionProvider.doLog("Vivaldi notified of created router");
        dHTRouter.addObserver(this);
        this.router = dHTRouter;
    }

    @Override
    public synchronized void added(DHTRouterContact dHTRouterContact) {
        this.purgeTransient(System.currentTimeMillis());
        IDWrapper iDWrapper = new IDWrapper(dHTRouterContact.getID());
        if (!this.router_entries.contains(iDWrapper)) {
            this.router_entries.add(iDWrapper);
        }
        if (this.transient_ids.remove(iDWrapper)) {
            TransientTuple transientTuple = null;
            Iterator iterator = this.transient_list.iterator();
            while (iterator.hasNext()) {
                transientTuple = (TransientTuple)iterator.next();
                if (!transientTuple.id.equals(iDWrapper)) continue;
                iterator.remove();
                break;
            }
            long l = System.currentTimeMillis();
            long l2 = l - transientTuple.create_time + transientTuple.last_pos.getAge();
            if (this.vc.processSample(iDWrapper, transientTuple.last_pos.getCoords(), transientTuple.last_pos.getError(), transientTuple.last_rtt, l2, l, true)) {
                this.resetPingClock(l);
            }
        } else if (this.vc.getHosts().contains(iDWrapper)) {
            // empty if block
        }
    }

    @Override
    public synchronized void removed(DHTRouterContact dHTRouterContact) {
        this.purgeTransient(System.currentTimeMillis());
        IDWrapper iDWrapper = new IDWrapper(dHTRouterContact.getID());
        if (this.router_entries.remove(iDWrapper)) {
            // empty if block
        }
        if (!this.vc.removeHost(iDWrapper) && this.transient_ids.remove(iDWrapper)) {
            Iterator iterator = this.transient_list.iterator();
            while (iterator.hasNext()) {
                TransientTuple transientTuple = (TransientTuple)iterator.next();
                if (!transientTuple.id.equals(iDWrapper)) continue;
                iterator.remove();
                break;
            }
        }
    }

    @Override
    public void locationChanged(DHTRouterContact dHTRouterContact) {
        this.purgeTransient(System.currentTimeMillis());
    }

    @Override
    public void nowAlive(DHTRouterContact dHTRouterContact) {
        this.purgeTransient(System.currentTimeMillis());
    }

    @Override
    public void nowFailing(DHTRouterContact dHTRouterContact) {
        this.purgeTransient(System.currentTimeMillis());
    }

    @Override
    public void destroyed(DHTRouter dHTRouter) {
        VivaldiV2PositionProvider.doLog("Vivaldi notified of destroyed router");
        dHTRouter.removeObserver(this);
        this.vc.reset();
        this.router_entries.clear();
        this.transient_ids.clear();
        this.transient_list.clear();
    }

    @Override
    public DHTNetworkPosition getLocalPosition() {
        if (this.started_up) {
            return new StableLocalPosition(this);
        }
        return null;
    }

    protected Coordinate getCoords() {
        return this.vc.getSystemCoords();
    }

    protected Coordinate getStableCoords() {
        return this.vc.getApplicationCoords();
    }

    protected float getError() {
        return (float)this.vc.getSystemError();
    }

    protected long getAge() {
        long l = this.vc.getAge(System.currentTimeMillis());
        return l;
    }

    protected InitialPosition getInitialPosition() {
        return this.ip;
    }

    protected VivaldiClient<IDWrapper> getVivaldiClient() {
        return this.vc;
    }

    protected synchronized void update(LocalPosition localPosition, IDWrapper iDWrapper, SyrahPosition syrahPosition, float f) {
        if (syrahPosition == localPosition) {
            VivaldiV2PositionProvider.doLog("update invoked on LocalPosition with itself, ID = " + iDWrapper);
            return;
        }
        if (syrahPosition == this.ip) {
            VivaldiV2PositionProvider.doLog("update invoked with the InitialPosition singleton, ID = " + iDWrapper);
            return;
        }
        long l = System.currentTimeMillis();
        if (this.vc.getHosts().contains(iDWrapper)) {
            if (this.vc.processSample(iDWrapper, syrahPosition.getCoords(), syrahPosition.getError(), f, syrahPosition.getAge(), l, false)) {
                this.resetPingClock(l);
            }
            VivaldiV2PositionProvider.doLog("update called on host, ID = " + iDWrapper);
            return;
        }
        if (this.router_entries.contains(iDWrapper)) {
            if (this.transient_ids.remove(iDWrapper)) {
                Iterator iterator = this.transient_list.iterator();
                while (iterator.hasNext()) {
                    TransientTuple transientTuple = (TransientTuple)iterator.next();
                    if (!transientTuple.id.equals(iDWrapper)) continue;
                    iterator.remove();
                    break;
                }
            }
            if (this.vc.processSample(iDWrapper, syrahPosition.getCoords(), syrahPosition.getError(), f, syrahPosition.getAge(), l, true)) {
                this.resetPingClock(l);
            }
            VivaldiV2PositionProvider.doLog("update called on host already in router, ID = " + iDWrapper);
            return;
        }
        long l2 = l + 45000L;
        if (!this.transient_ids.contains(iDWrapper)) {
            this.transient_ids.add(iDWrapper);
            this.transient_list.addLast(new TransientTuple(l2, iDWrapper, syrahPosition, f, l));
            VivaldiV2PositionProvider.doLog("added transient " + iDWrapper + " " + this.getStats());
            return;
        }
        VivaldiV2PositionProvider.doLog("updating transient " + iDWrapper + " " + this.getStats());
        TransientTuple transientTuple = null;
        Iterator iterator = this.transient_list.iterator();
        while (iterator.hasNext()) {
            transientTuple = (TransientTuple)iterator.next();
            if (!transientTuple.id.equals(iDWrapper)) continue;
            iterator.remove();
            break;
        }
        transientTuple.remove_time = l2;
        transientTuple.last_pos = syrahPosition;
        transientTuple.last_rtt = f;
        this.transient_list.addLast(transientTuple);
    }

    protected synchronized void purgeTransient(long l) {
        Iterator iterator = this.transient_list.iterator();
        while (iterator.hasNext()) {
            TransientTuple transientTuple = (TransientTuple)iterator.next();
            if (transientTuple.remove_time > l) {
                return;
            }
            iterator.remove();
            this.transient_ids.remove(transientTuple.id);
            VivaldiV2PositionProvider.doLog("removed transient " + transientTuple.id + " " + this.getStats());
        }
    }

    protected String getStats() {
        return "[h:" + this.vc.getHosts().size() + ", t:" + this.transient_list.size() + " re:" + this.router_entries.size() + "]";
    }

    protected static void doLog(String string) {
    }

    @Override
    public void startUp(DataInputStream dataInputStream) {
        this.started_up = true;
        try {
            this.vc.startUp(dataInputStream);
        }
        catch (IOException iOException) {
            VivaldiV2PositionProvider.doLog("startUp failed:" + iOException.toString());
        }
    }

    @Override
    public void shutDown(DataOutputStream dataOutputStream) {
        try {
            this.vc.shutDown(dataOutputStream);
        }
        catch (IOException iOException) {
            VivaldiV2PositionProvider.doLog("shutDown failed:" + iOException.toString());
        }
    }
}

