/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.vivaldi.ver2.stats;

import com.aelitis.azureus.vivaldi.ver2.stats.StatsSerializer;
import com.aelitis.azureus.vivaldi.ver2.stats.V1Serializer;
import com.aelitis.azureus.vivaldi.ver2.stats.VivaldiStatistics;
import edu.harvard.syrah.nc.VivaldiClient;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationController {
    protected final TreeMap<Byte, StatsSerializer> serializers = new TreeMap();
    protected final Set<Byte> versions_ro = Collections.unmodifiableSet(this.serializers.keySet());

    public SerializationController() {
        V1Serializer v1Serializer = V1Serializer.getInstance();
        this.serializers.put(v1Serializer.getSerializedVersion(), v1Serializer);
    }

    public boolean addSerializer(StatsSerializer statsSerializer) {
        byte by = statsSerializer.getSerializedVersion();
        if (this.serializers.containsKey(by)) {
            return false;
        }
        this.serializers.put(by, statsSerializer);
        return true;
    }

    public StatsSerializer removeSerializer(byte by) {
        return this.serializers.remove(by);
    }

    public boolean contains(byte by) {
        return this.serializers.containsKey(by);
    }

    public Set<Byte> getVersions() {
        return this.versions_ro;
    }

    public boolean toSerialized(byte by, DataOutputStream dataOutputStream, VivaldiClient vivaldiClient) throws IOException {
        StatsSerializer statsSerializer = this.serializers.get(by);
        if (statsSerializer == null) {
            return false;
        }
        dataOutputStream.writeByte(by);
        statsSerializer.toSerialized(dataOutputStream, vivaldiClient);
        return true;
    }

    public VivaldiStatistics fromSerialized(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        StatsSerializer statsSerializer = this.serializers.get(by);
        if (statsSerializer == null) {
            return null;
        }
        return statsSerializer.fromSerialized(dataInputStream);
    }
}

